/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.io.File;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.CachingDependencyResolveContext;
import org.gradle.api.internal.artifacts.DependencyResolveContext;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.initialization.ProjectAccessListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectDependency
extends AbstractModuleDependency
implements ProjectDependencyInternal {
    private final ProjectInternal dependencyProject;
    private final boolean buildProjectDependencies;
    private final TaskDependencyImpl taskDependency = new TaskDependencyImpl();
    private final ProjectAccessListener projectAccessListener;

    public DefaultProjectDependency(ProjectInternal dependencyProject, ProjectAccessListener projectAccessListener, boolean buildProjectDependencies) {
        this(dependencyProject, null, projectAccessListener, buildProjectDependencies);
    }

    public DefaultProjectDependency(ProjectInternal dependencyProject, String configuration, ProjectAccessListener projectAccessListener, boolean buildProjectDependencies) {
        super(configuration);
        this.dependencyProject = dependencyProject;
        this.projectAccessListener = projectAccessListener;
        this.buildProjectDependencies = buildProjectDependencies;
    }

    @Override
    public Project getDependencyProject() {
        return this.dependencyProject;
    }

    @Override
    public String getGroup() {
        return this.dependencyProject.getGroup().toString();
    }

    @Override
    public String getName() {
        return this.dependencyProject.getName();
    }

    @Override
    public String getVersion() {
        return this.dependencyProject.getVersion().toString();
    }

    @Override
    public Configuration getProjectConfiguration() {
        return this.dependencyProject.getConfigurations().getByName(this.getConfiguration());
    }

    @Override
    public ProjectDependency copy() {
        DefaultProjectDependency copiedProjectDependency = new DefaultProjectDependency(this.dependencyProject, this.getConfiguration(), this.projectAccessListener, this.buildProjectDependencies);
        this.copyTo(copiedProjectDependency);
        return copiedProjectDependency;
    }

    @Override
    public Set<File> resolve() {
        return this.resolve(true);
    }

    @Override
    public Set<File> resolve(boolean transitive) {
        CachingDependencyResolveContext context = new CachingDependencyResolveContext(transitive);
        context.add(this);
        return context.resolve().getFiles();
    }

    @Override
    public void beforeResolved() {
        this.projectAccessListener.beforeResolvingProjectDependency(this.dependencyProject);
    }

    @Override
    public void resolve(DependencyResolveContext context) {
        boolean transitive;
        boolean bl = transitive = this.isTransitive() && context.isTransitive();
        if (transitive) {
            for (Dependency dependency : this.getProjectConfiguration().getAllDependencies()) {
                context.add(dependency);
            }
        }
    }

    @Override
    public TaskDependencyInternal getBuildDependencies() {
        return this.taskDependency;
    }

    @Override
    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        ProjectDependency that = (ProjectDependency)dependency;
        if (!this.isCommonContentEquals(that)) {
            return false;
        }
        return this.dependencyProject.equals(that.getDependencyProject());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDependency that = (DefaultProjectDependency)o;
        if (!this.getDependencyProject().equals(that.getDependencyProject())) {
            return false;
        }
        if (!this.getConfiguration().equals(that.getConfiguration())) {
            return false;
        }
        return this.buildProjectDependencies == that.buildProjectDependencies;
    }

    @Override
    public int hashCode() {
        return this.getDependencyProject().hashCode() ^ this.getConfiguration().hashCode() ^ (this.buildProjectDependencies ? 1 : 0);
    }

    public String toString() {
        return "DefaultProjectDependency{dependencyProject='" + this.dependencyProject + '\'' + ", configuration='" + this.getConfiguration() + '\'' + '}';
    }

    private class TaskDependencyImpl
    extends AbstractTaskDependency {
        private TaskDependencyImpl() {
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            if (!DefaultProjectDependency.this.buildProjectDependencies) {
                return;
            }
            DefaultProjectDependency.this.projectAccessListener.beforeResolvingProjectDependency(DefaultProjectDependency.this.dependencyProject);
            Configuration configuration = DefaultProjectDependency.this.getProjectConfiguration();
            context.add(configuration);
            context.add(configuration.getAllArtifacts());
        }
    }
}

