/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.FileUtils;

class WatchPointsRegistry {
    private static final Logger LOG = Logging.getLogger(WatchPointsRegistry.class);
    private FileSystemSubset combinedFileSystemSubset;
    private ImmutableSet<? extends File> allRequestedRoots;
    private ImmutableCollection<? extends File> currentWatchPoints;
    private final boolean createNewStartingPointsUnderExistingRoots;

    public WatchPointsRegistry(boolean createNewStartingPointsUnderExistingRoots) {
        this.createNewStartingPointsUnderExistingRoots = createNewStartingPointsUnderExistingRoots;
        this.combinedFileSystemSubset = FileSystemSubset.builder().build();
        this.currentWatchPoints = ImmutableSet.of();
        this.allRequestedRoots = ImmutableSet.of();
    }

    public Delta appendFileSystemSubset(FileSystemSubset fileSystemSubset) {
        return new Delta(fileSystemSubset);
    }

    public boolean shouldFire(File file) {
        return this.combinedFileSystemSubset.contains(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Delta {
        private FileSystemSubset fileSystemSubset;
        private Iterable<? extends File> roots;
        private FileSystemSubset unfiltered;
        private Iterable<? extends File> startingWatchPoints;

        private Delta(FileSystemSubset fileSystemSubset) {
            this.fileSystemSubset = fileSystemSubset;
            this.init();
        }

        private Delta init() {
            this.roots = this.fileSystemSubset.getRoots();
            WatchPointsRegistry.this.allRequestedRoots = ImmutableSet.builder().addAll((Iterable)WatchPointsRegistry.this.allRequestedRoots).addAll(this.roots).build();
            this.unfiltered = this.fileSystemSubset.unfiltered();
            Iterable<? extends File> startingWatchPointCandidates = this.calculateStartingWatchPoints(this.roots, this.unfiltered);
            if (!WatchPointsRegistry.this.currentWatchPoints.isEmpty()) {
                if (WatchPointsRegistry.this.createNewStartingPointsUnderExistingRoots) {
                    this.startingWatchPoints = this.filterCurrentWatchPoints(startingWatchPointCandidates);
                    WatchPointsRegistry.this.currentWatchPoints = (ImmutableCollection)ImmutableSet.builder().addAll((Iterable)WatchPointsRegistry.this.currentWatchPoints).addAll(this.startingWatchPoints).build();
                } else {
                    Collection combinedRoots = FileUtils.calculateRoots((Iterable)Iterables.concat((Iterable)WatchPointsRegistry.this.currentWatchPoints, startingWatchPointCandidates));
                    this.startingWatchPoints = this.filterCurrentWatchPoints(combinedRoots);
                    WatchPointsRegistry.this.currentWatchPoints = (ImmutableCollection)ImmutableSet.copyOf((Iterable)combinedRoots);
                }
                WatchPointsRegistry.this.combinedFileSystemSubset = FileSystemSubset.builder().add(WatchPointsRegistry.this.combinedFileSystemSubset).add(this.fileSystemSubset).build();
            } else {
                this.startingWatchPoints = startingWatchPointCandidates;
                WatchPointsRegistry.this.combinedFileSystemSubset = this.fileSystemSubset;
                WatchPointsRegistry.this.currentWatchPoints = (ImmutableCollection)ImmutableSet.copyOf(this.startingWatchPoints);
            }
            return this;
        }

        private ImmutableSet<File> filterCurrentWatchPoints(Iterable<? extends File> startingWatchPointCandidates) {
            ImmutableSet.Builder newStartingPoints = ImmutableSet.builder();
            for (File file : startingWatchPointCandidates) {
                if (WatchPointsRegistry.this.currentWatchPoints.contains((Object)file)) continue;
                newStartingPoints.add((Object)file);
            }
            return newStartingPoints.build();
        }

        private Iterable<? extends File> calculateStartingWatchPoints(final Iterable<? extends File> roots, final FileSystemSubset unfiltered) {
            Iterable enclosingDirsThatExist = Iterables.transform(roots, (Function)new Function<File, File>(){

                public File apply(File input) {
                    File target = input;
                    while (!target.isDirectory()) {
                        target = target.getParentFile();
                    }
                    return target;
                }
            });
            return Iterables.filter((Iterable)FileUtils.calculateRoots((Iterable)enclosingDirsThatExist), (Predicate)new Predicate<File>(){

                public boolean apply(File input) {
                    return Delta.this.inUnfilteredSubsetOrAncestorOfAnyRoot(input, roots, unfiltered);
                }
            });
        }

        private boolean inUnfilteredSubsetOrAncestorOfAnyRoot(File file, Iterable<? extends File> roots, FileSystemSubset unfilteredFileSystemSubset) {
            return unfilteredFileSystemSubset.contains(file) || this.isAncestorOfAnyRoot(file, roots, false);
        }

        private boolean isAncestorOfAnyRoot(File file, Iterable<? extends File> roots) {
            return this.isAncestorOfAnyRoot(file, roots, true);
        }

        private boolean isAncestorOfAnyRoot(File file, Iterable<? extends File> roots, boolean onlyAncestors) {
            String absolutePathWithSeparator = file.getAbsolutePath() + File.separator;
            for (File file2 : roots) {
                if ((onlyAncestors || !file2.equals(file)) && !file2.getAbsolutePath().startsWith(absolutePathWithSeparator)) continue;
                return true;
            }
            return false;
        }

        private boolean inUnfilteredSubsetOrAncestorOfAnyRoot(File file) {
            return this.inUnfilteredSubsetOrAncestorOfAnyRoot(file, this.roots, this.unfiltered);
        }

        public Iterable<? extends File> getStartingWatchPoints() {
            return this.startingWatchPoints;
        }

        public boolean shouldWatch(File file) {
            boolean result;
            boolean bl = result = (this.inUnfilteredSubsetOrAncestorOfAnyRoot(file) || this.isAncestorOfAnyRoot(file, (Iterable<? extends File>)WatchPointsRegistry.this.allRequestedRoots)) && !this.isAncestorOfAnyRoot(file, (Iterable<? extends File>)WatchPointsRegistry.this.currentWatchPoints);
            if (!result) {
                LOG.debug("not watching file: {} currentWatchPoints: {} allRequestedRoots: {} roots: {} unfiltered: {}", file, WatchPointsRegistry.this.currentWatchPoints, WatchPointsRegistry.this.allRequestedRoots, this.roots, this.unfiltered);
            }
            return result;
        }
    }
}

