/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.logging.LogLevel;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.logging.ConsoleOutput;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.ShowStacktrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingCommandLineConverter
extends AbstractCommandLineConverter<LoggingConfiguration> {
    public static final String DEBUG = "d";
    public static final String DEBUG_LONG = "debug";
    public static final String INFO = "i";
    public static final String INFO_LONG = "info";
    public static final String QUIET = "q";
    public static final String QUIET_LONG = "quiet";
    public static final String NO_COLOR = "no-color";
    public static final String CONSOLE = "console";
    public static final String FULL_STACKTRACE = "S";
    public static final String FULL_STACKTRACE_LONG = "full-stacktrace";
    public static final String STACKTRACE = "s";
    public static final String STACKTRACE_LONG = "stacktrace";
    private final BiMap<String, LogLevel> logLevelMap = HashBiMap.create();
    private final BiMap<String, ShowStacktrace> showStacktraceMap = HashBiMap.create();

    public LoggingCommandLineConverter() {
        this.logLevelMap.put((Object)QUIET, (Object)LogLevel.QUIET);
        this.logLevelMap.put((Object)INFO, (Object)LogLevel.INFO);
        this.logLevelMap.put((Object)DEBUG, (Object)LogLevel.DEBUG);
        this.showStacktraceMap.put((Object)FULL_STACKTRACE, (Object)ShowStacktrace.ALWAYS_FULL);
        this.showStacktraceMap.put((Object)STACKTRACE, (Object)ShowStacktrace.ALWAYS);
    }

    public LoggingConfiguration convert(ParsedCommandLine commandLine, LoggingConfiguration loggingConfiguration) throws CommandLineArgumentException {
        for (Map.Entry entry : this.logLevelMap.entrySet()) {
            if (!commandLine.hasOption((String)entry.getKey())) continue;
            loggingConfiguration.setLogLevel((LogLevel)((Object)entry.getValue()));
        }
        for (Map.Entry entry : this.showStacktraceMap.entrySet()) {
            if (!commandLine.hasOption((String)entry.getKey())) continue;
            loggingConfiguration.setShowStacktrace((ShowStacktrace)((Object)entry.getValue()));
        }
        if (commandLine.hasOption(NO_COLOR)) {
            loggingConfiguration.setConsoleOutput(ConsoleOutput.Plain);
        }
        if (commandLine.hasOption(CONSOLE)) {
            String value = commandLine.option(CONSOLE).getValue();
            String consoleValue = StringUtils.capitalize((String)value.toLowerCase());
            try {
                ConsoleOutput colorOutput = ConsoleOutput.valueOf(consoleValue);
                loggingConfiguration.setConsoleOutput(colorOutput);
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineArgumentException(String.format("Unrecognized value '%s' for %s.", value, CONSOLE));
            }
        }
        return loggingConfiguration;
    }

    public void configure(CommandLineParser parser) {
        parser.option(new String[]{DEBUG, DEBUG_LONG}).hasDescription("Log in debug mode (includes normal stacktrace).");
        parser.option(new String[]{QUIET, QUIET_LONG}).hasDescription("Log errors only.");
        parser.option(new String[]{INFO, INFO_LONG}).hasDescription("Set log level to info.");
        parser.allowOneOf(new String[]{DEBUG, QUIET, INFO});
        parser.option(new String[]{NO_COLOR}).deprecated("use --console=plain instead").hasDescription("Do not use color in the console output.");
        parser.option(new String[]{CONSOLE}).hasArgument().hasDescription("Specifies which type of console output to generate. Values are 'plain', 'auto' (default) or 'rich'.");
        parser.allowOneOf(new String[]{NO_COLOR, CONSOLE});
        parser.option(new String[]{STACKTRACE, STACKTRACE_LONG}).hasDescription("Print out the stacktrace for all exceptions.");
        parser.option(new String[]{FULL_STACKTRACE, FULL_STACKTRACE_LONG}).hasDescription("Print out the full (very verbose) stacktrace for all exceptions.");
        parser.allowOneOf(new String[]{STACKTRACE, FULL_STACKTRACE_LONG});
    }

    public LogLevel getLogLevel(String commandLineArgument) {
        LogLevel logLevel = (LogLevel)((Object)this.logLevelMap.get((Object)commandLineArgument));
        if (logLevel == null) {
            return null;
        }
        return logLevel;
    }

    public String getLogLevelCommandLine(LogLevel logLevel) {
        String commandLine = (String)this.logLevelMap.inverse().get((Object)logLevel);
        if (commandLine == null) {
            return null;
        }
        return commandLine;
    }

    public Set<LogLevel> getLogLevels() {
        return new HashSet<LogLevel>(Arrays.asList(LogLevel.DEBUG, LogLevel.INFO, LogLevel.LIFECYCLE, LogLevel.QUIET));
    }

    public Set<String> getLogLevelOptions() {
        return this.logLevelMap.keySet();
    }

    public ShowStacktrace getShowStacktrace(String commandLineArgument) {
        ShowStacktrace showStacktrace = (ShowStacktrace)((Object)this.showStacktraceMap.get((Object)commandLineArgument));
        if (showStacktrace == null) {
            return null;
        }
        return showStacktrace;
    }

    public String getShowStacktraceCommandLine(ShowStacktrace showStacktrace) {
        String commandLine = (String)this.showStacktraceMap.inverse().get((Object)showStacktrace);
        if (commandLine == null) {
            return null;
        }
        return commandLine;
    }
}

