/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.io.Encoding;
import org.gjt.sp.jedit.jEdit;

public class EncodingServer {
    private static final String serviceClass = "org.gjt.sp.jedit.io.Encoding";

    public static Encoding getEncoding(String string) {
        try {
            return new CharsetEncoding(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        Object object = ServiceManager.getService(serviceClass, string);
        if (object != null && object instanceof Encoding) {
            return (Encoding)object;
        }
        throw new UnsupportedCharsetException("No such encoding: \"" + string + "\"");
    }

    public static Set<String> getAvailableNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Charset.availableCharsets().keySet());
        hashSet.addAll(Arrays.asList(ServiceManager.getServiceNames(serviceClass)));
        return hashSet;
    }

    public static Set<String> getSelectedNames() {
        Set<String> set = EncodingServer.getAvailableNames();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!jEdit.getBooleanProperty("encoding.opt-out." + string, false)) continue;
            iterator.remove();
        }
        return set;
    }

    public static Reader getTextReader(InputStream inputStream, String string) throws IOException {
        return EncodingServer.getEncoding(string).getTextReader(inputStream);
    }

    public static Writer getTextWriter(OutputStream outputStream, String string) throws IOException {
        return EncodingServer.getEncoding(string).getTextWriter(outputStream);
    }

    public static boolean hasEncoding(String string) {
        try {
            if (Charset.isSupported(string)) {
                return true;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return Arrays.asList(ServiceManager.getServiceNames(serviceClass)).contains(string);
    }
}

