/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;
import org.gjt.sp.util.Log;
import org.jedit.keymap.Keymap;

public class EnhancedCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private final ActionContext context;
    private String shortcut;
    private final String action;

    public EnhancedCheckBoxMenuItem(String string, String string2, ActionContext actionContext) {
        this.context = actionContext;
        this.action = string2;
        this.shortcut = GUIUtilities.getShortcutLabel(string2, true);
        String string3 = jEdit.getProperty(string2 + ".tooltip");
        if (string3 != null) {
            this.setToolTipText(string3);
        }
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            if (jEdit.getBooleanProperty("menu.multiShortcut", false)) {
                this.setText(string + " ( " + this.shortcut + " )");
            } else {
                this.setText(string);
                Keymap keymap = jEdit.getKeymapManager().getKeymap();
                String string4 = keymap.getShortcut(string2 + ".shortcut");
                KeyStroke keyStroke = KeyEventTranslator.parseKeyStroke(string4);
                if (keyStroke != null) {
                    this.setAccelerator(keyStroke);
                }
            }
            this.shortcut = null;
        } else {
            this.setText(string);
        }
        if (string2 != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(actionContext, string2));
            this.addMouseListener(new MouseHandler());
        } else {
            this.setEnabled(false);
        }
        this.setModel(new Model());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.shortcut != null) {
            dimension.width += this.getFontMetrics(EnhancedMenuItem.acceleratorFont).stringWidth(this.shortcut) + 15;
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.shortcut != null) {
            graphics.setFont(EnhancedMenuItem.acceleratorFont);
            graphics.setColor(this.getModel().isArmed() ? EnhancedMenuItem.acceleratorSelectionForeground : EnhancedMenuItem.acceleratorForeground);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Insets insets = this.getInsets();
            graphics.drawString(this.shortcut, this.getWidth() - (fontMetrics.stringWidth(this.shortcut) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - (OperatingSystem.isMacOSLF() ? 0 : 1)));
        }
    }

    class MouseHandler
    extends MouseAdapter {
        boolean msgSet = false;

        MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)mouseEvent.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            String string = jEdit.getProperty(EnhancedCheckBoxMenuItem.this.action + ".mouse-over");
            if (string != null) {
                GUIUtilities.getView((Component)mouseEvent.getSource()).getStatus().setMessage(string);
                this.msgSet = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)mouseEvent.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }
    }

    class Model
    extends DefaultButtonModel {
        Model() {
        }

        @Override
        public boolean isSelected() {
            if (!EnhancedCheckBoxMenuItem.this.isVisible()) {
                return false;
            }
            EditAction editAction = EnhancedCheckBoxMenuItem.this.context.getAction(EnhancedCheckBoxMenuItem.this.action);
            if (editAction == null) {
                Log.log(7, this, "Unknown action: " + EnhancedCheckBoxMenuItem.this.action);
                return false;
            }
            try {
                return editAction.isSelected(EnhancedCheckBoxMenuItem.this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
                return false;
            }
        }

        @Override
        public void setSelected(boolean bl) {
        }
    }
}

