/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.CollectionProperty;

class RecentTagCollection {
    private final Map<Tag, Void> recentTags;
    private SearchCompiler.Match tagsToIgnore;

    RecentTagCollection(final int n) {
        this.recentTags = new LinkedHashMap<Tag, Void>(n + 1, 1.1f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Tag, Void> entry) {
                return this.size() > n;
            }
        };
        this.tagsToIgnore = new SearchCompiler.Never();
    }

    public void loadFromPreference(CollectionProperty collectionProperty) {
        this.recentTags.clear();
        Iterator iterator = collectionProperty.get().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)iterator.next();
            this.add(new Tag(string, string2));
        }
    }

    public void saveToPreference(CollectionProperty collectionProperty) {
        ArrayList<String> arrayList = new ArrayList<String>(this.recentTags.size() * 2);
        for (Tag tag : this.recentTags.keySet()) {
            arrayList.add(tag.getKey());
            arrayList.add(tag.getValue());
        }
        collectionProperty.put((Collection<String>)arrayList);
    }

    public void add(Tag tag) {
        if (!this.tagsToIgnore.match(tag)) {
            this.recentTags.put(tag, null);
        }
    }

    public boolean isEmpty() {
        return this.recentTags.isEmpty();
    }

    public List<Tag> toList() {
        return new ArrayList<Tag>(this.recentTags.keySet());
    }

    public void setTagsToIgnore(SearchCompiler.Match match) {
        this.tagsToIgnore = match;
        Iterator<Tag> iterator = this.recentTags.keySet().iterator();
        while (iterator.hasNext()) {
            if (!match.match(iterator.next())) continue;
            iterator.remove();
        }
    }

    public void setTagsToIgnore(SearchAction.SearchSetting searchSetting) throws SearchCompiler.ParseError {
        this.setTagsToIgnore(searchSetting.text.isEmpty() ? new SearchCompiler.Never() : SearchCompiler.compile(searchSetting));
    }

    public SearchAction.SearchSetting ignoreTag(Tag tag, SearchAction.SearchSetting searchSetting) throws SearchCompiler.ParseError {
        String string = SearchCompiler.buildSearchStringForTag(tag.getKey(), tag.getValue());
        searchSetting.text = searchSetting.text.isEmpty() ? string : searchSetting.text + " OR " + string;
        this.setTagsToIgnore(searchSetting);
        return searchSetting;
    }
}

