/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ManualAuthorizationUI
extends AbstractAuthorizationUI {
    private JosmTextField tfAccessTokenKey;
    private transient AccessTokenKeyValidator valAccessTokenKey;
    private JosmTextField tfAccessTokenSecret;
    private transient AccessTokenSecretValidator valAccessTokenSecret;
    private JCheckBox cbSaveToPreferences;
    private HtmlPanel pnlMessage;
    private final transient Executor executor;

    protected JPanel buildAccessTokenPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AccessTokenBuilder accessTokenBuilder = new AccessTokenBuilder();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlMessage = new HtmlPanel();
        this.pnlMessage.setText("<html><body>" + I18n.tr("Please enter an OAuth Access Token which is authorized to access the OSM server ''{0}''.", this.getApiUrl()) + "</body></html>");
        jPanel.add((Component)this.pnlMessage, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("Access Token Key:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfAccessTokenKey = new JosmTextField();
        jPanel.add((Component)this.tfAccessTokenKey, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenKey);
        this.valAccessTokenKey = new AccessTokenKeyValidator(this.tfAccessTokenKey);
        this.valAccessTokenKey.validate();
        this.tfAccessTokenKey.getDocument().addDocumentListener(accessTokenBuilder);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Access Token Secret:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfAccessTokenSecret = new JosmTextField();
        jPanel.add((Component)this.tfAccessTokenSecret, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenSecret);
        this.valAccessTokenSecret = new AccessTokenSecretValidator(this.tfAccessTokenSecret);
        this.valAccessTokenSecret.validate();
        this.tfAccessTokenSecret.getDocument().addDocumentListener(accessTokenBuilder);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.cbSaveToPreferences = new JCheckBox(I18n.tr("Save Access Token in preferences", new Object[0]));
        jPanel.add((Component)this.cbSaveToPreferences, gridBagConstraints);
        this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildTabbedPreferencesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(this.buildAccessTokenPanel());
        jTabbedPane.add(this.getAdvancedPropertiesPanel());
        jTabbedPane.setTitleAt(0, I18n.tr("Access Token", new Object[0]));
        jTabbedPane.setTitleAt(1, I18n.tr("Advanced OAuth parameters", new Object[0]));
        jTabbedPane.setToolTipTextAt(0, I18n.tr("Enter the OAuth Access Token", new Object[0]));
        jTabbedPane.setToolTipTextAt(1, I18n.tr("Enter advanced OAuth properties", new Object[0]));
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    protected JPanel buildActionsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        TestAccessTokenAction testAccessTokenAction = new TestAccessTokenAction();
        jPanel.add(new SideButton(testAccessTokenAction));
        this.addPropertyChangeListener(testAccessTokenAction);
        return jPanel;
    }

    @Override
    public void setApiUrl(String string) {
        super.setApiUrl(string);
        if (this.pnlMessage != null) {
            this.pnlMessage.setText(I18n.tr("<html><body>Please enter an OAuth Access Token which is authorized to access the OSM server ''{0}''.</body></html>", this.getApiUrl()));
        }
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildTabbedPreferencesPanel(), "Center");
        this.add((Component)this.buildActionsPanel(), "South");
    }

    public ManualAuthorizationUI(String string, Executor executor) {
        super(string);
        this.executor = executor;
        this.build();
    }

    @Override
    public boolean isSaveAccessTokenToPreferences() {
        return this.cbSaveToPreferences.isSelected();
    }

    class TestAccessTokenAction
    extends AbstractAction
    implements PropertyChangeListener {
        TestAccessTokenAction() {
            this.putValue("Name", I18n.tr("Test Access Token", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth-small"));
            this.putValue("ShortDescription", I18n.tr("Click to test the Access Token", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestAccessTokenTask testAccessTokenTask = new TestAccessTokenTask(ManualAuthorizationUI.this, ManualAuthorizationUI.this.getApiUrl(), ManualAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), ManualAuthorizationUI.this.getAccessToken());
            ManualAuthorizationUI.this.executor.execute(testAccessTokenTask);
        }

        protected final void updateEnabledState() {
            this.setEnabled(ManualAuthorizationUI.this.hasAccessToken());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!propertyChangeEvent.getPropertyName().equals(AbstractAuthorizationUI.ACCESS_TOKEN_PROP)) {
                return;
            }
            this.updateEnabledState();
        }
    }

    class AccessTokenBuilder
    implements DocumentListener {
        AccessTokenBuilder() {
        }

        public void build() {
            if (!ManualAuthorizationUI.this.valAccessTokenKey.isValid() || !ManualAuthorizationUI.this.valAccessTokenSecret.isValid()) {
                ManualAuthorizationUI.this.setAccessToken(null);
            } else {
                ManualAuthorizationUI.this.setAccessToken(new OAuthToken(ManualAuthorizationUI.this.tfAccessTokenKey.getText().trim(), ManualAuthorizationUI.this.tfAccessTokenSecret.getText().trim()));
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.build();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.build();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.build();
        }
    }

    private static class AccessTokenSecretValidator
    extends AbstractTextComponentValidator {
        AccessTokenSecretValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            return !this.getComponent().getText().trim().isEmpty();
        }

        @Override
        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter an Access Token Secret", new Object[0]));
            } else {
                this.feedbackInvalid(I18n.tr("The Access Token Secret must not be empty. Please enter an Access Token Secret", new Object[0]));
            }
        }
    }

    private static class AccessTokenKeyValidator
    extends AbstractTextComponentValidator {
        AccessTokenKeyValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            return !this.getComponent().getText().trim().isEmpty();
        }

        @Override
        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter an Access Token Key", new Object[0]));
            } else {
                this.feedbackInvalid(I18n.tr("The Access Token Key must not be empty. Please enter an Access Token Key", new Object[0]));
            }
        }
    }
}

