/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class RescueBodyNode
extends Node {
    private final Node exceptionNodes;
    private final Node bodyNode;
    private final RescueBodyNode optRescueNode;

    public RescueBodyNode(ISourcePosition position, Node exceptionNodes, Node bodyNode, RescueBodyNode optRescueNode) {
        super(position, exceptionNodes != null && exceptionNodes.containsVariableAssignment() || bodyNode.containsVariableAssignment() || optRescueNode != null && optRescueNode.containsVariableAssignment());
        assert (bodyNode != null) : "bodyNode is not null";
        this.exceptionNodes = exceptionNodes;
        this.bodyNode = bodyNode;
        this.optRescueNode = optRescueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RESCUEBODYNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRescueBodyNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public RescueBodyNode getOptRescueNode() {
        return this.optRescueNode;
    }

    public Node getExceptionNodes() {
        return this.exceptionNodes;
    }

    @Override
    public List<Node> childNodes() {
        if (this.optRescueNode != null) {
            return Node.createList(this.exceptionNodes, this.bodyNode, (Node)this.optRescueNode);
        }
        return Node.createList(this.exceptionNodes, this.bodyNode);
    }
}

