/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.om.dsl.processor.layout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jruby.truffle.om.dsl.processor.layout.model.PropertyModel;

public class LayoutModel {
    private final String objectTypeSuperclass;
    private final LayoutModel superLayout;
    private final String name;
    private final String packageName;
    private final String interfaceFullName;
    private final boolean hasObjectTypeGuard;
    private final boolean hasObjectGuard;
    private final boolean hasDynamicObjectGuard;
    private final List<PropertyModel> properties;
    private final boolean hasShapeProperties;

    public LayoutModel(String objectTypeSuperclass, LayoutModel superLayout, String name, String packageName, boolean hasObjectTypeGuard, boolean hasObjectGuard, boolean hasDynamicObjectGuard, Collection<PropertyModel> properties, String interfaceFullName, boolean hasShapeProperties) {
        this.objectTypeSuperclass = objectTypeSuperclass;
        this.superLayout = superLayout;
        this.name = name;
        this.packageName = packageName;
        this.interfaceFullName = interfaceFullName;
        this.hasObjectTypeGuard = hasObjectTypeGuard;
        this.hasObjectGuard = hasObjectGuard;
        this.hasDynamicObjectGuard = hasDynamicObjectGuard;
        this.properties = Collections.unmodifiableList(new ArrayList<PropertyModel>(properties));
        this.hasShapeProperties = hasShapeProperties;
    }

    public String getObjectTypeSuperclass() {
        return this.objectTypeSuperclass;
    }

    public LayoutModel getSuperLayout() {
        return this.superLayout;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getInterfaceFullName() {
        return this.interfaceFullName;
    }

    public boolean hasObjectGuard() {
        return this.hasObjectGuard;
    }

    public boolean hasDynamicObjectGuard() {
        return this.hasDynamicObjectGuard;
    }

    public List<PropertyModel> getProperties() {
        return this.properties;
    }

    public List<PropertyModel> getNonShapeProperties() {
        ArrayList<PropertyModel> nonShapeProperties = new ArrayList<PropertyModel>();
        for (PropertyModel property : this.getProperties()) {
            if (property.isShapeProperty()) continue;
            nonShapeProperties.add(property);
        }
        return nonShapeProperties;
    }

    public List<PropertyModel> getShapeProperties() {
        ArrayList<PropertyModel> shapeProperties = new ArrayList<PropertyModel>();
        for (PropertyModel property : this.getProperties()) {
            if (!property.isShapeProperty()) continue;
            shapeProperties.add(property);
        }
        return shapeProperties;
    }

    public List<PropertyModel> getAllProperties() {
        ArrayList<PropertyModel> allProperties = new ArrayList<PropertyModel>();
        if (this.superLayout != null) {
            allProperties.addAll(this.superLayout.getAllProperties());
        }
        allProperties.addAll(this.properties);
        return allProperties;
    }

    public List<PropertyModel> getAllNonShapeProperties() {
        ArrayList<PropertyModel> allNonShapeProperties = new ArrayList<PropertyModel>();
        for (PropertyModel property : this.getAllProperties()) {
            if (property.isShapeProperty()) continue;
            allNonShapeProperties.add(property);
        }
        return allNonShapeProperties;
    }

    public List<PropertyModel> getInheritedShapeProperties() {
        ArrayList<PropertyModel> inheritedShapeProperties = new ArrayList<PropertyModel>();
        for (PropertyModel property : this.getAllProperties()) {
            if (this.properties.contains(property) || !property.isShapeProperty()) continue;
            inheritedShapeProperties.add(property);
        }
        return inheritedShapeProperties;
    }

    public List<PropertyModel> getAllShapeProperties() {
        ArrayList<PropertyModel> allShapeProperties = new ArrayList<PropertyModel>();
        for (PropertyModel property : this.getAllProperties()) {
            if (!property.isShapeProperty()) continue;
            allShapeProperties.add(property);
        }
        return allShapeProperties;
    }

    public boolean hasShapeProperties() {
        if (this.superLayout != null && this.superLayout.hasShapeProperties()) {
            return true;
        }
        return this.hasShapeProperties;
    }

    public boolean hasNonShapeProperties() {
        return !this.getAllNonShapeProperties().isEmpty();
    }

    public boolean hasObjectTypeGuard() {
        return this.hasObjectTypeGuard;
    }
}

