/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.COSVisitor;

public class COSArray
extends COSBase
implements List<COSBase> {
    private final List<COSBase> objects = new ArrayList<COSBase>();

    public COSArray() {
    }

    public COSArray(COSBase ... items) {
        Arrays.stream(items).forEach(this.objects::add);
    }

    @Override
    public boolean add(COSObjectable object) {
        return this.add(object.getCOSObject());
    }

    @Override
    public boolean add(COSBase object) {
        return this.objects.add(object);
    }

    @Override
    public void add(int index, COSObjectable object) {
        this.add(index, object.getCOSObject());
    }

    @Override
    public void add(int index, COSBase object) {
        this.objects.add(index, object);
    }

    @Override
    public void clear() {
        this.objects.clear();
    }

    @Override
    public boolean removeAll(Collection<?> objectsList) {
        return this.objects.removeAll(objectsList);
    }

    @Override
    public boolean retainAll(Collection<?> objectsList) {
        return this.objects.retainAll(objectsList);
    }

    @Override
    public boolean addAll(Collection<? extends COSBase> objectsList) {
        return this.objects.addAll(objectsList);
    }

    public boolean addAll(COSArray objectList) {
        if (objectList != null) {
            return this.objects.addAll(objectList.objects);
        }
        return false;
    }

    @Override
    public boolean addAll(int i, Collection<? extends COSBase> objectList) {
        return this.objects.addAll(i, objectList);
    }

    @Override
    public COSBase set(int index, COSBase object) {
        return this.objects.set(index, object);
    }

    @Override
    public void set(int index, COSObjectable object) {
        COSBase base = null;
        if (object != null) {
            base = object.getCOSObject();
        }
        this.set(index, base);
    }

    public COSBase getObject(int index) {
        return Optional.of(this.objects.get(index)).map(COSBase::getCOSObject).filter(i -> i != COSNull.NULL).orElse(null);
    }

    @Override
    public COSBase get(int index) {
        return this.objects.get(index);
    }

    public int getInt(int index) {
        return this.getInt(index, -1);
    }

    public int getInt(int index, int defaultValue) {
        COSBase obj;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSNumber) {
            return ((COSNumber)obj).intValue();
        }
        return defaultValue;
    }

    public String getName(int index) {
        return this.getName(index, null);
    }

    public String getName(int index, String defaultValue) {
        COSBase obj;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSName) {
            return ((COSName)obj).getName();
        }
        return defaultValue;
    }

    public void setString(int index, String string) {
        if (string != null) {
            this.set(index, COSString.parseLiteral(string));
        } else {
            this.set(index, (COSBase)null);
        }
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    public String getString(int index, String defaultValue) {
        COSBase obj;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof COSString) {
            return ((COSString)obj).getString();
        }
        return defaultValue;
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public COSBase remove(int i) {
        return this.objects.remove(i);
    }

    @Override
    public COSBase removeLast() {
        if (!this.objects.isEmpty()) {
            return this.objects.remove(this.objects.size() - 1);
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        return this.objects.remove(o);
    }

    public boolean removeObject(COSBase o) {
        boolean removed = this.remove(o);
        if (!removed) {
            for (int i = 0; i < this.size(); ++i) {
                COSBase entry = this.get(i);
                if (!entry.getCOSObject().equals(o)) continue;
                return this.remove(entry);
            }
        }
        return removed;
    }

    @Override
    public Iterator<COSBase> iterator() {
        return this.objects.iterator();
    }

    @Override
    public ListIterator<COSBase> listIterator() {
        return this.objects.listIterator();
    }

    @Override
    public ListIterator<COSBase> listIterator(int index) {
        return this.objects.listIterator(index);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.objects.lastIndexOf(o);
    }

    @Override
    public int indexOf(Object object) {
        return this.objects.indexOf(object);
    }

    public int indexOfObject(COSBase object) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getCOSObject().equals(object)) continue;
            return i;
        }
        return -1;
    }

    public void growToSize(int size) {
        this.growToSize(size, null);
    }

    public void growToSize(int size, COSBase object) {
        while (this.size() < size) {
            this.add(object);
        }
    }

    public float[] toFloatArray() {
        float[] retval = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            retval[i] = ((COSNumber)this.getObject(i)).floatValue();
        }
        return retval;
    }

    public void setFloatArray(float[] value) {
        this.clear();
        for (int i = 0; i < value.length; ++i) {
            this.add(new COSFloat(value[i]));
        }
    }

    public List<?> toList() {
        ArrayList retList = new ArrayList(this.size());
        Collections.copy(retList, this.objects);
        return retList;
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.objects.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.objects.toArray(a);
    }

    @Override
    public boolean contains(Object o) {
        return this.objects.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.objects.containsAll(c);
    }

    @Override
    public List<COSBase> subList(int fromIndex, int toIndex) {
        return this.objects.subList(fromIndex, toIndex);
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }

    public String toString() {
        return "COSArray{" + this.objects + "}";
    }
}

