/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.listener;

import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.SelectorFrame;
import com.baselet.diagram.SelectorOld;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.sticking.StickableMap;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.Command;
import com.baselet.gui.command.Controller;
import com.baselet.gui.command.Macro;
import com.baselet.gui.command.Move;
import java.awt.event.ComponentAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.Vector;

public abstract class UniversalListener
extends ComponentAdapter
implements MouseListener,
MouseMotionListener {
    protected DiagramHandler handler;
    protected DrawPanel diagram;
    public SelectorOld selector;
    protected Controller controller;
    private int _xOffset;
    private int _yOffset;
    private boolean disableElementMovement = true;
    private int old_x_eff;
    private int old_y_eff;
    private int new_x_eff;
    private int new_y_eff;

    protected UniversalListener(DiagramHandler handler) {
        this.handler = handler;
        this.diagram = handler.getDrawPanel();
        this.selector = this.diagram.getSelector();
        this.controller = handler.getController();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.disableElementMovement = false;
        CurrentGui.getInstance().getGui().requestFocus();
        Point off = this.getOffset(me);
        this._xOffset = off.x;
        this._yOffset = off.y;
        CurrentDiagram.getInstance().setCurrentDiagramHandler(this.handler);
        if (CurrentDiagram.getInstance().getDiagramHandler() != null) {
            int factor = CurrentDiagram.getInstance().getDiagramHandler().getGridSize();
            CurrentGui.getInstance().getGui().setValueOfZoomDisplay(factor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.disableElementMovement = true;
        if (this.selector.isSelectorFrameActive()) {
            SelectorFrame selframe = this.selector.getSelectorFrame();
            this.diagram.remove(selframe);
            this.selector.deselectAll();
            this.selector.multiSelect(Converter.convert(selframe.getBounds()));
            this.selector.setSelectorFrameActive(false);
            this.diagram.repaint();
        }
        this.diagram.updatePanelAndScrollbars();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.selector.isSelectorFrameActive()) {
            this.selector.getSelectorFrame().resizeTo(this.getOffset(me).getX(), this.getOffset(me).getY());
            this.disableElementMovement = true;
            return;
        }
        if (this.disableElementMovement()) {
            return;
        }
        Point off = this.getOffset(me);
        int xNewOffset = off.x;
        int yNewOffset = off.y;
        int gridSize = CurrentDiagram.getInstance().getDiagramHandler().getGridSize();
        this.new_x_eff = gridSize * ((xNewOffset - gridSize / 2) / gridSize);
        this.new_y_eff = gridSize * ((yNewOffset - gridSize / 2) / gridSize);
        this.old_x_eff = gridSize * ((this._xOffset - gridSize / 2) / gridSize);
        this.old_y_eff = gridSize * ((this._yOffset - gridSize / 2) / gridSize);
        this._xOffset = xNewOffset;
        this._yOffset = yNewOffset;
    }

    protected final boolean disableElementMovement() {
        return this.disableElementMovement;
    }

    protected final Point getOldCoordinate() {
        return new Point(this.old_x_eff, this.old_y_eff);
    }

    protected final Point getOldCoordinateNotRounded() {
        return new Point(this._xOffset, this._yOffset);
    }

    protected final Point getNewCoordinate() {
        return new Point(this.new_x_eff, this.new_y_eff);
    }

    protected abstract Point getOffset(MouseEvent var1);

    protected void dragDiagram() {
        if (this.disableElementMovement()) {
            return;
        }
        Point newp = this.getNewCoordinate();
        Point oldp = this.getOldCoordinate();
        int diffx = newp.x - oldp.x;
        int diffy = newp.y - oldp.y;
        if (diffx != 0 || diffy != 0) {
            Vector<Command> moveCommands = new Vector<Command>();
            for (GridElement e : this.diagram.getGridElements()) {
                moveCommands.add(new Move(Collections.<Direction>emptySet(), e, diffx, diffy, oldp, false, false, true, StickableMap.EMPTY_MAP));
            }
            this.controller.executeCommand(new Macro(moveCommands));
        }
    }
}

