(function(){
    "use strict";
    var _$rapyd$_iterator_symbol = (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") ? Symbol.iterator : "iterator-Symbol-5d0927e5554349048cf0e3762a228256";
    var _$rapyd$_kwargs_symbol = (typeof Symbol === "function") ? Symbol("kwargs-object") : "kwargs-object-Symbol-5d0927e5554349048cf0e3762a228256";
    var _$rapyd$_cond_temp;
    var _$rapyd$_object_counter = 0;
    function _$rapyd$_extends(child, parent) {
            child.prototype = Object.create(parent.prototype);
            child.prototype.constructor = child;
        };
    function _$rapyd$_Iterable(iterable) {
            var iterator, ans, result;
            if (_$rapyd$_arraylike(iterable)) {
                return iterable;
            }
            if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
                iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
                ans = _$rapyd$_list_decorate([]);
                result = iterator.next();
                while (!result.done) {
                    ans.push(result.value);
                    result = iterator.next();
                }
                return ans;
            }
            return Object.keys(iterable);
        };
    function callable(x) {
            return typeof x === "function";
        };
    function sum(iterable, start) {
    var ans, iterator, r;
    if (Array.isArray(iterable)) {
        return iterable.reduce(function(prev, cur) {
            return prev + cur;
        }, start || 0);
    }
    ans = start || 0;
    iterator = iter(iterable);
    r = iterator.next();
    while (!r.done) {
        ans += r.value;
        r = iterator.next();
    }
    return ans;
}
function map() {
    var func, iterators, args;
    func = arguments[0];
    iterators = new Array(arguments.length - 1);
    args = new Array(arguments.length - 1);
    for (var i = 1; i < arguments.length; i++) {
        iterators[i - 1] = iter(arguments[i]);
    }
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_func"] = func;
        _$rapyd$_d["_iterators"] = iterators;
        _$rapyd$_d["_args"] = args;
        _$rapyd$_d["next"] = function() {
            var r;
            for (var i = 0; i < this._iterators.length; i++) {
                r = this._iterators[i].next();
                if (r.done) {
                    return {
                        "done": true
                    };
                }
                this._args[i] = r.value;
            }
            return {
                "done": false,
                "value": this._func.apply(undefined, this._args)
            };
        };
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        return _$rapyd$_d;
    })();
}
function filter(func_or_none, iterable) {
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_iterator"] = iter(iterable);
        _$rapyd$_d["_func"] = (func_or_none === null) ? bool : func_or_none;
        _$rapyd$_d["next"] = function() {
            var r;
            r = this._iterator.next();
            while (!r.done) {
                if (this._func(r.value)) {
                    return r;
                }
                r = this._iterator.next();
            }
            return {
                "done": true
            };
        };
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        return _$rapyd$_d;
    })();
}
function zip() {
    var iterators;
    iterators = new Array(arguments.length);
    for (var i = 0; i < arguments.length; i++) {
        iterators[i] = iter(arguments[i]);
    }
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_iterators"] = iterators;
        _$rapyd$_d["next"] = function() {
            var args, r;
            args = new Array(this._iterators.length);
            for (var i = 0; i < this._iterators.length; i++) {
                r = this._iterators[i].next();
                if (r.done) {
                    return {
                        "done": true
                    };
                }
                args[i] = r.value;
            }
            return {
                "done": false,
                "value": args
            };
        };
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        return _$rapyd$_d;
    })();
};
    var _$rapyd$_desugar_kwargs = (function _$rapyd$_desugar_kwargs() {
            if (typeof Object.assign === "function") {
                return function() {
                    var ans;
                    ans = {};
                    ans[_$rapyd$_kwargs_symbol] = true;
                    for (var i = 0; i < arguments.length; i++) {
                        Object.assign(ans, arguments[i]);
                    }
                    return ans;
                };
            }
            return function() {
                var ans, keys;
                ans = {};
                ans[_$rapyd$_kwargs_symbol] = true;
                for (var i = 0; i < arguments.length; i++) {
                    keys = Object.keys(arguments[i]);
                    for (var j = 0; j < keys.length; j++) {
                        ans[keys[j]] = arguments[i][keys[j]];
                    }
                }
                return ans;
            };
        })();
    function enumerate(iterable) {
            var ans, iterator;
            if (_$rapyd$_arraylike(iterable)) {
                ans = {
                    "_i": -1,
                    "next": function() {
                        this._i += 1;
                        if (this._i < iterable.length) {
                            return {
                                "done": false,
                                "value": _$rapyd$_list_decorate([ this._i, iterable[this._i] ])
                            };
                        }
                        return {
                            "done": true
                        };
                    }
                };
                ans[_$rapyd$_iterator_symbol] = function() {
                    return this;
                };
                return ans;
            }
            if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
                iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
                ans = {
                    "_iterator": iterator,
                    "_i": -1,
                    "next": function() {
                        var r;
                        r = this._iterator.next();
                        if (r.done) {
                            return {
                                "done": true
                            };
                        }
                        this._i += 1;
                        return {
                            "done": false,
                            "value": _$rapyd$_list_decorate([ this._i, r.value ])
                        };
                    }
                };
                ans[_$rapyd$_iterator_symbol] = function() {
                    return this;
                };
                return ans;
            }
            return enumerate(Object.keys(iterable));
        };
    var _$rapyd$_in = (function _$rapyd$_in() {
            if (typeof Map === "function" && typeof Set === "function") {
                return function(val, arr) {
                    if (Array.isArray(arr) || typeof arr === "string") {
                        return arr.indexOf(val) !== -1;
                    }
                    if (typeof arr.__contains__ === "function") {
                        return arr.__contains__(val);
                    }
                    if ((arr instanceof Map || arr instanceof Set)) {
                        return arr.has(val);
                    }
                    return Object.prototype.hasOwnProperty.call(arr, val);
                };
            }
            return function(val, arr) {
                if (Array.isArray(arr) || typeof arr === "string") {
                    return arr.indexOf(val) !== -1;
                }
                if (typeof arr.__contains__ === "function") {
                    return arr.__contains__(val);
                }
                return Object.prototype.hasOwnProperty.call(arr, val);
            };
        })();
    function getattr(obj, name, defval) {
            var ret;
            try {
                ret = obj[name];
            } catch (_$rapyd$_Exception) {
                if (_$rapyd$_Exception instanceof TypeError) {
                    if (defval === undefined) {
                        throw new AttributeError("The attribute " + name + " is not present");
                    }
                    return defval;
                } else {
                    throw _$rapyd$_Exception;
                }
            }
            if (ret === undefined && !(name in obj)) {
                if (defval === undefined) {
                    throw new AttributeError("The attribute " + name + " is not present");
                }
                ret = defval;
            }
            return ret;
        };
    var len = (function _$rapyd$_len() {
            if (typeof Set === "function" && typeof Map === "function") {
                return function(obj) {
                    if (_$rapyd$_arraylike(obj)) {
                        return obj.length;
                    }
                    if (obj instanceof Set || obj instanceof Map) {
                        return obj.size;
                    }
                    if (typeof obj.__len__ === "function") {
                        return obj.__len__();
                    }
                    return Object.keys(obj).length;
                };
            }
            return function(obj) {
                if (_$rapyd$_arraylike(obj)) {
                    return obj.length;
                }
                if (typeof obj.__len__ === "function") {
                    return obj.__len__();
                }
                return Object.keys(obj).length;
            };
        })();
    function range(start, stop, step) {
            var length;
            if (arguments.length <= 1) {
                stop = start || 0;
                start = 0;
            }
            step = arguments[2] || 1;
            length = Math.max(Math.ceil((stop - start) / step), 0);
            return (function(){
                var _$rapyd$_d = {};
                _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
                    return this;
                };
                _$rapyd$_d["_i"] = start - step;
                _$rapyd$_d["_idx"] = -1;
                _$rapyd$_d["next"] = function() {
                    this._i += step;
                    this._idx += 1;
                    if (this._idx >= length) {
                        return {
                            "done": true
                        };
                    }
                    return {
                        "done": false,
                        "value": this._i
                    };
                };
                return _$rapyd$_d;
            })();
        };
    function _$rapyd$_flatten(arr) {
            var ans, value;
            ans = _$rapyd$_list_decorate([]);
            for (var i=0; i<arr.length; i++) {
                value = arr[i];
                if (Array.isArray(value)) {
                    ans = ans.concat(_$rapyd$_flatten(value));
                } else {
                    ans.push(value);
                }
            }
            return ans;
        };
    var Exception = Error;
function AttributeError() {
    if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
    AttributeError.prototype.__init__.apply(this, arguments);
}
_$rapyd$_extends(AttributeError, Error);
AttributeError.prototype.__init__ = function __init__(msg) {
    var self = this;
    self.message = msg;
    self.stack = new Error().stack;
};
AttributeError.prototype.__repr__ = function __repr__ () {
    return "<" + __name__ + "." + "AttributeError" + " #" + this._$rapyd$_object_id + ">";
};
AttributeError.prototype.__str__ = function __str__ () {
    return this.__repr__();
};
AttributeError.prototype.name = "AttributeError";

function IndexError() {
    if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
    IndexError.prototype.__init__.apply(this, arguments);
}
_$rapyd$_extends(IndexError, Error);
IndexError.prototype.__init__ = function __init__(msg) {
    var self = this;
    self.message = msg;
    self.stack = new Error().stack;
};
IndexError.prototype.__repr__ = function __repr__ () {
    return "<" + __name__ + "." + "IndexError" + " #" + this._$rapyd$_object_id + ">";
};
IndexError.prototype.__str__ = function __str__ () {
    return this.__repr__();
};
IndexError.prototype.name = "IndexError";

function KeyError() {
    if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
    KeyError.prototype.__init__.apply(this, arguments);
}
_$rapyd$_extends(KeyError, Error);
KeyError.prototype.__init__ = function __init__(msg) {
    var self = this;
    self.message = msg;
    self.stack = new Error().stack;
};
KeyError.prototype.__repr__ = function __repr__ () {
    return "<" + __name__ + "." + "KeyError" + " #" + this._$rapyd$_object_id + ">";
};
KeyError.prototype.__str__ = function __str__ () {
    return this.__repr__();
};
KeyError.prototype.name = "KeyError";

function ValueError() {
    if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
    ValueError.prototype.__init__.apply(this, arguments);
}
_$rapyd$_extends(ValueError, Error);
ValueError.prototype.__init__ = function __init__(msg) {
    var self = this;
    self.message = msg;
    self.stack = new Error().stack;
};
ValueError.prototype.__repr__ = function __repr__ () {
    return "<" + __name__ + "." + "ValueError" + " #" + this._$rapyd$_object_id + ">";
};
ValueError.prototype.__str__ = function __str__ () {
    return this.__repr__();
};
ValueError.prototype.name = "ValueError";
;
    var _$rapyd$_chain_assign_temp;
function _$rapyd$_equals(a, b) {
    try {
        return a.__eq__(b);
    } catch (_$rapyd$_Exception) {
        if (_$rapyd$_Exception instanceof TypeError) {
            return a === b;
        } else {
            throw _$rapyd$_Exception;
        }
    }
}
var equals = _$rapyd$_equals;;
function _$rapyd$_list_extend(iterable) {
    var start, iterator, result;
    if (Array.isArray(iterable) || typeof iterable === "string") {
        start = this.length;
        this.length += iterable.length;
        for (var i = 0; i < iterable.length; i++) {
            this[start + i] = iterable[i];
        }
    } else {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
        result = iterator.next();
        while (!result.done) {
            this.push(result.value);
            result = iterator.next();
        }
    }
}
function _$rapyd$_list_index(val, start, stop) {
    var idx;
    start = start || 0;
    if (start < 0) {
        start = this.length + start;
    }
    if (start < 0) {
        throw new ValueError(val + " is not in list");
    }
    if (stop === undefined) {
        idx = this.indexOf(val, start);
        if (idx === -1) {
            throw new ValueError(val + " is not in list");
        }
        return idx;
    }
    if (stop < 0) {
        stop = this.length + stop;
    }
    for (var i = start; i < stop; i++) {
        if (this[i] === val) {
            return i;
        }
    }
    throw new ValueError(val + " is not in list");
}
function _$rapyd$_list_pop(index) {
    var ans;
    if (this.length === 0) {
        throw new IndexError("list is empty");
    }
    ans = this.splice(index, 1);
    if (!ans.length) {
        throw new IndexError("pop index out of range");
    }
    return ans[0];
}
function _$rapyd$_list_remove(value) {
    var idx;
    idx = this.indexOf(value);
    if (idx === -1) {
        throw new ValueError(value + " not in list");
    }
    this.splice(idx, 1);
}
function _$rapyd$_list_to_string() {
    return "[" + this.join(", ") + "]";
}
function _$rapyd$_list_insert(index, val) {
    if (index < 0) {
        index += this.length;
    }
    index = min(this.length, max(index, 0));
    if (index === 0) {
        this.unshift(val);
        return;
    }
    for (var i = this.length; i > index; i--) {
        this[i] = this[i - 1];
    }
    this[index] = val;
}
function _$rapyd$_list_copy() {
    return _$rapyd$_list_constructor(this);
}
function _$rapyd$_list_clear() {
    this.length = 0;
}
function _$rapyd$_list_as_array() {
    return Array.prototype.slice.call(this);
}
function _$rapyd$_list_count(value) {
    return this.reduce(function(n, val) {
        return n + (val === value);
    }, 0);
}
function _$rapyd$_list_sort_key(value) {
    var t;
    t = typeof value;
    if (t === "string" || t === "number") {
        return value;
    }
    return value.toString();
}
function _$rapyd$_list_sort_cmp(a, b) {
    if (a < b) {
        return -1;
    }
    if (a > b) {
        return 1;
    }
    return 0;
}
function _$rapyd$_list_sort() {
    var key = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
    var reverse = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[1];
    var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
    if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
    if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "key")){
        key = _$rapyd$_kwargs_obj.key;
    }
    if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "reverse")){
        reverse = _$rapyd$_kwargs_obj.reverse;
    }
    var mult, keymap, k;
    key = key || _$rapyd$_list_sort_key;
    mult = (reverse) ? -1 : 1;
    keymap = dict();
    for (var i=0; i < this.length; i++) {
        k = this[i];
        keymap.set(k, key(k));
    }
    this.sort(function(a, b) {
        return mult * _$rapyd$_list_sort_cmp(keymap.get(a), keymap.get(b));
    });
}
function _$rapyd$_list_concat() {
    var ans;
    ans = Array.prototype.concat.apply(this, arguments);
    _$rapyd$_list_decorate(ans);
    return ans;
}
function _$rapyd$_list_slice() {
    var ans;
    ans = Array.prototype.slice.apply(this, arguments);
    _$rapyd$_list_decorate(ans);
    return ans;
}
function _$rapyd$_list_iterator(value) {
    var self;
    self = this;
    return {
        "_i": -1,
        "_list": self,
        "next": function() {
            this._i += 1;
            if (this._i >= this._list.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": this._list[this._i]
            };
        }
    };
}
function _$rapyd$_list_len() {
    return this.length;
}
function _$rapyd$_list_contains(val) {
    return this.indexOf(val) !== -1;
}
function _$rapyd$_list_eq(other) {
    if (!Array.isArray(other)) {
        return false;
    }
    if (other.length !== this.length) {
        return false;
    }
    if (other.length === 0) {
        return true;
    }
    for (var i = 0; i < other.length; i++) {
        if (!_$rapyd$_equals(this[i], other[i])) {
            return false;
        }
    }
    return true;
}
function _$rapyd$_list_decorate(ans) {
    ans.append = Array.prototype.push;
    ans.toString = _$rapyd$_list_to_string;
    ans.inspect = _$rapyd$_list_to_string;
    ans.extend = _$rapyd$_list_extend;
    ans.index = _$rapyd$_list_index;
    ans.pypop = _$rapyd$_list_pop;
    ans.remove = _$rapyd$_list_remove;
    ans.insert = _$rapyd$_list_insert;
    ans.copy = _$rapyd$_list_copy;
    ans.clear = _$rapyd$_list_clear;
    ans.count = _$rapyd$_list_count;
    ans.concat = _$rapyd$_list_concat;
    ans.pysort = _$rapyd$_list_sort;
    ans.slice = _$rapyd$_list_slice;
    ans.as_array = _$rapyd$_list_as_array;
    ans.__len__ = _$rapyd$_list_len;
    ans.__contains__ = _$rapyd$_list_contains;
    ans.__eq__ = _$rapyd$_list_eq;
    ans.constructor = _$rapyd$_list_constructor;
    if (typeof ans[_$rapyd$_iterator_symbol] !== "function") {
        ans[_$rapyd$_iterator_symbol] = _$rapyd$_list_iterator;
    }
    return ans;
}
function _$rapyd$_list_constructor(iterable) {
    var ans, iterator, result;
    if (iterable === undefined) {
        ans = [];
    } else if (_$rapyd$_arraylike(iterable)) {
        ans = new Array(iterable.length);
        for (var i = 0; i < iterable.length; i++) {
            ans[i] = iterable[i];
        }
    } else if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
        ans = _$rapyd$_list_decorate([]);
        result = iterator.next();
        while (!result.done) {
            ans.push(result.value);
            result = iterator.next();
        }
    } else if (typeof iterable === "number") {
        ans = new Array(iterable);
    } else {
        ans = Object.keys(iterable);
    }
    return _$rapyd$_list_decorate(ans);
}
_$rapyd$_list_constructor.__name__ = "list";
var list = _$rapyd$_list_constructor, list_wrap = _$rapyd$_list_decorate;
function sorted() {
    var iterable = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
    var key = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
    var reverse = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[2];
    var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
    if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
    if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "key")){
        key = _$rapyd$_kwargs_obj.key;
    }
    if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "reverse")){
        reverse = _$rapyd$_kwargs_obj.reverse;
    }
    var ans;
    ans = _$rapyd$_list_constructor(iterable);
    ans.pysort(key, reverse);
    return ans;
}
var _$rapyd$_global_object_id = 0, _$rapyd$_set_implementation;
function _$rapyd$_set_keyfor(x) {
    var t, ans;
    t = typeof x;
    if (t === "string" || t === "number" || t === "boolean") {
        return "_" + t[0] + x;
    }
    if (x === null) {
        return "__!@#$0";
    }
    ans = x._$rapyd$_hash_key_prop;
    if (ans === undefined) {
        ans = "_!@#$" + (++_$rapyd$_global_object_id);
        Object.defineProperty(x, "_$rapyd$_hash_key_prop", {
            "value": ans
        });
    }
    return ans;
}
function _$rapyd$_set_polyfill() {
    this._store = {};
    this.size = 0;
}
_$rapyd$_set_polyfill.prototype.add = function(x) {
    var key;
    key = _$rapyd$_set_keyfor(x);
    if (!Object.hasOwnProperty.call(this._store, key)) {
        this.size += 1;
        this._store[key] = x;
    }
    return this;
};
_$rapyd$_set_polyfill.prototype.clear = function(x) {
    this._store = {};
    this.size = 0;
};
_$rapyd$_set_polyfill.prototype.delete = function(x) {
    var key;
    key = _$rapyd$_set_keyfor(x);
    if (Object.hasOwnProperty.call(this._store, key)) {
        this.size -= 1;
        delete this._store[key];
        return true;
    }
    return false;
};
_$rapyd$_set_polyfill.prototype.has = function(x) {
    return Object.hasOwnProperty.call(this._store, _$rapyd$_set_keyfor(x));
};
_$rapyd$_set_polyfill.prototype.values = function(x) {
    var keys, s;
    keys = Object.keys(this._store);
    s = this._store;
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_keys"] = keys;
        _$rapyd$_d["_i"] = -1;
        _$rapyd$_d["_s"] = s;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            this._i += 1;
            if (this._i >= this._keys.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": s[this._keys[this._i]]
            };
        };
        return _$rapyd$_d;
    })();
};
if (typeof Set !== "function" || typeof Set.prototype.delete !== "function") {
    _$rapyd$_set_implementation = _$rapyd$_set_polyfill;
} else {
    _$rapyd$_set_implementation = Set;
}
function _$rapyd$_set(iterable) {
    var ans, s, iterator, result, keys;
    if (this instanceof _$rapyd$_set) {
        this.jsset = new _$rapyd$_set_implementation();
        ans = this;
        if (iterable === undefined) {
            return ans;
        }
        s = ans.jsset;
        if (_$rapyd$_arraylike(iterable)) {
            for (var i = 0; i < iterable.length; i++) {
                s.add(iterable[i]);
            }
        } else if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
            iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
            result = iterator.next();
            while (!result.done) {
                s.add(result.value);
                result = iterator.next();
            }
        } else {
            keys = Object.keys(iterable);
            for (var i=0; i < keys.length; i++) {
                s.add(keys[i]);
            }
        }
        return ans;
    } else {
        return new _$rapyd$_set(iterable);
    }
}
_$rapyd$_set.prototype.__name__ = "set";
Object.defineProperties(_$rapyd$_set.prototype, {
    "length": {
        "get": function() {
            return this.jsset.size;
        }
    },
    "size": {
        "get": function() {
            return this.jsset.size;
        }
    }
});
_$rapyd$_set.prototype.__len__ = function() {
    return this.jsset.size;
};
_$rapyd$_chain_assign_temp = function(x) {
    return this.jsset.has(x);
};
_$rapyd$_set.prototype.has = _$rapyd$_chain_assign_temp;
_$rapyd$_set.prototype.__contains__ = _$rapyd$_chain_assign_temp;
;
_$rapyd$_set.prototype.add = function(x) {
    this.jsset.add(x);
};
_$rapyd$_set.prototype.clear = function() {
    this.jsset.clear();
};
_$rapyd$_set.prototype.copy = function() {
    return _$rapyd$_set(this);
};
_$rapyd$_set.prototype.discard = function(x) {
    this.jsset.delete(x);
};
_$rapyd$_set.prototype[_$rapyd$_iterator_symbol] = function() {
    return this.jsset.values();
};
_$rapyd$_set.prototype.difference = function() {
    var ans, s, iterator, r, x, has;
    ans = new _$rapyd$_set();
    s = ans.jsset;
    iterator = this.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        has = false;
        for (var i = 0; i < arguments.length; i++) {
            if (arguments[i].has(x)) {
                has = true;
                break;
            }
        }
        if (!has) {
            s.add(x);
        }
        r = iterator.next();
    }
    return ans;
};
_$rapyd$_set.prototype.difference_update = function() {
    var s, remove, iterator, r, x;
    s = this.jsset;
    remove = [];
    iterator = s.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        for (var i = 0; i < arguments.length; i++) {
            if (arguments[i].has(x)) {
                remove.push(x);
                break;
            }
        }
        r = iterator.next();
    }
    for (var i = 0; i < remove.length; i++) {
        s.delete(remove[i]);
    }
};
_$rapyd$_set.prototype.intersection = function() {
    var ans, s, iterator, r, x, has;
    ans = new _$rapyd$_set();
    s = ans.jsset;
    iterator = this.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        has = true;
        for (var i = 0; i < arguments.length; i++) {
            if (!arguments[i].has(x)) {
                has = false;
                break;
            }
        }
        if (has) {
            s.add(x);
        }
        r = iterator.next();
    }
    return ans;
};
_$rapyd$_set.prototype.intersection_update = function() {
    var s, remove, iterator, r, x;
    s = this.jsset;
    remove = [];
    iterator = s.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        for (var i = 0; i < arguments.length; i++) {
            if (!arguments[i].has(x)) {
                remove.push(x);
                break;
            }
        }
        r = iterator.next();
    }
    for (var i = 0; i < remove.length; i++) {
        s.delete(remove[i]);
    }
};
_$rapyd$_set.prototype.isdisjoint = function(other) {
    var iterator, r, x;
    iterator = this.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        if (other.has(x)) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
_$rapyd$_set.prototype.issubset = function(other) {
    var iterator, r, x;
    iterator = this.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        if (!other.has(x)) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
_$rapyd$_set.prototype.issuperset = function(other) {
    var s, iterator, r, x;
    s = this.jsset;
    iterator = other.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        if (!s.has(x)) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
_$rapyd$_set.prototype.pop = function() {
    var iterator, r;
    iterator = this.jsset.values();
    r = iterator.next();
    if (r.done) {
        throw new KeyError("pop from an empty set");
    }
    this.jsset.delete(r.value);
    return r.value;
};
_$rapyd$_set.prototype.remove = function(x) {
    if (!this.jsset.delete(x)) {
        throw new KeyError(x.toString());
    }
};
_$rapyd$_set.prototype.symmetric_difference = function(other) {
    return this.union(other).difference(this.intersection(other));
};
_$rapyd$_set.prototype.symmetric_difference_update = function(other) {
    var common;
    common = this.intersection(other);
    this.update(other);
    this.difference_update(common);
};
_$rapyd$_set.prototype.union = function() {
    var ans;
    ans = _$rapyd$_set(this);
    ans.update.apply(ans, arguments);
    return ans;
};
_$rapyd$_set.prototype.update = function() {
    var s, iterator, r;
    s = this.jsset;
    for (var i=0; i < arguments.length; i++) {
        iterator = arguments[i][_$rapyd$_iterator_symbol]();
        r = iterator.next();
        while (!r.done) {
            s.add(r.value);
            r = iterator.next();
        }
    }
};
_$rapyd$_chain_assign_temp = function() {
    return "{" + list(this).join(", ") + "}";
};
_$rapyd$_set.prototype.toString = _$rapyd$_chain_assign_temp;
_$rapyd$_set.prototype.inspect = _$rapyd$_chain_assign_temp;
;
_$rapyd$_set.prototype.__eq__ = function(other) {
    var iterator, r;
    if (!(other instanceof this.constructor)) {
        return false;
    }
    if (other.size !== this.size) {
        return false;
    }
    if (other.size === 0) {
        return true;
    }
    iterator = other[_$rapyd$_iterator_symbol]();
    r = iterator.next();
    while (!r.done) {
        if (!this.has(r.value)) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
function _$rapyd$_set_wrap(x) {
    var ans;
    ans = new _$rapyd$_set();
    ans.jsset = x;
    return ans;
}
var set = _$rapyd$_set, set_wrap = _$rapyd$_set_wrap;
var _$rapyd$_dict_implementation;
function _$rapyd$_dict_polyfill() {
    this._store = {};
    this.size = 0;
}
_$rapyd$_dict_polyfill.prototype.set = function(x, value) {
    var key;
    key = _$rapyd$_set_keyfor(x);
    if (!Object.hasOwnProperty.call(this._store, key)) {
        this.size += 1;
    }
    this._store[key] = [x, value];
    return this;
};
_$rapyd$_dict_polyfill.prototype.clear = function(x) {
    this._store = {};
    this.size = 0;
};
_$rapyd$_dict_polyfill.prototype.delete = function(x) {
    var key;
    key = _$rapyd$_set_keyfor(x);
    if (Object.hasOwnProperty.call(this._store, key)) {
        this.size -= 1;
        delete this._store[key];
        return true;
    }
    return false;
};
_$rapyd$_dict_polyfill.prototype.has = function(x) {
    return Object.hasOwnProperty.call(this._store, _$rapyd$_set_keyfor(x));
};
_$rapyd$_dict_polyfill.prototype.get = function(x) {
    try {
        return this._store[_$rapyd$_set_keyfor(x)][1];
    } catch (_$rapyd$_Exception) {
        if (_$rapyd$_Exception instanceof TypeError) {
            return undefined;
        } else {
            throw _$rapyd$_Exception;
        }
    }
};
_$rapyd$_dict_polyfill.prototype.values = function(x) {
    var keys, s;
    keys = Object.keys(this._store);
    s = this._store;
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_keys"] = keys;
        _$rapyd$_d["_i"] = -1;
        _$rapyd$_d["_s"] = s;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            this._i += 1;
            if (this._i >= this._keys.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": s[this._keys[this._i]][1]
            };
        };
        return _$rapyd$_d;
    })();
};
_$rapyd$_dict_polyfill.prototype.keys = function(x) {
    var keys, s;
    keys = Object.keys(this._store);
    s = this._store;
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_keys"] = keys;
        _$rapyd$_d["_i"] = -1;
        _$rapyd$_d["_s"] = s;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            this._i += 1;
            if (this._i >= this._keys.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": s[this._keys[this._i]][0]
            };
        };
        return _$rapyd$_d;
    })();
};
_$rapyd$_dict_polyfill.prototype.entries = function(x) {
    var keys, s;
    keys = Object.keys(this._store);
    s = this._store;
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_keys"] = keys;
        _$rapyd$_d["_i"] = -1;
        _$rapyd$_d["_s"] = s;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            this._i += 1;
            if (this._i >= this._keys.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": s[this._keys[this._i]]
            };
        };
        return _$rapyd$_d;
    })();
};
if (typeof Map !== "function" || typeof Map.prototype.delete !== "function") {
    _$rapyd$_dict_implementation = _$rapyd$_dict_polyfill;
} else {
    _$rapyd$_dict_implementation = Map;
}
function _$rapyd$_dict(iterable) {
    if (this instanceof _$rapyd$_dict) {
        this.jsmap = new _$rapyd$_dict_implementation();
        if (iterable !== undefined) {
            this.update(iterable);
        }
        return this;
    } else {
        return new _$rapyd$_dict(iterable);
    }
}
_$rapyd$_dict.prototype.__name__ = "dict";
Object.defineProperties(_$rapyd$_dict.prototype, {
    "length": {
        "get": function() {
            return this.jsmap.size;
        }
    },
    "size": {
        "get": function() {
            return this.jsmap.size;
        }
    }
});
_$rapyd$_dict.prototype.__len__ = function() {
    return this.jsmap.size;
};
_$rapyd$_chain_assign_temp = function(x) {
    return this.jsmap.has(x);
};
_$rapyd$_dict.prototype.has = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.__contains__ = _$rapyd$_chain_assign_temp;
;
_$rapyd$_chain_assign_temp = function(key, value) {
    this.jsmap.set(key, value);
};
_$rapyd$_dict.prototype.set = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.__setitem__ = _$rapyd$_chain_assign_temp;
;
_$rapyd$_dict.prototype.clear = function() {
    this.jsmap.clear();
};
_$rapyd$_dict.prototype.copy = function() {
    return _$rapyd$_dict(this);
};
_$rapyd$_dict.prototype.keys = function() {
    return this.jsmap.keys();
};
_$rapyd$_dict.prototype.values = function() {
    return this.jsmap.values();
};
_$rapyd$_chain_assign_temp = function() {
    return this.jsmap.entries();
};
_$rapyd$_dict.prototype.items = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.entries = _$rapyd$_chain_assign_temp;
;
_$rapyd$_dict.prototype[_$rapyd$_iterator_symbol] = function() {
    return this.jsmap.keys();
};
_$rapyd$_dict.prototype.__getitem__ = function(key) {
    var ans;
    ans = this.jsmap.get(key);
    if (ans === undefined && !this.jsmap.has(key)) {
        throw new KeyError(key + "");
    }
    return ans;
};
_$rapyd$_dict.prototype.get = function(key, defval) {
    var ans;
    ans = this.jsmap.get(key);
    if (ans === undefined && !this.jsmap.has(key)) {
        return (defval === undefined) ? null : defval;
    }
    return ans;
};
_$rapyd$_dict.prototype.set_default = function(key, defval) {
    var j;
    j = this.jsmap;
    if (!j.has(key)) {
        j.set(key, defval);
        return defval;
    }
    return j.get(key);
};
_$rapyd$_chain_assign_temp = function() {
    var iterable = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
    var value = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
    var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
    if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
    if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "value")){
        value = _$rapyd$_kwargs_obj.value;
    }
    var ans, iterator, r;
    ans = _$rapyd$_dict();
    iterator = iter(iterable);
    r = iterator.next();
    while (!r.done) {
        ans.set(r.value, value);
        r = iterator.next();
    }
    return ans;
};
_$rapyd$_dict.fromkeys = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.fromkeys = _$rapyd$_chain_assign_temp;
;
_$rapyd$_dict.prototype.pop = function(key, defval) {
    var ans;
    ans = this.jsmap.get(key);
    if (ans === undefined && !this.jsmap.has(key)) {
        if (defval === undefined) {
            throw new KeyError(key);
        }
        return defval;
    }
    this.jsmap.delete(key);
    return ans;
};
_$rapyd$_dict.prototype.popitem = function() {
    var r;
    r = this.jsmap.entries().next();
    if (r.done) {
        throw new KeyError("dict is empty");
    }
    this.jsmap.delete(r.value[0]);
    return r.value;
};
_$rapyd$_dict.prototype.update = function() {
    var m, iterable, iterator, result, keys;
    if (arguments.length === 0) {
        return;
    }
    m = this.jsmap;
    iterable = arguments[0];
    if (Array.isArray(iterable)) {
        for (var i = 0; i < iterable.length; i++) {
            m.set(iterable[i][0], iterable[i][1]);
        }
    } else if (iterable instanceof _$rapyd$_dict) {
        iterator = iterable.items();
        result = iterator.next();
        while (!result.done) {
            m.set(result.value[0], result.value[1]);
            result = iterator.next();
        }
    } else if (typeof Map === "function" && iterable instanceof Map) {
        iterator = iterable.entries();
        result = iterator.next();
        while (!result.done) {
            m.set(result.value[0], result.value[1]);
            result = iterator.next();
        }
    } else if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
        iterator = iterable[_$rapyd$_iterator_symbol]();
        result = iterator.next();
        while (!result.done) {
            m.set(result.value[0], result.value[1]);
            result = iterator.next();
        }
    } else {
        keys = Object.keys(iterable);
        for (var i=0; i < keys.length; i++) {
            if (keys[i] !== _$rapyd$_iterator_symbol) {
                m.set(keys[i], iterable[keys[i]]);
            }
        }
    }
    if (arguments.length > 1) {
        _$rapyd$_dict.prototype.update.call(this, arguments[1]);
    }
};
_$rapyd$_chain_assign_temp = function() {
    var entries, iterator, r;
    entries = [];
    iterator = this.jsmap.entries();
    r = iterator.next();
    while (!r.done) {
        entries.push(r.value[0] + ": " + r.value[1]);
        r = iterator.next();
    }
    return "{" + entries.join(", ") + "}";
};
_$rapyd$_dict.prototype.toString = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.inspect = _$rapyd$_chain_assign_temp;
;
_$rapyd$_dict.prototype.__eq__ = function(other) {
    var iterator, r, x;
    if (!(other instanceof this.constructor)) {
        return false;
    }
    if (other.size !== this.size) {
        return false;
    }
    if (other.size === 0) {
        return true;
    }
    iterator = other.items();
    r = iterator.next();
    while (!r.done) {
        x = this.jsmap.get(r.value[0]);
        if (x === undefined && !this.jsmap.has(r.value[0]) || x !== r.value[1]) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
_$rapyd$_dict.prototype.as_object = function(other) {
    var ans, iterator, r;
    ans = {};
    iterator = this.jsmap.entries();
    r = iterator.next();
    while (!r.done) {
        ans[r.value[0]] = r.value[1];
        r = iterator.next();
    }
    return ans;
};
function _$rapyd$_dict_wrap(x) {
    var ans;
    ans = new _$rapyd$_dict();
    ans.jsmap = x;
    return ans;
}
var dict = _$rapyd$_dict, dict_wrap = _$rapyd$_dict_wrap;;
    function _$rapyd$_bool(val) {
    return !!val;
}
function _$rapyd$_bind(fn, thisArg) {
    var ret;
    if (fn.orig) {
        fn = fn.orig;
    }
    if (thisArg === false) {
        return fn;
    }
    ret = function() {
        return fn.apply(thisArg, arguments);
    };
    ret.orig = fn;
    return ret;
}
function _$rapyd$_rebind_all(thisArg, rebind) {
    if (typeof rebind === "undefined") {
        rebind = true;
    }
    for (var p in thisArg) {
        if (thisArg[p] && thisArg[p].orig) {
            if (rebind) {
                thisArg[p] = _$rapyd$_bind(thisArg[p], thisArg);
            } else {
                thisArg[p] = thisArg[p].orig;
            }
        }
    }
}
function _$rapyd$_eslice(arr, step, start, end) {
    var isString;
    arr = arr.slice(0);
    if (typeof arr === "string" || arr instanceof String) {
        isString = true;
        arr = arr.split("");
    }
    if (step < 0) {
        step = -step;
        arr.reverse();
        if (typeof start !== "undefined") {
            start = arr.length - start - 1;
        }
        if (typeof end !== "undefined") {
            end = arr.length - end - 1;
        }
    }
    if (typeof start === "undefined") {
        start = 0;
    }
    if (typeof end === "undefined") {
        end = arr.length;
    }
    arr = arr.slice(start, end).filter(function(e, i) {
        return i % step === 0;
    });
    return (isString) ? arr.join("") : arr;
}
function _$rapyd$_mixin(target, source, overwrite) {
    for (var i in source) {
        if (source.hasOwnProperty(i) && overwrite || typeof target[i] === "undefined") {
            target[i] = source[i];
        }
    }
}
function _$rapyd$_print() {
    var parts;
    if (typeof console === "object") {
        parts = [];
        for (var i = 0; i < arguments.length; i++) {
            parts.push(_$rapyd$_str(arguments[i]));
        }
        console.log(parts.join(" "));
    }
}
function _$rapyd$_int(val, base) {
    var ans;
    ans = parseInt(val, base || 10);
    if (isNaN(ans)) {
        throw new ValueError("Invalid literal for int with base " + (base || 10) + ": " + val);
    }
    return ans;
}
function _$rapyd$_float() {
    var ans;
    ans = parseFloat.apply(null, arguments);
    if (isNaN(ans)) {
        throw new ValueError("Could not convert string to float: " + arguments[0]);
    }
    return ans;
}
function _$rapyd$_arraylike_creator() {
    var names;
    if (typeof HTMLCollection === "function") {
        names = ["[object HTMLCollection]", "[object NodeList]", "[object NamedNodeMap]"];
        return function(x) {
            if (Array.isArray(x) || typeof x === "string" || names.indexOf(Object.prototype.toString.call(x)) > -1) {
                return true;
            }
            return false;
        };
    }
    return function(x) {
        if (Array.isArray(x) || typeof x === "string") {
            return true;
        }
        return false;
    };
}
function options_object(f) {
    return function() {
        if (typeof arguments[arguments.length - 1] === "object") {
            arguments[arguments.length - 1][_$rapyd$_kwargs_symbol] = true;
        }
        return f.apply(this, arguments);
    };
}
function _$rapyd$_id(x) {
    return x._$rapyd$_object_id;
}
var bool = _$rapyd$_bool, bind = _$rapyd$_bind, rebind_all = _$rapyd$_rebind_all;
var float = _$rapyd$_float, int = _$rapyd$_int, arraylike = _$rapyd$_arraylike_creator(), _$rapyd$_arraylike = arraylike;
var mixin = _$rapyd$_mixin, print = _$rapyd$_print, eslice = _$rapyd$_eslice, id = _$rapyd$_id;;
    function _$rapyd$_repr_js_builtin(x, as_array) {
    var ans, b, keys, key;
    ans = [];
    b = "{}";
    if (as_array) {
        b = "[]";
        for (var i = 0; i < x.length; i++) {
            ans.push(_$rapyd$_repr(x[i]));
        }
    } else {
        keys = Object.keys(x);
        for (var k = 0; k < keys.length; k++) {
            key = keys[k];
            ans.push(JSON.stringify(key) + ":" + _$rapyd$_repr(x[key]));
        }
    }
    return b[0] + ans.join(", ") + b[1];
}
function _$rapyd$_repr(x) {
    var ans;
    if (x === null) {
        return "None";
    }
    if (x === undefined) {
        return "undefined";
    }
    ans = x;
    if (typeof x.__repr__ === "function") {
        ans = x.__repr__();
    } else if (x === true || x === false) {
        ans = (x) ? "True" : "False";
    } else if (Array.isArray(x)) {
        ans = _$rapyd$_repr_js_builtin(x, true);
    } else {
        ans = (typeof x.toString === "function") ? x.toString() : x;
        if (ans === "[object Object]") {
            return _$rapyd$_repr_js_builtin(x);
        }
        try {
            ans = JSON.stringify(x);
        } catch (_$rapyd$_Exception) {
        }
    }
    return ans + "";
}
function _$rapyd$_str(x) {
    var ans;
    if (x === null) {
        return "None";
    }
    if (x === undefined) {
        return "undefined";
    }
    ans = x;
    if (typeof x.__str__ === "function") {
        ans = x.__str__();
    } else if (typeof x.__repr__ === "function") {
        ans = x.__repr__();
    } else if (x === true || x === false) {
        ans = (x) ? "True" : "False";
    } else if (Array.isArray(x)) {
        ans = _$rapyd$_repr_js_builtin(x, true);
    } else if (typeof x.toString === "function") {
        ans = x.toString();
        if (ans === "[object Object]") {
            ans = _$rapyd$_repr_js_builtin(x);
        }
    }
    return ans + "";
}
_$rapyd$_str.format = function() {
    var template, args, kwargs, explicit, implicit, _$rapyd$_chain_assign_temp, idx, ans, pos, in_brace, markup, ch;
    template = arguments[0];
    if (template === undefined) {
        throw new TypeError("Template is required");
    }
    args = Array.prototype.slice.call(arguments, 1);
    kwargs = {};
    if (args.length && args[args.length-1][_$rapyd$_kwargs_symbol] !== undefined) {
        kwargs = args[args.length-1];
        args = args.slice(0, -1);
    }
    _$rapyd$_chain_assign_temp = false;
    explicit = _$rapyd$_chain_assign_temp;
    implicit = _$rapyd$_chain_assign_temp;
;
    idx = 0;
    if (_$rapyd$_str.format._template_resolve_pat === undefined) {
        _$rapyd$_str.format._template_resolve_pat = /[.\[]/;
    }
    function resolve(arg, object) {
        var _$rapyd$_unpack, first, key, rest, ans;
        if (!arg) {
            return object;
        }
        _$rapyd$_unpack = [arg[0], arg.slice(1)];
        first = _$rapyd$_unpack[0];
        arg = _$rapyd$_unpack[1];
        key = arg.split(_$rapyd$_str.format._template_resolve_pat, 1)[0];
        rest = arg.slice(key.length);
        ans = (first === "[") ? object[key.slice(0, -1)] : getattr(object, key);
        if (ans === undefined) {
            throw new KeyError((first === "[") ? key.slice(0, -1) : key);
        }
        return resolve(rest, ans);
    }
    function resolve_format_spec(format_spec) {
        if (_$rapyd$_str.format._template_resolve_fs_pat === undefined) {
            _$rapyd$_str.format._template_resolve_fs_pat = /[{]([a-zA-Z0-9_]+)[}]/g;
        }
        return format_spec.replace(_$rapyd$_str.format._template_resolve_fs_pat, function(match, key) {
            if (!Object.prototype.hasOwnProperty.call(kwargs, key)) {
                return "";
            }
            return "" + kwargs[key];
        });
    }
    function apply_formatting(value, format_spec) {
        var _$rapyd$_unpack, fill, align, sign, fhash, zeropad, width, comma, precision, ftype, is_numeric, is_int, lftype, code, exp, nval, is_positive, left, right;
        if (format_spec.indexOf("{") !== -1) {
            format_spec = resolve_format_spec(format_spec);
        }
        if (_$rapyd$_str.format._template_format_pat === undefined) {
            _$rapyd$_str.format._template_format_pat = /([^{}](?=[<>=^]))?([<>=^])?([-+\x20])?(\#)?(0)?(\d+)?(,)?(?:\.(\d+))?([bcdeEfFgGnosxX%])?/;
        }
        try {
            _$rapyd$_unpack = format_spec.match(_$rapyd$_str.format._template_format_pat).slice(1);
            fill = _$rapyd$_unpack[0];
            align = _$rapyd$_unpack[1];
            sign = _$rapyd$_unpack[2];
            fhash = _$rapyd$_unpack[3];
            zeropad = _$rapyd$_unpack[4];
            width = _$rapyd$_unpack[5];
            comma = _$rapyd$_unpack[6];
            precision = _$rapyd$_unpack[7];
            ftype = _$rapyd$_unpack[8];
        } catch (_$rapyd$_Exception) {
            if (_$rapyd$_Exception instanceof TypeError) {
                return value;
            } else {
                throw _$rapyd$_Exception;
            }
        }
        if (zeropad) {
            fill = fill || "0";
            align = align || "=";
        } else {
            fill = fill || " ";
            align = align || ">";
        }
        is_numeric = Number(value) === value;
        is_int = is_numeric && value % 1 === 0;
        precision = parseInt(precision, 10);
        lftype = (ftype || "").toLowerCase();
        if (ftype === "n") {
            is_numeric = true;
            if (is_int) {
                if (comma) {
                    throw new ValueError("Cannot specify ',' with 'n'");
                }
                value = parseInt(value, 10).toLocaleString();
            } else {
                value = parseFloat(value).toLocaleString();
            }
        } else if (['b', 'c', 'd', 'o', 'x'].indexOf(lftype) !== -1) {
            value = parseInt(value, 10);
            is_numeric = true;
            if (!isNaN(value)) {
                if (ftype === "b") {
                    value = (value >>> 0).toString(2);
                    if (fhash) {
                        value = "0b" + value;
                    }
                } else if (ftype === "c") {
                    if (value > 65535) {
                        code = value - 65536;
                        value = String.fromCharCode(55296 + (code >> 10), 56320 + (code & 1023));
                    } else {
                        value = String.fromCharCode(value);
                    }
                } else if (ftype === "d") {
                    if (comma) {
                        value = value.toLocaleString("en-US");
                    } else {
                        value = value.toString(10);
                    }
                } else if (ftype === "o") {
                    value = value.toString(8);
                    if (fhash) {
                        value = "0o" + value;
                    }
                } else if (lftype === "x") {
                    value = value.toString(16);
                    value = (ftype === "x") ? value.toLowerCase() : value.toUpperCase();
                    if (fhash) {
                        value = "0x" + value;
                    }
                }
            }
        } else if (['e','f','g','%'].indexOf(lftype) !== -1) {
            is_numeric = true;
            value = parseFloat(value);
            if (lftype === "e") {
                value = value.toExponential((isNaN(precision)) ? 6 : precision);
                value = (ftype === "E") ? value.toUpperCase() : value.toLowerCase();
            } else if (lftype === "f") {
                value = value.toFixed((isNaN(precision)) ? 6 : precision);
                value = (ftype === "F") ? value.toUpperCase() : value.toLowerCase();
            } else if (ftype === "%") {
                value *= 100;
                value = value.toFixed((isNaN(precision)) ? 6 : precision) + "%";
            } else if (lftype === "g") {
                if (isNaN(precision)) {
                    precision = 6;
                }
                precision = max(1, precision);
                exp = parseInt(value.toExponential(precision - 1).toLowerCase().split("e")[1], 10);
                if (-4 <= exp && exp < precision) {
                    value = value.toFixed(precision - 1 - exp);
                } else {
                    value = value.toExponential(precision - 1);
                }
                value = value.replace(/0+$/g, "");
                if (value[value.length-1] === ".") {
                    value = value.slice(0, -1);
                }
                if (ftype === "G") {
                    value = value.toUpperCase();
                }
            }
        } else {
            value += "";
            if (!isNaN(precision)) {
                value = value.slice(0, precision);
            }
        }
        value += "";
        if (is_numeric && sign) {
            nval = Number(value);
            is_positive = !isNaN(nval) && nval >= 0;
            if (is_positive && (sign === " " || sign === "+")) {
                value = sign + value;
            }
        }
        function repeat(char, num) {
            return (new Array(num+1)).join(char);
        }
        if (is_numeric && width && width[0] === "0") {
            width = width.slice(1);
            _$rapyd$_unpack = ["0", "="];
            fill = _$rapyd$_unpack[0];
            align = _$rapyd$_unpack[1];
        }
        width = parseInt(width || "-1", 10);
        if (isNaN(width)) {
            throw new ValueError("Invalid width specification: " + width);
        }
        if (fill && value.length < width) {
            if (align === "<") {
                value = value + repeat(fill, width - value.length);
            } else if (align === ">") {
                value = repeat(fill, width - value.length) + value;
            } else if (align === "^") {
                left = Math.floor((width - value.length) / 2);
                right = width - left - value.length;
                value = repeat(fill, left) + value + repeat(fill, right);
            } else if (align === "=") {
                if (_$rapyd$_in(value[0], "+- ")) {
                    value = value[0] + repeat(fill, width - value.length) + value.slice(1);
                } else {
                    value = repeat(fill, width - value.length) + value;
                }
            } else {
                throw new ValueError("Unrecognized alignment: " + align);
            }
        }
        return value;
    }
    function parse_markup(markup) {
        var key, transformer, format_spec, _$rapyd$_chain_assign_temp, pos, state, ch;
        _$rapyd$_chain_assign_temp = "";
        key = _$rapyd$_chain_assign_temp;
        transformer = _$rapyd$_chain_assign_temp;
        format_spec = _$rapyd$_chain_assign_temp;
;
        pos = 0;
        state = 0;
        while (pos < markup.length) {
            ch = markup[pos];
            if (state === 0) {
                if (ch === "!") {
                    state = 1;
                } else if (ch === ":") {
                    state = 2;
                } else {
                    key += ch;
                }
            } else if (state === 1) {
                if (ch === ":") {
                    state = 2;
                } else {
                    transformer += ch;
                }
            } else {
                format_spec += ch;
            }
            pos += 1;
        }
        return [key, transformer, format_spec];
    }
    function render_markup(markup) {
        var _$rapyd$_unpack, key, transformer, format_spec, lkey, nvalue, object, ans;
        _$rapyd$_unpack = parse_markup(markup);
        key = _$rapyd$_unpack[0];
        transformer = _$rapyd$_unpack[1];
        format_spec = _$rapyd$_unpack[2];
        if (transformer && ['a', 'r', 's'].indexOf(transformer) === -1) {
            throw new ValueError("Unknown conversion specifier: " + transformer);
        }
        lkey = key.length && key.split(/[.\[]/, 1)[0];
        if (lkey) {
            explicit = true;
            if (implicit) {
                throw new ValueError("cannot switch from automatic field numbering to manual field specification");
            }
            nvalue = parseInt(lkey);
            object = (isNaN(nvalue)) ? kwargs[lkey] : args[nvalue];
            if (object === undefined) {
                if (isNaN(nvalue)) {
                    throw new KeyError(lkey);
                }
                throw new IndexError(lkey);
            }
            object = resolve(key.slice(lkey.length), object);
        } else {
            implicit = true;
            if (explicit) {
                throw new ValueError("cannot switch from manual field specification to automatic field numbering");
            }
            if (idx >= args.length) {
                throw new IndexError("Not enough arguments to match template: " + template);
            }
            object = args[idx];
            idx += 1;
        }
        if (typeof object === "function") {
            object = object();
        }
        ans = "" + object;
        if (format_spec) {
            ans = apply_formatting(ans, format_spec);
        }
        return ans;
    }
    ans = "";
    pos = 0;
    in_brace = 0;
    markup = "";
    while (pos < template.length) {
        ch = template[pos];
        if (in_brace) {
            if (ch === "{") {
                in_brace += 1;
                markup += "{";
            } else if (ch === "}") {
                in_brace -= 1;
                if (in_brace > 0) {
                    markup += "}";
                } else {
                    ans += render_markup(markup);
                }
            } else {
                markup += ch;
            }
        } else {
            if (ch === "{") {
                if (template[pos + 1] === "{") {
                    pos += 1;
                    ans += "{";
                } else {
                    in_brace = 1;
                    markup = "";
                }
            } else {
                ans += ch;
            }
        }
        pos += 1;
    }
    if (in_brace) {
        throw new ValueError("expected '}' before end of string");
    }
    return ans;
};
_$rapyd$_str.capitalize = function(string) {
    if (string) {
        string = string[0].toUpperCase() + string.slice(1).toLowerCase();
    }
    return string;
};
_$rapyd$_str.center = function(string, width, fill) {
    var left, right;
    left = Math.floor((width - string.length) / 2);
    right = width - left - string.length;
    fill = fill || " ";
    return new Array(left+1).join(fill) + string + new Array(right+1).join(fill);
};
_$rapyd$_str.count = function(string, needle, start, end) {
    var _$rapyd$_unpack, pos, step, ans;
    start = start || 0;
    end = end || string.length;
    if (start < 0 || end < 0) {
        string = string.slice(start, end);
        _$rapyd$_unpack = [0, string.length];
        start = _$rapyd$_unpack[0];
        end = _$rapyd$_unpack[1];
    }
    pos = start;
    step = needle.length;
    ans = 0;
    while (pos !== -1) {
        pos = string.indexOf(needle, pos);
        if (pos !== -1) {
            ans += 1;
            pos += step;
        }
    }
    return ans;
};
_$rapyd$_str.endswith = function(string, suffixes, start, end) {
    var q;
    start = start || 0;
    if (typeof suffixes === "string") {
        suffixes = [suffixes];
    }
    if (end !== undefined) {
        string = string.slice(0, end);
    }
    for (var i = 0; i < suffixes.length; i++) {
        q = suffixes[i];
        if (string.indexOf(q, Math.max(start, string.length - q.length)) !== -1) {
            return true;
        }
    }
    return false;
};
_$rapyd$_str.startswith = function(string, prefixes, start, end) {
    var prefix;
    start = start || 0;
    if (typeof prefixes === "string") {
        prefixes = [prefixes];
    }
    for (var i = 0; i < prefixes.length; i++) {
        prefix = prefixes[i];
        end = (end === undefined) ? string.length : end;
        if (end - start >= prefix.length && prefix === string.slice(start, start + prefix.length)) {
            return true;
        }
    }
    return false;
};
_$rapyd$_str.find = function(string, needle, start, end) {
    var ans;
    while (start < 0) {
        start += string.length;
    }
    ans = string.indexOf(needle, start);
    if (end !== undefined && ans !== -1) {
        while (end < 0) {
            end += string.length;
        }
        if (ans >= end - needle.length) {
            return -1;
        }
    }
    return ans;
};
_$rapyd$_str.rfind = function(string, needle, start, end) {
    var ans;
    while (end < 0) {
        end += string.length;
    }
    ans = string.lastIndexOf(needle, end - 1);
    if (start !== undefined && ans !== -1) {
        while (start < 0) {
            start += string.length;
        }
        if (ans < start) {
            return -1;
        }
    }
    return ans;
};
_$rapyd$_str.index = function(string, needle, start, end) {
    var ans;
    ans = _$rapyd$_str.find.apply(null, arguments);
    if (ans === -1) {
        throw new ValueError("substring not found");
    }
    return ans;
};
_$rapyd$_str.rindex = function(string, needle, start, end) {
    var ans;
    ans = _$rapyd$_str.rfind.apply(null, arguments);
    if (ans === -1) {
        throw new ValueError("substring not found");
    }
    return ans;
};
_$rapyd$_str.islower = function(string) {
    return string.length > 0 && string.toUpperCase() !== string;
};
_$rapyd$_str.isupper = function(string) {
    return string.length > 0 && string.toLowerCase() !== string;
};
_$rapyd$_str.isspace = function(string) {
    return string.length > 0 && /^\s+$/.test(string);
};
_$rapyd$_str.join = function(string, iterable) {
    var ans, r;
    if (Array.isArray(iterable)) {
        return iterable.join(string);
    }
    ans = "";
    r = iterable.next();
    while (!r.done) {
        if (ans) {
            ans += string;
        }
        ans += r.value;
        r = iterable.next();
    }
    return ans;
};
_$rapyd$_str.ljust = function(string, width, fill) {
    if (width > string.length) {
        fill = fill || " ";
        string += new Array(width - string.length + 1).join(fill);
    }
    return string;
};
_$rapyd$_str.rjust = function(string, width, fill) {
    if (width > string.length) {
        fill = fill || " ";
        string = new Array(width - string.length + 1).join(fill) + string;
    }
    return string;
};
_$rapyd$_str.lower = function(string) {
    return string.toLowerCase();
};
_$rapyd$_str.upper = function(string) {
    return string.toUpperCase();
};
_$rapyd$_str.lstrip = function(string, chars) {
    var pos;
    pos = 0;
    chars = chars || _$rapyd$_str.whitespace;
    while (chars.indexOf(string[pos]) !== -1) {
        pos += 1;
    }
    if (pos) {
        string = string.slice(pos);
    }
    return string;
};
_$rapyd$_str.rstrip = function(string, chars) {
    var pos;
    pos = string.length - 1;
    chars = chars || _$rapyd$_str.whitespace;
    while (chars.indexOf(string[pos]) !== -1) {
        pos -= 1;
    }
    if (pos < string.length - 1) {
        string = string.slice(0, pos + 1);
    }
    return string;
};
_$rapyd$_str.strip = function(string, chars) {
    return _$rapyd$_str.lstrip(_$rapyd$_str.rstrip(string, chars), chars);
};
_$rapyd$_str.partition = function(string, sep) {
    var idx;
    idx = string.indexOf(sep);
    if (idx === -1) {
        return [string, "", ""];
    }
    return [string.slice(0, idx), sep, string.slice(idx + sep.length)];
};
_$rapyd$_str.rpartition = function(string, sep) {
    var idx;
    idx = string.lastIndexOf(sep);
    if (idx === -1) {
        return ["", "", string];
    }
    return [string.slice(0, idx), sep, string.slice(idx + sep.length)];
};
_$rapyd$_str.replace = function(string, old, repl, count) {
    var pos, idx;
    if (count === 1) {
        return string.replace(old, repl);
    }
    if (count < 1) {
        return string;
    }
    count = count || Number.MAX_VALUE;
    pos = 0;
    while (count > 0) {
        count -= 1;
        idx = string.indexOf(old, pos);
        if (idx === -1) {
            break;
        }
        pos = idx + repl.length;
        string = string.slice(0, idx) + repl + string.slice(idx + old.length);
    }
    return string;
};
_$rapyd$_str.split = function(string, sep, maxsplit) {
    var ans, extra, parts;
    if (maxsplit === 0) {
        return _$rapyd$_list_decorate([ string ]);
    }
    if (sep === undefined || sep === null) {
        if (maxsplit > 0) {
            ans = string.split(/(\s+)/);
            extra = "";
            parts = [];
            for (var i = 0; i < ans.length; i++) {
                if (parts.length >= maxsplit + 1) {
                    extra += ans[i];
                } else if (i % 2 === 0) {
                    parts.push(ans[i]);
                }
            }
            parts[parts.length-1] += extra;
            ans = parts;
        } else {
            ans = string.split(/\s+/);
        }
    } else {
        if (sep === "") {
            throw new ValueError("empty separator");
        }
        ans = string.split(sep);
        if (maxsplit > 0 && ans.length > maxsplit) {
            extra = ans.slice(maxsplit).join(sep);
            ans = ans.slice(0, maxsplit);
            ans.push(extra);
        }
    }
    return _$rapyd$_list_decorate(ans);
};
_$rapyd$_str.rsplit = function(string, sep, maxsplit) {
    var ans, is_space, pos, current, spc, ch, end, _$rapyd$_chain_assign_temp, idx;
    if (!maxsplit) {
        return _$rapyd$_str.split.call(null, string, sep, maxsplit);
    }
    if (sep === undefined || sep === null) {
        if (maxsplit > 0) {
            ans = [];
            is_space = /\s/;
            pos = string.length - 1;
            current = "";
            while (pos > -1 && maxsplit > 0) {
                spc = false;
                ch = string[pos];
                while (pos > -1 && is_space.test(ch)) {
                    spc = true;
                    ch = string[--pos];
                }
                if (spc) {
                    if (current) {
                        ans.push(current);
                        maxsplit -= 1;
                    }
                    current = ch;
                } else {
                    current += ch;
                }
                pos -= 1;
            }
            ans.push(string.slice(0, pos + 1) + current);
            ans.reverse();
        } else {
            ans = string.split(/\s+/);
        }
    } else {
        if (sep === "") {
            throw new ValueError("empty separator");
        }
        ans = [];
        _$rapyd$_chain_assign_temp = string.length;
        pos = _$rapyd$_chain_assign_temp;
        end = _$rapyd$_chain_assign_temp;
;
        while (pos > -1 && maxsplit > 0) {
            maxsplit -= 1;
            idx = string.lastIndexOf(sep, pos);
            if (idx === -1) {
                break;
            }
            ans.push(string.slice(idx + sep.length, end));
            pos = idx - 1;
            end = idx;
        }
        ans.push(string.slice(0, end));
        ans.reverse();
    }
    return _$rapyd$_list_decorate(ans);
};
_$rapyd$_str.splitlines = function(string, keepends) {
    var parts, ans;
    if (keepends) {
        parts = string.split(/((?:\r?\n)|\r)/);
        ans = [];
        for (var i = 0; i < parts.length; i++) {
            if (i % 2 === 0) {
                ans.push(parts[i]);
            } else {
                ans[ans.length-1] += parts[i];
            }
        }
    } else {
        ans = string.split(/(?:\r?\n)|\r/);
    }
    return _$rapyd$_list_decorate(ans);
};
_$rapyd$_str.swapcase = function(string) {
    var ans, a, b;
    ans = new Array(string.length);
    for (var i = 0; i < ans.length; i++) {
        a = string[i];
        b = a.toLowerCase();
        if (a === b) {
            b = a.toUpperCase();
        }
        ans[i] = b;
    }
    return ans.join("");
};
_$rapyd$_str.zfill = function(string, width) {
    if (width > string.length) {
        string = new Array(width - string.length + 1).join("0") + string;
    }
    return string;
};
_$rapyd$_str.uchrs = function(string, with_positions) {
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_string"] = string;
        _$rapyd$_d["_pos"] = 0;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            var length, pos, value, ans, extra;
            length = this._string.length;
            if (this._pos >= length) {
                return {
                    "done": true
                };
            }
            pos = this._pos;
            value = this._string.charCodeAt(this._pos++);
            ans = "\ufffd";
            if (55296 <= value && value <= 56319) {
                if (this._pos < length) {
                    extra = this._string.charCodeAt(this._pos++);
                    if ((extra & 56320) === 56320) {
                        ans = String.fromCharCode(value, extra);
                    }
                }
            } else if ((value & 56320) !== 56320) {
                ans = String.fromCharCode(value);
            }
            if (with_positions) {
                return {
                    "done": false,
                    "value": _$rapyd$_list_decorate([ pos, ans ])
                };
            } else {
                return {
                    "done": false,
                    "value": ans
                };
            }
        };
        return _$rapyd$_d;
    })();
};
_$rapyd$_str.uslice = function(string, start, end) {
    var items, iterator, r;
    items = [];
    iterator = _$rapyd$_str.uchrs(string);
    r = iterator.next();
    while (!r.done) {
        items.push(r.value);
        r = iterator.next();
    }
    return items.slice(start || 0, (end === undefined) ? items.length : end).join("");
};
_$rapyd$_str.ulen = function(string) {
    var iterator, r, ans;
    iterator = _$rapyd$_str.uchrs(string);
    r = iterator.next();
    ans = 0;
    while (!r.done) {
        r = iterator.next();
        ans += 1;
    }
    return ans;
};
_$rapyd$_str.ascii_lowercase = "abcdefghijklmnopqrstuvwxyz";
_$rapyd$_str.ascii_uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
_$rapyd$_str.ascii_letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
_$rapyd$_str.digits = "0123456789";
_$rapyd$_str.punctuation = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
_$rapyd$_str.printable = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~ \t\n\r\u000b\f";
_$rapyd$_str.whitespace = " \t\n\r\u000b\f";
var str = _$rapyd$_str, repr = _$rapyd$_repr;;
    function iter(iterable) {
            var ans;
            if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
                return (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
            }
            if (_$rapyd$_arraylike(iterable)) {
                ans = {
                    "_i": -1,
                    "next": function() {
                        this._i += 1;
                        if (this._i < iterable.length) {
                            return {
                                "done": false,
                                "value": iterable[this._i]
                            };
                        }
                        return {
                            "done": true
                        };
                    }
                };
                ans[_$rapyd$_iterator_symbol] = function() {
                    return this;
                };
                return ans;
            }
            return iter(Object.keys(iterable));
        };
    var min = (function min() {
            return Math.min;
        })();
    var max = (function max() {
            return Math.max;
        })();
    var _$rapyd$_modules = {};
    _$rapyd$_modules["gettext"] = {};
    _$rapyd$_modules["ajax"] = {};
    _$rapyd$_modules["elementmaker"] = {};
    _$rapyd$_modules["session"] = {};
    _$rapyd$_modules["utils"] = {};
    _$rapyd$_modules["book_list"] = {};
    _$rapyd$_modules["dom"] = {};
    _$rapyd$_modules["book_list.theme"] = {};
    _$rapyd$_modules["modals"] = {};
    _$rapyd$_modules["widgets"] = {};
    _$rapyd$_modules["book_list.globals"] = {};
    _$rapyd$_modules["book_list.search"] = {};
    _$rapyd$_modules["book_list.top_bar"] = {};
    _$rapyd$_modules["book_list.views"] = {};
    _$rapyd$_modules["book_list.item_list"] = {};
    _$rapyd$_modules["book_list.prefs"] = {};
    _$rapyd$_modules["date"] = {};
    _$rapyd$_modules["book_list.book_details"] = {};
    _$rapyd$_modules["book_list.ui"] = {};
    _$rapyd$_modules["book_list.boss"] = {};

    (function(){
        var __name__ = "gettext";
        var Jed, plural_forms_parser, _gettext, _ngettext;
        Jed = {};
        
  Jed.PF = {};

  Jed.PF.parse = function ( p ) {
    var plural_str = Jed.PF.extractPluralExpr( p );
    return Jed.PF.parser.parse.call(Jed.PF.parser, plural_str);
  };

  Jed.PF.compile = function ( p ) {
    // Handle trues and falses as 0 and 1
    function imply( val ) {
      return (val === true ? 1 : val ? val : 0);
    }

    var ast = Jed.PF.parse( p );
    return function ( n ) {
      return imply( Jed.PF.interpreter( ast )( n ) );
    };
  };

  Jed.PF.interpreter = function ( ast ) {
    return function ( n ) {
      var res;
      switch ( ast.type ) {
        case 'GROUP':
          return Jed.PF.interpreter( ast.expr )( n );
        case 'TERNARY':
          if ( Jed.PF.interpreter( ast.expr )( n ) ) {
            return Jed.PF.interpreter( ast.truthy )( n );
          }
          return Jed.PF.interpreter( ast.falsey )( n );
        case 'OR':
          return Jed.PF.interpreter( ast.left )( n ) || Jed.PF.interpreter( ast.right )( n );
        case 'AND':
          return Jed.PF.interpreter( ast.left )( n ) && Jed.PF.interpreter( ast.right )( n );
        case 'LT':
          return Jed.PF.interpreter( ast.left )( n ) < Jed.PF.interpreter( ast.right )( n );
        case 'GT':
          return Jed.PF.interpreter( ast.left )( n ) > Jed.PF.interpreter( ast.right )( n );
        case 'LTE':
          return Jed.PF.interpreter( ast.left )( n ) <= Jed.PF.interpreter( ast.right )( n );
        case 'GTE':
          return Jed.PF.interpreter( ast.left )( n ) >= Jed.PF.interpreter( ast.right )( n );
        case 'EQ':
          return Jed.PF.interpreter( ast.left )( n ) == Jed.PF.interpreter( ast.right )( n );
        case 'NEQ':
          return Jed.PF.interpreter( ast.left )( n ) != Jed.PF.interpreter( ast.right )( n );
        case 'MOD':
          return Jed.PF.interpreter( ast.left )( n ) % Jed.PF.interpreter( ast.right )( n );
        case 'VAR':
          return n;
        case 'NUM':
          return ast.val;
        default:
          throw new Error("Invalid Token found.");
      }
    };
  };

  Jed.PF.extractPluralExpr = function ( p ) {
    // trim first
    p = p.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

    if (! /;\s*$/.test(p)) {
      p = p.concat(';');
    }

    var nplurals_re = /nplurals\=(\d+);/,
        plural_re = /plural\=(.*);/,
        nplurals_matches = p.match( nplurals_re ),
        res = {},
        plural_matches;

    // Find the nplurals number
    if ( nplurals_matches.length > 1 ) {
      res.nplurals = nplurals_matches[1];
    }
    else {
      throw new Error('nplurals not found in plural_forms string: ' + p );
    }

    // remove that data to get to the formula
    p = p.replace( nplurals_re, "" );
    plural_matches = p.match( plural_re );

    if (!( plural_matches && plural_matches.length > 1 ) ) {
      throw new Error('`plural` expression not found: ' + p);
    }
    return plural_matches[ 1 ];
  };

  /* Jison generated parser */
  Jed.PF.parser = (function(){

var parser = {trace: function trace() { },
yy: {},
symbols_: {"error":2,"expressions":3,"e":4,"EOF":5,"?":6,":":7,"||":8,"&&":9,"<":10,"<=":11,">":12,">=":13,"!=":14,"==":15,"%":16,"(":17,")":18,"n":19,"NUMBER":20,"$accept":0,"$end":1},
terminals_: {2:"error",5:"EOF",6:"?",7:":",8:"||",9:"&&",10:"<",11:"<=",12:">",13:">=",14:"!=",15:"==",16:"%",17:"(",18:")",19:"n",20:"NUMBER"},
productions_: [0,[3,2],[4,5],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,1],[4,1]],
performAction: function anonymous(yytext,yyleng,yylineno,yy,yystate,$$,_$) {

var $0 = $$.length - 1;
switch (yystate) {
case 1: return { type : 'GROUP', expr: $$[$0-1] };
case 2:this.$ = { type: 'TERNARY', expr: $$[$0-4], truthy : $$[$0-2], falsey: $$[$0] };
break;
case 3:this.$ = { type: "OR", left: $$[$0-2], right: $$[$0] };
break;
case 4:this.$ = { type: "AND", left: $$[$0-2], right: $$[$0] };
break;
case 5:this.$ = { type: 'LT', left: $$[$0-2], right: $$[$0] };
break;
case 6:this.$ = { type: 'LTE', left: $$[$0-2], right: $$[$0] };
break;
case 7:this.$ = { type: 'GT', left: $$[$0-2], right: $$[$0] };
break;
case 8:this.$ = { type: 'GTE', left: $$[$0-2], right: $$[$0] };
break;
case 9:this.$ = { type: 'NEQ', left: $$[$0-2], right: $$[$0] };
break;
case 10:this.$ = { type: 'EQ', left: $$[$0-2], right: $$[$0] };
break;
case 11:this.$ = { type: 'MOD', left: $$[$0-2], right: $$[$0] };
break;
case 12:this.$ = { type: 'GROUP', expr: $$[$0-1] };
break;
case 13:this.$ = { type: 'VAR' };
break;
case 14:this.$ = { type: 'NUM', val: Number(yytext) };
break;
}
},
table: [{3:1,4:2,17:[1,3],19:[1,4],20:[1,5]},{1:[3]},{5:[1,6],6:[1,7],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16]},{4:17,17:[1,3],19:[1,4],20:[1,5]},{5:[2,13],6:[2,13],7:[2,13],8:[2,13],9:[2,13],10:[2,13],11:[2,13],12:[2,13],13:[2,13],14:[2,13],15:[2,13],16:[2,13],18:[2,13]},{5:[2,14],6:[2,14],7:[2,14],8:[2,14],9:[2,14],10:[2,14],11:[2,14],12:[2,14],13:[2,14],14:[2,14],15:[2,14],16:[2,14],18:[2,14]},{1:[2,1]},{4:18,17:[1,3],19:[1,4],20:[1,5]},{4:19,17:[1,3],19:[1,4],20:[1,5]},{4:20,17:[1,3],19:[1,4],20:[1,5]},{4:21,17:[1,3],19:[1,4],20:[1,5]},{4:22,17:[1,3],19:[1,4],20:[1,5]},{4:23,17:[1,3],19:[1,4],20:[1,5]},{4:24,17:[1,3],19:[1,4],20:[1,5]},{4:25,17:[1,3],19:[1,4],20:[1,5]},{4:26,17:[1,3],19:[1,4],20:[1,5]},{4:27,17:[1,3],19:[1,4],20:[1,5]},{6:[1,7],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[1,28]},{6:[1,7],7:[1,29],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16]},{5:[2,3],6:[2,3],7:[2,3],8:[2,3],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,3]},{5:[2,4],6:[2,4],7:[2,4],8:[2,4],9:[2,4],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,4]},{5:[2,5],6:[2,5],7:[2,5],8:[2,5],9:[2,5],10:[2,5],11:[2,5],12:[2,5],13:[2,5],14:[2,5],15:[2,5],16:[1,16],18:[2,5]},{5:[2,6],6:[2,6],7:[2,6],8:[2,6],9:[2,6],10:[2,6],11:[2,6],12:[2,6],13:[2,6],14:[2,6],15:[2,6],16:[1,16],18:[2,6]},{5:[2,7],6:[2,7],7:[2,7],8:[2,7],9:[2,7],10:[2,7],11:[2,7],12:[2,7],13:[2,7],14:[2,7],15:[2,7],16:[1,16],18:[2,7]},{5:[2,8],6:[2,8],7:[2,8],8:[2,8],9:[2,8],10:[2,8],11:[2,8],12:[2,8],13:[2,8],14:[2,8],15:[2,8],16:[1,16],18:[2,8]},{5:[2,9],6:[2,9],7:[2,9],8:[2,9],9:[2,9],10:[2,9],11:[2,9],12:[2,9],13:[2,9],14:[2,9],15:[2,9],16:[1,16],18:[2,9]},{5:[2,10],6:[2,10],7:[2,10],8:[2,10],9:[2,10],10:[2,10],11:[2,10],12:[2,10],13:[2,10],14:[2,10],15:[2,10],16:[1,16],18:[2,10]},{5:[2,11],6:[2,11],7:[2,11],8:[2,11],9:[2,11],10:[2,11],11:[2,11],12:[2,11],13:[2,11],14:[2,11],15:[2,11],16:[2,11],18:[2,11]},{5:[2,12],6:[2,12],7:[2,12],8:[2,12],9:[2,12],10:[2,12],11:[2,12],12:[2,12],13:[2,12],14:[2,12],15:[2,12],16:[2,12],18:[2,12]},{4:30,17:[1,3],19:[1,4],20:[1,5]},{5:[2,2],6:[1,7],7:[2,2],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,2]}],
defaultActions: {6:[2,1]},
parseError: function parseError(str, hash) {
    throw new Error(str);
},
parse: function parse(input) {
    var self = this,
        stack = [0],
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    //this.reductionCount = this.shiftCount = 0;

    this.lexer.setInput(input);
    this.lexer.yy = this.yy;
    this.yy.lexer = this.lexer;
    if (typeof this.lexer.yylloc == 'undefined')
        this.lexer.yylloc = {};
    var yyloc = this.lexer.yylloc;
    lstack.push(yyloc);

    if (typeof this.yy.parseError === 'function')
        this.parseError = this.yy.parseError;

    function popStack (n) {
        stack.length = stack.length - 2*n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

    function lex() {
        var token;
        token = self.lexer.lex() || 1; // $end = 1
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval={},p,len,newState, expected, errStr;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length-1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || symbol === undefined)
                symbol = lex();
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

        // handle parse error
        _handle_error:
        if (typeof action === 'undefined' || !action.length || !action[0]) {

            if (!recovering) {
                // Report error
                expected = [];
                for (p in table[state]) if (this.terminals_[p] && p > 2) {
                    expected.push("'"+this.terminals_[p]+"'");
                }
                errStr = '';
                if (this.lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + this.terminals_[symbol]+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == 1 /*EOF*/ ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr,
                    {text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected: expected});
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol == EOF) {
                    throw new Error(errStr || 'Parsing halted.');
                }

                // discard current lookahead and grab another
                yyleng = this.lexer.yyleng;
                yytext = this.lexer.yytext;
                yylineno = this.lexer.yylineno;
                yyloc = this.lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            while (1) {
                // check for error recovery rule in this state
                if ((TERROR.toString()) in table[state]) {
                    break;
                }
                if (state === 0) {
                    throw new Error(errStr || 'Parsing halted.');
                }
                popStack(1);
                state = stack[stack.length-1];
            }

            preErrorSymbol = symbol; // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {

            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(this.lexer.yytext);
                lstack.push(this.lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0)
                        recovering--;
                } else { // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2: // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                r = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3: // accept
                return true;
        }

    }

    return true;
}};/* Jison generated lexer */
var lexer = (function(){

var lexer = ({EOF:1,
parseError:function parseError(str, hash) {
        if (this.yy.parseError) {
            this.yy.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },
setInput:function (input) {
        this._input = input;
        this._more = this._less = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {first_line:1,first_column:0,last_line:1,last_column:0};
        return this;
    },
input:function () {
        var ch = this._input[0];
        this.yytext+=ch;
        this.yyleng++;
        this.match+=ch;
        this.matched+=ch;
        var lines = ch.match(/\n/);
        if (lines) this.yylineno++;
        this._input = this._input.slice(1);
        return ch;
    },
unput:function (ch) {
        this._input = ch + this._input;
        return this;
    },
more:function () {
        this._more = true;
        return this;
    },
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20)+(next.length > 20 ? '...':'')).replace(/\n/g, "");
    },
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c+"^";
    },
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) this.done = true;

        var token,
            match,
            col,
            lines;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i=0;i < rules.length; i++) {
            match = this._input.match(this.rules[rules[i]]);
            if (match) {
                lines = match[0].match(/\n.*/g);
                if (lines) this.yylineno += lines.length;
                this.yylloc = {first_line: this.yylloc.last_line,
                               last_line: this.yylineno+1,
                               first_column: this.yylloc.last_column,
                               last_column: lines ? lines[lines.length-1].length-1 : this.yylloc.last_column + match[0].length};
                this.yytext += match[0];
                this.match += match[0];
                this.matches = match;
                this.yyleng = this.yytext.length;
                this._more = false;
                this._input = this._input.slice(match[0].length);
                this.matched += match[0];
                token = this.performAction.call(this, this.yy, this, rules[i],this.conditionStack[this.conditionStack.length-1]);
                if (token) return token;
                else return;
            }
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            this.parseError('Lexical error on line '+(this.yylineno+1)+'. Unrecognized text.\n'+this.showPosition(),
                    {text: "", token: null, line: this.yylineno});
        }
    },
lex:function lex() {
        var r = this.next();
        if (typeof r !== 'undefined') {
            return r;
        } else {
            return this.lex();
        }
    },
begin:function begin(condition) {
        this.conditionStack.push(condition);
    },
popState:function popState() {
        return this.conditionStack.pop();
    },
_currentRules:function _currentRules() {
        return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules;
    },
topState:function () {
        return this.conditionStack[this.conditionStack.length-2];
    },
pushState:function begin(condition) {
        this.begin(condition);
    }});
lexer.performAction = function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {

var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0:/* skip whitespace */
break;
case 1:return 20
break;
case 2:return 19
break;
case 3:return 8
break;
case 4:return 9
break;
case 5:return 6
break;
case 6:return 7
break;
case 7:return 11
break;
case 8:return 13
break;
case 9:return 10
break;
case 10:return 12
break;
case 11:return 14
break;
case 12:return 15
break;
case 13:return 16
break;
case 14:return 17
break;
case 15:return 18
break;
case 16:return 5
break;
case 17:return 'INVALID'
break;
}
};
lexer.rules = [/^\s+/,/^[0-9]+(\.[0-9]+)?\b/,/^n\b/,/^\|\|/,/^&&/,/^\?/,/^:/,/^<=/,/^>=/,/^</,/^>/,/^!=/,/^==/,/^%/,/^\(/,/^\)/,/^$/,/^./];
lexer.conditions = {"INITIAL":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],"inclusive":true}};return lexer;})()
parser.lexer = lexer;
return parser;
})();
;
        plural_forms_parser = Jed.PF;
        function _get_plural_forms_function(plural_forms_string) {
            return plural_forms_parser.compile(plural_forms_string || "nplurals=2; plural=(n != 1);");
        }
        _gettext = function(text) {
            return text;
        };
        _ngettext = function(text, plural, n) {
            return (n === 1) ? text : plural;
        };
        function gettext(text) {
            return _gettext(text);
        }
        function ngettext(text, plural, n) {
            return _ngettext(text, plural, n);
        }
        function install(translation_data) {
            var t;
            t = new Translations(translation_data);
            t.install();
            return t;
        }
        function Translations() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            Translations.prototype.__init__.apply(this, arguments);
        }
        Translations.prototype.__init__ = function __init__(translation_data) {
            var self = this;
            translation_data = translation_data || {};
            translation_data["func"] = _get_plural_forms_function(translation_data["plural_forms"]);
            self.translations = [translation_data];
            self.language = translation_data["language"];
        };
        Translations.prototype.add_fallback = function add_fallback(fallback) {
            var self = this;
            fallback["func"] = _get_plural_forms_function(fallback["plural_forms"]);
            self.translations.push(fallback || {});
        };
        Translations.prototype.gettext = function gettext(text) {
            var self = this;
            var m, t;
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(self.translations);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                t = _$rapyd$_Iter0[_$rapyd$_Index0];
                m = t["entries"];
                if (Object.prototype.hasOwnProperty.call(m, text)) {
                    return m[text][0];
                }
            }
            return text;
        };
        Translations.prototype.ngettext = function ngettext(text, plural, n) {
            var self = this;
            var m, idx, t;
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(self.translations);
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                t = _$rapyd$_Iter1[_$rapyd$_Index1];
                m = t["entries"];
                if (Object.prototype.hasOwnProperty.call(m, text)) {
                    idx = t["func"](n);
                    return m[text][idx] || ((n === 1) ? text : plural);
                }
            }
            return (n === 1) ? text : plural;
        };
        Translations.prototype.install = function install() {
            var self = this;
            _gettext = function() {
                return self.gettext.apply(self, arguments);
            };
            _ngettext = function() {
                return self.ngettext.apply(self, arguments);
            };
        };
        Translations.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "Translations" + " #" + this._$rapyd$_object_id + ">";
        };
        Translations.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        _$rapyd$_modules["gettext"]["Jed"] = Jed;

        _$rapyd$_modules["gettext"]["plural_forms_parser"] = plural_forms_parser;

        _$rapyd$_modules["gettext"]["_gettext"] = _gettext;

        _$rapyd$_modules["gettext"]["_ngettext"] = _ngettext;

        _$rapyd$_modules["gettext"]["_get_plural_forms_function"] = _get_plural_forms_function;

        _$rapyd$_modules["gettext"]["gettext"] = gettext;

        _$rapyd$_modules["gettext"]["ngettext"] = ngettext;

        _$rapyd$_modules["gettext"]["install"] = install;

        _$rapyd$_modules["gettext"]["Translations"] = Translations;
    })();

    (function(){
        var __name__ = "ajax";
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        function encode_query(query) {
            var keys, has_query, path, val, k;
            if (!query) {
                return "";
            }
            keys = Object.keys(query);
            has_query = false;
            path = "";
            if (keys.length) {
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(keys);
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    k = _$rapyd$_Iter0[_$rapyd$_Index0];
                    val = query[k];
                    if (val === undefined || val === null) {
                        continue;
                    }
                    path += ((has_query) ? "&" : "?") + encodeURIComponent(k) + "=" + encodeURIComponent(val.toString());
                    has_query = true;
                }
            }
            return path;
        }
        function ajax() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_complete = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_progress = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var bypass_cache = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[3];
            var method = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("GET") : arguments[4];
            var query = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[5];
            var timeout = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (30 * 1e3) : arguments[6];
            var ok_code = (arguments[7] === undefined || ( 7 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (200) : arguments[7];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_progress")){
                on_progress = _$rapyd$_kwargs_obj.on_progress;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "bypass_cache")){
                bypass_cache = _$rapyd$_kwargs_obj.bypass_cache;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "method")){
                method = _$rapyd$_kwargs_obj.method;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "query")){
                query = _$rapyd$_kwargs_obj.query;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "timeout")){
                timeout = _$rapyd$_kwargs_obj.timeout;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "ok_code")){
                ok_code = _$rapyd$_kwargs_obj.ok_code;
            }
            var xhr, eq, has_query;
            query = query || {};
            xhr = new XMLHttpRequest();
            eq = encode_query(query);
            has_query = eq.length > 0;
            path += eq;
            if (bypass_cache) {
                path += ((has_query) ? "&" : "?") + new Date().getTime();
            }
            xhr.request_path = path;
            xhr.error_html = "";
            function set_error(event) {
                var rtext;
                if (event === "timeout") {
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", timed out after: {} seconds"), xhr.request_path, timeout / 1e3);
                } else if (event === "abort") {
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", aborted"), xhr.request_path);
                } else {
                    rtext = xhr.responseText || "";
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", with status: [{}] {}<br>{}"), xhr.request_path, xhr.status, xhr.statusText, rtext.slice(0, 200));
                }
            }
            function progress_callback(ev) {
                var ul;
                if (ev.lengthComputable) {
                    on_progress(ev.loaded, ev.total, xhr);
                } else if (ev.loaded) {
                    ul = xhr.getResponseHeader("Calibre-Uncompressed-Length");
                    if (ul) {
                        try {
                            ul = int(ul);
                        } catch (_$rapyd$_Exception) {
                            if (_$rapyd$_Exception instanceof Exception) {
                                return;
                            } else {
                                throw _$rapyd$_Exception;
                            }
                        }
                        on_progress(ev.loaded, ul, xhr);
                    }
                }
            }
            function complete_callback(end_type, ev) {
                if (xhr.status !== ok_code && end_type === "load") {
                    end_type = "error";
                }
                if (end_type !== "load") {
                    set_error(end_type);
                }
                on_complete(end_type, xhr, ev);
            }
            if (on_progress) {
                xhr.addEventListener("progress", progress_callback);
            }
            xhr.addEventListener("abort", function(ev) {
                complete_callback("abort", ev);
            });
            xhr.addEventListener("error", function(ev) {
                complete_callback("error", ev);
            });
            xhr.addEventListener("load", function(ev) {
                complete_callback("load", ev);
            });
            xhr.addEventListener("timeout", function(ev) {
                complete_callback("timeout", ev);
            });
            xhr.open(method, path);
            xhr.timeout = timeout;
            return xhr;
        }
        function ajax_send() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_complete = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[2];
            var on_progress = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var query = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[4];
            var timeout = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (30 * 1e3) : arguments[5];
            var ok_code = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (200) : arguments[6];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_progress")){
                on_progress = _$rapyd$_kwargs_obj.on_progress;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "query")){
                query = _$rapyd$_kwargs_obj.query;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "timeout")){
                timeout = _$rapyd$_kwargs_obj.timeout;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "ok_code")){
                ok_code = _$rapyd$_kwargs_obj.ok_code;
            }
            var xhr;
            xhr = ajax(path, on_complete, on_progress, false, "POST", query, timeout, ok_code);
            xhr.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
            xhr.send(JSON.stringify(data));
            return xhr;
        }
        _$rapyd$_modules["ajax"]["encode_query"] = encode_query;

        _$rapyd$_modules["ajax"]["ajax"] = ajax;

        _$rapyd$_modules["ajax"]["ajax_send"] = ajax_send;
    })();

    (function(){
        var __name__ = "elementmaker";
        var html_elements, mathml_elements, svg_elements, html5_tags, E;
        html_elements = (function(){
            var s = _$rapyd$_set();
            s.jsset.add("a");
            s.jsset.add("abbr");
            s.jsset.add("acronym");
            s.jsset.add("address");
            s.jsset.add("area");
            s.jsset.add("article");
            s.jsset.add("aside");
            s.jsset.add("audio");
            s.jsset.add("b");
            s.jsset.add("big");
            s.jsset.add("blockquote");
            s.jsset.add("br");
            s.jsset.add("button");
            s.jsset.add("canvas");
            s.jsset.add("caption");
            s.jsset.add("center");
            s.jsset.add("cite");
            s.jsset.add("code");
            s.jsset.add("col");
            s.jsset.add("colgroup");
            s.jsset.add("command");
            s.jsset.add("datagrid");
            s.jsset.add("datalist");
            s.jsset.add("dd");
            s.jsset.add("del");
            s.jsset.add("details");
            s.jsset.add("dfn");
            s.jsset.add("dialog");
            s.jsset.add("dir");
            s.jsset.add("div");
            s.jsset.add("dl");
            s.jsset.add("dt");
            s.jsset.add("em");
            s.jsset.add("event-source");
            s.jsset.add("fieldset");
            s.jsset.add("figcaption");
            s.jsset.add("figure");
            s.jsset.add("footer");
            s.jsset.add("font");
            s.jsset.add("form");
            s.jsset.add("header");
            s.jsset.add("h1");
            s.jsset.add("h2");
            s.jsset.add("h3");
            s.jsset.add("h4");
            s.jsset.add("h5");
            s.jsset.add("h6");
            s.jsset.add("hr");
            s.jsset.add("i");
            s.jsset.add("img");
            s.jsset.add("input");
            s.jsset.add("ins");
            s.jsset.add("keygen");
            s.jsset.add("kbd");
            s.jsset.add("label");
            s.jsset.add("legend");
            s.jsset.add("li");
            s.jsset.add("m");
            s.jsset.add("map");
            s.jsset.add("menu");
            s.jsset.add("meter");
            s.jsset.add("multicol");
            s.jsset.add("nav");
            s.jsset.add("nextid");
            s.jsset.add("ol");
            s.jsset.add("output");
            s.jsset.add("optgroup");
            s.jsset.add("option");
            s.jsset.add("p");
            s.jsset.add("pre");
            s.jsset.add("progress");
            s.jsset.add("q");
            s.jsset.add("s");
            s.jsset.add("samp");
            s.jsset.add("script");
            s.jsset.add("section");
            s.jsset.add("select");
            s.jsset.add("small");
            s.jsset.add("sound");
            s.jsset.add("source");
            s.jsset.add("spacer");
            s.jsset.add("span");
            s.jsset.add("strike");
            s.jsset.add("strong");
            s.jsset.add("style");
            s.jsset.add("sub");
            s.jsset.add("sup");
            s.jsset.add("table");
            s.jsset.add("tbody");
            s.jsset.add("td");
            s.jsset.add("textarea");
            s.jsset.add("time");
            s.jsset.add("tfoot");
            s.jsset.add("th");
            s.jsset.add("thead");
            s.jsset.add("tr");
            s.jsset.add("tt");
            s.jsset.add("u");
            s.jsset.add("ul");
            s.jsset.add("var");
            s.jsset.add("video");
            return s;
        })();
        mathml_elements = (function(){
            var s = _$rapyd$_set();
            s.jsset.add("maction");
            s.jsset.add("math");
            s.jsset.add("merror");
            s.jsset.add("mfrac");
            s.jsset.add("mi");
            s.jsset.add("mmultiscripts");
            s.jsset.add("mn");
            s.jsset.add("mo");
            s.jsset.add("mover");
            s.jsset.add("mpadded");
            s.jsset.add("mphantom");
            s.jsset.add("mprescripts");
            s.jsset.add("mroot");
            s.jsset.add("mrow");
            s.jsset.add("mspace");
            s.jsset.add("msqrt");
            s.jsset.add("mstyle");
            s.jsset.add("msub");
            s.jsset.add("msubsup");
            s.jsset.add("msup");
            s.jsset.add("mtable");
            s.jsset.add("mtd");
            s.jsset.add("mtext");
            s.jsset.add("mtr");
            s.jsset.add("munder");
            s.jsset.add("munderover");
            s.jsset.add("none");
            return s;
        })();
        svg_elements = (function(){
            var s = _$rapyd$_set();
            s.jsset.add("a");
            s.jsset.add("animate");
            s.jsset.add("animateColor");
            s.jsset.add("animateMotion");
            s.jsset.add("animateTransform");
            s.jsset.add("clipPath");
            s.jsset.add("circle");
            s.jsset.add("defs");
            s.jsset.add("desc");
            s.jsset.add("ellipse");
            s.jsset.add("font-face");
            s.jsset.add("font-face-name");
            s.jsset.add("font-face-src");
            s.jsset.add("g");
            s.jsset.add("glyph");
            s.jsset.add("hkern");
            s.jsset.add("linearGradient");
            s.jsset.add("line");
            s.jsset.add("marker");
            s.jsset.add("metadata");
            s.jsset.add("missing-glyph");
            s.jsset.add("mpath");
            s.jsset.add("path");
            s.jsset.add("polygon");
            s.jsset.add("polyline");
            s.jsset.add("radialGradient");
            s.jsset.add("rect");
            s.jsset.add("set");
            s.jsset.add("stop");
            s.jsset.add("svg");
            s.jsset.add("switch");
            s.jsset.add("text");
            s.jsset.add("title");
            s.jsset.add("tspan");
            s.jsset.add("use");
            return s;
        })();
        html5_tags = html_elements.union(mathml_elements).union(svg_elements);
        function _makeelement() {
            var tag = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var kwargs = arguments[arguments.length-1];
            if (kwargs === null || typeof kwargs !== "object" || kwargs [_$rapyd$_kwargs_symbol] !== true) kwargs = {};
            var args = Array.prototype.slice.call(arguments, 1 );
            if (kwargs !== null && typeof kwargs === "object" && kwargs [_$rapyd$_kwargs_symbol] === true) args .pop();
            var ans, vattr, val, attr, arg;
            ans = this.createElement(tag);
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(kwargs);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                attr = _$rapyd$_Iter0[_$rapyd$_Index0];
                vattr = str.replace(str.rstrip(attr, "_"), "_", "-");
                val = kwargs[attr];
                if (callable(val)) {
                    if (str.startswith(attr, "on")) {
                        attr = attr.slice(2);
                    }
                    ans.addEventListener(attr, val);
                } else {
                    ans.setAttribute(vattr, val);
                }
            }
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(args);
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                arg = _$rapyd$_Iter1[_$rapyd$_Index1];
                if (typeof arg === "string") {
                    arg = this.createTextNode(arg);
                }
                ans.appendChild(arg);
            }
            return ans;
        }
        function maker_for_document(document) {
            var E, tag;
            E = _makeelement.bind(document);
            var _$rapyd$_Iter2 = _$rapyd$_Iterable(html5_tags);
            for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                tag = _$rapyd$_Iter2[_$rapyd$_Index2];
                Object.defineProperty(E, tag, {
                    "value": _makeelement.bind(document, tag)
                });
            }
            return E;
        }
        if (typeof document === "undefined") {
            E = maker_for_document({
                "createTextNode": function(value) {
                    return value;
                },
                "createElement": function(name) {
                    return {
                        "name": name,
                        "children": _$rapyd$_list_decorate([]),
                        "attributes": {},
                        "setAttribute": function(name, val) {
                            this.attributes[name] = val;
                        },
                        "appendChild": function(child) {
                            this.children.push(child);
                        }
                    };
                }
            });
        } else {
            E = maker_for_document(document);
        }
        _$rapyd$_modules["elementmaker"]["html_elements"] = html_elements;

        _$rapyd$_modules["elementmaker"]["mathml_elements"] = mathml_elements;

        _$rapyd$_modules["elementmaker"]["svg_elements"] = svg_elements;

        _$rapyd$_modules["elementmaker"]["html5_tags"] = html5_tags;

        _$rapyd$_modules["elementmaker"]["E"] = E;

        _$rapyd$_modules["elementmaker"]["_makeelement"] = _makeelement;

        _$rapyd$_modules["elementmaker"]["maker_for_document"] = maker_for_document;
    })();

    (function(){
        var __name__ = "session";
        var defaults, session_storage;
        var ajax_send = _$rapyd$_modules["ajax"].ajax_send;
        
        defaults = {
            "view_mode": "cover_grid",
            "sort": "timestamp.desc",
            "partition_method": "first letter",
            "collapse_at": 25,
            "dont_collapse": "",
            "sort_tags_by": "name",
            "hide_empty_categories": "no",
            "and_search_terms": false
        };
        function storage_available(which) {
            var storage, x;
            which = which || "localStorage";
            try {
                storage = window[which];
                x = "__storage__test__";
                storage.setItem(x, x);
                storage.removeItem(x);
                return true;
            } catch (_$rapyd$_Exception) {
                return false;
            }
        }
        session_storage = null;
        function FakeStorage() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            FakeStorage.prototype.__init__.apply(this, arguments);
        }
        FakeStorage.prototype.__init__ = function __init__() {
            var self = this;
            self.data = {};
        };
        FakeStorage.prototype.getItem = function getItem(key) {
            var self = this;
            return self.data[key];
        };
        FakeStorage.prototype.setItem = function setItem(key, value) {
            var self = this;
            if (typeof value !== "string") {
                value = JSON.stringify(value);
            }
            self.data[key] = value;
        };
        FakeStorage.prototype.clear = function clear() {
            var self = this;
            self.data = {};
        };
        FakeStorage.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "FakeStorage" + " #" + this._$rapyd$_object_id + ">";
        };
        FakeStorage.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        function get_session_storage() {
            if (session_storage === null) {
                if (storage_available("localStorage")) {
                    session_storage = window.localStorage;
                } else if (storage_available("sessionStorage")) {
                    session_storage = window.sessionStorage;
                    console.error("localStorage not available using sessionStorage instead");
                } else {
                    session_storage = new FakeStorage();
                    console.error("sessionStorage and localStorage not available using a temp cache instead");
                }
            }
            return session_storage;
        }
        function SessionData() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            SessionData.prototype.__init__.apply(this, arguments);
        }
        SessionData.prototype.__init__ = function __init__() {
            var self = this;
            self.storage = get_session_storage();
            self.overflow_storage = {};
            self.has_overflow = false;
        };
        SessionData.prototype.get = function get(key, defval) {
            var self = this;
            var ans;
            key = self.global_prefix + key;
            if (self.has_overflow) {
                ans = self.overflow_storage[key];
                if (ans === undefined) {
                    ans = self.storage.getItem(key);
                }
            } else {
                ans = self.storage.getItem(key);
            }
            if (ans === undefined || ans === null) {
                if (defval === undefined) {
                    defval = null;
                }
                return defval;
            }
            return JSON.parse(ans);
        };
        SessionData.prototype.set = function set(key, value) {
            var self = this;
            key = self.global_prefix + key;
            if (value === null) {
                self.storage.removeItem(key);
                delete self.overflow_storage[key];
                return true;
            }
            value = JSON.stringify(value);
            try {
                self.storage.setItem(key, value);
                delete self.overflow_storage[key];
                return true;
            } catch (_$rapyd$_Exception) {
                self.overflow_storage[key] = value;
                self.has_overflow = true;
                console.error("session storage has overflowed, using a temp cache instead");
            }
            return false;
        };
        SessionData.prototype.clear = function clear() {
            var self = this;
            self.storage.clear();
            self.overflow_storage = {};
            self.has_overflow = false;
        };
        SessionData.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "SessionData" + " #" + this._$rapyd$_object_id + ">";
        };
        SessionData.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        SessionData.prototype.global_prefix = "calibre-";

        function UserSessionData() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            UserSessionData.prototype.__init__.apply(this, arguments);
        }
        _$rapyd$_extends(UserSessionData, SessionData);
        UserSessionData.prototype.__init__ = function __init__(username, saved_data) {
            var self = this;
            var key;
            self.prefix = (username || "") + "-";
            self.has_user = bool(username);
            self.username = username;
            SessionData.prototype.constructor.call(self);
            self.echo_changes = false;
            self.changes = {};
            self.has_changes = false;
            self.push_timer_id = null;
            if (saved_data) {
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(saved_data);
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    key = _$rapyd$_Iter0[_$rapyd$_Index0];
                    self.set(key, saved_data[key]);
                }
            }
            self.echo_changes = true;
        };
        UserSessionData.prototype.defval = function defval(key) {
            var self = this;
            return defaults[key];
        };
        UserSessionData.prototype.get = function get(key, defval) {
            var self = this;
            if (defval === undefined) {
                defval = defaults[key];
            }
            return SessionData.prototype.get.call(self, self.prefix + key, defval);
        };
        UserSessionData.prototype.get_library_option = function get_library_option(library_id, key, defval) {
            var self = this;
            var lkey;
            if (!library_id) {
                return self.get(key, defval);
            }
            lkey = key + "-||-" + library_id;
            if (defval === undefined) {
                defval = defaults[key];
            }
            return self.get(lkey, defval);
        };
        UserSessionData.prototype.set = function set(key, value) {
            var self = this;
            if (self.echo_changes && self.has_user) {
                self.changes[key] = value;
                self.has_changes = true;
                if (self.push_timer_id !== null) {
                    clearTimeout(self.push_timer_id);
                }
                self.push_timer_id = setTimeout(self.push_to_server.bind(self), 1e3);
            }
            return SessionData.prototype.set.call(self, self.prefix + key, value);
        };
        UserSessionData.prototype.set_library_option = function set_library_option(library_id, key, value) {
            var self = this;
            if (library_id) {
                key = key + "-||-" + library_id;
            }
            return self.set(key, value);
        };
        UserSessionData.prototype.push_to_server = function push_to_server() {
            var self = this;
            if (self.has_changes) {
                ajax_send("interface-data/set-session-data", self.changes, function(end_type, xhr, ev) {
                    if (end_type !== "load") {
                        console.error("Failed to send session data to server: " + xhr.error_html);
                    }
                });
                self.changes = {};
                self.has_changes = false;
            }
        };
        UserSessionData.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "UserSessionData" + " #" + this._$rapyd$_object_id + ">";
        };
        UserSessionData.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        _$rapyd$_modules["session"]["defaults"] = defaults;

        _$rapyd$_modules["session"]["session_storage"] = session_storage;

        _$rapyd$_modules["session"]["storage_available"] = storage_available;

        _$rapyd$_modules["session"]["FakeStorage"] = FakeStorage;

        _$rapyd$_modules["session"]["get_session_storage"] = get_session_storage;

        _$rapyd$_modules["session"]["SessionData"] = SessionData;

        _$rapyd$_modules["session"]["UserSessionData"] = UserSessionData;
    })();

    (function(){
        var __name__ = "utils";
        var _roman;
        function debounce() {
            var func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var wait = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var immediate = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "immediate")){
                immediate = _$rapyd$_kwargs_obj.immediate;
            }
            var timeout;
            timeout = null;
            return function debounce_inner() {
                var _$rapyd$_unpack, context, args, call_now;
                _$rapyd$_unpack = [this, arguments];
                context = _$rapyd$_unpack[0];
                args = _$rapyd$_unpack[1];
                function later() {
                    timeout = null;
                    if (!immediate) {
                        func.apply(context, args);
                    }
                }
                call_now = immediate && !timeout;
                window.clearTimeout(timeout);
                timeout = window.setTimeout(later, wait);
                if (call_now) {
                    func.apply(context, args);
                }
            };
        }
        function to_utf8(string) {
            var escstr, binstr, ua;
            if (typeof TextEncoder === "function") {
                return new TextEncoder("utf-8").encode(string);
            }
            escstr = encodeURIComponent(string);
            binstr = escstr.replace(/%([0-9A-F]{2})/g, function(match, p1) {
                return String.fromCharCode("0x" + p1);
            });
            ua = new Uint8Array(binstr.length);
            Array.prototype.forEach.call(binstr, function(ch, i) {
                ua[i] = ch.charCodeAt(0);
            });
            return ua;
        }
        function parse_url_params() {
            var url = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
            var allow_multiple = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[1];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "url")){
                url = _$rapyd$_kwargs_obj.url;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "allow_multiple")){
                allow_multiple = _$rapyd$_kwargs_obj.allow_multiple;
            }
            var qs, ans, q, pairs, _$rapyd$_unpack, key, val, pair;
            url = url || window.location.href;
            qs = url.indexOf("?");
            ans = {};
            if (qs < 0) {
                return ans;
            }
            q = url.slice(qs + 1, url.indexOf("#") + 1 || url.length + 1);
            if (!q) {
                return ans;
            }
            pairs = q.replace(/\+/g, " ").split("&");
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(pairs);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                pair = _$rapyd$_Iter0[_$rapyd$_Index0];
                _$rapyd$_unpack = _$rapyd$_eslice(str.partition(pair, "="), 2);
                key = _$rapyd$_unpack[0];
                val = _$rapyd$_unpack[1];
                _$rapyd$_unpack = [decodeURIComponent(key), decodeURIComponent(val)];
                key = _$rapyd$_unpack[0];
                val = _$rapyd$_unpack[1];
                if (allow_multiple) {
                    if (!Object.prototype.hasOwnProperty.call(ans, key)) {
                        ans[key] = _$rapyd$_list_decorate([]);
                    }
                    ans[key].append(val);
                } else {
                    ans[key] = val;
                }
            }
            return ans;
        }
        _roman = list(zip(_$rapyd$_list_decorate([ 1e3, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1 ]), _$rapyd$_list_decorate([ "M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I" ])));
        function roman(num) {
            var result, _$rapyd$_unpack, d, r;
            if (num <= 0 || num >= 4e3 || int(num) !== num) {
                return num + "";
            }
            result = _$rapyd$_list_decorate([]);
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(_roman);
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                _$rapyd$_unpack = _$rapyd$_Iter1[_$rapyd$_Index1];
                d = _$rapyd$_unpack[0];
                r = _$rapyd$_unpack[1];
                while (num >= d) {
                    result.append(r);
                    num -= d;
                }
            }
            return result.join("");
        }
        function fmt_sidx() {
            var val = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var fmt = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("{:.2f}") : arguments[1];
            var use_roman = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "fmt")){
                fmt = _$rapyd$_kwargs_obj.fmt;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "use_roman")){
                use_roman = _$rapyd$_kwargs_obj.use_roman;
            }
            if (val === undefined || val === null || val === "") {
                return "1";
            }
            if (int(val) === float(val)) {
                if (use_roman) {
                    return roman(val);
                }
                return int(val) + "";
            }
            return str.format(fmt, float(val));
        }
        if (__name__ === "__main__") {
            print(fmt_sidx(10), fmt_sidx(1.2));
        }
        _$rapyd$_modules["utils"]["_roman"] = _roman;

        _$rapyd$_modules["utils"]["debounce"] = debounce;

        _$rapyd$_modules["utils"]["to_utf8"] = to_utf8;

        _$rapyd$_modules["utils"]["parse_url_params"] = parse_url_params;

        _$rapyd$_modules["utils"]["roman"] = roman;

        _$rapyd$_modules["utils"]["fmt_sidx"] = fmt_sidx;
    })();

    (function(){
        var __name__ = "book_list";
        _$rapyd$_modules["book_list"]["theme"] = _$rapyd$_modules["book_list.theme"];
        _$rapyd$_modules["book_list"]["globals"] = _$rapyd$_modules["book_list.globals"];
        _$rapyd$_modules["book_list"]["search"] = _$rapyd$_modules["book_list.search"];
        _$rapyd$_modules["book_list"]["top_bar"] = _$rapyd$_modules["book_list.top_bar"];
        _$rapyd$_modules["book_list"]["views"] = _$rapyd$_modules["book_list.views"];
        _$rapyd$_modules["book_list"]["item_list"] = _$rapyd$_modules["book_list.item_list"];
        _$rapyd$_modules["book_list"]["prefs"] = _$rapyd$_modules["book_list.prefs"];
        _$rapyd$_modules["book_list"]["book_details"] = _$rapyd$_modules["book_list.book_details"];
        _$rapyd$_modules["book_list"]["ui"] = _$rapyd$_modules["book_list.ui"];
        _$rapyd$_modules["book_list"]["boss"] = _$rapyd$_modules["book_list.boss"];
    })();

    (function(){
        var __name__ = "dom";
        var simple_vendor_prefixes;
        simple_vendor_prefixes = {
            "animation": ['webkit', 'moz', 'o'],
            "animation-name": ['webkit', 'moz', 'o'],
            "animation-duration": ['webkit', 'moz', 'o'],
            "animation-timing-function": ['webkit', 'moz', 'o'],
            "animation-delay": ['webkit', 'moz', 'o'],
            "animation-iteration-count": ['webkit', 'moz', 'o'],
            "animation-direction": ['webkit', 'moz', 'o'],
            "animation-fill-mode": ['webkit', 'moz', 'o'],
            "animation-play-state": ['webkit', 'moz', 'o'],
            "transform": ['webkit', 'ms', 'moz', 'o'],
            "transition": ['webkit', 'moz', 'o'],
            "filter": ['webkit'],
            "user-select": ['webkit', 'moz', 'ms']
        };
        function set_css() {
            var elem = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            var s, _$rapyd$_unpack, name, val, prefixes, prefix, prop;
            s = elem.style;
            if (s) {
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(kw);
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    prop = _$rapyd$_Iter0[_$rapyd$_Index0];
                    _$rapyd$_unpack = [str.replace(str.rstrip(prop, "_"), "_", "-"), kw[prop]];
                    name = _$rapyd$_unpack[0];
                    val = _$rapyd$_unpack[1];
                    if (val === null || val === undefined) {
                        s.removeProperty(name);
                    } else {
                        s.setProperty(name, val);
                    }
                    prefixes = simple_vendor_prefixes[name];
                    if (prefixes) {
                        var _$rapyd$_Iter1 = _$rapyd$_Iterable(prefixes);
                        for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                            prefix = _$rapyd$_Iter1[_$rapyd$_Index1];
                            if (val === null || val === undefined) {
                                s.removeProperty("-" + prefix + "-" + name);
                            } else {
                                s.setProperty("-" + prefix + "-" + name, val);
                            }
                        }
                    }
                }
            }
        }
        function build_rule() {
            var selector = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            var ans, _$rapyd$_unpack, name, val, prefixes, prefix, prop;
            ans = [selector + " { "];
            var _$rapyd$_Iter2 = _$rapyd$_Iterable(kw);
            for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                prop = _$rapyd$_Iter2[_$rapyd$_Index2];
                _$rapyd$_unpack = [str.replace(str.rstrip(prop, "_"), "_", "-"), kw[prop]];
                name = _$rapyd$_unpack[0];
                val = _$rapyd$_unpack[1];
                ans.push(name + ":" + val + ";");
                prefixes = simple_vendor_prefixes[name];
                if (prefixes) {
                    var _$rapyd$_Iter3 = _$rapyd$_Iterable(prefixes);
                    for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                        prefix = _$rapyd$_Iter3[_$rapyd$_Index3];
                        ans.push("-" + prefix + "-" + name + ":" + val + ";");
                    }
                }
            }
            ans.push("}");
            return ans.join("\n") + "\n";
        }
        function clear() {
            var nodes = Array.prototype.slice.call(arguments, 0 );
            if (arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) nodes .pop();
            var node;
            var _$rapyd$_Iter4 = _$rapyd$_Iterable(nodes);
            for (var _$rapyd$_Index4 = 0; _$rapyd$_Index4 < _$rapyd$_Iter4.length; _$rapyd$_Index4++) {
                node = _$rapyd$_Iter4[_$rapyd$_Index4];
                while (node.firstChild) {
                    node.removeChild(node.firstChild);
                }
            }
        }
        function create_keyframes() {
            var animation_name = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var frames = Array.prototype.slice.call(arguments, 1 );
            if (arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) frames .pop();
            var ans, frame, prefix;
            ans = [];
            var _$rapyd$_Iter5 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ "-webkit-", "-moz-", "-o-", "" ]));
            for (var _$rapyd$_Index5 = 0; _$rapyd$_Index5 < _$rapyd$_Iter5.length; _$rapyd$_Index5++) {
                prefix = _$rapyd$_Iter5[_$rapyd$_Index5];
                ans.push("@" + prefix + "keyframes " + animation_name + " {");
                var _$rapyd$_Iter6 = _$rapyd$_Iterable(frames);
                for (var _$rapyd$_Index6 = 0; _$rapyd$_Index6 < _$rapyd$_Iter6.length; _$rapyd$_Index6++) {
                    frame = _$rapyd$_Iter6[_$rapyd$_Index6];
                    ans.push(frame);
                }
                ans.push("}");
            }
            return ans.join("\n") + "\n";
        }
        _$rapyd$_modules["dom"]["simple_vendor_prefixes"] = simple_vendor_prefixes;

        _$rapyd$_modules["dom"]["set_css"] = set_css;

        _$rapyd$_modules["dom"]["build_rule"] = build_rule;

        _$rapyd$_modules["dom"]["clear"] = clear;

        _$rapyd$_modules["dom"]["create_keyframes"] = create_keyframes;
    })();

    (function(){
        var __name__ = "book_list.theme";
        var DARK, LIGHT, LIGHT_DARKER, LIGHT_GRADIENT;
        DARK = "#39322B";
        LIGHT = "#F6F3E9";
        LIGHT_DARKER = "#b6b3a8";
        LIGHT_GRADIENT = str.format("linear-gradient(to bottom, {}, {})", LIGHT, LIGHT_DARKER);
        function get_color(name) {
            return {
                "window-background": LIGHT,
                "window-background2": LIGHT_DARKER,
                "window-foreground": DARK,
                "bar-background": DARK,
                "bar-foreground": LIGHT,
                "bar-highlight": "yellow",
                "heart": "#B92111",
                "list-hover-background": DARK,
                "list-hover-foreground": LIGHT,
                "button-start": DARK,
                "button-end": "#49423B",
                "button-text": LIGHT,
                "dialog-background": LIGHT,
                "dialog-background-image": LIGHT_GRADIENT,
                "dialog-foreground": DARK
            }[name];
        }
        function get_font_size(name) {
            return {
                "title": "1.4rem",
                "item-list-title": "1.2rem",
                "item-list-subtitle": "0.8 rem"
            }[name];
        }
        _$rapyd$_modules["book_list.theme"]["DARK"] = DARK;

        _$rapyd$_modules["book_list.theme"]["LIGHT"] = LIGHT;

        _$rapyd$_modules["book_list.theme"]["LIGHT_DARKER"] = LIGHT_DARKER;

        _$rapyd$_modules["book_list.theme"]["LIGHT_GRADIENT"] = LIGHT_GRADIENT;

        _$rapyd$_modules["book_list.theme"]["get_color"] = get_color;

        _$rapyd$_modules["book_list.theme"]["get_font_size"] = get_font_size;
    })();

    (function(){
        var __name__ = "modals";
        var modal_container, modal_count;
        var ajax = _$rapyd$_modules["ajax"].ajax;
        var ajax_send = _$rapyd$_modules["ajax"].ajax_send;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var set_css = _$rapyd$_modules["dom"].set_css;
        var clear = _$rapyd$_modules["dom"].clear;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        var get_font_size = _$rapyd$_modules["book_list.theme"].get_font_size;
        
        modal_container = null;
        modal_count = 0;
        function Modal() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            Modal.prototype.__init__.apply(this, arguments);
        }
        Modal.prototype.__init__ = function __init__(create_func, on_close, show_close) {
            var self = this;
            var _$rapyd$_unpack;
            _$rapyd$_unpack = [create_func, on_close, show_close];
            self.create_func = _$rapyd$_unpack[0];
            self.on_close = _$rapyd$_unpack[1];
            self.show_close = _$rapyd$_unpack[2];
            modal_count += 1;
            self.id = modal_count;
        };
        Modal.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "Modal" + " #" + this._$rapyd$_object_id + ">";
        };
        Modal.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        function ModalContainer() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            ModalContainer.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(ModalContainer.prototype,  {
            "modal_container": {
                "enumerable": true, 
                "get": function modal_container() {
                    var self = this;
                    return document.getElementById("modal-container");
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        ModalContainer.prototype.__init__ = function __init__() {
            var self = this;
            var div;
            div = E.div(E.div(E.div(), E.a(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-close", style: "vertical-align:bottom;"})), _$rapyd$_desugar_kwargs({title: _("Close")}))), E.style(build_rule("#modal-container > div > a:hover", _$rapyd$_desugar_kwargs({color: get_color("dialog-foreground") + " !important", background_color: get_color("dialog-background") + " !important"})) + build_rule("#modal-container a.dialog-simple-link:hover", _$rapyd$_desugar_kwargs({color: "red !important"}))), _$rapyd$_desugar_kwargs({id: "modal-container"}));
            document.body.appendChild(div);
            set_css(div, _$rapyd$_desugar_kwargs({position: "fixed", top: "0", right: "0", bottom: "0", left: "0", background_color: "rgba(0,0,0,0.8)", z_index: "1000", display: "none", text_align: "center", user_select: "none"}));
            set_css(div.firstChild, get_color("dialog-background"), get_color("dialog-background2"), _$rapyd$_desugar_kwargs({position: "relative", display: "inline-block", top: "50vh", transform: "translateY(-50%)", min_width: "25vw", max_width: "75vw", border_radius: "1em", padding: "1em 2em", margin_right: "1em", margin_left: "1em", background: get_color("dialog-background"), color: get_color("dialog-foreground"), background_image: get_color("dialog-background-image")}));
            set_css(div.firstChild.lastChild, _$rapyd$_desugar_kwargs({font_size: "1.5em", line_height: "100%", cursor: "pointer", position: "absolute", right: "-0.5em", top: "-0.5em", width: "1em", height: "1em", background_color: get_color("window-foreground"), color: get_color("window-background"), display: "inline-box", border_radius: "50%", padding: "4px", text_align: "center", box_shadow: "1px 1px 3px black"}));
            div.firstChild.lastChild.addEventListener("click", function(event) {
                [event.preventDefault(), self.close_current_modal(event)];
            });
            set_css(div.firstChild.firstChild, _$rapyd$_desugar_kwargs({user_select: "text", max_height: "60vh", overflow: "auto"}));
            self.modals = [];
            self.current_modal = null;
            self.hide = self.close_current_modal.bind(self);
        };
        ModalContainer.prototype.show_modal = function show_modal() {
            var self = this;
            var create_func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var show_close = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_close")){
                on_close = _$rapyd$_kwargs_obj.on_close;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "show_close")){
                show_close = _$rapyd$_kwargs_obj.show_close;
            }
            var modal_id;
            self.modals.push(new Modal(create_func, on_close, show_close));
            modal_id = self.modals[self.modals.length-1].id;
            self.update();
            return modal_id;
        };
        ModalContainer.prototype.hide_modal = function hide_modal(modal_id) {
            var self = this;
            var doomed_modal, _$rapyd$_unpack, i, modal;
            if (self.current_modal !== null && self.current_modal.id === modal_id) {
                self.clear_current_modal();
            } else {
                doomed_modal = null;
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(enumerate(self.modals));
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    _$rapyd$_unpack = _$rapyd$_Iter0[_$rapyd$_Index0];
                    i = _$rapyd$_unpack[0];
                    modal = _$rapyd$_unpack[1];
                    if (modal.id === modal_id) {
                        doomed_modal = i;
                        break;
                    }
                }
                if (doomed_modal !== null) {
                    self.modals.splice(doomed_modal, 1);
                }
            }
        };
        ModalContainer.prototype.update = function update() {
            var self = this;
            var c;
            if (self.current_modal === null && self.modals) {
                self.current_modal = self.modals.shift();
                c = self.modal_container;
                try {
                    self.current_modal.create_func(c.firstChild.firstChild, self.hide);
                } catch (_$rapyd$_Exception) {
                    self.current_modal = null;
                    throw _$rapyd$_Exception;
                }
                if (c.style.display === "none") {
                    set_css(c, _$rapyd$_desugar_kwargs({display: "block"}));
                }
                c.firstChild.lastChild.style.visibility = (self.current_modal.show_close) ? "visible" : "hidden";
            }
        };
        ModalContainer.prototype.clear_current_modal = function clear_current_modal() {
            var self = this;
            var c;
            self.current_modal = null;
            c = self.modal_container;
            clear(c.firstChild.firstChild);
            if (self.modals.length === 0) {
                set_css(c, _$rapyd$_desugar_kwargs({display: "none"}));
            } else {
                self.update();
            }
        };
        ModalContainer.prototype.close_current_modal = function close_current_modal(event) {
            var self = this;
            if (self.current_modal !== null) {
                if (self.current_modal.on_close !== null && self.current_modal.on_close(event) === true) {
                    return;
                }
                self.clear_current_modal();
            }
        };
        ModalContainer.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "ModalContainer" + " #" + this._$rapyd$_object_id + ">";
        };
        ModalContainer.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        

        function create_simple_dialog(title, msg, details, icon_name, prefix) {
            details = details || "";
            function create_func(parent) {
                var show_details, is_html_msg, html_container;
                show_details = E.a(_("Show details"), _$rapyd$_desugar_kwargs({class_: "dialog-simple-link", style: "cursor:pointer; color: blue; padding-top:1em; display:inline-block; margin-left: auto"}));
                show_details.addEventListener("click", function() {
                    show_details.style.display = "none";
                    show_details.nextSibling.style.display = "block";
                });
                is_html_msg = /<[a-zA-Z]/.test(msg);
                html_container = E.div();
                if (is_html_msg) {
                    html_container.innerHTML = msg;
                }
                parent.appendChild(E.div(E.h2(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-lg fa-" + icon_name, style: "color:red"})), E.span(" " + prefix + " ", _$rapyd$_desugar_kwargs({style: "font-variant:small-caps"})), title, _$rapyd$_desugar_kwargs({style: "font-weight: bold; font-size: " + get_font_size("title")})), E.div((is_html_msg) ? html_container : msg, _$rapyd$_desugar_kwargs({style: "padding-top: 1em; margin-top: 1em; border-top: 1px solid currentColor"})), E.div(show_details, E.div(details, _$rapyd$_desugar_kwargs({style: "display:none; white-space:pre-wrap; font-size: smaller; margin-top: 1em; border-top: solid 1px currentColor; padding-top: 1em"})), _$rapyd$_desugar_kwargs({style: "display: " + ((details) ? "block" : "none")})), _$rapyd$_desugar_kwargs({style: "max-width:60em; text-align: left"})));
            }
            show_modal(create_func);
        }
        function create_progress_dialog(msg, on_close) {
            var _$rapyd$_unpack, pbar, msg_div, show_close, modal_id;
            msg = msg || _("Loading, please wait...");
            _$rapyd$_unpack = [E.progress(_$rapyd$_desugar_kwargs({style: "display:inline-block"})), 
            E.div(msg, _$rapyd$_desugar_kwargs({style: "text-align:center; padding-top:1ex"}))];
            pbar = _$rapyd$_unpack[0];
            msg_div = _$rapyd$_unpack[1];
            function create_func(parent) {
                parent.appendChild(E.div(pbar, msg_div, _$rapyd$_desugar_kwargs({style: "text-align: center"})));
            }
            show_close = on_close !== null;
            modal_id = show_modal(create_func, on_close, show_close);
            return {
                "close": function() {
                    modal_container.hide_modal(modal_id);
                },
                "update_progress": function(amount, total) {
                    var _$rapyd$_unpack;
                    _$rapyd$_unpack = [total, amount];
                    pbar.max = _$rapyd$_unpack[0];
                    pbar.value = _$rapyd$_unpack[1];
                },
                "set_msg": function(new_msg) {
                    msg_div.innerHTML = new_msg;
                }
            };
        }
        function create_modal_container() {
            if (modal_container === null) {
                modal_container = new ModalContainer();
            }
            return modal_container;
        }
        function show_modal() {
            var create_func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var show_close = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_close")){
                on_close = _$rapyd$_kwargs_obj.on_close;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "show_close")){
                show_close = _$rapyd$_kwargs_obj.show_close;
            }
            return modal_container.show_modal(create_func, on_close, show_close);
        }
        function error_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var details = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "details")){
                details = _$rapyd$_kwargs_obj.details;
            }
            create_simple_dialog(title, msg, details, "bug", _("Error:"));
        }
        function warning_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var details = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "details")){
                details = _$rapyd$_kwargs_obj.details;
            }
            create_simple_dialog(title, msg, details, "warning", _("Warning:"));
        }
        function progress_dialog() {
            var msg = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_close")){
                on_close = _$rapyd$_kwargs_obj.on_close;
            }
            return create_progress_dialog(msg, on_close);
        }
        function ajax_progress_dialog() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_complete = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var msg = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[2];
            var extra_data_for_callback = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            if (Object.prototype.hasOwnProperty.call(kw, "extra_data_for_callback")){
                extra_data_for_callback = kw.extra_data_for_callback;
                delete kw.extra_data_for_callback;
            }
            var pd, xhr;
            pd = null;
            function on_complete_callback(event_type, xhr, ev) {
                pd.close();
                pd = undefined;
                return on_complete(event_type, xhr, ev);
            }
            function on_progress_callback(loaded, total, xhr) {
                pd.update_progress(loaded, total);
            }
            xhr = ajax.apply(this, [path, on_complete_callback].concat([_$rapyd$_desugar_kwargs(kw, {on_progress: on_progress_callback})]));
            xhr.extra_data_for_callback = extra_data_for_callback;
            pd = progress_dialog(msg, xhr.abort.bind(xhr));
            xhr.send();
            return [xhr, pd];
        }
        function ajax_send_progress_dialog() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_complete = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[2];
            var msg = ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[3];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            var pd, xhr;
            pd = null;
            function on_complete_callback(event_type, xhr, ev) {
                pd.close();
                pd = undefined;
                return on_complete(event_type, xhr, ev);
            }
            function on_progress_callback(loaded, total, xhr) {
                pd.update_progress(loaded, total);
            }
            xhr = ajax_send.apply(this, [path, data, on_complete_callback].concat([_$rapyd$_desugar_kwargs(kw, {on_progress: on_progress_callback})]));
            pd = progress_dialog(msg, xhr.abort.bind(xhr));
            return [xhr, pd];
        }
        _$rapyd$_modules["modals"]["modal_container"] = modal_container;

        _$rapyd$_modules["modals"]["modal_count"] = modal_count;

        _$rapyd$_modules["modals"]["Modal"] = Modal;

        _$rapyd$_modules["modals"]["ModalContainer"] = ModalContainer;

        _$rapyd$_modules["modals"]["create_simple_dialog"] = create_simple_dialog;

        _$rapyd$_modules["modals"]["create_progress_dialog"] = create_progress_dialog;

        _$rapyd$_modules["modals"]["create_modal_container"] = create_modal_container;

        _$rapyd$_modules["modals"]["show_modal"] = show_modal;

        _$rapyd$_modules["modals"]["error_dialog"] = error_dialog;

        _$rapyd$_modules["modals"]["warning_dialog"] = warning_dialog;

        _$rapyd$_modules["modals"]["progress_dialog"] = progress_dialog;

        _$rapyd$_modules["modals"]["ajax_progress_dialog"] = ajax_progress_dialog;

        _$rapyd$_modules["modals"]["ajax_send_progress_dialog"] = ajax_send_progress_dialog;
    })();

    (function(){
        var __name__ = "widgets";
        var BUTTON_VPADDING, id_counter;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        var clear = _$rapyd$_modules["dom"].clear;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        
        BUTTON_VPADDING = "0.5ex";
        function create_button() {
            var text = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var icon = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var action = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var tooltip = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "icon")){
                icon = _$rapyd$_kwargs_obj.icon;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "action")){
                action = _$rapyd$_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "tooltip")){
                tooltip = _$rapyd$_kwargs_obj.tooltip;
            }
            var cls, ans;
            cls = "";
            if (icon) {
                cls = str.format("fa fa-{} fa-lg", icon);
                text = " " + text;
            }
            ans = E.button(E.i(_$rapyd$_desugar_kwargs({class_: cls})), text, _$rapyd$_desugar_kwargs({class_: "calibre-push-button", type: "button", title: tooltip || ""}));
            if (action !== null) {
                ans.addEventListener("click", function(event) {
                    [event.preventDefault(), action(event)];
                });
            }
            return ans;
        }
        create_button.style = build_rule("button.calibre-push-button", _$rapyd$_desugar_kwargs({border_radius: "1em", background_clip: "padding-box", background_color: get_color("button-start"), background_image: str.format("linear-gradient(to bottom, {}, {})", get_color("button-start"), get_color("button-end")), padding: BUTTON_VPADDING + " 1em", color: get_color("button-text"), cursor: "pointer", font_size: "inherit"}));
        create_button.style += build_rule("button.calibre-push-button:hover", _$rapyd$_desugar_kwargs({transform: "scale(1.2)"}));
        create_button.style += build_rule("button.calibre-push-button:active", _$rapyd$_desugar_kwargs({transform: "scale(2)"}));
        function create_spinner() {
            return E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-spin fa-spinner"}));
        }
        id_counter = 0;
        function Breadcrumbs() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            Breadcrumbs.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(Breadcrumbs.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.container_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        Breadcrumbs.prototype.__init__ = function __init__(container) {
            var self = this;
            id_counter += 1;
            container.setAttribute("id", container.getAttribute("id") || "calibre-breadcrumbs-" + id_counter);
            container.classList.add("calibre-breadcrumbs");
            clear(container);
            self.container_id = container.getAttribute("id");
        };
        Breadcrumbs.prototype.reset = function reset() {
            var self = this;
            clear(self.container);
        };
        Breadcrumbs.prototype.add_crumb = function add_crumb(callback) {
            var self = this;
            var li;
            li = E.li();
            if (callback) {
                li.addEventListener("click", callback);
            }
            self.container.appendChild(li);
            return li;
        };
        Breadcrumbs.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "Breadcrumbs" + " #" + this._$rapyd$_object_id + ">";
        };
        Breadcrumbs.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        Breadcrumbs.prototype.STYLE_RULES = build_rule(".calibre-breadcrumbs", _$rapyd$_desugar_kwargs({user_select: "none", white_space: "nowrap", background_color: get_color("window-background2"), z_index: "-1", border_radius: "10px", margin: "1ex 1em", margin_bottom: "0"}));
        Breadcrumbs.prototype.STYLE_RULES += build_rule(".calibre-breadcrumbs > li", _$rapyd$_desugar_kwargs({cursor: "pointer", display: "inline-block", line_height: "26px", margin: "0 9px 0 -10px", padding: "0.5ex 1rem", position: "relative"}));
        Breadcrumbs.prototype.STYLE_RULES += build_rule(".calibre-breadcrumbs > li:hover", _$rapyd$_desugar_kwargs({color: "red"}));
        Breadcrumbs.prototype.STYLE_RULES += build_rule(".calibre-breadcrumbs > li:active", _$rapyd$_desugar_kwargs({color: "red", transform: "scale(1.5)"}));
        Breadcrumbs.prototype.STYLE_RULES += build_rule(".calibre-breadcrumbs > li:before, .calibre-breadcrumbs > li:after", _$rapyd$_desugar_kwargs({border_right: "2px solid currentColor", content: "\"\"", display: "block", height: "50%", position: "absolute", left: "0", top: "0", right: "0", transform: "skewX(45deg)"}));
        Breadcrumbs.prototype.STYLE_RULES += build_rule(".calibre-breadcrumbs > li:after", _$rapyd$_desugar_kwargs({bottom: "0", top: "auto", transform: "skewX(-45deg)"}));
        Breadcrumbs.prototype.STYLE_RULES += build_rule(".calibre-breadcrumbs > li:last-of-type:before, .calibre-breadcrumbs > li:last-of-type:after", _$rapyd$_desugar_kwargs({display: "none"}));
        

        function get_widget_css() {
            var ans;
            ans = "a, button:focus { outline: none }; a, button::-moz-focus-inner { border: 0 }\n";
            ans += create_button.style;
            ans += Breadcrumbs.prototype.STYLE_RULES;
            return ans;
        }
        _$rapyd$_modules["widgets"]["BUTTON_VPADDING"] = BUTTON_VPADDING;

        _$rapyd$_modules["widgets"]["id_counter"] = id_counter;

        _$rapyd$_modules["widgets"]["create_button"] = create_button;

        _$rapyd$_modules["widgets"]["create_spinner"] = create_spinner;

        _$rapyd$_modules["widgets"]["Breadcrumbs"] = Breadcrumbs;

        _$rapyd$_modules["widgets"]["get_widget_css"] = get_widget_css;
    })();

    (function(){
        var __name__ = "book_list.globals";
        var boss, session_data, current_query;
        boss = null;
        session_data = null;
        current_query = {};
        function get_boss() {
            return boss;
        }
        function set_boss(obj) {
            boss = obj;
            return boss;
        }
        function set_session_data(sd) {
            session_data = sd;
            return session_data;
        }
        function get_session_data() {
            return session_data;
        }
        function get_current_query() {
            return current_query;
        }
        function set_current_query(val) {
            current_query = val;
        }
        _$rapyd$_modules["book_list.globals"]["boss"] = boss;

        _$rapyd$_modules["book_list.globals"]["session_data"] = session_data;

        _$rapyd$_modules["book_list.globals"]["current_query"] = current_query;

        _$rapyd$_modules["book_list.globals"]["get_boss"] = get_boss;

        _$rapyd$_modules["book_list.globals"]["set_boss"] = set_boss;

        _$rapyd$_modules["book_list.globals"]["set_session_data"] = set_session_data;

        _$rapyd$_modules["book_list.globals"]["get_session_data"] = get_session_data;

        _$rapyd$_modules["book_list.globals"]["get_current_query"] = get_current_query;

        _$rapyd$_modules["book_list.globals"]["set_current_query"] = set_current_query;
    })();

    (function(){
        var __name__ = "book_list.search";
        var sp_counter;
        var ajax = _$rapyd$_modules["ajax"].ajax;
        
        var clear = _$rapyd$_modules["dom"].clear;
        var set_css = _$rapyd$_modules["dom"].set_css;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var create_button = _$rapyd$_modules["widgets"].create_button;
        var BUTTON_VPADDING = _$rapyd$_modules["widgets"].BUTTON_VPADDING;
        var create_spinner = _$rapyd$_modules["widgets"].create_spinner;
        var Breadcrumbs = _$rapyd$_modules["widgets"].Breadcrumbs;
        
        var show_modal = _$rapyd$_modules["modals"].show_modal;
        
        var get_boss = _$rapyd$_modules["book_list.globals"].get_boss;
        var get_session_data = _$rapyd$_modules["book_list.globals"].get_session_data;
        
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        var get_font_size = _$rapyd$_modules["book_list.theme"].get_font_size;
        
        sp_counter = 0;
        function SearchPanel() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            SearchPanel.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(SearchPanel.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.container_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "breadcrumbs_container": {
                "enumerable": true, 
                "get": function breadcrumbs_container() {
                    var self = this;
                    return self.tb_container.previousSibling;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "tb_container": {
                "enumerable": true, 
                "get": function tb_container() {
                    var self = this;
                    return self.container.lastChild.lastChild;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "search_control": {
                "enumerable": true, 
                "get": function search_control() {
                    var self = this;
                    return self.container.querySelector("input[name=\"search-books\"]");
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "search_items_container": {
                "enumerable": true, 
                "get": function search_items_container() {
                    var self = this;
                    return self.container.firstChild.nextSibling.lastChild;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "is_visible": {
                "enumerable": true, 
                "get": function is_visible() {
                    var self = this;
                    self.container.style.display === "block";
                }, 
                "set": function is_visible(val) {
                    var self = this;
                    self.container.style.display = (val) ? "block" : "none";
                }
            }, 
        });
        SearchPanel.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var style, div, search_container, search_button, loading_panel;
            sp_counter += 1;
            self.container_id = "search-panel-" + sp_counter;
            self.interface_data = interface_data;
            self.tag_path = _$rapyd$_list_decorate([]);
            style = build_rule("#" + self.container_id + " div.tag-name:hover", _$rapyd$_desugar_kwargs({color: get_color("list-hover-foreground"), background_color: get_color("list-hover-background")}));
            style += build_rule("#" + self.container_id + " div.tag-menu:hover", _$rapyd$_desugar_kwargs({color: get_color("list-hover-foreground"), background_color: get_color("list-hover-background")}));
            style += build_rule("#" + self.container_id + " div.tag-name:active", _$rapyd$_desugar_kwargs({transform: "scale(1.5)"}));
            style += build_rule("#" + self.container_id + " div.tag-menu:active", _$rapyd$_desugar_kwargs({transform: "scale(2)"}));
            style += build_rule("#" + self.container_id + " ul.search-items", _$rapyd$_desugar_kwargs({margin_top: "1ex", list_style_type: "none", text_align: "left"}));
            style += build_rule("#" + self.container_id + " ul.search-items > li", _$rapyd$_desugar_kwargs({display: "inline-block", cursor: "pointer", background_color: get_color("window-background2"), border_radius: "10px", padding: "0.5ex", margin_right: "1em"}));
            style += build_rule("#" + self.container_id + " ul.search-items > li:hover", _$rapyd$_desugar_kwargs({color: "red"}));
            style += build_rule("#" + self.container_id + " ul.search-items > li:active", _$rapyd$_desugar_kwargs({transform: "scale(1.5)"}));
            div = E.div(E.style(style, _$rapyd$_desugar_kwargs({type: "text/css"})), E.div(_$rapyd$_desugar_kwargs({style: "text-align:center; padding:1ex 1em; border-bottom: solid 1px currentColor; margin-bottom: 0.5ex"})), E.div(E.div(), E.ol(_$rapyd$_desugar_kwargs({style: "display:none"})), E.div(_$rapyd$_desugar_kwargs({style: "display:none"}))), _$rapyd$_desugar_kwargs({id: self.container_id, style: "display:none"}));
            book_list_container.appendChild(div);
            search_container = div.firstChild.nextSibling;
            search_button = create_button(_("Search"), _$rapyd$_desugar_kwargs({icon: "search", action: self.execute_search.bind(self), tooltip: _("Do the search")}));
            search_container.appendChild(E.div(E.input(_$rapyd$_desugar_kwargs({type: "search", autosave: "search-for-books-in-main-calibre-booklist", name: "search-books", autocomplete: "on", inputmode: "latin", title: _("Search for books"), placeholder: _("Enter the search query"), spellcheck: "false", style: str.format("flex-grow: 10; padding: {} 0.5em; margin-right: 0.5em", BUTTON_VPADDING)})), search_button, _$rapyd$_desugar_kwargs({style: "display: flex; width: 100%;"})));
            search_container.firstChild.firstChild.addEventListener("keypress", function(event) {
                if (event.keyCode === 13) {
                    search_button.focus();
                    self.execute_search();
                    [event.preventDefault(), event.stopPropagation()];
                }
            });
            search_container.appendChild(E.ul(_$rapyd$_desugar_kwargs({class_: "search-items"})));
            loading_panel = div.lastChild.firstChild;
            loading_panel.appendChild(E.div(create_spinner(), " " + _("Fetching data for the tag browser, please wait") + "…", _$rapyd$_desugar_kwargs({style: "margin-left:auto; margin-right:auto; font-size: 1.5rem; font-weight; bold; text-align:center; margin-top:30vh"})));
            self.breadcrumbs = new Breadcrumbs(self.breadcrumbs_container);
            self.initial_load_started = false;
            self.currently_loading = null;
            self.tag_browser_data = null;
            self.node_id_map = {};
            self.active_nodes = {};
        };
        SearchPanel.prototype.init = function init() {
            var self = this;
            var tb;
            tb = self.search_control;
            tb.value = "";
            self.tag_path = _$rapyd$_list_decorate([]);
            self.active_nodes = {};
            if (!self.initial_load_started) {
                self.initial_load_started = true;
                self.refresh();
            } else {
                self.render_tag_browser();
            }
        };
        SearchPanel.prototype.refresh = function refresh() {
            var self = this;
            var sd, query, k, xhr;
            if (self.currently_loading !== null) {
                self.currently_loading.abort();
                self.currently_loading = null;
            }
            sd = get_session_data();
            query = {
                "library_id": self.interface_data.library_id
            };
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(str.split("sort_tags_by partition_method collapse_at dont_collapse hide_empty_categories"));
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                k = _$rapyd$_Iter0[_$rapyd$_Index0];
                query[k] = sd.get(k) + "";
            }
            xhr = ajax("interface-data/tag-browser", self.on_data_fetched.bind(self), _$rapyd$_desugar_kwargs({query: query, bypass_cache: false}));
            xhr.send();
            self.currently_loading = xhr;
        };
        SearchPanel.prototype.on_data_fetched = function on_data_fetched(end_type, xhr, ev) {
            var self = this;
            var parent, container, tag_browser_data, item_map;
            self.currently_loading = null;
            if (end_type === "abort") {
                return;
            }
            parent = self.container.lastChild;
            if (parent.lastChild.style.display === "none") {
                parent.firstChild.style.display = "none";
                parent.lastChild.style.display = "block";
            }
            container = self.tb_container;
            clear(container);
            function show_error(error_html) {
                var ediv;
                ediv = E.div();
                container.appendChild(ediv);
                ediv.innerHTML = "<h3>" + _("Failed to load tag browser data") + "</h3>" + error_html;
            }
            function process_node(node) {
                var child;
                self.node_id_map[node.id] = node;
                node.data = item_map[node.id];
                var _$rapyd$_Iter1 = _$rapyd$_Iterable(node.children);
                for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                    child = _$rapyd$_Iter1[_$rapyd$_Index1];
                    child.parent = node;
                    process_node(child);
                }
            }
            if (end_type === "load") {
                try {
                    tag_browser_data = JSON.parse(xhr.responseText);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        show_error(err + "");
                        return;
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
                item_map = tag_browser_data.item_map;
                self.tag_browser_data = tag_browser_data.root;
                self.node_id_map = {};
                self.active_nodes = {};
                process_node(self.tag_browser_data);
                self.render_tag_browser(container);
            } else {
                show_error(xhr.error_html);
            }
        };
        SearchPanel.prototype.node_for_path = function node_for_path(path) {
            var self = this;
            var ans, child_index;
            path = path || self.tag_path;
            ans = self.tag_browser_data;
            var _$rapyd$_Iter2 = _$rapyd$_Iterable(path);
            for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                child_index = _$rapyd$_Iter2[_$rapyd$_Index2];
                ans = ans.children[child_index];
            }
            return ans;
        };
        SearchPanel.prototype.render_tag_browser = function render_tag_browser() {
            var self = this;
            var container = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "container")){
                container = _$rapyd$_kwargs_obj.container;
            }
            container = container || self.tb_container;
            clear(container);
            set_css(container, _$rapyd$_desugar_kwargs({padding: "1ex 1em", display: "flex", flex_wrap: "wrap", margin_left: "-0.5rem"}));
            self.render_children(container, self.node_for_path().children);
            self.render_breadcrumbs();
        };
        SearchPanel.prototype.icon_for_node = function icon_for_node(node) {
            var self = this;
            var ans;
            ans = self.interface_data.icon_map[node.data.category] || "column.png";
            return self.interface_data.icon_path + "/" + ans;
        };
        SearchPanel.prototype.render_children = function render_children(container, children) {
            var self = this;
            var data, tooltip, div, _$rapyd$_unpack, i, node;
            function click_handler(func, i) {
                return function() {
                    func.call(self, i);
                };
            }
            var _$rapyd$_Iter3 = _$rapyd$_Iterable(enumerate(children));
            for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                _$rapyd$_unpack = _$rapyd$_Iter3[_$rapyd$_Index3];
                i = _$rapyd$_unpack[0];
                node = _$rapyd$_unpack[1];
                data = node.data;
                tooltip = "";
                if (data.count !== undefined) {
                    tooltip += "\n" + str.format(_("Number of books in this category: {}"), data.count);
                }
                if (data.avg_rating !== undefined) {
                    tooltip += "\n" + str.format(_("Average rating for books in this category: {:.1f}"), data.avg_rating);
                }
                div = E.div(E.div(E.img(_$rapyd$_desugar_kwargs({src: self.icon_for_node(node), style: "display:inline-block; max-height:2.5ex"})), " " + data.name, _$rapyd$_desugar_kwargs({class_: "tag-name", style: "border-right:solid 1px currentColor; padding: 1ex; display:flex; align-items: center"})), E.div(E.div(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-angle-down"}))), _$rapyd$_desugar_kwargs({class_: "tag-menu", style: "padding: 1ex; display:flex; align-items:center"})), _$rapyd$_desugar_kwargs({title: str.lstrip(tooltip), style: "display:flex; align-items: stretch"}));
                set_css(div, _$rapyd$_desugar_kwargs({max_width: "45vw", border: "solid 1px currentColor", border_radius: "20px", margin: "0.5rem", cursor: "pointer", overflow: "hidden", user_select: "none"}));
                div.firstChild.addEventListener("click", click_handler(self.node_clicked, i));
                div.lastChild.addEventListener("click", click_handler(self.menu_clicked, i));
                container.appendChild(div);
            }
        };
        SearchPanel.prototype.render_breadcrumbs = function render_breadcrumbs() {
            var self = this;
            var container, parent, _$rapyd$_unpack, i, index;
            container = self.breadcrumbs_container;
            if (!self.tag_path.length) {
                container.style.display = "none";
                return;
            }
            container.style.display = "inline-block";
            self.breadcrumbs.reset();
            function onclick(i) {
                return function(ev) {
                    self.tag_path = self.tag_path.slice(0, i + 1);
                    self.render_tag_browser();
                    ev.preventDefault();
                    return true;
                };
            }
            function create_breadcrumb() {
                var index = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (-1) : arguments[0];
                var item = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
                var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
                if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
                if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "index")){
                    index = _$rapyd$_kwargs_obj.index;
                }
                if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "item")){
                    item = _$rapyd$_kwargs_obj.item;
                }
                var li;
                li = self.breadcrumbs.add_crumb(onclick(index));
                if (item) {
                    li.appendChild(E.span(item.name));
                } else {
                    li.appendChild(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-home fa-lg"})));
                }
            }
            create_breadcrumb();
            parent = self.tag_browser_data;
            var _$rapyd$_Iter4 = _$rapyd$_Iterable(enumerate(self.tag_path));
            for (var _$rapyd$_Index4 = 0; _$rapyd$_Index4 < _$rapyd$_Iter4.length; _$rapyd$_Index4++) {
                _$rapyd$_unpack = _$rapyd$_Iter4[_$rapyd$_Index4];
                i = _$rapyd$_unpack[0];
                index = _$rapyd$_unpack[1];
                parent = parent.children[index];
                create_breadcrumb(i, parent.data);
            }
        };
        SearchPanel.prototype.search_expression_for_item = function search_expression_for_item(node, state) {
            var self = this;
            var item, search_state, category, letters_seen, child, charclass, expr, fm, suffix, name;
            item = node.data;
            if (item.is_searchable === false || !state || state === "clear") {
                return "";
            }
            search_state = {
                "plus": "true",
                "plusplus": ".true",
                "minus": "false",
                "minusminus": ".false"
            }[state];
            if (item.is_category) {
                category = item.category;
                if (item.is_first_letter) {
                    letters_seen = {};
                    var _$rapyd$_Iter5 = _$rapyd$_Iterable(node.children);
                    for (var _$rapyd$_Index5 = 0; _$rapyd$_Index5 < _$rapyd$_Iter5.length; _$rapyd$_Index5++) {
                        child = _$rapyd$_Iter5[_$rapyd$_Index5];
                        if (child.data.sort) {
                            letters_seen[child.data.sort[0]] = true;
                        }
                    }
                    letters_seen = Object.keys(letters_seen);
                    if (letters_seen.length) {
                        charclass = letters_seen.join("");
                        if (category === "authors") {
                            expr = str.format("author_sort:\"~(^[{0}])|(&\\s*[{0}])\"", charclass);
                        } else if (category === "series") {
                            expr = str.format("series_sort:\"~^[{0}]\"", charclass);
                        } else {
                            expr = str.format("{0}:\"~^[{1}]\"", category, charclass);
                        }
                    } else {
                        expr = str.format("{}:false", category);
                    }
                } else if (category === "news") {
                    expr = str.format("tags:\"={}\"", item.name);
                } else {
                    return str.format("{}:{}", category, search_state);
                }
                if (_$rapyd$_in("false", search_state)) {
                    expr = "(not " + expr + ")";
                }
                return expr;
            }
            category = (item.category === "news") ? "tags" : item.category;
            if (item.name && item.name[0] === "★") {
                expr = str.format("{}:{}", category, item.name.length);
            } else {
                fm = self.interface_data.field_metadata[item.category];
                suffix = (fm && fm.is_csp) ? ":" : "";
                name = item.original_name || item.name || item.sort;
                if (!name) {
                    return "";
                }
                name = str.replace(name, "\"", "\\\"");
                if (name[0] === ".") {
                    name = "." + name;
                }
                if (search_state === "plusplus" || search_state === "minusminus") {
                    name = "." + name;
                }
                expr = str.format("{}:\"={}{}\"", category, name, suffix);
            }
            if (_$rapyd$_in("false", search_state)) {
                expr = "(not " + expr + ")";
            }
            return expr;
        };
        SearchPanel.prototype.node_clicked = function node_clicked(i) {
            var self = this;
            var node, expr;
            node = self.node_for_path().children[i];
            if (node.children && node.children.length) {
                self.tag_path.append(i);
                self.render_tag_browser();
            } else {
                expr = self.search_expression_for_item(node, "plus");
                self.execute_search(expr);
            }
        };
        SearchPanel.prototype.menu_clicked = function menu_clicked(i) {
            var self = this;
            function add_to_search(node, search_type) {
                return function() {
                    self.add_to_search(node, search_type);
                };
            }
            function create_details(container, hide_modal) {
                var node, data, name, items, suffix, style, title, ul, li, _$rapyd$_unpack, text, search_type, f, and_control;
                node = self.node_for_path().children[i];
                data = node.data;
                name = data.original_name || data.name || data.sort;
                items = _$rapyd$_list_decorate([]);
                if (data.count !== undefined) {
                    items.append(_("Count: ") + data.count);
                }
                if (data.avg_rating !== undefined) {
                    items.append(str.format(_("Rating: {:.1f}"), data.avg_rating));
                }
                suffix = "";
                if (items.length) {
                    suffix = " [" + items.join(" ") + "]";
                }
                style = build_rule("#modal-container ul.tb-action-list > li:hover", _$rapyd$_desugar_kwargs({color: get_color("list-hover-foreground"), background_color: get_color("list-hover-background")}));
                style += build_rule("#modal-container ul.tb-action-list > li:active", _$rapyd$_desugar_kwargs({color: "red", color: get_color("list-hover-foreground"), background_color: get_color("list-hover-background")}));
                title = E.h2(E.style(style), E.img(_$rapyd$_desugar_kwargs({src: self.icon_for_node(node), style: "height:2ex"})), E.span(" " + name + suffix), _$rapyd$_desugar_kwargs({style: "display:flex; align-items: center; border-bottom: solid 1px currentColor; font-weight:bold; font-size:" + get_font_size("title")}));
                container.appendChild(title);
                container.appendChild(E.div(_("Search for books based on this category (a search term will be added to the search box)"), _$rapyd$_desugar_kwargs({style: "margin-top:1ex; margin-bottom: 1ex"})));
                ul = E.ul(_$rapyd$_desugar_kwargs({style: "list-style:none; overflow:hidden", class_: "tb-action-list"}));
                container.appendChild(ul);
                items = _$rapyd$_list_decorate([ [_("Books matching this category"), "plus"], [_("Books that do not match this category"), 
                "minus"] ]);
                if (node.data.is_hierarchical === 5) {
                    items.extend(_$rapyd$_list_decorate([ [_("Books that match this category and all sub-categories"), 
                    "plusplus"], [_("Books that do not match this category or any of its sub-categories"), 
                    "minusminus"] ]));
                }
                var _$rapyd$_Iter6 = _$rapyd$_Iterable(items);
                for (var _$rapyd$_Index6 = 0; _$rapyd$_Index6 < _$rapyd$_Iter6.length; _$rapyd$_Index6++) {
                    _$rapyd$_unpack = _$rapyd$_Iter6[_$rapyd$_Index6];
                    text = _$rapyd$_unpack[0];
                    search_type = _$rapyd$_unpack[1];
                    li = E.li(E.img(_$rapyd$_desugar_kwargs({src: str.format("{}/{}.png", self.interface_data.icon_path, search_type), style: "max-height: 2.5ex"})), E.span(" " + text), _$rapyd$_desugar_kwargs({style: "display:flex; align-items: center; margin-bottom:0.5ex; padding: 0.5ex; cursor:pointer"}));
                    li.addEventListener("click", add_to_search(node, search_type));
                    li.addEventListener("click", hide_modal);
                    ul.appendChild(li);
                }
                f = E.form(E.span(_("Add to the search expression with:")), E.input(_$rapyd$_desugar_kwargs({type: "radio", name: "expr_join", value: "OR", checked: ""})), E.span(" OR "), E.input(_$rapyd$_desugar_kwargs({type: "radio", name: "expr_join", value: "AND"})), E.span(" AND"), _$rapyd$_desugar_kwargs({style: "text-align:left; border-top: solid 1px currentColor; padding-top:1ex; margin-top:0.5ex; display:flex; align-items:center"}));
                and_control = f.lastChild.previousSibling;
                and_control.checked = get_session_data().get("and_search_terms");
                container.appendChild(f);
                and_control.addEventListener("change", function(ev) {
                    get_session_data().set("and_search_terms", bool(ev.target.checked));
                });
                f.firstChild.nextSibling.addEventListener("change", function(ev) {
                    get_session_data().set("and_search_terms", !ev.target.checked);
                });
            }
            show_modal(create_details);
        };
        SearchPanel.prototype.add_to_search = function add_to_search(node, search_type, anded) {
            var self = this;
            if (anded === undefined || anded === null) {
                anded = get_session_data().get("and_search_terms");
            }
            self.active_nodes[node.id] = _$rapyd$_list_decorate([ search_type, anded ]);
            self.render_search_expression();
        };
        SearchPanel.prototype.render_search_expression = function render_search_expression() {
            var self = this;
            var parts, container, _$rapyd$_unpack, search_type, anded, node, expr, name, c, node_id;
            function remove_expression(node_id) {
                return function() {
                    delete self.active_nodes[node_id];
                    self.render_search_expression();
                };
            }
            parts = _$rapyd$_list_decorate([]);
            container = self.search_items_container;
            clear(container);
            var _$rapyd$_Iter7 = _$rapyd$_Iterable(Object.keys(self.active_nodes));
            for (var _$rapyd$_Index7 = 0; _$rapyd$_Index7 < _$rapyd$_Iter7.length; _$rapyd$_Index7++) {
                node_id = _$rapyd$_Iter7[_$rapyd$_Index7];
                _$rapyd$_unpack = self.active_nodes[node_id];
                search_type = _$rapyd$_unpack[0];
                anded = _$rapyd$_unpack[1];
                node = self.node_id_map[node_id];
                expr = self.search_expression_for_item(node, search_type);
                name = node.data.original_name || node.data.name || node.data.sort || "";
                if (expr) {
                    c = E.li(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-remove"})), " " + name);
                    container.appendChild(c);
                    c.addEventListener("click", remove_expression(node_id));
                    if (parts.length) {
                        expr = ((anded) ? "and" : "or") + " " + expr;
                    }
                    parts.push(expr);
                }
            }
            self.search_control.value = parts.join(" ");
        };
        SearchPanel.prototype.get_prefs = function get_prefs() {
            var self = this;
            return _$rapyd$_list_decorate([ {
                "name": "sort_tags_by",
                "text": _("Sort tags by"),
                "choices": _$rapyd$_list_decorate([ ["name", _("Name")], ["popularity", _("Popularity (number of books)")], ["rating", 
                _("Average rating")] ]),
                "tooltip": _("Change how the tags/authors/etc. are sorted in the Tag Browser")
            }, {
                "name": "partition_method",
                "text": _("Tags browser category partitioning method"),
                "choices": _$rapyd$_list_decorate([ ["first letter", _("First Letter")], ["disable", 
                _("Disable")], ["partition", _("Partition")] ]),
                "tooltip": _("Choose how tag browser subcategories are displayed when there are more items than the limit. Select by first letter to see an A, B, C list. Choose partitioned to have a list of fixed-sized groups. Set to disabled if you never want subcategories.")
            }, {
                "name": "collapse_at",
                "text": _("Collapse when more items than"),
                "min": 5,
                "max": 1e4,
                "step": 5,
                "from_storage": int,
                "to_storage": int,
                "tooltip": _("If a Tag Browser category has more than this number of items, it is divided up into subcategories. If the partition method is set to disable, this value is ignored.")
            }, {
                "name": "dont_collapse",
                "text": _("Categories not to partition"),
                "tooltip": _("A comma-separated list of categories in which items containing periods are displayed in the tag browser trees. For example, if this box contains 'tags' then tags of the form 'Mystery.English' and 'Mystery.Thriller' will be displayed with English and Thriller both under 'Mystery'. If 'tags' is not in this box, then the tags will be displayed each on their own line.")
            }, {
                "name": "hide_empty_categories",
                "text": _("Hide empty categories (columns)"),
                "from_storage": function(x) {
                    return x.toLowerCase() === "yes";
                },
                "to_storage": function(x) {
                    return (x) ? "yes" : "no";
                },
                "tooltip": _("When checked, calibre will automatically hide any category (a column, custom or standard) that has no items to show. For example, some categories might not have values when using virtual libraries. Checking this box will cause these empty categories to be hidden.")
            } ]);
        };
        SearchPanel.prototype.apply_prefs = function apply_prefs() {
            var self = this;
            var container;
            container = self.tb_container;
            clear(container);
            container.appendChild(E.div(_("Reloading tag browser with updated settings, please wait..."), _$rapyd$_desugar_kwargs({style: "margin: 1ex 1em"})));
            self.refresh();
        };
        SearchPanel.prototype.execute_search = function execute_search() {
            var self = this;
            var text = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("") : arguments[0];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "text")){
                text = _$rapyd$_kwargs_obj.text;
            }
            text = text || self.search_control.value || "";
            get_boss().ui.books_view.change_search(text);
        };
        SearchPanel.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "SearchPanel" + " #" + this._$rapyd$_object_id + ">";
        };
        SearchPanel.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        
        
        
        
        
        
        

        _$rapyd$_modules["book_list.search"]["sp_counter"] = sp_counter;

        _$rapyd$_modules["book_list.search"]["SearchPanel"] = SearchPanel;
    })();

    (function(){
        var __name__ = "book_list.top_bar";
        var bar_counter;
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        var get_font_size = _$rapyd$_modules["book_list.theme"].get_font_size;
        
        var set_css = _$rapyd$_modules["dom"].set_css;
        var clear = _$rapyd$_modules["dom"].clear;
        var create_keyframes = _$rapyd$_modules["dom"].create_keyframes;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        bar_counter = 0;
        function TopBar() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            TopBar.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(TopBar.prototype,  {
            "bar": {
                "enumerable": true, 
                "get": function bar() {
                    var self = this;
                    return document.getElementById(self.bar_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "dummy_bar": {
                "enumerable": true, 
                "get": function dummy_bar() {
                    var self = this;
                    return document.getElementById(self.dummy_bar_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        TopBar.prototype.__init__ = function __init__(book_list_container) {
            var self = this;
            var _$rapyd$_unpack, style, sel, bar, bid;
            bar_counter += 1;
            self.current_left_data = {};
            _$rapyd$_unpack = ["top-bar-" + bar_counter, "dummy-top-bar-" + bar_counter];
            self.bar_id = _$rapyd$_unpack[0];
            self.dummy_bar_id = _$rapyd$_unpack[1];
            self.throbber_name = self.bar_id + "-throbber";
            style = create_keyframes(self.throbber_name, "from { transform: scale(1); } 50% { transform: scale(0.5); } to { transform: scale(1); }");
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.dummy_bar_id, self.bar_id ]));
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                sel = _$rapyd$_Iter0[_$rapyd$_Index0];
                sel = "#" + sel + " a";
                style += build_rule(sel, _$rapyd$_desugar_kwargs({display: "inline-block", vertical_align: "middle", overflow: "hidden", cursor: "pointer", color: get_color("bar-foreground"), background: "none", padding_top: self.VSPACING, padding_bottom: self.VSPACING}));
            }
            style += build_rule(sel + ":hover", _$rapyd$_desugar_kwargs({transform: "scale(1.5)"}));
            style += build_rule(sel + ":active", _$rapyd$_desugar_kwargs({transform: "scale(2)"}));
            style += build_rule(sel + ":focus", _$rapyd$_desugar_kwargs({outline: "none"}));
            style += build_rule(sel + ".top-bar-title:hover", _$rapyd$_desugar_kwargs({transform: "scale(1)", color: get_color("bar-highlight"), font_style: "italic"}));
            style += build_rule(sel + ".top-bar-title:active", _$rapyd$_desugar_kwargs({transform: "scale(1)", color: get_color("bar-highlight"), font_style: "italic"}));
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.dummy_bar_id, self.bar_id ]));
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                bid = _$rapyd$_Iter1[_$rapyd$_Index1];
                bar = E.div(E.div(_$rapyd$_desugar_kwargs({style: "white-space:nowrap; overflow:hidden; text-overflow: ellipsis; padding-left: 0.5em;"})), E.div(_$rapyd$_desugar_kwargs({style: "white-space:nowrap; text-align:right; padding-right: 0.5em;"})), _$rapyd$_desugar_kwargs({id: bid}));
                if (bid === self.bar_id) {
                    set_css(bar, _$rapyd$_desugar_kwargs({position: "fixed", left: "0", top: "0", z_index: "1"}));
                    bar.appendChild(E.style(style, _$rapyd$_desugar_kwargs({type: "text/css"})));
                }
                set_css(bar, _$rapyd$_desugar_kwargs({width: "100%", display: "flex", flex_direction: "row", flex_wrap: "wrap", justify_content: "space-between", font_size: get_font_size("title"), user_select: "none", color: get_color("bar-foreground"), background_color: get_color("bar-background")}));
                book_list_container.appendChild(bar);
            }
        };
        TopBar.prototype.set_left = function set_left() {
            var self = this;
            var title = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("calibre") : arguments[0];
            var icon_name = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("heart") : arguments[1];
            var action = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var tooltip = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("") : arguments[3];
            var run_animation = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[4];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "title")){
                title = _$rapyd$_kwargs_obj.title;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "icon_name")){
                icon_name = _$rapyd$_kwargs_obj.icon_name;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "action")){
                action = _$rapyd$_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "tooltip")){
                tooltip = _$rapyd$_kwargs_obj.tooltip;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "run_animation")){
                run_animation = _$rapyd$_kwargs_obj.run_animation;
            }
            var title_action, title_tooltip, _$rapyd$_chain_assign_temp, data, _$rapyd$_unpack, left, title_elem, a, bar;
            self.current_left_data = {
                "title": title,
                "icon_name": icon_name,
                "action": action,
                "tooltip": tooltip
            };
            if (icon_name === "heart") {
                if (!tooltip) {
                    tooltip = _("Donate to support calibre development");
                }
            }
            _$rapyd$_chain_assign_temp = null;
            title_action = _$rapyd$_chain_assign_temp;
            title_tooltip = _$rapyd$_chain_assign_temp;
;
            if (callable(title)) {
                data = title();
                _$rapyd$_unpack = [data.title, data.title_action, data.title_tooltip];
                title = _$rapyd$_unpack[0];
                title_action = _$rapyd$_unpack[1];
                title_tooltip = _$rapyd$_unpack[2];
            }
            var _$rapyd$_Iter2 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.bar, self.dummy_bar ]));
            for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                bar = _$rapyd$_Iter2[_$rapyd$_Index2];
                left = bar.firstChild;
                clear(left);
                title_elem = (callable(title_action)) ? "a" : "span";
                left.appendChild(E.a(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-" + icon_name + " fa-fw"})), _$rapyd$_desugar_kwargs({title: tooltip})));
                left.appendChild(E(title_elem, title, _$rapyd$_desugar_kwargs({title: title_tooltip, class_: "top-bar-title", style: str.format("margin-left: {0}; font-weight: bold; padding-top: {1}; padding-bottom: {1}; vertical-align: middle", self.SPACING, self.VSPACING)})));
                if (bar === self.bar) {
                    a = left.firstChild;
                    if (icon_name === "heart") {
                        set_css(a, _$rapyd$_desugar_kwargs({animation_name: self.throbber_name, animation_duration: "1s", animation_timing_function: "ease-in-out", animation_iteration_count: "5", animation_play_state: (run_animation) ? "running" : "paused"}));
                        set_css(a.firstChild, _$rapyd$_desugar_kwargs({color: get_color("heart")}));
                        a.setAttribute("href", "http://calibre-ebook.com/donate");
                        a.setAttribute("target", "donate-to-calibre");
                    }
                    if (action !== null) {
                        a.addEventListener("click", function(event) {
                            [event.preventDefault(), action()];
                        });
                    }
                    if (callable(title_action)) {
                        a = a.nextSibling;
                        a.addEventListener("click", function(event) {
                            [event.preventDefault(), title_action()];
                        });
                    }
                }
            }
        };
        TopBar.prototype.refresh_left = function refresh_left() {
            var self = this;
            var kw;
            kw = self.current_left_data;
            self.set_left.apply(self, [_$rapyd$_desugar_kwargs(kw)]);
        };
        TopBar.prototype.add_button = function add_button() {
            var self = this;
            var icon_name = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
            var action = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var tooltip = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("") : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "icon_name")){
                icon_name = _$rapyd$_kwargs_obj.icon_name;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "action")){
                action = _$rapyd$_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "tooltip")){
                tooltip = _$rapyd$_kwargs_obj.tooltip;
            }
            var right, bar;
            if (!icon_name) {
                return;
            }
            var _$rapyd$_Iter3 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.bar, self.dummy_bar ]));
            for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                bar = _$rapyd$_Iter3[_$rapyd$_Index3];
                right = bar.firstChild.nextSibling;
                right.appendChild(E.a(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-" + icon_name + " fa-fw"})), _$rapyd$_desugar_kwargs({style: "margin-left: " + self.SPACING, title: tooltip})));
                if (bar === self.bar) {
                    if (action !== null) {
                        right.lastChild.addEventListener("click", function(event) {
                            [event.preventDefault(), action()];
                        });
                    }
                }
            }
        };
        TopBar.prototype.set_button_visibility = function set_button_visibility(icon_name, visible) {
            var self = this;
            var right, elem, bar;
            var _$rapyd$_Iter4 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.bar, self.dummy_bar ]));
            for (var _$rapyd$_Index4 = 0; _$rapyd$_Index4 < _$rapyd$_Iter4.length; _$rapyd$_Index4++) {
                bar = _$rapyd$_Iter4[_$rapyd$_Index4];
                right = bar.firstChild.nextSibling;
                elem = right.querySelector("i.fa.fa-fw.fa-" + icon_name);
                if (elem) {
                    elem.parentNode.style.display = (visible) ? "inline" : "none";
                }
            }
        };
        TopBar.prototype.apply_state = function apply_state(left, buttons) {
            var self = this;
            var right, bar, button;
            self.set_left.apply(self, [_$rapyd$_desugar_kwargs(left)]);
            var _$rapyd$_Iter5 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.bar, self.dummy_bar ]));
            for (var _$rapyd$_Index5 = 0; _$rapyd$_Index5 < _$rapyd$_Iter5.length; _$rapyd$_Index5++) {
                bar = _$rapyd$_Iter5[_$rapyd$_Index5];
                right = bar.firstChild.nextSibling;
                clear(right);
            }
            var _$rapyd$_Iter6 = _$rapyd$_Iterable(buttons);
            for (var _$rapyd$_Index6 = 0; _$rapyd$_Index6 < _$rapyd$_Iter6.length; _$rapyd$_Index6++) {
                button = _$rapyd$_Iter6[_$rapyd$_Index6];
                self.add_button.apply(self, [_$rapyd$_desugar_kwargs(button)]);
            }
        };
        TopBar.prototype.set_title = function set_title(text) {
            var self = this;
            var bar;
            var _$rapyd$_Iter7 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.bar, self.dummy_bar ]));
            for (var _$rapyd$_Index7 = 0; _$rapyd$_Index7 < _$rapyd$_Iter7.length; _$rapyd$_Index7++) {
                bar = _$rapyd$_Iter7[_$rapyd$_Index7];
                bar.firstChild.firstChild.nextSibling.textContent = text;
            }
        };
        TopBar.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "TopBar" + " #" + this._$rapyd$_object_id + ">";
        };
        TopBar.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        TopBar.prototype.SPACING = "0.75em";
        TopBar.prototype.VSPACING = "0.5ex";
        
        

        _$rapyd$_modules["book_list.top_bar"]["bar_counter"] = bar_counter;

        _$rapyd$_modules["book_list.top_bar"]["TopBar"] = TopBar;
    })();

    (function(){
        var __name__ = "book_list.views";
        var THUMBNAIL_MAX_WIDTH, THUMBNAIL_MAX_HEIGHT, bv_counter;
        var ajax_send = _$rapyd$_modules["ajax"].ajax_send;
        
        var set_css = _$rapyd$_modules["dom"].set_css;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        var clear = _$rapyd$_modules["dom"].clear;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var error_dialog = _$rapyd$_modules["modals"].error_dialog;
        var ajax_progress_dialog = _$rapyd$_modules["modals"].ajax_progress_dialog;
        
        var get_session_data = _$rapyd$_modules["book_list.globals"].get_session_data;
        var get_boss = _$rapyd$_modules["book_list.globals"].get_boss;
        
        var create_button = _$rapyd$_modules["widgets"].create_button;
        var create_spinner = _$rapyd$_modules["widgets"].create_spinner;
        
        THUMBNAIL_MAX_WIDTH = 300;
        THUMBNAIL_MAX_HEIGHT = 400;
        bv_counter = 0;
        function BooksView() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            BooksView.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(BooksView.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.container_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "grid": {
                "enumerable": true, 
                "get": function grid() {
                    var self = this;
                    return self.container.lastChild.previousSibling;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "is_visible": {
                "enumerable": true, 
                "get": function is_visible() {
                    var self = this;
                    self.container.style.display === "block";
                }, 
                "set": function is_visible(val) {
                    var self = this;
                    self.container.style.display = (val) ? "block" : "none";
                }
            }, 
        });
        BooksView.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var style, div;
            bv_counter += 1;
            self.interface_data = interface_data;
            self.is_fetching = null;
            self.shown_book_ids = set();
            self.container_id = "books-view-" + bv_counter;
            style = build_rule("#" + self.container_id + " .cover_grid > div:hover", _$rapyd$_desugar_kwargs({transform: "scale(1.2)"}));
            style += build_rule("#" + self.container_id + " .cover_grid > div:active", _$rapyd$_desugar_kwargs({transform: "scale(2.0)"}));
            div = E.div(E.style(style), E.div(), E.div(), _$rapyd$_desugar_kwargs({id: self.container_id, style: "display:block"}));
            book_list_container.appendChild(div);
            self.set_view_mode(get_session_data().get("view_mode"));
            self.create_more_button(div);
        };
        BooksView.prototype.create_more_button = function create_more_button(div) {
            var self = this;
            var more;
            more = div.lastChild;
            more.appendChild(create_button(_("Show more books"), "cloud-download", function() {
                self.get_more_books();
            }));
            more.lastChild.setAttribute("rel", "next");
            set_css(more.firstChild, _$rapyd$_desugar_kwargs({display: "block", margin_left: "auto", margin_right: "auto"}));
            set_css(more, _$rapyd$_desugar_kwargs({font_size: "1.5rem", padding_top: "1.5rem", margin_bottom: "1.5rem", width: "100%", text_align: "center"}));
            more.appendChild(E.div(create_spinner(), " " + _("Fetching metadata for more books, please wait") + "…", _$rapyd$_desugar_kwargs({style: "margin-left:auto; margin-right:auto; display:none"})));
            self.update_fetching_status();
        };
        BooksView.prototype.set_view_mode = function set_view_mode() {
            var self = this;
            var mode = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("cover_grid") : arguments[0];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "mode")){
                mode = _$rapyd$_kwargs_obj.mode;
            }
            if (self.mode === mode) {
                return;
            }
            if (!(_$rapyd$_in(mode, ['cover_grid']))) {
                mode = "cover_grid";
            }
            self.mode = mode;
            if (mode === "cover_grid") {
                self.render_book = self.cover_grid_item.bind(self);
                self.init_grid = self.init_cover_grid.bind(self);
            }
            self.clear();
            self.render_ids();
        };
        BooksView.prototype.clear = function clear() {
            var self = this;
            var c;
            c = self.container;
            c.removeChild(self.grid);
            c.insertBefore(E.div(), c.lastChild);
            self.shown_book_ids.clear();
            self.init_grid();
        };
        BooksView.prototype.render_id = function render_id(book_id) {
            var self = this;
            var l;
            l = self.shown_book_ids.length;
            self.shown_book_ids.add(book_id);
            if (l < self.shown_book_ids.length) {
                return self.render_book(book_id);
            }
        };
        BooksView.prototype.render_ids = function render_ids(book_ids) {
            var self = this;
            var div, child, book_id;
            book_ids = book_ids || self.interface_data["search_result"]["book_ids"];
            div = self.grid;
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(book_ids);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                book_id = _$rapyd$_Iter0[_$rapyd$_Index0];
                child = self.render_id(book_id);
                if (child !== null) {
                    div.appendChild(self.render_book(book_id));
                }
            }
        };
        BooksView.prototype.update_fetching_status = function update_fetching_status() {
            var self = this;
            var c, more;
            c = self.container;
            more = c.lastChild;
            if (self.is_fetching !== null) {
                more.firstChild.style.display = "none";
                more.lastChild.style.display = "block";
            } else if (self.interface_data["search_result"]["total_num"] > self.shown_book_ids.length) {
                more.firstChild.style.display = "block";
                more.lastChild.style.display = "none";
            } else {
                more.firstChild.style.display = "none";
                more.lastChild.style.display = "none";
            }
        };
        BooksView.prototype.get_more_books = function get_more_books() {
            var self = this;
            var data, key;
            data = {
                "offset": self.shown_book_ids.length
            };
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ "query", "sort", "sort_order" ]));
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                key = _$rapyd$_Iter1[_$rapyd$_Index1];
                data[key] = self.interface_data["search_result"][key];
            }
            self.is_fetching = ajax_send("interface-data/more-books", data, self.got_more_books.bind(self), _$rapyd$_desugar_kwargs({query: {
                "library_id": self.interface_data.library_id
            }}));
            self.update_fetching_status();
        };
        BooksView.prototype.abort_get_more_books = function abort_get_more_books() {
            var self = this;
            var _$rapyd$_unpack, a;
            if (self.is_fetching) {
                _$rapyd$_unpack = [self.is_fetching, null];
                a = _$rapyd$_unpack[0];
                self.is_fetching = _$rapyd$_unpack[1];
                a.abort();
                self.update_fetching_status();
            }
        };
        BooksView.prototype.got_more_books = function got_more_books(end_type, xhr, event) {
            var self = this;
            var data, key;
            if (self.is_fetching === null || self.is_fetching !== xhr) {
                return;
            }
            self.is_fetching = null;
            self.update_fetching_status();
            if (end_type === "load") {
                try {
                    data = JSON.parse(xhr.responseText);
                    var _$rapyd$_Iter2 = _$rapyd$_Iterable(data.metadata);
                    for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                        key = _$rapyd$_Iter2[_$rapyd$_Index2];
                        self.interface_data.metadata[key] = data.metadata[key];
                    }
                    if (!data.search_result.book_ids) {
                        throw new Exception("No books ids object in search result from server");
                    }
                    self.render_ids(data.search_result.book_ids);
                    self.interface_data.search_result = data.search_result;
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        error_dialog(_("Could not get more books"), _("Server returned an invalid response"), err.stack || err.toString());
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
            } else if (end_type !== "abort") {
                error_dialog(_("Could not get more books"), xhr.error_html);
            }
        };
        BooksView.prototype.init_cover_grid = function init_cover_grid() {
            var self = this;
            var div;
            div = self.grid;
            set_css(div, _$rapyd$_desugar_kwargs({display: "flex", flex_wrap: "wrap", justify_content: "flex-start", align_items: "flex-end", align_content: "flex-start", user_select: "none"}));
            div.setAttribute("class", "cover_grid");
        };
        BooksView.prototype.on_cover_grid_img_err = function on_cover_grid_img_err(err) {
            var self = this;
            var img, div;
            img = err.target;
            div = img.parentNode;
            if (!div) {
                return;
            }
            clear(div);
            div.appendChild(E.div(E.h2(img.getAttribute("data-title"), _$rapyd$_desugar_kwargs({style: "text-align:center; font-size:larger; font-weight: bold"})), E.div(_("by"), _$rapyd$_desugar_kwargs({style: "text-align: center"})), E.h2(img.getAttribute("data-authors"), _$rapyd$_desugar_kwargs({style: "text-align:center; font-size:larger; font-weight: bold"})), _$rapyd$_desugar_kwargs({style: "position:relative; top:-50%; transform: translateY(50%)"})));
            set_css(div, _$rapyd$_desugar_kwargs({border: "dashed 1px currentColor", border_radius: "10px"}));
        };
        BooksView.prototype.cover_grid_item = function cover_grid_item(book_id) {
            var self = this;
            var cover_url, metadata, alt, img, ans;
            cover_url = str.format("get/thumb/{}/{}?sz={}x{}", book_id, self.interface_data["library_id"], THUMBNAIL_MAX_WIDTH, THUMBNAIL_MAX_HEIGHT);
            metadata = self.interface_data["metadata"][book_id];
            alt = str.format(_("{} by {}"), metadata["title"], metadata["authors"].join(" & "));
            img = E.img(_$rapyd$_desugar_kwargs({src: cover_url, alt: alt, title: alt, data_title: metadata["title"], data_authors: metadata["authors"].join(" & "), style: "max-width: 100%; max-height: 100%; display: block; width:auto; height:auto; border-radius: 10px"}));
            img.onerror = self.on_cover_grid_img_err.bind(self);
            ans = E.div(img, _$rapyd$_desugar_kwargs({style: str.format("margin: 10px; display: flex; align-content: flex-end; align-items: flex-end; justify-content: space-around;width: 21vw; height: 28vw; max-width: {}px; max-height: {}px; min-width: {}px; min-height: {}px; cursor:pointer", THUMBNAIL_MAX_WIDTH, THUMBNAIL_MAX_HEIGHT, Math.floor(THUMBNAIL_MAX_WIDTH / 2), Math.floor(THUMBNAIL_MAX_HEIGHT / 2)), data_book_id: str(book_id)}));
            ans.addEventListener("click", function(ev) {
                self.show_book_details(book_id);
            });
            return ans;
        };
        BooksView.prototype.sort_panel_data = function sort_panel_data(create_item) {
            var self = this;
            var current_sorted_field, current_sorted_field_order, new_sort_order, ans, subtitle, icon_name, _$rapyd$_chain_assign_temp, action, _$rapyd$_unpack, field, name;
            current_sorted_field = str.partition(self.interface_data.search_result.sort, ",")[0];
            current_sorted_field_order = str.partition(self.interface_data.search_result.sort_order, ",")[0];
            new_sort_order = (current_sorted_field_order === "asc") ? "desc" : "asc";
            if (current_sorted_field === "date") {
                current_sorted_field = "timestamp";
            }
            ans = _$rapyd$_list_decorate([]);
            ans.subtitle = _("Change how the list of books is sorted");
            var _$rapyd$_Iter3 = _$rapyd$_Iterable(self.interface_data.sortable_fields);
            for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                _$rapyd$_unpack = _$rapyd$_Iter3[_$rapyd$_Index3];
                field = _$rapyd$_unpack[0];
                name = _$rapyd$_unpack[1];
                _$rapyd$_chain_assign_temp = null;
                subtitle = _$rapyd$_chain_assign_temp;
                icon_name = _$rapyd$_chain_assign_temp;
;
                if (field === current_sorted_field) {
                    subtitle = _("Reverse current sort order");
                    icon_name = (current_sorted_field_order === "asc") ? "sort-amount-asc" : "sort-amount-desc";
                    action = self.change_sort.bind(self, field, new_sort_order);
                } else {
                    action = self.change_sort.bind(self, field, null);
                }
                ans.push(create_item(name, _$rapyd$_desugar_kwargs({subtitle: subtitle, icon_name: icon_name, action: action})));
            }
            return ans;
        };
        BooksView.prototype.change_sort = function change_sort(field, order) {
            var self = this;
            var key, sd, sr, sort, data;
            self.abort_get_more_books();
            key = "sort-order-for-" + field;
            sd = get_session_data();
            order = order || sd.get(key, "asc");
            order = (order === "asc") ? "asc" : "desc";
            sd.set(key, order);
            sr = self.interface_data.search_result;
            sort = field + "." + order + "," + sr.sort + "." + sr.order;
            data = {
                "search": sr.query || "",
                "sort": sort,
                "num": self.shown_book_ids.length,
                "library_id": self.interface_data.library_id
            };
            ajax_progress_dialog("interface-data/get-books", self.sort_change_completed.bind(self), _("Fetching data from server, please wait") + "…", _$rapyd$_desugar_kwargs({query: data}));
        };
        BooksView.prototype.sort_change_completed = function sort_change_completed(end_type, xhr, ev) {
            var self = this;
            var boss, data;
            if (end_type === "load") {
                boss = get_boss();
                try {
                    data = JSON.parse(xhr.responseText);
                    boss.change_books(data);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        return error_dialog(_("Could not change sort order"), err + "", _$rapyd$_desugar_kwargs({details: err.stack}));
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
                boss.ui.show_panel(boss.ui.ROOT_PANEL);
                window.scrollTo(0, 0);
            } else if (end_type !== "abort") {
                error_dialog(_("Could not change sort order"), xhr.error_html);
            }
        };
        BooksView.prototype.change_search = function change_search() {
            var self = this;
            var query = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var push_state = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[1];
            var panel_to_show = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "push_state")){
                push_state = _$rapyd$_kwargs_obj.push_state;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "panel_to_show")){
                panel_to_show = _$rapyd$_kwargs_obj.panel_to_show;
            }
            var sd, data;
            self.abort_get_more_books();
            query = query || "";
            sd = get_session_data();
            data = {
                "search": query,
                "sort": sd.get_library_option(self.interface_data.library_id, "sort"),
                "library_id": self.interface_data.library_id
            };
            ajax_progress_dialog("interface-data/get-books", self.search_change_completed.bind(self), _("Fetching data from server, please wait") + "…", _$rapyd$_desugar_kwargs({query: data, extra_data_for_callback: {
                "push_state": push_state,
                "panel_to_show": panel_to_show
            }}));
        };
        BooksView.prototype.search_change_completed = function search_change_completed(end_type, xhr, ev) {
            var self = this;
            var boss, data, ed, msg;
            if (end_type === "load") {
                boss = get_boss();
                try {
                    data = JSON.parse(xhr.responseText);
                    boss.change_books(data);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        return error_dialog(_("Could not change search query"), err + "", _$rapyd$_desugar_kwargs({details: err.stack}));
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
                self.update_fetching_status();
                ed = xhr.extra_data_for_callback;
                boss.ui.show_panel(ed.panel_to_show || boss.ui.ROOT_PANEL, _$rapyd$_desugar_kwargs({push_state: ed.push_state}));
                window.scrollTo(0, 0);
            } else if (end_type !== "abort") {
                msg = xhr.error_html;
                if (xhr.status === 400 && str.startswith(xhr.responseText, "Invalid search expression:")) {
                    msg = _("The search expression could not be parsed: ") + xhr.responseText;
                }
                error_dialog(_("Could not change search query"), msg);
            }
        };
        BooksView.prototype.refresh = function refresh() {
            var self = this;
            self.clear();
            self.render_ids();
        };
        BooksView.prototype.show_book_details = function show_book_details(book_id) {
            var self = this;
            get_boss().ui.show_panel("book-details", _$rapyd$_desugar_kwargs({extra_query_data: {
                "book-id": "" + book_id
            }}));
        };
        BooksView.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "BooksView" + " #" + this._$rapyd$_object_id + ">";
        };
        BooksView.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        
        
        
        

        _$rapyd$_modules["book_list.views"]["THUMBNAIL_MAX_WIDTH"] = THUMBNAIL_MAX_WIDTH;

        _$rapyd$_modules["book_list.views"]["THUMBNAIL_MAX_HEIGHT"] = THUMBNAIL_MAX_HEIGHT;

        _$rapyd$_modules["book_list.views"]["bv_counter"] = bv_counter;

        _$rapyd$_modules["book_list.views"]["BooksView"] = BooksView;
    })();

    (function(){
        var __name__ = "book_list.item_list";
        var iv_counter;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var get_font_size = _$rapyd$_modules["book_list.theme"].get_font_size;
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        
        iv_counter = 0;
        function ItemsView() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            ItemsView.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(ItemsView.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.container_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "is_visible": {
                "enumerable": true, 
                "get": function is_visible() {
                    var self = this;
                    self.container.style.display === "block";
                }, 
                "set": function is_visible(val) {
                    var self = this;
                    self.container.style.display = (val) ? "block" : "none";
                }
            }, 
        });
        ItemsView.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var style, cid, div;
            iv_counter += 1;
            self.container_id = "items-view-" + iv_counter;
            style = "";
            cid = "#" + self.container_id;
            style += build_rule(cid + " li", _$rapyd$_desugar_kwargs({padding: "1em", border_bottom: "solid 1px " + get_color("window-foreground"), border_top: "solid 1px " + get_color("window-background"), cursor: "pointer", list_style: "none"}));
            style += build_rule(cid + " .item-title", _$rapyd$_desugar_kwargs({font_size: get_font_size("item-list-title")}));
            style += build_rule(cid + " .item-subtitle", _$rapyd$_desugar_kwargs({font_size: get_font_size("item-list-subtitle"), font_style: "italic"}));
            style += build_rule(cid + " li:hover", _$rapyd$_desugar_kwargs({color: get_color("list-hover-foreground"), background_color: get_color("list-hover-background"), border_top_color: get_color("list-hover-foreground")}));
            style += build_rule(cid + " li:active", _$rapyd$_desugar_kwargs({transform: "scale(1, 1.5)"}));
            self.base_style = style;
            div = E.div(E.style(style, _$rapyd$_desugar_kwargs({type: "text/css"})), _$rapyd$_desugar_kwargs({id: self.container_id, style: "display:none"}));
            book_list_container.appendChild(div);
        };
        ItemsView.prototype.clear = function clear() {
            var self = this;
            var c;
            c = self.container;
            while (c.lastChild !== c.firstChild) {
                c.removeChild(c.lastChild);
            }
            return c;
        };
        ItemsView.prototype.init = function init(data) {
            var self = this;
            var items, subtitle, c, ul, has_icons, item, ic, a;
            items = getattr(data, "items", data);
            subtitle = getattr(data, "subtitle", null);
            c = self.clear();
            if (subtitle) {
                c.appendChild(E.p(subtitle, _$rapyd$_desugar_kwargs({style: "font-style:italic; padding: 1em 1ex; border-bottom: solid 1px currentColor"})));
            }
            ul = E.ul();
            c.appendChild(ul);
            has_icons = false;
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(items);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                item = _$rapyd$_Iter0[_$rapyd$_Index0];
                if (item.icon_name) {
                    has_icons = true;
                    break;
                }
            }
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(items);
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                item = _$rapyd$_Iter1[_$rapyd$_Index1];
                ic = "";
                if (has_icons) {
                    ic = "fa fa-fw ";
                    if (item.icon_name) {
                        ic += " fa-" + item.icon_name;
                    }
                    ic = E.span(" ", _$rapyd$_desugar_kwargs({class_: ic}));
                }
                ul.appendChild(E.li(E.a(E.div(ic, item.title, _$rapyd$_desugar_kwargs({class_: "item-title"})), _$rapyd$_desugar_kwargs({href: "javascript:void(0)"}))));
                a = ul.lastChild.firstChild;
                if (item.subtitle) {
                    a.appendChild(E.div(item.subtitle, _$rapyd$_desugar_kwargs({class_: "item-subtitle", style: "padding-top:1ex"})));
                }
                a.addEventListener("click", function(event) {
                    event.preventDefault();
                });
                if (item.action) {
                    ul.lastChild.addEventListener("click", item.action);
                }
            }
        };
        ItemsView.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "ItemsView" + " #" + this._$rapyd$_object_id + ">";
        };
        ItemsView.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        
        
        

        function create_item() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var action = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var subtitle = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var icon_name = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "action")){
                action = _$rapyd$_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "subtitle")){
                subtitle = _$rapyd$_kwargs_obj.subtitle;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "icon_name")){
                icon_name = _$rapyd$_kwargs_obj.icon_name;
            }
            return {
                "title": title,
                "action": action,
                "subtitle": subtitle,
                "icon_name": icon_name
            };
        }
        _$rapyd$_modules["book_list.item_list"]["iv_counter"] = iv_counter;

        _$rapyd$_modules["book_list.item_list"]["ItemsView"] = ItemsView;

        _$rapyd$_modules["book_list.item_list"]["create_item"] = create_item;
    })();

    (function(){
        var __name__ = "book_list.prefs";
        var pp_counter, widget_counter;
        var clear = _$rapyd$_modules["dom"].clear;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var get_session_data = _$rapyd$_modules["book_list.globals"].get_session_data;
        
        var create_button = _$rapyd$_modules["widgets"].create_button;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        pp_counter = 0;
        widget_counter = 0;
        function ConfigItem() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            ConfigItem.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(ConfigItem.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.widget_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "control": {
                "enumerable": true, 
                "get": function control() {
                    var self = this;
                    return self.container.lastChild;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        ConfigItem.prototype.__init__ = function __init__(item_data) {
            var self = this;
            widget_counter += 1;
            self.widget_id = "pref-widget-" + widget_counter;
            self.item_data = item_data;
            self.ignore_ui_value_changed = false;
        };
        ConfigItem.prototype.initialize = function initialize() {
            var self = this;
            self.ignore_ui_value_changed = true;
            try {
                self.to_ui(self.from_storage());
            } finally {
                self.ignore_ui_value_changed = false;
            }
            return self;
        };
        ConfigItem.prototype.from_storage = function from_storage() {
            var self = this;
            var val;
            val = get_session_data().get(self.item_data.name);
            if (self.item_data.from_storage) {
                val = self.item_data.from_storage(val);
            }
            return val;
        };
        ConfigItem.prototype.to_storage = function to_storage(val) {
            var self = this;
            if (self.item_data.to_storage) {
                val = self.item_data.to_storage(val);
            }
            get_session_data().set(self.item_data.name, val);
        };
        ConfigItem.prototype.defval = function defval() {
            var self = this;
            var val;
            val = get_session_data().defval(self.item_data.name);
            if (self.item_data.from_storage) {
                val = self.item_data.from_storage(val);
            }
            return val;
        };
        ConfigItem.prototype.ui_value_changed = function ui_value_changed() {
            var self = this;
            if (self.ignore_ui_value_changed) {
                return;
            }
            self.to_storage(self.from_ui());
        };
        ConfigItem.prototype.reset_to_default = function reset_to_default() {
            var self = this;
            self.to_ui(self.defval());
            self.ui_value_changed();
        };
        ConfigItem.prototype.to_ui = function to_ui(val) {
            var self = this;
        };
        ConfigItem.prototype.from_ui = function from_ui() {
            var self = this;
        };
        ConfigItem.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "ConfigItem" + " #" + this._$rapyd$_object_id + ">";
        };
        ConfigItem.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        
        

        function Choices() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            Choices.prototype.__init__.apply(this, arguments);
        }
        _$rapyd$_extends(Choices, ConfigItem);
        Choices.prototype.__init__ = function __init__(item_data, container, onfocus) {
            var self = this;
            var div, select, _$rapyd$_unpack, choice, text;
            ConfigItem.prototype.constructor.call(self, item_data);
            div = E.div(E.span(item_data.text + ": ", _$rapyd$_desugar_kwargs({style: "white-space:pre"})), E.select(_$rapyd$_desugar_kwargs({required: "1"})), _$rapyd$_desugar_kwargs({id: self.widget_id}));
            container.appendChild(div);
            select = div.lastChild;
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(item_data.choices);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                _$rapyd$_unpack = _$rapyd$_Iter0[_$rapyd$_Index0];
                choice = _$rapyd$_unpack[0];
                text = _$rapyd$_unpack[1];
                select.appendChild(E.option(text, _$rapyd$_desugar_kwargs({value: choice})));
            }
            select.addEventListener("change", self.ui_value_changed.bind(self));
            select.addEventListener("focus", onfocus);
            div.addEventListener("click", onfocus);
        };
        Choices.prototype.to_ui = function to_ui(val) {
            var self = this;
            self.control.value = val;
        };
        Choices.prototype.from_ui = function from_ui() {
            var self = this;
            return self.control.value;
        };
        Choices.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "Choices" + " #" + this._$rapyd$_object_id + ">";
        };
        Choices.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        function CheckBox() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            CheckBox.prototype.__init__.apply(this, arguments);
        }
        _$rapyd$_extends(CheckBox, ConfigItem);
        Object.defineProperties(CheckBox.prototype,  {
            "control": {
                "enumerable": true, 
                "get": function control() {
                    var self = this;
                    return self.container.firstChild;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        CheckBox.prototype.__init__ = function __init__(item_data, container, onfocus) {
            var self = this;
            var div, control;
            ConfigItem.prototype.constructor.call(self, item_data);
            div = E.div(E.input(_$rapyd$_desugar_kwargs({type: "checkbox"})), E.span(" " + item_data.text, _$rapyd$_desugar_kwargs({style: "white-space:pre"})), _$rapyd$_desugar_kwargs({id: self.widget_id}));
            container.appendChild(div);
            control = div.firstChild;
            control.addEventListener("change", self.ui_value_changed.bind(self));
            control.addEventListener("focus", onfocus);
            div.addEventListener("click", onfocus);
            div.lastChild.addEventListener("click", self.toggle.bind(self));
        };
        CheckBox.prototype.to_ui = function to_ui(val) {
            var self = this;
            self.control.checked = bool(val);
        };
        CheckBox.prototype.from_ui = function from_ui() {
            var self = this;
            return bool(self.control.checked);
        };
        CheckBox.prototype.toggle = function toggle() {
            var self = this;
            self.to_ui(!self.from_ui());
            self.ui_value_changed();
        };
        CheckBox.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "CheckBox" + " #" + this._$rapyd$_object_id + ">";
        };
        CheckBox.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        

        function SpinBox() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            SpinBox.prototype.__init__.apply(this, arguments);
        }
        _$rapyd$_extends(SpinBox, ConfigItem);
        SpinBox.prototype.__init__ = function __init__(item_data, container, onfocus) {
            var self = this;
            var div, control, val, attr;
            ConfigItem.prototype.constructor.call(self, item_data);
            div = E.div(E.span(item_data.text + ": ", _$rapyd$_desugar_kwargs({style: "white-space:pre"})), E.input(_$rapyd$_desugar_kwargs({type: "number", step: "any", min: "1", max: "100"})), _$rapyd$_desugar_kwargs({id: self.widget_id}));
            container.appendChild(div);
            control = div.lastChild;
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(str.split("min max step"));
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                attr = _$rapyd$_Iter1[_$rapyd$_Index1];
                val = item_data[attr];
                if (val !== undefined && val !== null) {
                    control.setAttribute(attr, "" + val);
                }
            }
            control.addEventListener("change", self.ui_value_changed.bind(self));
            control.addEventListener("focus", onfocus);
            div.addEventListener("click", onfocus);
        };
        SpinBox.prototype.to_ui = function to_ui(val) {
            var self = this;
            self.control.value = val;
        };
        SpinBox.prototype.from_ui = function from_ui() {
            var self = this;
            return self.control.value;
        };
        SpinBox.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "SpinBox" + " #" + this._$rapyd$_object_id + ">";
        };
        SpinBox.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        function LineEdit() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            LineEdit.prototype.__init__.apply(this, arguments);
        }
        _$rapyd$_extends(LineEdit, ConfigItem);
        LineEdit.prototype.__init__ = function __init__(item_data, container, onfocus) {
            var self = this;
            var div, control;
            ConfigItem.prototype.constructor.call(self, item_data);
            div = E.div(E.span(item_data.text + ": ", _$rapyd$_desugar_kwargs({style: "white-space:pre"})), E.input(_$rapyd$_desugar_kwargs({type: "text"})), _$rapyd$_desugar_kwargs({id: self.widget_id}));
            container.appendChild(div);
            control = div.lastChild;
            control.addEventListener("change", self.ui_value_changed.bind(self));
            control.addEventListener("focus", onfocus);
            div.addEventListener("click", onfocus);
        };
        LineEdit.prototype.to_ui = function to_ui(val) {
            var self = this;
            self.control.value = val || "";
        };
        LineEdit.prototype.from_ui = function from_ui() {
            var self = this;
            return self.control.value || "";
        };
        LineEdit.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "LineEdit" + " #" + this._$rapyd$_object_id + ">";
        };
        LineEdit.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        function PrefsPanel() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            PrefsPanel.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(PrefsPanel.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.container_id);
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "is_visible": {
                "enumerable": true, 
                "get": function is_visible() {
                    var self = this;
                    self.container.style.display === "block";
                }, 
                "set": function is_visible(val) {
                    var self = this;
                    self.container.style.display = (val) ? "block" : "none";
                }
            }, 
        });
        PrefsPanel.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var pp_counter, style, div;
            pp_counter += 1;
            self.container_id = "prefs-panel-" + pp_counter;
            style = "";
            div = E.div(E.style(style, _$rapyd$_desugar_kwargs({type: "text/css"})), _$rapyd$_desugar_kwargs({id: self.container_id, style: "display:none"}));
            book_list_container.appendChild(div);
            self.widgets = _$rapyd$_list_decorate([]);
        };
        PrefsPanel.prototype.init = function init(data) {
            var self = this;
            var c, div, val, cls, item;
            c = self.container;
            clear(c);
            self.widgets = _$rapyd$_list_decorate([]);
            function onfocus(name) {
                return function(ev) {
                    var c, div;
                    c = self.container;
                    div = c.querySelector(str.format("div[data-name=\"{}\"]", name));
                    div.lastChild.style.display = "block";
                };
            }
            var _$rapyd$_Iter2 = _$rapyd$_Iterable(data);
            for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                item = _$rapyd$_Iter2[_$rapyd$_Index2];
                div = E.div(E.div(), E.div(item.tooltip || "", _$rapyd$_desugar_kwargs({style: "font-size:0.8rem; font-style: italic; margin-top:1ex; display:none"})), _$rapyd$_desugar_kwargs({style: "margin-bottom:1ex; padding: 1ex 1em; border-bottom: solid 1px currentColor", title: item.tooltip, data_name: item.name}));
                c.appendChild(div);
                val = get_session_data().get(item.name);
                if (item.from_storage) {
                    val = item.from_storage(val);
                }
                if (item.choices) {
                    cls = Choices;
                } else if (val === true || val === false) {
                    cls = CheckBox;
                } else if (typeof val === "number") {
                    cls = SpinBox;
                } else {
                    cls = LineEdit;
                }
                self.widgets.append(new cls(item, div.firstChild, onfocus(item.name)).initialize());
            }
            if (self.widgets.length) {
                c.appendChild(E.div(create_button(_("Restore default settings"), "refresh", self.reset_to_defaults.bind(self)), _$rapyd$_desugar_kwargs({style: "margin:1ex 1em; padding: 1em; text-align:center"})));
            }
        };
        PrefsPanel.prototype.reset_to_defaults = function reset_to_defaults() {
            var self = this;
            var w;
            var _$rapyd$_Iter3 = _$rapyd$_Iterable(self.widgets);
            for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                w = _$rapyd$_Iter3[_$rapyd$_Index3];
                w.reset_to_default();
            }
        };
        PrefsPanel.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "PrefsPanel" + " #" + this._$rapyd$_object_id + ">";
        };
        PrefsPanel.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        
        
        

        _$rapyd$_modules["book_list.prefs"]["pp_counter"] = pp_counter;

        _$rapyd$_modules["book_list.prefs"]["widget_counter"] = widget_counter;

        _$rapyd$_modules["book_list.prefs"]["ConfigItem"] = ConfigItem;

        _$rapyd$_modules["book_list.prefs"]["Choices"] = Choices;

        _$rapyd$_modules["book_list.prefs"]["CheckBox"] = CheckBox;

        _$rapyd$_modules["book_list.prefs"]["SpinBox"] = SpinBox;

        _$rapyd$_modules["book_list.prefs"]["LineEdit"] = LineEdit;

        _$rapyd$_modules["book_list.prefs"]["PrefsPanel"] = PrefsPanel;
    })();

    (function(){
        var __name__ = "date";
        var UNDEFINED_DATE, lcdata, supports_locales, _fmt_date_pat, fd_function_index;
        UNDEFINED_DATE = new Date("0101-01-01T00:00:00+00:00");
        function is_date_undefined(date) {
            var _$rapyd$_unpack, dy, uy;
            _$rapyd$_unpack = [date.getUTCFullYear(), UNDEFINED_DATE.getUTCFullYear()];
            dy = _$rapyd$_unpack[0];
            uy = _$rapyd$_unpack[1];
            return dy < uy || dy === uy && date.getUTCMonth() === UNDEFINED_DATE.getUTCMonth() && date.getUTCDate() === UNDEFINED_DATE.getUTCDate();
        }
        lcdata = {
            "abday": _$rapyd$_list_decorate([ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ]),
            "abmon": _$rapyd$_list_decorate([ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ]),
            "day": _$rapyd$_list_decorate([ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ]),
            "mon": _$rapyd$_list_decorate([ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ])
        };
        supports_locales = false;
        try {
            new Date().toLocaleString("dfkjghdfkgj");
        } catch (_$rapyd$_Exception) {
            if (_$rapyd$_Exception instanceof RangeError) {
                supports_locales = true;
            } else {
            } 
        }
        _fmt_date_pat = null;
        function fmt_date_pat() {
            if (!_fmt_date_pat) {
                _fmt_date_pat = /(s{1,2})|(m{1,2})|(h{1,2})|(ap)|(AP)|(d{1,4}|M{1,4}|(?:yyyy|yy))/g;
            }
            return _fmt_date_pat;
        }
        function fd_format_hour(dt, ampm, hr, as_utc) {
            var h;
            h = (as_utc) ? dt.getUTCHours() : dt.getHours();
            if (ampm) {
                h = h % 12;
            }
            return (hr.length === 1) ? h.toString() : str.format("{:02d}", h);
        }
        function fd_format_minute(dt, ampm, min, as_utc) {
            var m;
            m = (as_utc) ? dt.getUTCMinutes() : dt.getMinutes();
            return (min.length === 1) ? m.toString() : str.format("{:02d}", m);
        }
        function fd_format_second(dt, ampm, min, as_utc) {
            var s;
            s = (as_utc) ? dt.getUTCSeconds() : dt.getSeconds();
            return (min.length === 1) ? s.toString() : str.format("{:02d}", s);
        }
        function fd_format_ampm(dt, ampm, ap, as_utc) {
            var h, ans;
            h = (as_utc) ? dt.getUTCHours() : dt.getHours();
            ans = (h < 12) ? "am" : "pm";
            return (ap === "ap") ? ans : ans.toUpperCase();
        }
        function fd_format_day(dt, ampm, dy, as_utc) {
            var d, options, w;
            d = (as_utc) ? dt.getUTCDate() : dt.getDate();
            if (dy.length === 1) {
                return d.toString();
            }
            if (dy.length === 2) {
                return str.format("{:02d}", d);
            }
            if (supports_locales) {
                options = {
                    "weekday": (dy.length === 3) ? "short" : "long"
                };
                if (as_utc) {
                    options["timeZone"] = "UTC";
                }
                return dt.toLocaleString(undefined, options);
            }
            w = (as_utc) ? dt.getUTCDay() : dt.getDay();
            return lcdata[(dy.length === 3) ? "abday" : "day"][(w + 1) % 7];
        }
        function fd_format_month(dt, ampm, mo, as_utc) {
            var m, options;
            m = (as_utc) ? dt.getUTCMonth() : dt.getMonth();
            if (mo.length === 1) {
                return (m + 1).toString();
            }
            if (mo.length === 2) {
                return str.format("{:02d}", m + 1);
            }
            if (supports_locales) {
                options = {
                    "month": {
                        1: "numeric",
                        2: "2-digit",
                        3: "short",
                        4: "long"
                    }[mo.length] || "long"
                };
                if (as_utc) {
                    options["timeZone"] = "UTC";
                }
                return dt.toLocaleString(undefined, options);
            }
            return lcdata[(mo.length === 3) ? "abmon" : "mon"][m];
        }
        function fd_format_year(dt, ampm, yr, as_utc) {
            var y;
            y = (as_utc) ? dt.getUTCFullYear() : dt.getFullYear();
            if (yr.length === 2) {
                return str.format("{:02d}", y % 100);
            }
            return str.format("{:04d}", y);
        }
        fd_function_index = {
            "d": fd_format_day,
            "M": fd_format_month,
            "y": fd_format_year,
            "h": fd_format_hour,
            "m": fd_format_minute,
            "s": fd_format_second,
            "a": fd_format_ampm,
            "A": fd_format_ampm
        };
        function test_fd(date, fmt, ans) {
            var q;
            q = format_date(date, fmt, _$rapyd$_desugar_kwargs({as_utc: true}));
            if (q !== ans) {
                throw new Exception(str.format("Failed to format {} with {}: {} != {}", date, fmt, q, ans));
            }
        }
        function format_date() {
            var date = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
            var fmt = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("dd MMM yyyy") : arguments[1];
            var as_utc = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "date")){
                date = _$rapyd$_kwargs_obj.date;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "fmt")){
                fmt = _$rapyd$_kwargs_obj.fmt;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "as_utc")){
                as_utc = _$rapyd$_kwargs_obj.as_utc;
            }
            var ampm;
            fmt = fmt || "dd MMM yyyy";
            ampm = _$rapyd$_in("ap", fmt.toLowerCase());
            if (typeof date === "string") {
                date = new Date(date);
            }
            date = date || new Date();
            if (is_date_undefined(date)) {
                return "";
            }
            return fmt.replace(fmt_date_pat(), function(match) {
                if (!match) {
                    return "";
                }
                try {
                    return fd_function_index[match[0]](date, ampm, match, as_utc);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        print(str.format("Failed to format date with format: {} and match: {}", fmt, match));
                        return "";
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
            });
        }
        if (__name__ === "__main__") {
            test_fd("1101-01-01T09:00:00+00:00", "hh h", "09 9");
            test_fd("1101-01-01T09:05:01+00:00", "hh h mm m ss s ap AP yy yyyy", "09 9 05 5 01 1 am AM 01 1101");
            test_fd("2001-01-02T09:00:00+00:00", "M MM MMM MMMM", "1 01 Jan January");
            test_fd("2001-01-01T12:00:00+00:00", "d dd ddd dddd", "1 01 Mon Monday");
        }
        _$rapyd$_modules["date"]["UNDEFINED_DATE"] = UNDEFINED_DATE;

        _$rapyd$_modules["date"]["lcdata"] = lcdata;

        _$rapyd$_modules["date"]["supports_locales"] = supports_locales;

        _$rapyd$_modules["date"]["_fmt_date_pat"] = _fmt_date_pat;

        _$rapyd$_modules["date"]["fd_function_index"] = fd_function_index;

        _$rapyd$_modules["date"]["is_date_undefined"] = is_date_undefined;

        _$rapyd$_modules["date"]["fmt_date_pat"] = fmt_date_pat;

        _$rapyd$_modules["date"]["fd_format_hour"] = fd_format_hour;

        _$rapyd$_modules["date"]["fd_format_minute"] = fd_format_minute;

        _$rapyd$_modules["date"]["fd_format_second"] = fd_format_second;

        _$rapyd$_modules["date"]["fd_format_ampm"] = fd_format_ampm;

        _$rapyd$_modules["date"]["fd_format_day"] = fd_format_day;

        _$rapyd$_modules["date"]["fd_format_month"] = fd_format_month;

        _$rapyd$_modules["date"]["fd_format_year"] = fd_format_year;

        _$rapyd$_modules["date"]["test_fd"] = test_fd;

        _$rapyd$_modules["date"]["format_date"] = format_date;
    })();

    (function(){
        var __name__ = "book_list.book_details";
        var bd_counter, FORMAT_PRIORITIES, IGNORED_FIELDS, default_sort, _$rapyd$_unpack, i, f;
        var ajax = _$rapyd$_modules["ajax"].ajax;
        
        var get_current_query = _$rapyd$_modules["book_list.globals"].get_current_query;
        
        var get_font_size = _$rapyd$_modules["book_list.theme"].get_font_size;
        
        var clear = _$rapyd$_modules["dom"].clear;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var get_boss = _$rapyd$_modules["book_list.globals"].get_boss;
        
        var error_dialog = _$rapyd$_modules["modals"].error_dialog;
        
        var create_spinner = _$rapyd$_modules["widgets"].create_spinner;
        var create_button = _$rapyd$_modules["widgets"].create_button;
        
        var format_date = _$rapyd$_modules["date"].format_date;
        
        var fmt_sidx = _$rapyd$_modules["utils"].fmt_sidx;
        
        bd_counter = 0;
        FORMAT_PRIORITIES = _$rapyd$_list_decorate([ "EPUB", "AZW3", "DOCX", "LIT", "MOBI", "ODT", "RTF", "MD", "MARKDOWN", "TXT", "PDF" ]);
        function sort_formats_key(fmt) {
            var ans;
            ans = FORMAT_PRIORITIES.indexOf(fmt);
            if (ans < 0) {
                ans = FORMAT_PRIORITIES.length;
            }
            return ans;
        }
        function get_preferred_format(metadata, output_format, input_formats) {
            var formats, f, fmt, q;
            formats = metadata && metadata.formats || [];
            formats = (function() {
                var _$rapyd$_Iter = _$rapyd$_Iterable(formats), _$rapyd$_Result = [], f;
                for (var _$rapyd$_Index = 0; _$rapyd$_Index < _$rapyd$_Iter.length; _$rapyd$_Index++) {
                    f = _$rapyd$_Iter[_$rapyd$_Index];
                    _$rapyd$_Result.push(f.toUpperCase());
                }
                _$rapyd$_Result = _$rapyd$_list_constructor(_$rapyd$_Result);
                return _$rapyd$_Result;
            })();
            fmt = (output_format === "PDF") ? "EPUB" : output_format;
            if (formats.length && formats.indexOf(fmt) === -1) {
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(sorted(formats, _$rapyd$_desugar_kwargs({key: sort_formats_key})));
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    q = _$rapyd$_Iter0[_$rapyd$_Index0];
                    if (input_formats[q]) {
                        fmt = q;
                        break;
                    }
                }
            }
            return fmt.toUpperCase();
        }
        IGNORED_FIELDS = (function(){
            var s = _$rapyd$_set();
            s.jsset.add("title");
            s.jsset.add("sort");
            s.jsset.add("uuid");
            s.jsset.add("id");
            s.jsset.add("urls_from_identifiers");
            s.jsset.add("lang_names");
            s.jsset.add("last_modified");
            return s;
        })();
        default_sort = (function() {
            var _$rapyd$_Iter = _$rapyd$_Iterable(enumerate(["title", "title_sort", "authors", 
            "author_sort", "series", "rating", "pubdate", "tags", "timestamp", "pubdate", "identifiers", 
            "languages", "publisher", "last_modified"])), _$rapyd$_Result = {}, i, f;
            for (var _$rapyd$_Index = 0; _$rapyd$_Index < _$rapyd$_Iter.length; _$rapyd$_Index++) {
                _$rapyd$_unpack = _$rapyd$_Iter[_$rapyd$_Index];
                i = _$rapyd$_unpack[0];
                f = _$rapyd$_unpack[1];
                _$rapyd$_Result[f] = (i + 1);
            }
            return _$rapyd$_Result;
        })();
        default_sort["formats"] = 999;
        function field_sorter(field_metadata) {
            return function(field) {
                var lvl, fm;
                lvl = str.format("{:03d}", default_sort[field] || 998);
                fm = (field_metadata[field] || {})[field] || {};
                return lvl + (fm.name || "zzzzz");
            };
        }
        function execute_search(ev) {
            var _$rapyd$_unpack, name, val, search;
            _$rapyd$_unpack = JSON.parse(ev.currentTarget.getAttribute("data-search"));
            name = _$rapyd$_unpack[0];
            val = _$rapyd$_unpack[1];
            search = str.format("{}:\"={}\"", name, str.replace(val, "\"", "\\\""));
            get_boss().ui.books_view.change_search(search);
        }
        function download_format(ev) {
            var fmt;
            fmt = ev.currentTarget.getAttribute("data-format");
            get_boss().ui.book_details_panel.download_format(fmt);
        }
        function read_format(ev) {
            var fmt;
            fmt = ev.currentTarget.getAttribute("data-format");
            get_boss().ui.book_details_panel.read_format(fmt);
        }
        function render_metadata() {
            var mi = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var interface_data = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var table = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[2];
            var field_list = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "field_list")){
                field_list = _$rapyd$_kwargs_obj.field_list;
            }
            var fields, comments, fm, field, comment, div, _$rapyd$_unpack, i;
            function allowed_fields(field) {
                var fm;
                if (str.endswith(field, "_index")) {
                    fm = interface_data.field_metadata[field.slice(0, -len("_index"))];
                    if (fm && fm.datatype === "series") {
                        return false;
                    }
                }
                if (str.startswith(field, "#")) {
                    return true;
                }
                if (_$rapyd$_in(field, IGNORED_FIELDS) || str.endswith(field, "_sort")) {
                    return false;
                }
                return true;
            }
            fields = field_list || sorted(filter(allowed_fields, mi), _$rapyd$_desugar_kwargs({key: field_sorter(interface_data.field_metadata)}));
            comments = {};
            function add_row() {
                var name = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
                var val = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
                var is_searchable = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[2];
                var is_html = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[3];
                var join = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[4];
                var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
                if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
                if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "is_searchable")){
                    is_searchable = _$rapyd$_kwargs_obj.is_searchable;
                }
                if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "is_html")){
                    is_html = _$rapyd$_kwargs_obj.is_html;
                }
                if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "join")){
                    join = _$rapyd$_kwargs_obj.join;
                }
                var v;
                function add_val(v) {
                    if (!v.appendChild) {
                        v += "";
                    }
                    if (is_searchable) {
                        table.lastChild.lastChild.appendChild(E.a(v, _$rapyd$_desugar_kwargs({data_search: JSON.stringify(_$rapyd$_list_decorate([ is_searchable, v ])), onclick: execute_search, title: str.format(_("Click to see books with {0}: {1}"), name, v), href: "javascript: void(0)"})));
                    } else {
                        if (v.appendChild) {
                            table.lastChild.lastChild.appendChild(v);
                        } else {
                            table.lastChild.lastChild.appendChild(document.createTextNode(v));
                        }
                    }
                }
                table.appendChild(E.tr(E.td(name + ":"), E.td()));
                if (is_html) {
                    table.lastChild.lastChild.innerHTML = val + "";
                } else {
                    if (!join) {
                        add_val(val);
                    } else {
                        var _$rapyd$_Iter1 = _$rapyd$_Iterable(val);
                        for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                            v = _$rapyd$_Iter1[_$rapyd$_Index1];
                            add_val(v);
                            if (v !== val[val.length-1]) {
                                table.lastChild.lastChild.appendChild(document.createTextNode(join));
                            }
                        }
                    }
                }
            }
            function process_composite(field, fm, name, val) {
                var all_vals;
                if (fm.display && fm.display.contains_html) {
                    add_row(name, val, _$rapyd$_desugar_kwargs({is_html: true}));
                    return;
                }
                if (fm.is_multiple && fm.is_multiple.list_to_ui) {
                    all_vals = filter(null, map(str.strip, str.split(val, fm.is_multiple.list_to_ui)));
                    add_row(name, all_vals, _$rapyd$_desugar_kwargs({is_searchable: field, join: fm.is_multiple.list_to_ui}));
                } else {
                    add_row(name, val, _$rapyd$_desugar_kwargs({is_searchable: field}));
                }
            }
            function process_authors(field, fm, name, val) {
                add_row(name, val, _$rapyd$_desugar_kwargs({is_searchable: field, join: " & "}));
            }
            function process_publisher(field, fm, name, val) {
                add_row(name, val, _$rapyd$_desugar_kwargs({is_searchable: field}));
            }
            function process_formats(field, fm, name, val) {
                var td, fmt;
                table.appendChild(E.tr(E.td(name + ":"), E.td()));
                var _$rapyd$_Iter2 = _$rapyd$_Iterable(val);
                for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                    fmt = _$rapyd$_Iter2[_$rapyd$_Index2];
                    td = table.lastChild.lastChild;
                    td.appendChild(E.span(fmt, _$rapyd$_desugar_kwargs({style: "white-space: nowrap"})));
                    if (interface_data.input_formats[fmt] || interface_data.input_formats[fmt.replace("ORIGINAL_", "")]) {
                        td.lastChild.appendChild(E.a(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-book"})), _$rapyd$_desugar_kwargs({title: str.format(_("Read this book in the {} format"), fmt), href: "javascript:void(0)", style: "padding-left: 1em", onclick: read_format, data_format: fmt})));
                    }
                    td.lastChild.appendChild(E.a(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-cloud-download"})), _$rapyd$_desugar_kwargs({title: str.format(_("Download the {} format of this book"), fmt), href: "javascript:void(0)", style: "padding-left: 1em", onclick: download_format, data_format: fmt})));
                    if (fmt !== val[val.length-1]) {
                        td.lastChild.appendChild(document.createTextNode(","));
                        td.appendChild(document.createTextNode(" "));
                    }
                }
            }
            function process_rating(field, fm, name, val) {
                var stars, i;
                stars = E.span();
                for (i = 0; i < Math.floor(int(val) / 2); i++) {
                    stars.appendChild(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-star"})));
                }
                add_row(name, stars);
            }
            function process_identifiers(field, fm, name, val) {
                var keys, url_map, _$rapyd$_unpack, text, k, url, td, idval, x;
                if (val) {
                    keys = Object.keys(val);
                    if (keys.length) {
                        table.appendChild(E.tr(E.td(name + ":"), E.td()));
                        url_map = (function() {
                            var _$rapyd$_Iter = _$rapyd$_Iterable(mi.urls_from_identifiers || []), _$rapyd$_Result = {}, text, 
                            k, val, url;
                            for (var _$rapyd$_Index = 0; _$rapyd$_Index < _$rapyd$_Iter.length; _$rapyd$_Index++) {
                                _$rapyd$_unpack = _$rapyd$_flatten(_$rapyd$_Iter[_$rapyd$_Index]);
                                text = _$rapyd$_unpack[0];
                                k = _$rapyd$_unpack[1];
                                val = _$rapyd$_unpack[2];
                                url = _$rapyd$_unpack[3];
                                _$rapyd$_Result[k] = ([text, url]);
                            }
                            return _$rapyd$_Result;
                        })();
                        td = table.lastChild.lastChild;
                        var _$rapyd$_Iter3 = _$rapyd$_Iterable(keys);
                        for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                            k = _$rapyd$_Iter3[_$rapyd$_Index3];
                            idval = val[k];
                            x = url_map[k];
                            if (Array.isArray(x) && x.length === 2) {
                                td.appendChild(E.a(x[0], _$rapyd$_desugar_kwargs({title: str.format("{}:{}", k, idval), target: "_new", href: x[1]})));
                            } else {
                                td.appendChild(E.span(k, ":", idval));
                            }
                            if (k !== keys[keys.length-1]) {
                                td.appendChild(document.createTextNode(", "));
                            }
                        }
                    }
                }
            }
            function process_languages(field, fm, name, val) {
                var td, lang, k;
                if (val && val.length) {
                    table.appendChild(E.tr(E.td(name + ":"), E.td()));
                    td = table.lastChild.lastChild;
                    var _$rapyd$_Iter4 = _$rapyd$_Iterable(val);
                    for (var _$rapyd$_Index4 = 0; _$rapyd$_Index4 < _$rapyd$_Iter4.length; _$rapyd$_Index4++) {
                        k = _$rapyd$_Iter4[_$rapyd$_Index4];
                        lang = mi.lang_names[k] || k;
                        td.appendChild(E.a(lang, _$rapyd$_desugar_kwargs({title: str.format(_("Click to see books with language: {}"), lang), href: "javascript: void(0)", data_search: JSON.stringify(_$rapyd$_list_decorate([ field, k ])), onclick: execute_search})));
                        if (k !== val[val.length-1]) {
                            td.appendChild(document.createTextNode(", "));
                        }
                    }
                }
            }
            function process_datetime(field, fm, name, val) {
                var fmt;
                if (val) {
                    fmt = interface_data["gui_" + field + "_display_format"] || (fm["display"] || {}).date_format;
                    add_row(name, format_date(val, fmt));
                }
            }
            function process_series(field, fm, name, val) {
                var ifield, ival;
                if (val) {
                    ifield = field + "_index";
                    try {
                        ival = float(mi[ifield]);
                    } catch (_$rapyd$_Exception) {
                        if (_$rapyd$_Exception instanceof Exception) {
                            ival = 1;
                        } else {
                            throw _$rapyd$_Exception;
                        }
                    }
                    ival = fmt_sidx(ival, _$rapyd$_desugar_kwargs({use_roman: interface_data.use_roman_numerals_for_series_number}));
                    table.appendChild(E.tr(E.td(name + ":"), E.td()));
                    table.lastChild.lastChild.appendChild(E.span(ival, _(" of "), E.a(val, _$rapyd$_desugar_kwargs({data_search: JSON.stringify(_$rapyd$_list_decorate([ field, val ])), onclick: execute_search, title: str.format(_("Click to see books with {0}: {1}"), name, val), href: "javascript: void(0)"}))));
                }
            }
            function process_field(field, fm) {
                var name, datatype, val, func, join, fmt;
                name = fm.name || field;
                datatype = fm.datatype;
                val = mi[field];
                if (field === "comments" || datatype === "comments") {
                    comments[field] = val;
                    return;
                }
                func = null;
                if (datatype === "composite") {
                    func = process_composite;
                } else if (field === "formats") {
                    func = process_formats;
                } else if (datatype === "rating") {
                    func = process_rating;
                } else if (field === "identifiers") {
                    func = process_identifiers;
                } else if (field === "authors") {
                    func = process_authors;
                } else if (field === "publisher") {
                    func = process_publisher;
                } else if (field === "languages") {
                    func = process_languages;
                } else if (datatype === "datetime") {
                    func = process_datetime;
                } else if (datatype === "series") {
                    func = process_series;
                }
                if (func) {
                    func(field, fm, name, val);
                } else {
                    if (datatype === "text" || datatype === "enumeration") {
                        join = (fm.is_multiple) ? fm.is_multiple.list_to_ui : null;
                        add_row(name, val, _$rapyd$_desugar_kwargs({join: join, is_searchable: field}));
                    } else if (datatype === "bool") {
                        add_row(name, (val) ? _("Yes") : _("No"));
                    } else if (datatype === "int" || datatype === "float") {
                        fmt = (fm.display || {}).number_format;
                        if (fmt) {
                            val = str.format(fmt, val);
                        } else {
                            val += "";
                        }
                        add_row(name, val);
                    }
                }
            }
            var _$rapyd$_Iter5 = _$rapyd$_Iterable(fields);
            for (var _$rapyd$_Index5 = 0; _$rapyd$_Index5 < _$rapyd$_Iter5.length; _$rapyd$_Index5++) {
                field = _$rapyd$_Iter5[_$rapyd$_Index5];
                fm = interface_data.field_metadata[field];
                if (!fm) {
                    continue;
                }
                try {
                    process_field(field, fm);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        print("Failed to render metadata field: " + field);
                        print(err.toString());
                        print(err.stack);
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
            }
            var _$rapyd$_Iter6 = _$rapyd$_Iterable(enumerate(sorted(comments)));
            for (var _$rapyd$_Index6 = 0; _$rapyd$_Index6 < _$rapyd$_Iter6.length; _$rapyd$_Index6++) {
                _$rapyd$_unpack = _$rapyd$_Iter6[_$rapyd$_Index6];
                i = _$rapyd$_unpack[0];
                field = _$rapyd$_unpack[1];
                comment = comments[field];
                div = E.div();
                div.innerHTML = comment;
                table.parentNode.appendChild(div);
                if (i === 0) {
                    div.style.marginTop = "2ex";
                }
            }
        }
        function BookDetailsPanel() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            BookDetailsPanel.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(BookDetailsPanel.prototype,  {
            "container": {
                "enumerable": true, 
                "get": function container() {
                    var self = this;
                    return document.getElementById(self.container_id).lastChild;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
            "is_visible": {
                "enumerable": true, 
                "get": function is_visible() {
                    var self = this;
                    self.container.parentNode.style.display === "block";
                }, 
                "set": function is_visible(val) {
                    var self = this;
                    self.container.parentNode.style.display = (val) ? "block" : "none";
                }
            }, 
        });
        BookDetailsPanel.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var style, div;
            bd_counter += 1;
            self.container_id = "book-details-panel-" + bd_counter;
            style = build_rule("#" + self.container_id + " table.metadata td:first-of-type", _$rapyd$_desugar_kwargs({font_weight: "bold", padding_right: "1em", white_space: "nowrap"}));
            style += build_rule("#" + self.container_id + " table.metadata a[href]", _$rapyd$_desugar_kwargs({color: "blue"}));
            style += build_rule("#" + self.container_id + " table.metadata a[href]:hover", _$rapyd$_desugar_kwargs({color: "red"}));
            style += build_rule("#" + self.container_id + " table.metadata a[href]:active", _$rapyd$_desugar_kwargs({color: "red", transform: "scale(1.5)"}));
            div = E.div(E.style(style, _$rapyd$_desugar_kwargs({type: "text/css"})), E.div(), _$rapyd$_desugar_kwargs({id: self.container_id, style: "display:none"}));
            book_list_container.appendChild(div);
            self.interface_data = interface_data;
            self.current_book_id = null;
        };
        BookDetailsPanel.prototype.init = function init(data) {
            var self = this;
            var c, book_id;
            self.current_book_id = null;
            c = self.container;
            clear(c);
            book_id = get_current_query()["book-id"];
            if (book_id === undefined || book_id === null) {
                self.no_book();
            } else if (_$rapyd$_in(book_id, self.interface_data.metadata)) {
                self.render_book(book_id);
            } else {
                self.fetch_metadata(book_id);
            }
            get_boss().ui.set_button_visibility("random", !book_id || book_id === "0");
        };
        BookDetailsPanel.prototype.show_random = function show_random() {
            var self = this;
            self.fetch_metadata("0");
        };
        BookDetailsPanel.prototype.no_book = function no_book(book_id) {
            var self = this;
            self.container.appendChild(E.div(_("No book found"), _$rapyd$_desugar_kwargs({style: "margin: 1ex 1em"})));
        };
        BookDetailsPanel.prototype.fetch_metadata = function fetch_metadata(book_id) {
            var self = this;
            if (self.is_fetching) {
                self.is_fetching.abort();
            }
            self.is_fetching = ajax("interface-data/book-metadata/" + book_id, self.metadata_fetched.bind(self), _$rapyd$_desugar_kwargs({query: {
                "library_id": self.interface_data.library_id
            }}));
            self.is_fetching.send();
            self.container.appendChild(E.div(create_spinner(), " " + _("Fetching metadata for the book, please wait") + "…", _$rapyd$_desugar_kwargs({style: "margin: 1ex 1em"})));
        };
        BookDetailsPanel.prototype.metadata_fetched = function metadata_fetched(end_type, xhr, event) {
            var self = this;
            var c, data, book_id;
            if (self.is_fetching === null || self.is_fetching !== xhr) {
                return;
            }
            self.is_fetching = null;
            c = self.container;
            if (end_type === "load") {
                try {
                    data = JSON.parse(xhr.responseText);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        error_dialog(_("Could not fetch metadata for book"), _("Server returned an invalid response"), err.toString());
                        return;
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
                clear(c);
                book_id = data["id"];
                self.interface_data.metadata[book_id] = data;
                self.render_book(book_id);
            } else if (end_type !== "abort") {
                clear(c);
                c.appendChild(E.div(_("Could not fetch metadata for book"), E.div(_$rapyd$_desugar_kwargs({style: "margin: 1ex 1em"})), _$rapyd$_desugar_kwargs({style: "margin: 1ex 1em"})));
                c.lastChild.lastChild.innerHTML = xhr.error_html;
            }
        };
        BookDetailsPanel.prototype.render_book = function render_book(book_id) {
            var self = this;
            var metadata, cover_url, alt, imgdiv, c, container, read_button, download_button, row, md, table;
            self.current_book_id = int(book_id);
            metadata = self.interface_data.metadata[book_id];
            get_boss().ui.set_title(metadata.title);
            cover_url = str.format("get/cover/{}/{}", book_id, self.interface_data["library_id"]);
            alt = str.format(_("{} by {}"), metadata["title"], metadata["authors"].join(" & "));
            imgdiv = E.div(E.img(_$rapyd$_desugar_kwargs({src: cover_url, alt: alt, title: alt, data_title: metadata["title"], data_authors: metadata["authors"].join(" & "), style: str.format("border-radius: 20px; max-width: calc(100vw - 2em); max-height: calc(100vh - 4ex - {}); display: block; width:auto; height:auto; border-radius: 20px", get_font_size("title"))})));
            imgdiv.firstChild.onerror = self.on_img_err.bind(self);
            c = self.container;
            c.appendChild(E.div(E.div(_$rapyd$_desugar_kwargs({style: "margin-right: 1em; flex-grow: 3; max-width: 500px", data_book_id: "" + book_id})), imgdiv, _$rapyd$_desugar_kwargs({style: "display:flex; padding: 1ex 1em; align-items: flex-start; justify-content: flex-start; flex-wrap: wrap"})));
            container = c.lastChild.firstChild;
            read_button = create_button(_("Read"), "book", self.read_book.bind(self), _("Read this book"));
            download_button = create_button(_("Download"), "cloud-download", self.download_book.bind(self), str.format(_("Download this book in the {} format"), self.preferred_format(book_id)));
            row = E.div(read_button, "   ", download_button, _$rapyd$_desugar_kwargs({style: "margin-bottom: 1ex"}));
            if (!metadata.formats || !metadata.formats.length) {
                row.style.display = "none";
            }
            container.appendChild(row);
            md = E.div(_$rapyd$_desugar_kwargs({style: "margin-bottom: 2ex"}));
            table = E.table(_$rapyd$_desugar_kwargs({class_: "metadata"}));
            container.appendChild(md);
            md.appendChild(table);
            render_metadata(metadata, self.interface_data, table);
        };
        BookDetailsPanel.prototype.on_img_err = function on_img_err(err) {
            var self = this;
            var img;
            img = err.target;
            img.parentNode.style.display = "none";
        };
        BookDetailsPanel.prototype.preferred_format = function preferred_format(book_id) {
            var self = this;
            return get_preferred_format(self.interface_data.metadata[book_id], self.interface_data.output_format, self.interface_data.input_formats);
        };
        BookDetailsPanel.prototype.download_format = function download_format(fmt) {
            var self = this;
            window.location = str.format("get/{}/{}/{}", fmt, self.current_book_id, self.interface_data.library_id);
        };
        BookDetailsPanel.prototype.download_book = function download_book() {
            var self = this;
            var book_id, fmt;
            book_id = self.current_book_id;
            fmt = self.preferred_format(book_id);
            self.download_format(fmt);
        };
        BookDetailsPanel.prototype.read_format = function read_format(fmt) {
            var self = this;
        };
        BookDetailsPanel.prototype.read_book = function read_book() {
            var self = this;
            var book_id, fmt;
            book_id = self.current_book_id;
            fmt = self.preferred_format(book_id);
            self.read_format(fmt);
        };
        BookDetailsPanel.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "BookDetailsPanel" + " #" + this._$rapyd$_object_id + ">";
        };
        BookDetailsPanel.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        
        
        

        _$rapyd$_modules["book_list.book_details"]["bd_counter"] = bd_counter;

        _$rapyd$_modules["book_list.book_details"]["FORMAT_PRIORITIES"] = FORMAT_PRIORITIES;

        _$rapyd$_modules["book_list.book_details"]["IGNORED_FIELDS"] = IGNORED_FIELDS;

        _$rapyd$_modules["book_list.book_details"]["default_sort"] = default_sort;

        _$rapyd$_modules["book_list.book_details"]["_$rapyd$_unpack"] = _$rapyd$_unpack;

        _$rapyd$_modules["book_list.book_details"]["i"] = i;

        _$rapyd$_modules["book_list.book_details"]["f"] = f;

        _$rapyd$_modules["book_list.book_details"]["sort_formats_key"] = sort_formats_key;

        _$rapyd$_modules["book_list.book_details"]["get_preferred_format"] = get_preferred_format;

        _$rapyd$_modules["book_list.book_details"]["field_sorter"] = field_sorter;

        _$rapyd$_modules["book_list.book_details"]["execute_search"] = execute_search;

        _$rapyd$_modules["book_list.book_details"]["download_format"] = download_format;

        _$rapyd$_modules["book_list.book_details"]["read_format"] = read_format;

        _$rapyd$_modules["book_list.book_details"]["render_metadata"] = render_metadata;

        _$rapyd$_modules["book_list.book_details"]["BookDetailsPanel"] = BookDetailsPanel;
    })();

    (function(){
        var __name__ = "book_list.ui";
        var get_boss = _$rapyd$_modules["book_list.globals"].get_boss;
        var get_session_data = _$rapyd$_modules["book_list.globals"].get_session_data;
        
        var SearchPanel = _$rapyd$_modules["book_list.search"].SearchPanel;
        
        var TopBar = _$rapyd$_modules["book_list.top_bar"].TopBar;
        
        var BooksView = _$rapyd$_modules["book_list.views"].BooksView;
        
        var ItemsView = _$rapyd$_modules["book_list.item_list"].ItemsView;
        var create_item = _$rapyd$_modules["book_list.item_list"].create_item;
        
        var PrefsPanel = _$rapyd$_modules["book_list.prefs"].PrefsPanel;
        
        var BookDetailsPanel = _$rapyd$_modules["book_list.book_details"].BookDetailsPanel;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var debounce = _$rapyd$_modules["utils"].debounce;
        
        var error_dialog = _$rapyd$_modules["modals"].error_dialog;
        var ajax_progress_dialog = _$rapyd$_modules["modals"].ajax_progress_dialog;
        
        function BarState() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            BarState.prototype.__init__.apply(this, arguments);
        }
        BarState.prototype.__init__ = function __init__() {
            var self = this;
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            self.left_state = kw;
            self.buttons = [];
        };
        BarState.prototype.add_button = function add_button() {
            var self = this;
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            self.buttons.push(kw);
        };
        BarState.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "BarState" + " #" + this._$rapyd$_object_id + ">";
        };
        BarState.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        function ClosePanelBar() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            ClosePanelBar.prototype.__init__.apply(this, arguments);
        }
        _$rapyd$_extends(ClosePanelBar, BarState);
        ClosePanelBar.prototype.__init__ = function __init__() {
            var self = this;
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var tooltip = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("") : arguments[1];
            var close_callback = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "tooltip")){
                tooltip = _$rapyd$_kwargs_obj.tooltip;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "close_callback")){
                close_callback = _$rapyd$_kwargs_obj.close_callback;
            }
            tooltip = tooltip || _("Close this panel");
            function action() {
                close_panel();
                if (close_callback !== null) {
                    close_callback();
                }
            }
            BarState.prototype.constructor.call(self, _$rapyd$_desugar_kwargs({title: title, tooltip: tooltip, action: action, icon_name: "times"}));
        };
        ClosePanelBar.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "ClosePanelBar" + " #" + this._$rapyd$_object_id + ">";
        };
        ClosePanelBar.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        function UIState() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            UIState.prototype.__init__.apply(this, arguments);
        }
        UIState.prototype.__init__ = function __init__() {
            var self = this;
            var top_bar_state = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
            var main_panel = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var panel_data = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "top_bar_state")){
                top_bar_state = _$rapyd$_kwargs_obj.top_bar_state;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "main_panel")){
                main_panel = _$rapyd$_kwargs_obj.main_panel;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "panel_data")){
                panel_data = _$rapyd$_kwargs_obj.panel_data;
            }
            self.top_bar_state = top_bar_state;
            self.main_panel = main_panel;
            self.panel_data = panel_data;
        };
        UIState.prototype.add_button = function add_button() {
            var self = this;
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            self.top_bar_state.add_button.apply(self.top_bar_state, [_$rapyd$_desugar_kwargs(kw)]);
        };
        UIState.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "UIState" + " #" + this._$rapyd$_object_id + ">";
        };
        UIState.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };

        function close_panel() {
            get_boss().ui.close_panel();
        }
        function replace_panel_action(replacement) {
            return function() {
                get_boss().ui.replace_panel(replacement);
            };
        }
        function show_panel_action(key) {
            return function() {
                get_boss().ui.show_panel(key);
            };
        }
        function create_book_view_top_bar_state(books_view) {
            var ibs;
            ibs = new BarState(_$rapyd$_desugar_kwargs({run_animation: true, title: function() {
                var q;
                q = books_view.interface_data["search_result"]["query"];
                if (q) {
                    return {
                        "title": _("Books matching") + "::  " + q,
                        "title_tooltip": _("Click to clear this search"),
                        "title_action": function() {
                            books_view.change_search("");
                        }
                    };
                }
                return {
                    "title": "calibre"
                };
            }}));
            ibs.add_button(_$rapyd$_desugar_kwargs({icon_name: "sort-amount-desc", tooltip: _("Sort books"), action: show_panel_action("booklist-sort-menu")}));
            ibs.add_button(_$rapyd$_desugar_kwargs({icon_name: "search", tooltip: _("Search for books"), action: show_panel_action("booklist-search")}));
            ibs.add_button(_$rapyd$_desugar_kwargs({icon_name: "ellipsis-v", tooltip: _("More actions"), action: show_panel_action("more-actions-menu")}));
            return ibs;
        }
        function random_book() {
            get_boss().ui.replace_panel("book-details", _$rapyd$_desugar_kwargs({extra_query_data: {
                "book-id": "0"
            }}));
        }
        function change_library_actions() {
            var boss, interface_data, ans, library_name, lid;
            boss = get_boss();
            interface_data = boss.interface_data;
            ans = _$rapyd$_list_decorate([]);
            ans.subtitle = _("Currently showing the library: ") + interface_data.library_map[interface_data.library_id];
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(sorted(interface_data.library_map));
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                lid = _$rapyd$_Iter0[_$rapyd$_Index0];
                if (lid !== interface_data.library_id) {
                    library_name = interface_data.library_map[lid];
                    ans.append({
                        "title": library_name,
                        "action": boss.ui.change_library.bind(boss.ui, lid)
                    });
                }
            }
            return ans;
        }
        function UI() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            UI.prototype.__init__.apply(this, arguments);
        }
        UI.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var num_of_libraries, actions, bss, bd, _$rapyd$_chain_assign_temp;
            self.top_bar = new TopBar(book_list_container);
            self.books_view = new BooksView(interface_data, book_list_container);
            self.items_view = new ItemsView(interface_data, book_list_container);
            self.prefs_panel = new PrefsPanel(interface_data, book_list_container);
            self.search_panel = new SearchPanel(interface_data, book_list_container);
            self.book_details_panel = new BookDetailsPanel(interface_data, book_list_container);
            self.panels = _$rapyd$_list_decorate([ self.books_view, self.items_view, self.search_panel, self.prefs_panel, self.book_details_panel ]);
            self.panel_map = (function(){
                var _$rapyd$_d = {};
                _$rapyd$_d[self.ROOT_PANEL] = new UIState(create_book_view_top_bar_state(self.books_view), _$rapyd$_desugar_kwargs({main_panel: self.books_view}));
                return _$rapyd$_d;
            })();
            self.current_panel = self.ROOT_PANEL;
            window.addEventListener("resize", debounce(self.on_resize.bind(self), 250));
            num_of_libraries = len(interface_data.library_map);
            actions = _$rapyd$_list_decorate([ create_item(_("Book List Mode"), replace_panel_action("booklist-mode-menu"), _("Change how the list of books is displayed")), create_item(_("A Random Book"), random_book, _("Choose a random book from your library")) ]);
            if (num_of_libraries > 1) {
                actions.push(create_item(_("Change Library"), replace_panel_action("booklist-change-library"), _("Choose a different library to display")));
                self.panel_map["booklist-change-library"] = new UIState(new ClosePanelBar(_("Change Library")), _$rapyd$_desugar_kwargs({panel_data: change_library_actions}));
            }
            self.panel_map["more-actions-menu"] = new UIState(new ClosePanelBar(_("More actions")), _$rapyd$_desugar_kwargs({panel_data: actions}));
            self.panel_map["booklist-mode-menu"] = new UIState(new ClosePanelBar(_("Book List Mode")), _$rapyd$_desugar_kwargs({panel_data: _$rapyd$_list_decorate([])}));
            self.panel_map["booklist-sort-menu"] = new UIState(new ClosePanelBar(_("Sort books")), _$rapyd$_desugar_kwargs({panel_data: function() {
                return self.books_view.sort_panel_data(create_item);
            }}));
            self.panel_map["booklist-config-tb"] = self.create_prefences_panel(_("Configure Tag Browser"), _$rapyd$_desugar_kwargs({close_callback: self.search_panel.apply_prefs.bind(self.search_panel), panel_data: self.search_panel.get_prefs.bind(self.search_panel)}));
            bss = new ClosePanelBar(_("Search for books"));
            bss.add_button(_$rapyd$_desugar_kwargs({icon_name: "cogs", tooltip: _("Configure Tag Browser"), action: show_panel_action("booklist-config-tb")}));
            self.panel_map["booklist-search"] = new UIState(bss, _$rapyd$_desugar_kwargs({main_panel: self.search_panel}));
            _$rapyd$_chain_assign_temp = new UIState(new ClosePanelBar(_("Book Details")), _$rapyd$_desugar_kwargs({main_panel: self.book_details_panel}));
            self.panel_map["book-details"] = _$rapyd$_chain_assign_temp;
            bd = _$rapyd$_chain_assign_temp;
;
            bd.add_button(_$rapyd$_desugar_kwargs({icon_name: "random", tooltip: _("Pick another random book"), action: self.book_details_panel.show_random.bind(self.book_details_panel)}));
        };
        UI.prototype.create_prefences_panel = function create_prefences_panel() {
            var self = this;
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var close_callback = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var panel_data = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "close_callback")){
                close_callback = _$rapyd$_kwargs_obj.close_callback;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "panel_data")){
                panel_data = _$rapyd$_kwargs_obj.panel_data;
            }
            var ans;
            ans = new UIState(new ClosePanelBar(title), _$rapyd$_desugar_kwargs({close_callback: close_callback, main_panel: self.prefs_panel, panel_data: panel_data}));
            ans.add_button(_$rapyd$_desugar_kwargs({icon_name: "refresh", tooltip: _("Restore default settings"), action: self.prefs_panel.reset_to_defaults.bind(self.prefs_panel)}));
            return ans;
        };
        UI.prototype.set_title = function set_title(text) {
            var self = this;
            self.top_bar.set_title(text);
        };
        UI.prototype.set_button_visibility = function set_button_visibility(icon_name, visible) {
            var self = this;
            self.top_bar.set_button_visibility(icon_name, visible);
        };
        UI.prototype.on_resize = function on_resize() {
            var self = this;
        };
        UI.prototype.apply_state = function apply_state() {
            var self = this;
            var state, main_panel, panel, panel_data;
            window.scrollTo(0, 0);
            state = self.panel_map[self.current_panel];
            self.top_bar.apply_state(state.top_bar_state.left_state, state.top_bar_state.buttons);
            main_panel = state.main_panel || self.items_view;
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(self.panels);
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                panel = _$rapyd$_Iter1[_$rapyd$_Index1];
                panel.is_visible = panel === main_panel;
            }
            if (callable(main_panel.init)) {
                panel_data = (callable(state.panel_data)) ? state.panel_data() : state.panel_data;
                main_panel.init(panel_data);
            }
            if (self.current_panel === self.ROOT_PANEL) {
                window.setTimeout(function() {
                    state.top_bar_state.left_state.run_animation = false;
                }, 10);
            }
        };
        UI.prototype.close_panel = function close_panel() {
            var self = this;
            if (get_boss().has_history) {
                window.history.back();
            } else {
                self.show_panel(self.ROOT_PANEL);
            }
        };
        UI.prototype.replace_panel = function replace_panel() {
            var self = this;
            var panel_name = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var force = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[1];
            var extra_query_data = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "force")){
                force = _$rapyd$_kwargs_obj.force;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "extra_query_data")){
                extra_query_data = _$rapyd$_kwargs_obj.extra_query_data;
            }
            var action_needed;
            action_needed = force || panel_name !== self.current_panel;
            if (action_needed) {
                self.current_panel = panel_name || self.ROOT_PANEL;
            }
            get_boss().push_state(_$rapyd$_desugar_kwargs({replace: true, extra_query_data: extra_query_data}));
            if (action_needed) {
                self.apply_state();
            }
        };
        UI.prototype.show_panel = function show_panel() {
            var self = this;
            var panel_name = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var push_state = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[1];
            var force = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[2];
            var extra_query_data = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "push_state")){
                push_state = _$rapyd$_kwargs_obj.push_state;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "force")){
                force = _$rapyd$_kwargs_obj.force;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "extra_query_data")){
                extra_query_data = _$rapyd$_kwargs_obj.extra_query_data;
            }
            var action_needed;
            action_needed = force || panel_name !== self.current_panel;
            if (action_needed) {
                self.current_panel = panel_name || self.ROOT_PANEL;
            }
            if (push_state) {
                get_boss().push_state(_$rapyd$_desugar_kwargs({extra_query_data: extra_query_data}));
            }
            if (action_needed) {
                self.apply_state();
            }
        };
        UI.prototype.refresh_books_view = function refresh_books_view() {
            var self = this;
            self.books_view.refresh();
            if (self.current_panel === self.ROOT_PANEL) {
                self.top_bar.refresh_left();
            }
        };
        UI.prototype.change_library = function change_library(library_id) {
            var self = this;
            var data;
            data = {
                "search": "",
                "sort": get_session_data().get_library_option(library_id, "sort"),
                "library_id": library_id
            };
            ajax_progress_dialog("interface-data/get-books", self.library_changed.bind(self), _("Fetching data from server, please wait") + "…", _$rapyd$_desugar_kwargs({query: data, extra_data_for_callback: {
                "library_id": library_id
            }}));
        };
        UI.prototype.library_changed = function library_changed(end_type, xhr, ev) {
            var self = this;
            var boss, data, msg;
            if (end_type === "load") {
                boss = get_boss();
                boss.interface_data.library_id = xhr.extra_data_for_callback.library_id;
                try {
                    data = JSON.parse(xhr.responseText);
                    boss.change_books(data);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        return error_dialog(_("Could not change library"), err + "", _$rapyd$_desugar_kwargs({details: err.stack}));
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
                self.show_panel(self.ROOT_PANEL);
                window.scrollTo(0, 0);
            } else if (end_type !== "abort") {
                msg = xhr.error_html;
                error_dialog(_("Could not change library"), msg);
            }
        };
        UI.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "UI" + " #" + this._$rapyd$_object_id + ">";
        };
        UI.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        UI.prototype.ROOT_PANEL = "books";

        _$rapyd$_modules["book_list.ui"]["BarState"] = BarState;

        _$rapyd$_modules["book_list.ui"]["ClosePanelBar"] = ClosePanelBar;

        _$rapyd$_modules["book_list.ui"]["UIState"] = UIState;

        _$rapyd$_modules["book_list.ui"]["close_panel"] = close_panel;

        _$rapyd$_modules["book_list.ui"]["replace_panel_action"] = replace_panel_action;

        _$rapyd$_modules["book_list.ui"]["show_panel_action"] = show_panel_action;

        _$rapyd$_modules["book_list.ui"]["create_book_view_top_bar_state"] = create_book_view_top_bar_state;

        _$rapyd$_modules["book_list.ui"]["random_book"] = random_book;

        _$rapyd$_modules["book_list.ui"]["change_library_actions"] = change_library_actions;

        _$rapyd$_modules["book_list.ui"]["UI"] = UI;
    })();

    (function(){
        var __name__ = "book_list.boss";
        var encode_query = _$rapyd$_modules["ajax"].encode_query;
        
        var set_css = _$rapyd$_modules["dom"].set_css;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var error_dialog = _$rapyd$_modules["modals"].error_dialog;
        var create_modal_container = _$rapyd$_modules["modals"].create_modal_container;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var get_widget_css = _$rapyd$_modules["widgets"].get_widget_css;
        
        var parse_url_params = _$rapyd$_modules["utils"].parse_url_params;
        
        var get_session_data = _$rapyd$_modules["book_list.globals"].get_session_data;
        var set_boss = _$rapyd$_modules["book_list.globals"].set_boss;
        var set_current_query = _$rapyd$_modules["book_list.globals"].set_current_query;
        
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        
        var UI = _$rapyd$_modules["book_list.ui"].UI;
        
        function Boss() {
            if (this._$rapyd$_object_id === undefined) Object.defineProperty(this, "_$rapyd$_object_id", {"value":++_$rapyd$_object_counter});
            Boss.prototype.__init__.apply(this, arguments);
        }
        Object.defineProperties(Boss.prototype,  {
            "has_history": {
                "enumerable": true, 
                "get": function has_history() {
                    var self = this;
                    return self.history_count > 0;
                }, 
                "set": function () { throw new AttributeError("can't set attribute") }
            }, 
        });
        Boss.prototype.__init__ = function __init__(interface_data) {
            var self = this;
            var div, data;
            set_boss(self);
            document.head.appendChild(E.style(get_widget_css()));
            set_css(document.body, _$rapyd$_desugar_kwargs({background_color: get_color("window-background"), color: get_color("window-foreground")}));
            create_modal_container();
            self.interface_data = interface_data;
            self.current_library_id = interface_data["default_library"];
            self.current_library_name = interface_data["library_map"][self.current_library_id];
            self.current_mode = "book_list";
            self.update_window_title();
            div = E.div(_$rapyd$_desugar_kwargs({id: "book-list-container"}));
            document.body.appendChild(div);
            self.ui = new UI(interface_data, div);
            window.onerror = self.onerror.bind(self);
            self.history_count = 0;
            data = parse_url_params();
            set_current_query(data);
            self.ui.apply_state();
            if (!data.mode || data.mode === "book_list") {
                if (data.panel !== self.ui.current_panel) {
                    self.ui.show_panel(data.panel, _$rapyd$_desugar_kwargs({push_state: false}));
                }
            }
            setTimeout(function() {
                window.onpopstate = self.onpopstate.bind(self);
            }, 0);
        };
        Boss.prototype.update_window_title = function update_window_title() {
            var self = this;
            document.title = "calibre :: " + self.current_library_name;
        };
        Boss.prototype.onerror = function onerror(msg, script_url, line_number, column_number, error_object) {
            var self = this;
            var fname, details;
            try {
                fname = str.rpartition(script_url, "/")[str.rpartition(script_url, "/").length-1] || script_url;
                msg = msg + "<br><span style=\"font-size:smaller\">" + str.format("Error at {}:{}:{}", fname, line_number, column_number || "") + "</span>";
                details = "";
                if (error_object && error_object.stack) {
                    details = error_object.stack;
                }
                error_dialog(_("Unhandled error"), msg, details);
                return true;
            } catch (_$rapyd$_Exception) {
                console.error("There was an error in the unhandled exception handler");
            }
        };
        Boss.prototype.onpopstate = function onpopstate(ev) {
            var self = this;
            var data, mode, search;
            data = parse_url_params();
            set_current_query(data);
            mode = data.mode || "book_list";
            self.history_count -= 1;
            if (mode === "book_list") {
                search = data.search || "";
                if (data.panel !== self.ui.current_panel) {
                    self.ui.show_panel(data.panel, _$rapyd$_desugar_kwargs({push_state: false}));
                }
                if (search !== self.ui.books_view.interface_data.search_result.query) {
                    self.ui.books_view.change_search(search, _$rapyd$_desugar_kwargs({push_state: false, panel_to_show: data.panel}));
                }
            }
        };
        Boss.prototype.change_books = function change_books(data) {
            var self = this;
            var sval, _$rapyd$_unpack, field, order;
            data.search_result.sort = str.split(data.search_result.sort, ",").slice(0, 2).join(",");
            data.search_result.sort_order = str.split(data.search_result.sort_order, ",").slice(0, 2).join(",");
            sval = "";
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(zip(str.split(data.search_result.sort, ","), str.split(data.search_result.sort_order, ",")));
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                _$rapyd$_unpack = _$rapyd$_Iter0[_$rapyd$_Index0];
                field = _$rapyd$_unpack[0];
                order = _$rapyd$_unpack[1];
                sval += field + "." + order + ",";
            }
            get_session_data().set_library_option(self.interface_data.library_id, "sort", str.rstrip(sval, ","));
            self.interface_data.metadata = data.metadata;
            self.interface_data.search_result = data.search_result;
            self.ui.refresh_books_view();
        };
        Boss.prototype.push_state = function push_state() {
            var self = this;
            var replace = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[0];
            var extra_query_data = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "replace")){
                replace = _$rapyd$_kwargs_obj.replace;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "extra_query_data")){
                extra_query_data = _$rapyd$_kwargs_obj.extra_query_data;
            }
            var query, k, idata, sq;
            query = {};
            if (extra_query_data) {
                var _$rapyd$_Iter1 = _$rapyd$_Iterable(extra_query_data);
                for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                    k = _$rapyd$_Iter1[_$rapyd$_Index1];
                    query[k] = extra_query_data[k];
                }
            }
            if (self.current_mode === "book_list") {
                if (self.ui.current_panel !== self.ui.ROOT_PANEL) {
                    query.panel = self.ui.current_panel;
                }
            } else {
                query.current_mode = self.current_mode;
            }
            idata = self.interface_data;
            if (idata.library_id !== idata.default_library) {
                query.library_id = idata.library_id;
            }
            sq = idata.search_result.query;
            if (sq) {
                query.search = sq;
            }
            set_current_query(query);
            query = encode_query(query) || "?";
            if (replace) {
                window.history.replaceState(null, "", query);
            } else {
                window.history.pushState(null, "", query);
                self.history_count += 1;
            }
        };
        Boss.prototype.__repr__ = function __repr__ () {
            return "<" + __name__ + "." + "Boss" + " #" + this._$rapyd$_object_id + ">";
        };
        Boss.prototype.__str__ = function __str__ () {
            return this.__repr__();
        };
        

        _$rapyd$_modules["book_list.boss"]["Boss"] = Boss;
    })();

    (function(){

        var __name__ = "__main__";


        var ajax = _$rapyd$_modules["ajax"].ajax;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var UserSessionData = _$rapyd$_modules["session"].UserSessionData;
        
        var parse_url_params = _$rapyd$_modules["utils"].parse_url_params;
        
        var Boss = _$rapyd$_modules["book_list.boss"].Boss;
        
        var set_session_data = _$rapyd$_modules["book_list.globals"].set_session_data;
        
        function on_library_loaded(end_type, xhr, ev) {
            var p, interface_data, sd;
            p = document.getElementById("page_load_progress");
            p.parentNode.removeChild(p);
            if (end_type === "load") {
                interface_data = JSON.parse(xhr.responseText);
                sd = new UserSessionData(interface_data["username"], interface_data["user_session_data"]);
                set_session_data(sd);
                new Boss(interface_data);
            } else {
                p = E.p(_$rapyd$_desugar_kwargs({style: "color:red; font-weight: bold; font-size:1.5em"}));
                if (xhr.status === 401) {
                    p.innerHTML = _("You are not authorized to view this site");
                } else {
                    p.innerHTML = xhr.error_html;
                }
                document.body.appendChild(p);
            }
        }
        function on_library_load_progress(loaded, total) {
            var p;
            p = document.querySelector("#page_load_progress > progress");
            p.max = total;
            p.value = loaded;
        }
        function load_book_list() {
            var temp, query, default_lib, library_id, url_query, key;
            temp = new UserSessionData(null, {});
            query = {};
            default_lib = window.calibre_default_library;
            delete window.calibre_default_library;
            query.sort = temp.get_library_option(default_lib, "sort");
            library_id = temp.get("library_id");
            if (library_id) {
                query.library_id = library_id;
            }
            url_query = parse_url_params();
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(url_query);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                key = _$rapyd$_Iter0[_$rapyd$_Index0];
                query[key] = url_query[key];
            }
            ajax("interface-data/init", on_library_loaded, on_library_load_progress, _$rapyd$_desugar_kwargs({query: query})).send();
        }
        function on_load() {
            var ep;
            ep = window.calibre_entry_point;
            delete window.calibre_entry_point;
            if (ep === "book list") {
                print("calibre loaded at:", new Date().toString());
                load_book_list();
            }
        }
        window.addEventListener("load", on_load);
    })();
})();