/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MapperQueryParser;
import org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class QueryParseContext {
    private static final ParseField CACHE = new ParseField("_cache", new String[0]).withAllDeprecated("Elasticsearch makes its own caching decisions");
    private static final ParseField CACHE_KEY = new ParseField("_cache_key", new String[0]).withAllDeprecated("Filters are always used as cache keys");
    private static ThreadLocal<String[]> typesContext = new ThreadLocal();
    private final Index index;
    private final Version indexVersionCreated;
    private final IndexQueryParserService indexQueryParser;
    private final Map<String, Query> namedQueries = Maps.newHashMap();
    private final MapperQueryParser queryParser = new MapperQueryParser(this);
    private XContentParser parser;
    private ParseFieldMatcher parseFieldMatcher;
    private boolean allowUnmappedFields;
    private boolean mapUnmappedFieldAsString;
    private NestedScope nestedScope;
    private boolean isFilter;
    private SearchLookup lookup = null;

    public static void setTypes(String[] types) {
        typesContext.set(types);
    }

    public static String[] getTypes() {
        return typesContext.get();
    }

    public static String[] setTypesWithPrevious(String[] types) {
        String[] old = typesContext.get();
        QueryParseContext.setTypes(types);
        return old;
    }

    public static void removeTypes() {
        typesContext.remove();
    }

    public QueryParseContext(Index index, IndexQueryParserService indexQueryParser) {
        this.index = index;
        this.indexVersionCreated = Version.indexCreated(indexQueryParser.indexSettings());
        this.indexQueryParser = indexQueryParser;
    }

    public void parseFieldMatcher(ParseFieldMatcher parseFieldMatcher) {
        this.parseFieldMatcher = parseFieldMatcher;
    }

    public ParseFieldMatcher parseFieldMatcher() {
        return this.parseFieldMatcher;
    }

    public void reset(XContentParser jp) {
        this.allowUnmappedFields = this.indexQueryParser.defaultAllowUnmappedFields();
        this.parseFieldMatcher = ParseFieldMatcher.EMPTY;
        this.lookup = null;
        this.parser = jp;
        this.namedQueries.clear();
        this.nestedScope = new NestedScope();
        this.isFilter = false;
    }

    public Index index() {
        return this.index;
    }

    public void parser(XContentParser parser) {
        this.parser = parser;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public IndexQueryParserService indexQueryParserService() {
        return this.indexQueryParser;
    }

    public AnalysisService analysisService() {
        return this.indexQueryParser.analysisService;
    }

    public ScriptService scriptService() {
        return this.indexQueryParser.scriptService;
    }

    public MapperService mapperService() {
        return this.indexQueryParser.mapperService;
    }

    @Nullable
    public SimilarityService similarityService() {
        return this.indexQueryParser.similarityService;
    }

    public Similarity searchSimilarity() {
        return this.indexQueryParser.similarityService != null ? this.indexQueryParser.similarityService.similarity() : null;
    }

    public String defaultField() {
        return this.indexQueryParser.defaultField();
    }

    public boolean queryStringLenient() {
        return this.indexQueryParser.queryStringLenient();
    }

    public MapperQueryParser queryParser(QueryParserSettings settings) {
        this.queryParser.reset(settings);
        return this.queryParser;
    }

    public BitSetProducer bitsetFilter(Query filter) {
        return this.indexQueryParser.bitsetFilterCache.getBitSetProducer(filter);
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType mapper) {
        return this.indexQueryParser.fieldDataService.getForField(mapper);
    }

    public void addNamedQuery(String name, Query query) {
        if (query != null) {
            this.namedQueries.put(name, query);
        }
    }

    public ImmutableMap<String, Query> copyNamedQueries() {
        return ImmutableMap.copyOf(this.namedQueries);
    }

    public void combineNamedQueries(QueryParseContext context) {
        this.namedQueries.putAll(context.namedQueries);
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public void addInnerHits(String name, InnerHitsContext.BaseInnerHits context) {
        SearchContext sc = SearchContext.current();
        if (sc == null) {
            throw new QueryParsingException(this, "inner_hits unsupported", new Object[0]);
        }
        InnerHitsContext innerHitsContext = sc.innerHits();
        innerHitsContext.addInnerHitDefinition(name, context);
    }

    @Nullable
    public Query parseInnerQuery() throws QueryParsingException, IOException {
        XContentParser.Token token;
        if (this.parser.currentToken() != XContentParser.Token.START_OBJECT && (token = this.parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new QueryParsingException(this, "[_na] query malformed, must start with start_object", new Object[0]);
        }
        token = this.parser.nextToken();
        if (token == XContentParser.Token.END_OBJECT) {
            return null;
        }
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(this, "[_na] query malformed, no field after start_object", new Object[0]);
        }
        String queryName = this.parser.currentName();
        token = this.parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
            throw new QueryParsingException(this, "[_na] query malformed, no field after start_object", new Object[0]);
        }
        QueryParser queryParser = this.indexQueryParser.queryParser(queryName);
        if (queryParser == null) {
            throw new QueryParsingException(this, "No query registered for [" + queryName + "]", new Object[0]);
        }
        Query result = queryParser.parse(this);
        if (this.parser.currentToken() == XContentParser.Token.END_OBJECT || this.parser.currentToken() == XContentParser.Token.END_ARRAY) {
            this.parser.nextToken();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Query parseInnerFilter() throws QueryParsingException, IOException {
        boolean originalIsFilter = this.isFilter;
        try {
            this.isFilter = true;
            Query query = this.parseInnerQuery();
            return query;
        }
        finally {
            this.isFilter = originalIsFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query parseInnerFilter(String queryName) throws IOException, QueryParsingException {
        boolean originalIsFilter = this.isFilter;
        try {
            this.isFilter = true;
            QueryParser queryParser = this.indexQueryParser.queryParser(queryName);
            if (queryParser == null) {
                throw new QueryParsingException(this, "No query registered for [" + queryName + "]", new Object[0]);
            }
            Query query = queryParser.parse(this);
            return query;
        }
        finally {
            this.isFilter = originalIsFilter;
        }
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        return this.indexQueryParser.mapperService.simpleMatchToIndexNames(pattern, QueryParseContext.getTypes());
    }

    public MappedFieldType fieldMapper(String name) {
        return this.failIfFieldMappingNotFound(name, this.indexQueryParser.mapperService.smartNameFieldType(name, QueryParseContext.getTypes()));
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.indexQueryParser.mapperService.getObjectMapper(name, QueryParseContext.getTypes());
    }

    public Analyzer getSearchAnalyzer(MappedFieldType fieldType) {
        if (fieldType.searchAnalyzer() != null) {
            return fieldType.searchAnalyzer();
        }
        return this.mapperService().searchAnalyzer();
    }

    public Analyzer getSearchQuoteAnalyzer(MappedFieldType fieldType) {
        if (fieldType.searchQuoteAnalyzer() != null) {
            return fieldType.searchQuoteAnalyzer();
        }
        return this.mapperService().searchQuoteAnalyzer();
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    private MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            StringFieldMapper.Builder builder = MapperBuilders.stringField(name);
            Settings settings = Settings.builder().put("index.version.created", this.indexQueryParser.getIndexCreatedVersion()).build();
            return builder.build(new Mapper.BuilderContext(settings, new ContentPath(1))).fieldType();
        }
        Version indexCreatedVersion = this.indexQueryParser.getIndexCreatedVersion();
        if (fieldMapping == null && indexCreatedVersion.onOrAfter(Version.V_1_4_0_Beta1)) {
            throw new QueryParsingException(this, "Strict field resolution and no field mapping can be found for the field with name [" + name + "]", new Object[0]);
        }
        return fieldMapping;
    }

    public Collection<String> queryTypes() {
        String[] types = QueryParseContext.getTypes();
        if (types == null || types.length == 0) {
            return this.mapperService().types();
        }
        if (types.length == 1 && types[0].equals("_all")) {
            return this.mapperService().types();
        }
        return Arrays.asList(types);
    }

    public SearchLookup lookup() {
        SearchContext current = SearchContext.current();
        if (current != null) {
            return current.lookup();
        }
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this.mapperService(), this.indexQueryParser.fieldDataService, null);
        }
        return this.lookup;
    }

    public long nowInMillis() {
        SearchContext current = SearchContext.current();
        if (current != null) {
            return current.nowInMillis();
        }
        return System.currentTimeMillis();
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public boolean isDeprecatedSetting(String setting) {
        return this.parseFieldMatcher.match(setting, CACHE) || this.parseFieldMatcher.match(setting, CACHE_KEY);
    }

    public Version indexVersionCreated() {
        return this.indexVersionCreated;
    }
}

