/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesVisitor;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassRelevancyFilter;
import org.gradle.util.GFileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassDependenciesAnalyzer
implements ClassDependenciesAnalyzer {
    public ClassAnalysis getClassAnalysis(String className, InputStream input) throws IOException {
        ClassRelevancyFilter filter = new ClassRelevancyFilter(className);
        ClassReader reader = new ClassReader(input);
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor();
        reader.accept((ClassVisitor)visitor, 6);
        Set<String> classDependencies = this.getClassDependencies(filter, reader);
        return new ClassAnalysis(classDependencies, visitor.dependentToAll);
    }

    private Set<String> getClassDependencies(ClassRelevancyFilter filter, ClassReader reader) {
        HashSet<String> out = new HashSet<String>();
        char[] charBuffer = new char[reader.getMaxStringLength()];
        for (int i = 1; i < reader.getItemCount(); ++i) {
            String name;
            int itemOffset = reader.getItem(i);
            if (itemOffset <= 0 || reader.readByte(itemOffset - 1) != 7) continue;
            String classDescriptor = reader.readUTF8(itemOffset, charBuffer);
            Type type = Type.getObjectType((String)classDescriptor);
            while (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() != 10 || !filter.isRelevant(name = type.getClassName())) continue;
            out.add(name);
        }
        return out;
    }

    @Override
    public ClassAnalysis getClassAnalysis(String className, File classFile) {
        FileInputStream input = GFileUtils.openInputStream((File)classFile);
        try {
            ClassAnalysis classAnalysis = this.getClassAnalysis(className, input);
            return classAnalysis;
        }
        catch (IOException e) {
            throw new RuntimeException("Problems loading class analysis for '" + className + "' from file: " + classFile);
        }
        finally {
            GFileUtils.closeInputStream((InputStream)input);
        }
    }
}

