/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.compare.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildComparisonSpec;
import org.gradle.api.plugins.buildcomparison.compare.internal.DefaultBuildComparisonSpecBuilder;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcomeAssociator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildComparisonSpecFactory {
    private final BuildOutcomeAssociator associator;

    public BuildComparisonSpecFactory(BuildOutcomeAssociator associator) {
        this.associator = associator;
    }

    public BuildComparisonSpec createSpec(Set<BuildOutcome> from, Set<BuildOutcome> to) {
        DefaultBuildComparisonSpecBuilder builder = new DefaultBuildComparisonSpecBuilder();
        HashSet<BuildOutcome> toCopy = new HashSet<BuildOutcome>(to);
        for (BuildOutcome fromBuildOutcome : from) {
            BuildOutcome buildOutcome;
            BuildOutcome toBuildOutcome = null;
            Class<? extends BuildOutcome> associationType = null;
            Iterator i$ = toCopy.iterator();
            while (i$.hasNext() && (associationType = this.associator.findAssociationType(fromBuildOutcome, toBuildOutcome = (buildOutcome = (BuildOutcome)i$.next()))) == null) {
            }
            if (associationType == null) {
                builder.addUnassociatedFrom(fromBuildOutcome);
                continue;
            }
            builder.associate((BuildOutcome)associationType.cast(fromBuildOutcome), (BuildOutcome)associationType.cast(toBuildOutcome), associationType);
            toCopy.remove(toBuildOutcome);
        }
        for (BuildOutcome buildOutcome : toCopy) {
            builder.addUnassociatedTo(buildOutcome);
        }
        return builder.build();
    }
}

