/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.ListModelEditor;
import org.gjt.sp.jedit.jEdit;

public class HistoryText {
    private JTextComponent text;
    private HistoryModel historyModel;
    private int index;
    private String current;
    private JPopupMenu popup;
    private boolean instantPopups;

    public HistoryText(JTextComponent jTextComponent, String string) {
        this.text = jTextComponent;
        this.setModel(string);
        this.index = -1;
    }

    public void fireActionPerformed() {
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public HistoryModel getModel() {
        return this.historyModel;
    }

    public void setModel(String string) {
        this.historyModel = string == null ? null : HistoryModel.getModel(string);
        this.index = -1;
    }

    public void setInstantPopups(boolean bl) {
        this.instantPopups = bl;
    }

    public boolean getInstantPopups() {
        return this.instantPopups;
    }

    public void addCurrentToHistory() {
        if (this.historyModel != null) {
            this.historyModel.addItem(this.getText());
        }
        this.index = 0;
    }

    public void doBackwardSearch() {
        if (this.historyModel == null) {
            return;
        }
        if (this.text.getSelectionEnd() != this.getDocument().getLength()) {
            this.text.setCaretPosition(this.getDocument().getLength());
        }
        int n = this.getInputStart();
        String string = this.getText().substring(0, this.text.getSelectionStart() - n);
        if (string == null) {
            this.historyPrevious();
            return;
        }
        for (int i = this.index + 1; i < this.historyModel.getSize(); ++i) {
            String string2 = this.historyModel.getItem(i);
            if (!string2.startsWith(string)) continue;
            this.text.replaceSelection(string2.substring(string.length()));
            this.text.select(this.getInputStart() + string.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        this.text.getToolkit().beep();
    }

    public void doForwardSearch() {
        if (this.historyModel == null) {
            return;
        }
        if (this.text.getSelectionEnd() != this.getDocument().getLength()) {
            this.text.setCaretPosition(this.getDocument().getLength());
        }
        int n = this.getInputStart();
        String string = this.getText().substring(0, this.text.getSelectionStart() - n);
        if (string == null) {
            this.historyNext();
            return;
        }
        for (int i = this.index - 1; i >= 0; --i) {
            String string2 = this.historyModel.getItem(i);
            if (!string2.startsWith(string)) continue;
            this.text.replaceSelection(string2.substring(string.length()));
            this.text.select(this.getInputStart() + string.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        this.text.getToolkit().beep();
    }

    public void historyPrevious() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == this.historyModel.getSize() - 1) {
            this.text.getToolkit().beep();
        } else if (this.index == -1) {
            this.current = this.getText();
            this.setText(this.historyModel.getItem(0));
            this.index = 0;
        } else {
            int n = this.index + 1;
            this.setText(this.historyModel.getItem(n));
            this.index = n;
        }
    }

    public void historyNext() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == -1) {
            this.text.getToolkit().beep();
        } else if (this.index == 0) {
            this.setText(this.current);
        } else {
            int n = this.index - 1;
            this.setText(this.historyModel.getItem(n));
            this.index = n;
        }
    }

    public Document getDocument() {
        return this.text.getDocument();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String string) {
        this.index = -1;
        this.text.setText(string);
    }

    public int getInputStart() {
        return 0;
    }

    public void showPopupMenu(String string, int n, int n2) {
        if (this.historyModel == null) {
            return;
        }
        this.text.requestFocus();
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
            this.popup = null;
            return;
        }
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean bl) {
                if (!bl) {
                    HistoryText.this.popup = null;
                }
                super.setVisible(bl);
            }
        };
        JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("history.caption"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ListModelEditor().open(HistoryText.this.historyModel);
            }
        });
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        for (int i = 0; i < this.historyModel.getSize(); ++i) {
            String string2 = this.historyModel.getItem(i);
            if (!string2.startsWith(string)) continue;
            JMenuItem jMenuItem2 = new JMenuItem(string2);
            jMenuItem2.setActionCommand(String.valueOf(i));
            jMenuItem2.addActionListener(new ActionHandler());
            this.popup.add(jMenuItem2);
        }
        GUIUtilities.showPopupMenu(this.popup, this.text, n, n2, false);
    }

    public void showPopupMenu(boolean bl) {
        if (bl) {
            this.showPopupMenu(this.getText().substring(this.getInputStart(), this.text.getSelectionStart()), 0, this.text.getHeight());
        } else {
            this.showPopupMenu("", 0, this.text.getHeight());
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            if (n == -1) {
                if (HistoryText.this.index != -1) {
                    HistoryText.this.setText(HistoryText.this.current);
                }
            } else {
                HistoryText.this.setText(HistoryText.this.historyModel.getItem(n));
                HistoryText.this.index = n;
            }
            if (HistoryText.this.instantPopups) {
                HistoryText.this.addCurrentToHistory();
                HistoryText.this.fireActionPerformed();
            }
        }
    }
}

