/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javajs.api.GenericPlatform;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.c.STER;
import org.jmol.g3d.CircleRenderer;
import org.jmol.g3d.CylinderRenderer;
import org.jmol.g3d.G3DRenderer;
import org.jmol.g3d.HermiteRenderer;
import org.jmol.g3d.LineRenderer;
import org.jmol.g3d.Pixelator;
import org.jmol.g3d.PixelatorScreened;
import org.jmol.g3d.PixelatorShaded;
import org.jmol.g3d.PixelatorT;
import org.jmol.g3d.Platform3D;
import org.jmol.g3d.PrecisionRenderer;
import org.jmol.g3d.SphereRenderer;
import org.jmol.g3d.TextRenderer;
import org.jmol.g3d.TextString;
import org.jmol.g3d.TriangleRenderer;
import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.util.MeshSurface;
import org.jmol.util.Normix;
import org.jmol.util.Rgb16;
import org.jmol.viewer.Viewer;

public final class Graphics3D
extends GData
implements JmolRendererInterface {
    Platform3D platform;
    LineRenderer line3d;
    private SphereRenderer sphere3d;
    private CylinderRenderer cylinder3d;
    private G3DRenderer triangle3d;
    private G3DRenderer circle3d;
    private G3DRenderer hermite3d;
    private boolean isFullSceneAntialiasingEnabled;
    private boolean antialias2;
    private TextString[] strings = null;
    private int stringCount;
    private byte[] anaglyphChannelBytes;
    private boolean twoPass = false;
    private boolean haveTranslucentObjects;
    protected int[] pbuf;
    protected int[] pbufT;
    protected int[] zbuf;
    protected int[] zbufT;
    protected int translucencyMask;
    private boolean renderLow;
    private int[] shadesCurrent;
    private int anaglyphLength;
    Pixelator pixel;
    Pixelator pixel0;
    private PixelatorT pixelT0;
    private PixelatorScreened pixelScreened;
    private PixelatorShaded pixelShaded;
    protected int zMargin;
    private int[] aobuf;
    int currentShadeIndex;
    private int lastRawColor;
    int translucencyLog;
    private boolean wasScreened;
    private int saveAmbient;
    private int saveDiffuse;
    public static Comparator<TextString> sort;
    private static byte nullShadeIndex;
    private final V3 vectorAB = new V3();
    private final V3 vectorAC = new V3();
    private final V3 vectorNormal = new V3();
    private final byte[] shadeIndexes = new byte[normixCount];
    private final byte[] shadeIndexes2Sided = new byte[normixCount];
    public int pass2Flag01;

    @Override
    public void clear() {
        this.stringCount = 0;
        this.strings = null;
        TextRenderer.clearFontCache();
    }

    @Override
    public void destroy() {
        this.releaseBuffers();
        this.platform = null;
        this.pixelShaded = null;
        this.pixel0 = null;
        this.pixel = null;
        this.pixelT0 = null;
        this.pixelScreened = null;
        this.graphicsForMetrics = null;
    }

    void setZMargin(int n) {
        this.zMargin = n;
    }

    public Graphics3D() {
        int n = normixCount;
        while (--n >= 0) {
            this.transformedVectors[n] = new V3();
        }
    }

    @Override
    public void initialize(Viewer viewer, GenericPlatform genericPlatform) {
        this.vwr = viewer;
        this.apiPlatform = genericPlatform;
        this.platform = new Platform3D(genericPlatform);
        this.pixel = this.pixel0 = new Pixelator(this);
        this.graphicsForMetrics = this.platform.getGraphicsForMetrics();
        this.line3d = new LineRenderer(this);
        this.sphere3d = new SphereRenderer(this);
        this.cylinder3d = new CylinderRenderer(this);
    }

    @Override
    public void addRenderer(int n) {
        switch (n) {
            case 1073741880: {
                if (this.circle3d != null) break;
                this.circle3d = this.getRenderer("Circle");
                break;
            }
            case 553648147: {
                if (this.hermite3d == null) {
                    this.hermite3d = this.getRenderer("Hermite");
                }
            }
            case 1073742182: {
                if (this.triangle3d != null) break;
                this.triangle3d = this.getRenderer("Triangle");
                ((PrecisionRenderer)((Object)this.triangle3d)).isOrthographic = !this.vwr.tm.perspectiveDepth;
            }
        }
    }

    private G3DRenderer getRenderer(String string) {
        G3DRenderer g3DRenderer = (G3DRenderer)Interface.getOption("g3d." + string + "Renderer", this.vwr, "render");
        if (g3DRenderer == null) {
            throw new NullPointerException("Interface");
        }
        g3DRenderer.set(this, this);
        return g3DRenderer;
    }

    @Override
    public void setWindowParameters(int n, int n2, boolean bl) {
        this.setWinParams(n, n2, bl);
        if (this.currentlyRendering) {
            this.endRendering();
        }
    }

    @Override
    public boolean checkTranslucent(boolean bl) {
        if (bl) {
            this.haveTranslucentObjects = true;
        }
        return !this.twoPass || this.twoPass && this.isPass2 == bl;
    }

    @Override
    public void beginRendering(M3 m3, boolean bl, boolean bl2, boolean bl3) {
        if (this.currentlyRendering) {
            this.endRendering();
        }
        this.renderLow = bl3;
        if (this.windowWidth != this.newWindowWidth || this.windowHeight != this.newWindowHeight || this.newAntialiasing != this.isFullSceneAntialiasingEnabled) {
            this.windowWidth = this.newWindowWidth;
            this.windowHeight = this.newWindowHeight;
            this.isFullSceneAntialiasingEnabled = this.newAntialiasing;
            this.releaseBuffers();
        }
        this.setRotationMatrix(m3);
        boolean bl4 = this.line3d.isOrthographic = !this.vwr.tm.perspectiveDepth;
        if (this.triangle3d != null) {
            ((PrecisionRenderer)((Object)this.triangle3d)).isOrthographic = !this.vwr.tm.perspectiveDepth;
        }
        this.antialiasEnabled = this.antialiasThisFrame = this.newAntialiasing;
        this.currentlyRendering = true;
        if (this.strings != null) {
            int n = Math.min(this.strings.length, this.stringCount);
            while (--n >= 0) {
                this.strings[n] = null;
            }
        }
        this.stringCount = 0;
        this.twoPass = true;
        this.isPass2 = false;
        this.pass2Flag01 = 0;
        this.colixCurrent = 0;
        this.wasScreened = false;
        this.haveTranslucentObjects = false;
        this.pixel = this.pixel0;
        this.pixel.bgcolor = this.bgcolor;
        boolean bl5 = this.translucentCoverOnly = !bl;
        if (this.pbuf == null) {
            this.platform.allocateBuffers(this.windowWidth, this.windowHeight, this.antialiasThisFrame, bl2);
            this.pbuf = this.platform.pBuffer;
            this.zbuf = this.platform.zBuffer;
            this.aobuf = null;
            this.pixel0.setBuf();
            if (this.pixelT0 != null) {
                this.pixelT0.setBuf();
            }
            if (this.pixelShaded != null) {
                this.pixelShaded.setBuf();
            }
        }
        this.setWidthHeight(this.antialiasThisFrame);
        if (this.pixelScreened != null) {
            this.pixelScreened.width = this.width;
        }
        this.platform.clearBuffer();
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, null, (short)0, 0, 0);
        }
        this.textY = 0;
    }

    @Override
    public void setBackgroundTransparent(boolean bl) {
        if (this.platform != null) {
            this.platform.setBackgroundTransparent(bl);
        }
    }

    private void releaseBuffers() {
        this.pbuf = null;
        this.zbuf = null;
        this.pbufT = null;
        this.zbufT = null;
        this.aobuf = null;
        this.platform.releaseBuffers();
        this.line3d.clearLineCache();
    }

    @Override
    public boolean setPass2(boolean bl) {
        if (!this.haveTranslucentObjects || !this.currentlyRendering) {
            return false;
        }
        this.isPass2 = true;
        this.pass2Flag01 = 1;
        this.colixCurrent = 0;
        if (this.pbufT == null || this.antialias2 != bl) {
            this.platform.allocateTBuffers(bl);
            this.pbufT = this.platform.pBufferT;
            this.zbufT = this.platform.zBufferT;
        }
        this.antialias2 = bl;
        if (this.antialiasThisFrame && !this.antialias2) {
            this.downsampleFullSceneAntialiasing(true);
        }
        this.platform.clearTBuffer();
        if (this.pixelT0 == null) {
            this.pixelT0 = new PixelatorT(this);
        }
        if (this.pixel.p0 == null) {
            this.pixel = this.pixelT0;
        } else {
            this.pixel.p0 = this.pixelT0;
        }
        return true;
    }

    @Override
    public void endRendering() {
        if (!this.currentlyRendering) {
            return;
        }
        if (this.pbuf != null) {
            if (this.isPass2 && this.pbufT != null) {
                int n = this.pbufT.length;
                while (--n >= 0) {
                    this.pbuf[n] = Graphics3D.mergeBufferPixel(this.pbuf[n], this.pbufT[n], this.bgcolor);
                }
            }
            if (this.pixel == this.pixelShaded && this.pixelShaded.zShadePower == 0) {
                this.pixelShaded.showZBuffer();
            }
            if (this.antialiasThisFrame) {
                this.downsampleFullSceneAntialiasing(false);
            }
        }
        this.platform.setBackgroundColor(this.bgcolor);
        this.platform.notifyEndOfRendering();
        this.isPass2 = false;
        this.currentlyRendering = false;
    }

    public static int mergeBufferPixel(int n, int n2, int n3) {
        if (n2 == 0 || n == n2) {
            return n;
        }
        if (n == 0) {
            n = n3;
        }
        int n4 = n & 0xFF00FF;
        int n5 = n & 0xFF00;
        int n6 = n2 & 0xFF00FF;
        int n7 = n2 & 0xFF00;
        int n8 = n2 >> 24 & 0xF;
        switch (n8) {
            case 0: {
                n4 = n6;
                n5 = n7;
                break;
            }
            case 1: {
                n4 = (n6 << 2) + (n6 << 1) + n6 + n4 >> 3 & 0xFF00FF;
                n5 = (n7 << 2) + (n7 << 1) + n7 + n5 >> 3 & 0xFF00;
                break;
            }
            case 2: {
                n4 = (n6 << 1) + n6 + n4 >> 2 & 0xFF00FF;
                n5 = (n7 << 1) + n7 + n5 >> 2 & 0xFF00;
                break;
            }
            case 3: {
                n4 = (n6 << 2) + n6 + (n4 << 1) + n4 >> 3 & 0xFF00FF;
                n5 = (n7 << 2) + n7 + (n5 << 1) + n5 >> 3 & 0xFF00;
                break;
            }
            case 4: {
                n4 = n4 + n6 >> 1 & 0xFF00FF;
                n5 = n5 + n7 >> 1 & 0xFF00;
                break;
            }
            case 5: {
                n4 = (n6 << 1) + n6 + (n4 << 2) + n4 >> 3 & 0xFF00FF;
                n5 = (n7 << 1) + n7 + (n5 << 2) + n5 >> 3 & 0xFF00;
                break;
            }
            case 6: {
                n4 = (n4 << 1) + n4 + n6 >> 2 & 0xFF00FF;
                n5 = (n5 << 1) + n5 + n7 >> 2 & 0xFF00;
                break;
            }
            case 7: {
                n4 = (n4 << 2) + (n4 << 1) + n4 + n6 >> 3 & 0xFF00FF;
                n5 = (n5 << 2) + (n5 << 1) + n5 + n7 >> 3 & 0xFF00;
            }
        }
        return 0xFF000000 | n4 | n5;
    }

    @Override
    public Object getScreenImage(boolean bl) {
        return this.platform.bufferedImage;
    }

    @Override
    public void applyAnaglygh(STER sTER, int[] nArray) {
        switch (sTER) {
            case REDCYAN: {
                int n = this.anaglyphLength;
                while (--n >= 0) {
                    int n2 = this.anaglyphChannelBytes[n] & 0xFF;
                    int n3 = n2 << 8 | n2;
                    this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n3;
                }
                break;
            }
            case CUSTOM: {
                int n = nArray[0];
                int n4 = nArray[1] & 0xFFFFFF;
                int n5 = this.anaglyphLength;
                while (--n5 >= 0) {
                    int n6 = this.anaglyphChannelBytes[n5] & 0xFF;
                    n6 = (n6 | (n6 | n6 << 8) << 8) & n4;
                    this.pbuf[n5] = this.pbuf[n5] & n | n6;
                }
                break;
            }
            case REDBLUE: {
                int n = this.anaglyphLength;
                while (--n >= 0) {
                    int n7 = this.anaglyphChannelBytes[n] & 0xFF;
                    this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n7;
                }
                break;
            }
            case REDGREEN: {
                int n = this.anaglyphLength;
                while (--n >= 0) {
                    int n8 = (this.anaglyphChannelBytes[n] & 0xFF) << 8;
                    this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n8;
                }
                break;
            }
        }
    }

    @Override
    public void snapshotAnaglyphChannelBytes() {
        if (this.currentlyRendering) {
            throw new NullPointerException();
        }
        this.anaglyphLength = this.windowWidth * this.windowHeight;
        if (this.anaglyphChannelBytes == null || this.anaglyphChannelBytes.length != this.anaglyphLength) {
            this.anaglyphChannelBytes = new byte[this.anaglyphLength];
        }
        int n = this.anaglyphLength;
        while (--n >= 0) {
            this.anaglyphChannelBytes[n] = (byte)this.pbuf[n];
        }
    }

    @Override
    public void releaseScreenImage() {
        this.platform.clearScreenBufferThreaded();
    }

    @Override
    public boolean haveTranslucentObjects() {
        return this.haveTranslucentObjects;
    }

    @Override
    public void setSlabAndZShade(int n, int n2, int n3, int n4, int n5) {
        this.setSlab(n);
        this.setDepth(n2);
        if (n3 < n4) {
            if (this.pixelShaded == null) {
                this.pixelShaded = new PixelatorShaded(this);
            }
            this.pixel = this.pixelShaded.set(n3, n4, n5);
        } else {
            this.pixel = this.pixel0;
        }
    }

    private void downsampleFullSceneAntialiasing(boolean bl) {
        int n = this.bgcolor;
        if (bl) {
            n += (n & 0xFF) == 255 ? -1 : 1;
        }
        Graphics3D.downsample2d(this.pbuf, this.windowWidth, this.windowHeight, n);
        if (bl) {
            Graphics3D.downsample2dZ(this.pbuf, this.zbuf, this.windowWidth, this.windowHeight, n);
            this.antialiasThisFrame = false;
            this.setWidthHeight(false);
        }
    }

    public static void downsample2d(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = n << 1;
        if (n3 != 0) {
            n3 &= 0xFFFFFF;
            n4 = nArray.length;
            while (--n4 >= 0) {
                if (nArray[n4] != 0) continue;
                nArray[n4] = n3;
            }
        }
        n4 = (n3 >> 2 & 0x3F3F3F3F) << 2;
        n4 += (n4 & 0xC0C0C0C0) >> 6;
        int n6 = 0;
        int n7 = 0;
        int n8 = n2;
        while (--n8 >= 0) {
            int n9 = n;
            while (--n9 >= 0) {
                int n10 = (nArray[n7] >> 2 & 0x3F3F3F3F) + (nArray[n7++ + n5] >> 2 & 0x3F3F3F3F) + (nArray[n7] >> 2 & 0x3F3F3F3F) + (nArray[n7++ + n5] >> 2 & 0x3F3F3F3F);
                if ((n10 += (n10 & 0xC0C0C0C0) >> 6) == n4) {
                    n10 = n3;
                }
                nArray[n6] = n10 & 0xFFFFFF;
                ++n6;
            }
            n7 += n5;
        }
    }

    private static void downsample2dZ(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4 = n << 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        while (--n7 >= 0) {
            int n8 = n;
            while (--n8 >= 0) {
                int n9 = Math.min(nArray2[n6], nArray2[n6 + n4]);
                n9 = Math.min(n9, nArray2[++n6]);
                if ((n9 = Math.min(n9, nArray2[n6 + n4])) != Integer.MAX_VALUE) {
                    n9 >>= 1;
                }
                nArray2[n5] = nArray[n5] == n3 ? Integer.MAX_VALUE : n9;
                ++n5;
                ++n6;
            }
            n6 += n4;
        }
    }

    public boolean hasContent() {
        return this.platform.hasContent();
    }

    @Override
    public boolean setC(short s) {
        boolean bl = C.isColixLastAvailable(s);
        if (!bl && s == this.colixCurrent && this.currentShadeIndex == -1) {
            return true;
        }
        int n = s & 0x7800;
        if (n == 16384) {
            return false;
        }
        if (this.renderLow) {
            n = 0;
        }
        boolean bl2 = n != 0;
        boolean bl3 = bl2 && n == 30720;
        this.setScreened(bl3);
        if (!this.checkTranslucent(bl2 && !bl3)) {
            return false;
        }
        if (this.isPass2) {
            this.translucencyMask = n << 13 | 0xFFFFFF;
            this.translucencyLog = n >> 11;
        } else {
            this.translucencyLog = 0;
        }
        this.colixCurrent = s;
        if (bl && this.argbCurrent != this.lastRawColor) {
            if (this.argbCurrent == 0) {
                this.argbCurrent = -1;
            }
            this.lastRawColor = this.argbCurrent;
            this.shader.setLastColix(this.argbCurrent, this.inGreyscaleMode);
        }
        this.shadesCurrent = this.getShades(s);
        this.currentShadeIndex = -1;
        this.setColor(this.getColorArgbOrGray(s));
        return true;
    }

    Pixelator setScreened(boolean bl) {
        if (this.wasScreened != bl) {
            this.wasScreened = bl;
            if (bl) {
                if (this.pixelScreened == null) {
                    this.pixelScreened = new PixelatorScreened(this, this.pixel0);
                }
                if (this.pixel.p0 == null) {
                    this.pixel = this.pixelScreened;
                } else {
                    this.pixel.p0 = this.pixelScreened;
                }
            } else if (this.pixel.p0 == null || this.pixel == this.pixelScreened) {
                this.pixel = this.isPass2 ? this.pixelT0 : this.pixel0;
            } else {
                this.pixel.p0 = this.isPass2 ? this.pixelT0 : this.pixel0;
            }
        }
        return this.pixel;
    }

    @Override
    public void drawFilledCircle(short s, short s2, int n, int n2, int n3, int n4) {
        boolean bl;
        if (this.isClippedZ(n4)) {
            return;
        }
        int n5 = (n + 1) / 2;
        boolean bl2 = bl = n2 < n5 || n2 + n5 >= this.width || n3 < n5 || n3 + n5 >= this.height;
        if (bl && this.isClippedXY(n, n2, n3)) {
            return;
        }
        if (s != 0 && this.setC(s)) {
            if (bl) {
                if (!this.isClippedXY(n, n2, n3)) {
                    ((CircleRenderer)this.circle3d).plotCircleCenteredClipped(n2, n3, n4, n);
                }
            } else {
                ((CircleRenderer)this.circle3d).plotCircleCenteredUnclipped(n2, n3, n4, n);
            }
        }
        if (s2 != 0 && this.setC(s2)) {
            if (bl) {
                ((CircleRenderer)this.circle3d).plotFilledCircleCenteredClipped(n2, n3, n4, n);
            } else {
                ((CircleRenderer)this.circle3d).plotFilledCircleCenteredUnclipped(n2, n3, n4, n);
            }
        }
    }

    @Override
    public void volumeRender4(int n, int n2, int n3, int n4) {
        boolean bl;
        if (n == 1) {
            this.plotPixelClippedArgb(this.argbCurrent, n2, n3, n4, this.width, this.zbuf, this.pixel);
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        int n5 = (n + 1) / 2;
        boolean bl2 = bl = n2 < n5 || n2 + n5 >= this.width || n3 < n5 || n3 + n5 >= this.height;
        if (bl && this.isClippedXY(n, n2, n3)) {
            return;
        }
        if (bl) {
            ((CircleRenderer)this.circle3d).plotFilledCircleCenteredClipped(n2, n3, n4, n);
        } else {
            ((CircleRenderer)this.circle3d).plotFilledCircleCenteredUnclipped(n2, n3, n4, n);
        }
    }

    @Override
    public void fillSphereXYZ(int n, int n2, int n3, int n4) {
        switch (n) {
            case 1: {
                this.plotPixelClippedArgb(this.argbCurrent, n2, n3, n4, this.width, this.zbuf, this.pixel);
                return;
            }
            case 0: {
                return;
            }
        }
        if (n <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, n, n2, n3, n4, null, null, null, -1, null);
        }
    }

    @Override
    public void volumeRender(boolean bl) {
        if (bl) {
            this.saveAmbient = this.getAmbientPercent();
            this.saveDiffuse = this.getDiffusePercent();
            this.setAmbientPercent(100);
            this.setDiffusePercent(0);
            this.addRenderer(1073741880);
        } else {
            this.setAmbientPercent(this.saveAmbient);
            this.setDiffusePercent(this.saveDiffuse);
        }
    }

    @Override
    public void fillSphereI(int n, P3i p3i) {
        this.fillSphereXYZ(n, p3i.x, p3i.y, p3i.z);
    }

    @Override
    public void fillSphereBits(int n, P3 p3) {
        this.fillSphereXYZ(n, Math.round(p3.x), Math.round(p3.y), Math.round(p3.z));
    }

    @Override
    public void fillEllipsoid(P3 p3, P3[] p3Array, int n, int n2, int n3, int n4, M3 m3, double[] dArray, M4 m4, int n5, P3[] p3Array2) {
        switch (n4) {
            case 1: {
                this.plotPixelClippedArgb(this.argbCurrent, n, n2, n3, this.width, this.zbuf, this.pixel);
                return;
            }
            case 0: {
                return;
            }
        }
        if (n4 <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, n4, n, n2, n3, m3, dArray, m4, n5, p3Array2);
        }
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 != 0 && this.isClippedZ(n4)) {
            return;
        }
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = n + n7;
        int n10 = n2 + n8;
        if (n2 >= 0 && n2 < this.height) {
            this.drawHLine(n, n2, n3, n7);
        }
        if (n10 >= 0 && n10 < this.height) {
            this.drawHLine(n, n10, n3, n7);
        }
        if (n >= 0 && n < this.width) {
            this.drawVLine(n, n2, n3, n8);
        }
        if (n9 >= 0 && n9 < this.width) {
            this.drawVLine(n9, n2, n3, n8);
        }
    }

    private void drawHLine(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n += n4;
            n4 = -n4;
        }
        if (n < 0) {
            n4 += n;
            n = 0;
        }
        if (n + n4 >= this.width) {
            n4 = this.width - 1 - n;
        }
        Pixelator pixelator = this.pixel;
        int n5 = this.argbCurrent;
        int n6 = n + this.width * n2;
        for (int i = 0; i <= n4; ++i) {
            if (n3 < this.zbuf[n6]) {
                pixelator.addPixel(n6, n3, n5);
            }
            ++n6;
        }
    }

    private void drawVLine(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n2 + n4 >= this.height) {
            n4 = this.height - 1 - n2;
        }
        int n5 = n + this.width * n2;
        Pixelator pixelator = this.pixel;
        int n6 = this.argbCurrent;
        for (int i = 0; i <= n4; ++i) {
            if (n3 < this.zbuf[n5]) {
                pixelator.addPixel(n5, n3, n6);
            }
            n5 += this.width;
        }
    }

    @Override
    public void fillTextRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isClippedZ(n4)) {
            return;
        }
        int n7 = this.width;
        if (n < 0) {
            if ((n5 += n) <= 0) {
                return;
            }
            n = 0;
        }
        if (n + n5 > n7 && (n5 = n7 - n) <= 0) {
            return;
        }
        if (n2 < 0) {
            if ((n6 += n2) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n2 + n6 > this.height) {
            n6 = this.height - n2;
        }
        int n8 = this.argbCurrent;
        int[] nArray = this.zbuf;
        Pixelator pixelator = this.pixel;
        while (--n6 >= 0) {
            this.plotPixelsUnclippedCount(n8, n5, n, n2++, n3, n7, nArray, pixelator);
        }
    }

    @Override
    public void drawString(String string, Font font, int n, int n2, int n3, int n4, short s) {
        this.currentShadeIndex = 0;
        if (string == null) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        this.drawStringNoSlab(string, font, n, n2, n3, s);
    }

    @Override
    public void drawStringNoSlab(String string, Font font, int n, int n2, int n3, short s) {
        if (string == null) {
            return;
        }
        if (this.strings == null) {
            this.strings = new TextString[10];
        }
        if (this.stringCount == this.strings.length) {
            this.strings = (TextString[])AU.doubleLength(this.strings);
        }
        TextString textString = new TextString();
        textString.setText(string, font == null ? this.currentFont : (this.currentFont = font), this.argbCurrent, C.isColixTranslucent(s) ? this.getColorArgbOrGray(s) & 0xFFFFFF | (s & 0x7800) << 13 : 0, n, n2, n3);
        this.strings[this.stringCount++] = textString;
    }

    @Override
    public void renderAllStrings(Object object) {
        if (this.strings == null) {
            return;
        }
        if (this.stringCount >= 2) {
            if (sort == null) {
                sort = new TextString();
            }
            Arrays.sort(this.strings, sort);
        }
        for (int i = 0; i < this.stringCount; ++i) {
            TextString textString = this.strings[i];
            this.plotText(textString.x, textString.y, textString.z, textString.argb, textString.bgargb, textString.text, textString.font, (JmolRendererInterface)object);
        }
        this.strings = null;
        this.stringCount = 0;
    }

    @Override
    public void plotText(int n, int n2, int n3, int n4, int n5, String string, Font font, JmolRendererInterface jmolRendererInterface) {
        TextRenderer.plot(n, n2, n3, n4, n5, string, font, this, jmolRendererInterface, this.antialiasThisFrame);
    }

    @Override
    public void drawImage(Object object, int n, int n2, int n3, int n4, short s, int n5, int n6) {
        if (object != null && n5 > 0 && n6 > 0 && !this.isClippedZ(n4)) {
            this.plotImage(n, n2, n3, object, null, s, n5, n6);
        }
    }

    @Override
    public void plotImage(int n, int n2, int n3, Object object, JmolRendererInterface jmolRendererInterface, short s, int n4, int n5) {
        int n6;
        this.setC(s);
        if (!this.isPass2) {
            this.translucencyMask = -1;
        }
        if (s == 0) {
            this.argbCurrent = 0;
        }
        boolean bl = n == Integer.MIN_VALUE;
        int n7 = n6 = bl ? this.bgcolor : this.argbCurrent;
        if (bl) {
            n = 0;
            n3 = 0x7FFFFFFE;
            n4 = this.width;
            n5 = this.height;
        }
        if (n + n4 <= 0 || n >= this.width || n2 + n5 <= 0 || n2 >= this.height) {
            return;
        }
        Object object2 = this.platform.getGraphicsForTextOrImage(n4, n5);
        int[] nArray = this.apiPlatform.drawImageToBuffer(object2, this.platform.offscreenImage, object, n4, n5, bl ? n6 : 0);
        if (nArray == null) {
            return;
        }
        int[] nArray2 = this.zbuf;
        int n8 = this.width;
        Pixelator pixelator = this.pixel;
        int n9 = this.height;
        int n10 = this.translucencyLog;
        if (jmolRendererInterface == null && n >= 0 && n + n4 <= n8 && n2 >= 0 && n2 + n5 <= n9) {
            int n11 = 0;
            int n12 = 0;
            int n13 = n2 * n8 + n;
            while (n11 < n5) {
                int n14 = 0;
                while (n14 < n4) {
                    int n15;
                    if (n3 < nArray2[n13] && ((n15 = nArray[n12]) & 0xFF000000) == -16777216) {
                        pixelator.addPixel(n13, n3, n15);
                    }
                    ++n14;
                    ++n12;
                    ++n13;
                }
                ++n11;
                n13 += n8 - n4;
            }
        } else {
            if (jmolRendererInterface == null) {
                jmolRendererInterface = this;
            }
            int n16 = 0;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int n17;
                    if (((n17 = nArray[n16++]) & 0xFF000000) != -16777216) continue;
                    jmolRendererInterface.plotImagePixel(n17, n + j, n2 + i, n3, (byte)8, n6, n8, n9, nArray2, pixelator, n10);
                }
            }
        }
    }

    @Override
    public void setFontFid(byte by) {
        this.currentFont = Font.getFont3D(by);
    }

    @Override
    public void setFont(Font font) {
        this.currentFont = font;
    }

    @Override
    public void drawPixel(int n, int n2, int n3) {
        this.plotPixelClippedArgb(this.argbCurrent, n, n2, n3, this.width, this.zbuf, this.pixel);
    }

    @Override
    public void drawPoints(int n, int[] nArray, int n2) {
        if (n2 > 1) {
            float f = (float)(n2 * n2) * 0.8f;
            for (int i = -n2; i < n2; ++i) {
                for (int j = -n2; j < n2; ++j) {
                    if ((float)(i * i + j * j) > f) continue;
                    this.plotPoints(n, nArray, i, j);
                    this.plotPoints(n, nArray, i, j);
                }
            }
        } else {
            this.plotPoints(n, nArray, 0, 0);
        }
    }

    @Override
    public void drawDashedLineBits(int n, int n2, P3 p3, P3 p32) {
        this.line3d.plotDashedLineBits(this.argbCurrent, n, n2, p3, p32);
    }

    @Override
    public void drawDottedLineBits(P3 p3, P3 p32) {
        this.line3d.plotDashedLineBits(this.argbCurrent, 2, 1, p3, p32);
    }

    @Override
    public void drawLineXYZ(int n, int n2, int n3, int n4, int n5, int n6) {
        this.line3d.plotLineOld(this.argbCurrent, this.argbCurrent, n, n2, n3, n4, n5, n6, true);
    }

    @Override
    public void drawLine(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.setC(s)) {
            s = 0;
        }
        int n7 = this.argbCurrent;
        if (!this.setC(s2)) {
            s2 = 0;
        }
        if (s != 0 || s2 != 0) {
            this.line3d.plotLineOld(n7, this.argbCurrent, n, n2, n3, n4, n5, n6, true);
        }
    }

    @Override
    public void drawLineBits(short s, short s2, P3 p3, P3 p32) {
        if (!this.setC(s)) {
            s = 0;
        }
        int n = this.argbCurrent;
        if (!this.setC(s2)) {
            s2 = 0;
        }
        if (s != 0 || s2 != 0) {
            this.line3d.plotLineBits(n, this.argbCurrent, p3, p32);
        }
    }

    @Override
    public void drawLineAB(P3 p3, P3 p32) {
        this.line3d.plotLineBits(this.argbCurrent, this.argbCurrent, p3, p32);
    }

    @Override
    public void fillCylinderXYZ(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n > this.ht3) {
            return;
        }
        int n8 = 0;
        this.currentShadeIndex = 0;
        if (!this.setC(s2)) {
            s2 = 0;
        }
        if (this.wasScreened) {
            n8 = 2;
        }
        if (!this.setC(s)) {
            s = 0;
        }
        if (this.wasScreened) {
            ++n8;
        }
        if (s == 0 && s2 == 0) {
            return;
        }
        this.cylinder3d.renderOld(s, s2, n8, by, n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void fillCylinderScreen3I(byte by, int n, P3 p3, P3 p32, P3 p33, P3 p34, float f) {
        if (n <= this.ht3) {
            this.cylinder3d.renderOld(this.colixCurrent, this.colixCurrent, 0, by, n, (int)p3.x, (int)p3.y, (int)p3.z, (int)p32.x, (int)p32.y, (int)p32.z);
        }
    }

    @Override
    public void fillCylinder(byte by, int n, P3i p3i, P3i p3i2) {
        if (n <= this.ht3) {
            this.cylinder3d.renderOld(this.colixCurrent, this.colixCurrent, 0, by, n, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
        }
    }

    @Override
    public void fillCylinderBits(byte by, int n, P3 p3, P3 p32) {
        if (n <= this.ht3 && p3.z != 1.0f && p32.z != 1.0f) {
            this.cylinder3d.renderBits(this.colixCurrent, this.colixCurrent, 0, by, n, p3, p32);
        }
    }

    @Override
    public void fillCylinderBits2(short s, short s2, byte by, int n, P3 p3, P3 p32) {
        if (n > this.ht3) {
            return;
        }
        int n2 = 0;
        this.currentShadeIndex = 0;
        if (!this.setC(s2)) {
            s2 = 0;
        }
        if (this.wasScreened) {
            n2 = 2;
        }
        if (!this.setC(s)) {
            s = 0;
        }
        if (this.wasScreened) {
            ++n2;
        }
        if (s == 0 && s2 == 0) {
            return;
        }
        this.cylinder3d.renderBits(s, s2, n2, by, n, p3, p32);
    }

    @Override
    public void fillConeScreen3f(byte by, int n, P3 p3, P3 p32, boolean bl) {
        if (n <= this.ht3) {
            this.cylinder3d.renderConeOld(this.colixCurrent, by, n, p3.x, p3.y, p3.z, p32.x, p32.y, p32.z, true, bl);
        }
    }

    @Override
    public void drawHermite4(int n, P3 p3, P3 p32, P3 p33, P3 p34) {
        ((HermiteRenderer)this.hermite3d).renderHermiteRope(false, n, 0, 0, 0, p3, p32, p33, p34);
    }

    @Override
    public void drawHermite7(boolean bl, boolean bl2, int n, P3 p3, P3 p32, P3 p33, P3 p34, P3 p35, P3 p36, P3 p37, P3 p38, int n2, short s) {
        if (s == 0) {
            ((HermiteRenderer)this.hermite3d).renderHermiteRibbon(bl, bl2, n, p3, p32, p33, p34, p35, p36, p37, p38, n2, 0);
            return;
        }
        ((HermiteRenderer)this.hermite3d).renderHermiteRibbon(bl, bl2, n, p3, p32, p33, p34, p35, p36, p37, p38, n2, 1);
        short s2 = this.colixCurrent;
        this.setC(s);
        ((HermiteRenderer)this.hermite3d).renderHermiteRibbon(bl, bl2, n, p3, p32, p33, p34, p35, p36, p37, p38, n2, -1);
        this.setC(s2);
    }

    @Override
    public void fillHermite(int n, int n2, int n3, int n4, P3 p3, P3 p32, P3 p33, P3 p34) {
        ((HermiteRenderer)this.hermite3d).renderHermiteRope(true, n, n2, n3, n4, p3, p32, p33, p34);
    }

    @Override
    public void drawTriangle3C(P3i p3i, short s, P3i p3i2, short s2, P3i p3i3, short s3, int n) {
        if ((n & 1) == 1) {
            this.drawLine(s, s2, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
        }
        if ((n & 2) == 2) {
            this.drawLine(s2, s3, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
        }
        if ((n & 4) == 4) {
            this.drawLine(s, s3, p3i.x, p3i.y, p3i.z, p3i3.x, p3i3.y, p3i3.z);
        }
    }

    @Override
    public void fillTriangleTwoSided(short s, P3 p3, P3 p32, P3 p33) {
        this.setColorNoisy(this.getShadeIndex(s));
        ((TriangleRenderer)this.triangle3d).fillTriangleP3f(p3, p32, p33, false, true);
    }

    @Override
    public void fillTriangle3f(P3 p3, P3 p32, P3 p33, boolean bl) {
        int n = this.getShadeIndexP3(p3, p32, p33);
        if (bl) {
            this.setColorNoisy(n);
        } else {
            this.setColor(this.shadesCurrent[n]);
        }
        ((TriangleRenderer)this.triangle3d).fillTriangleP3f(p3, p32, p33, false, true);
    }

    @Override
    public void fillTriangle3i(P3 p3, P3 p32, P3 p33, T3 t3, T3 t32, T3 t33, boolean bl) {
        if (bl) {
            int n;
            V3 v3 = this.vectorAB;
            v3.set(p32.x - p3.x, p32.y - p3.y, p32.z - p3.z);
            if (p33 == null) {
                n = this.shader.getShadeIndex(-v3.x, -v3.y, v3.z);
            } else {
                this.vectorAC.set(p33.x - p3.x, p33.y - p3.y, p33.z - p3.z);
                v3.cross(v3, this.vectorAC);
                int n2 = n = v3.z >= 0.0f ? this.shader.getShadeIndex(-v3.x, -v3.y, v3.z) : this.shader.getShadeIndex(v3.x, v3.y, -v3.z);
            }
            if (n > 56) {
                n = 56;
            }
            this.setColorNoisy(n);
        }
        ((TriangleRenderer)this.triangle3d).fillTriangleP3f(p3, p32, p33, false, false);
    }

    @Override
    public void fillTriangle3CN(P3i p3i, short s, short s2, P3i p3i2, short s3, short s4, P3i p3i3, short s5, short s6) {
        ((TriangleRenderer)this.triangle3d).fillTriangleP3i(p3i, p3i2, p3i3, this.checkGouraud(s, s3, s5, s2, s4, s6));
    }

    @Override
    public void fillTriangle3CNBits(P3 p3, short s, short s2, P3 p32, short s3, short s4, P3 p33, short s5, short s6) {
        ((TriangleRenderer)this.triangle3d).fillTriangleP3f(p3, p32, p33, this.checkGouraud(s, s3, s5, s2, s4, s6), true);
    }

    private boolean checkGouraud(short s, short s2, short s3, short s4, short s5, short s6) {
        if (!this.isPass2 && s4 == s5 && s4 == s6 && s == s2 && s == s3) {
            int n = this.getShadeIndex(s4);
            if (s != this.colixCurrent || this.currentShadeIndex != n) {
                this.currentShadeIndex = -1;
                this.setC(s);
                this.setColorNoisy(n);
            }
            return false;
        }
        this.setTriangleTranslucency(s, s2, s3);
        ((TriangleRenderer)this.triangle3d).setGouraud(this.getShades(s)[this.getShadeIndex(s4)], this.getShades(s2)[this.getShadeIndex(s5)], this.getShades(s3)[this.getShadeIndex(s6)]);
        return true;
    }

    public int getShadeIndex(short s) {
        return s == -10000 || s == 9999 ? nullShadeIndex : (s < 0 ? this.shadeIndexes2Sided[~s] : this.shadeIndexes[s]);
    }

    private void setTriangleTranslucency(short s, short s2, short s3) {
        if (this.isPass2) {
            int n = s & 0x7800;
            int n2 = s2 & 0x7800;
            int n3 = s3 & 0x7800;
            int n4 = Graphics3D.roundInt(((n &= 0xFFFFBFFF) + (n2 &= 0xFFFFBFFF) + (n3 &= 0xFFFFBFFF)) / 3) & 0x7800;
            this.translucencyMask = n4 << 13 | 0xFFFFFF;
        }
    }

    @Override
    public void fillQuadrilateral(P3 p3, P3 p32, P3 p33, P3 p34) {
        int n = this.getShadeIndexP3(p3, p32, p33);
        this.setColorNoisy(n);
        ((TriangleRenderer)this.triangle3d).fillTriangleP3f(p3, p32, p33, false, true);
        ((TriangleRenderer)this.triangle3d).fillTriangleP3f(p3, p33, p34, false, true);
    }

    @Override
    public void drawSurface(MeshSurface meshSurface, short s) {
    }

    @Override
    public void plotPixelClippedP3i(P3i p3i) {
        this.plotPixelClippedArgb(this.argbCurrent, p3i.x, p3i.y, p3i.z, this.width, this.zbuf, this.pixel);
    }

    void plotPixelClippedArgb(int n, int n2, int n3, int n4, int n5, int[] nArray, Pixelator pixelator) {
        if (this.isClipped3(n2, n3, n4)) {
            return;
        }
        int n6 = n3 * n5 + n2;
        if (n4 < nArray[n6]) {
            pixelator.addPixel(n6, n4, n);
        }
    }

    void plotPixelUnclipped(int n, int n2, int n3, int n4, int n5, int[] nArray, Pixelator pixelator) {
        int n6 = n3 * n5 + n2;
        if (n4 < nArray[n6]) {
            pixelator.addPixel(n6, n4, n);
        }
    }

    @Override
    public void plotImagePixel(int n, int n2, int n3, int n4, byte by, int n5, int n6, int n7, int[] nArray, Object object, int n8) {
        if (n2 < 0 || n2 >= n6 || n3 < 0 || n3 >= n7) {
            return;
        }
        ((Pixelator)object).addImagePixel(by, n8, n3 * n6 + n2, n4, n, n5);
    }

    void plotPixelsClippedRaster(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162) {
        int n6;
        int n7;
        if (n <= 0 || n3 < 0 || n3 >= this.height || n2 >= this.width || n4 < (n7 = this.slab) && n5 < n7 || n4 > (n6 = this.depth) && n5 > n6) {
            return;
        }
        int[] nArray = this.zbuf;
        int n8 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        int n9 = (n4 << 10) + 512;
        int n10 = n5 - n4;
        int n11 = n / 2;
        int n12 = Graphics3D.roundInt(((n10 << 10) + (n10 >= 0 ? n11 : -n11)) / n);
        if (n2 < 0) {
            n2 = -n2;
            n9 += n12 * n2;
            if ((n -= n2) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n + n2 > this.width) {
            n = this.width - n2;
        }
        int n13 = n3 * this.width + n2;
        Pixelator pixelator = this.pixel;
        if (rgb16 == null) {
            int n14 = this.argbNoisyDn;
            int n15 = this.argbNoisyUp;
            int n16 = this.argbCurrent;
            while (--n >= 0) {
                int n17 = n9 >> 10;
                if (n17 >= n7 && n17 <= n6 && n17 < nArray[n13]) {
                    int n18 = (n8 = (n8 << 16) + (n8 << 1) + n8 & Integer.MAX_VALUE) >> 16 & 7;
                    pixelator.addPixel(n13, n17, n18 == 0 ? n14 : (n18 == 1 ? n15 : n16));
                }
                ++n13;
                n9 += n12;
            }
        } else {
            int n19 = rgb16.r << 8;
            int n20 = (rgb162.r - rgb16.r << 8) / n;
            int n21 = rgb16.g;
            int n22 = (rgb162.g - n21) / n;
            int n23 = rgb16.b;
            int n24 = (rgb162.b - n23) / n;
            while (--n >= 0) {
                int n25 = n9 >> 10;
                if (n25 >= n7 && n25 <= n6 && n25 < nArray[n13]) {
                    pixelator.addPixel(n13, n25, 0xFF000000 | n19 & 0xFF0000 | n21 & 0xFF00 | n23 >> 8 & 0xFF);
                }
                ++n13;
                n9 += n12;
                n19 += n20;
                n21 += n22;
                n23 += n24;
            }
        }
    }

    void plotPixelsUnclippedRaster(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162) {
        if (n <= 0) {
            return;
        }
        int n6 = ((n2 << 16) + (n3 << 1) ^ 0x33333333) & Integer.MAX_VALUE;
        int n7 = (n4 << 10) + 512;
        int n8 = n5 - n4;
        int n9 = n / 2;
        int n10 = Graphics3D.roundInt(((n8 << 10) + (n8 >= 0 ? n9 : -n9)) / n);
        int n11 = n3 * this.width + n2;
        int[] nArray = this.zbuf;
        Pixelator pixelator = this.pixel;
        if (rgb16 == null) {
            int n12 = this.argbNoisyDn;
            int n13 = this.argbNoisyUp;
            int n14 = this.argbCurrent;
            while (--n >= 0) {
                int n15 = n7 >> 10;
                if (n15 < nArray[n11]) {
                    int n16 = (n6 = (n6 << 16) + (n6 << 1) + n6 & Integer.MAX_VALUE) >> 16 & 7;
                    pixelator.addPixel(n11, n15, n16 == 0 ? n12 : (n16 == 1 ? n13 : n14));
                }
                ++n11;
                n7 += n10;
            }
        } else {
            int n17 = rgb16.r << 8;
            int n18 = Graphics3D.roundInt((rgb162.r - rgb16.r << 8) / n);
            int n19 = rgb16.g;
            int n20 = Graphics3D.roundInt((rgb162.g - n19) / n);
            int n21 = rgb16.b;
            int n22 = Graphics3D.roundInt((rgb162.b - n21) / n);
            while (--n >= 0) {
                int n23 = n7 >> 10;
                if (n23 < nArray[n11]) {
                    pixelator.addPixel(n11, n23, 0xFF000000 | n17 & 0xFF0000 | n19 & 0xFF00 | n21 >> 8 & 0xFF);
                }
                ++n11;
                n7 += n10;
                n17 += n18;
                n19 += n20;
                n21 += n22;
            }
        }
    }

    void plotPixelsClippedRasterBits(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162, float f, float f2) {
        int n6;
        int n7;
        if (n <= 0 || n3 < 0 || n3 >= this.height || n2 >= this.width || n4 < (n7 = this.slab) && n5 < n7 || n4 > (n6 = this.depth) && n5 > n6) {
            return;
        }
        int[] nArray = this.zbuf;
        int n8 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        if (n2 < 0) {
            if ((n -= (n2 = -n2)) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n + n2 > this.width) {
            n = this.width - n2;
        }
        int n9 = n3 * this.width + n2;
        Pixelator pixelator = this.pixel;
        if (rgb16 == null) {
            int n10 = this.argbNoisyDn;
            int n11 = this.argbNoisyUp;
            int n12 = this.argbCurrent;
            while (--n >= 0) {
                int n13;
                if ((n13 = this.line3d.getZCurrent(f, f2, n2++)) >= n7 && n13 <= n6 && n13 < nArray[n9]) {
                    int n14 = (n8 = (n8 << 16) + (n8 << 1) + n8 & Integer.MAX_VALUE) >> 16 & 7;
                    pixelator.addPixel(n9, n13, n14 < 2 ? n10 : (n14 < 6 ? n11 : n12));
                }
                ++n9;
            }
        } else {
            int n15 = rgb16.r << 8;
            int n16 = (rgb162.r - rgb16.r << 8) / n;
            int n17 = rgb16.g;
            int n18 = (rgb162.g - n17) / n;
            int n19 = rgb16.b;
            int n20 = (rgb162.b - n19) / n;
            while (--n >= 0) {
                int n21;
                if ((n21 = this.line3d.getZCurrent(f, f2, n2++)) >= n7 && n21 <= n6 && n21 < nArray[n9]) {
                    pixelator.addPixel(n9, n21, 0xFF000000 | n15 & 0xFF0000 | n17 & 0xFF00 | n19 >> 8 & 0xFF);
                }
                ++n9;
                n15 += n16;
                n17 += n18;
                n19 += n20;
            }
        }
    }

    void plotPixelsUnclippedRasterBits(int n, int n2, int n3, Rgb16 rgb16, Rgb16 rgb162, float f, float f2) {
        if (n <= 0) {
            return;
        }
        int n4 = ((n2 << 16) + (n3 << 1) ^ 0x33333333) & Integer.MAX_VALUE;
        int n5 = n3 * this.width + n2;
        int[] nArray = this.zbuf;
        Pixelator pixelator = this.pixel;
        if (rgb16 == null) {
            int n6 = this.argbNoisyDn;
            int n7 = this.argbNoisyUp;
            int n8 = this.argbCurrent;
            while (--n >= 0) {
                int n9;
                if ((n9 = this.line3d.getZCurrent(f, f2, n2++)) < nArray[n5]) {
                    int n10 = (n4 = (n4 << 16) + (n4 << 1) + n4 & Integer.MAX_VALUE) >> 16 & 7;
                    int n11 = n10 == 0 ? n6 : (n10 == 1 ? n7 : n8);
                    pixelator.addPixel(n5, n9, n11);
                }
                ++n5;
            }
        } else {
            int n12 = rgb16.r << 8;
            int n13 = Graphics3D.roundInt((rgb162.r - rgb16.r << 8) / n);
            int n14 = rgb16.g;
            int n15 = Graphics3D.roundInt((rgb162.g - n14) / n);
            int n16 = rgb16.b;
            int n17 = Graphics3D.roundInt((rgb162.b - n16) / n);
            while (--n >= 0) {
                int n18;
                if ((n18 = this.line3d.getZCurrent(f, f2, n2++)) < nArray[n5]) {
                    pixelator.addPixel(n5, n18, 0xFF000000 | n12 & 0xFF0000 | n14 & 0xFF00 | n16 >> 8 & 0xFF);
                }
                ++n5;
                n12 += n13;
                n14 += n15;
                n16 += n17;
            }
        }
    }

    void plotPixelsUnclippedCount(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, Pixelator pixelator) {
        int n7 = n4 * n6 + n3;
        while (--n2 >= 0) {
            if (n5 < nArray[n7]) {
                pixelator.addPixel(n7, n5, n);
            }
            ++n7;
        }
    }

    private void plotPoints(int n, int[] nArray, int n2, int n3) {
        Pixelator pixelator = this.pixel;
        int n4 = this.argbCurrent;
        int[] nArray2 = this.zbuf;
        int n5 = this.width;
        boolean bl = this.antialiasThisFrame;
        int n6 = n * 3;
        while (n6 > 0) {
            int n7;
            int n8;
            int n9;
            int n10 = nArray[--n6];
            --n6;
            if (this.isClipped3(n9 = nArray[--n6] + n2, n8 = nArray[n6] + n3, n10)) continue;
            if (n10 < nArray2[n7 = n8 * n5 + n9++]) {
                pixelator.addPixel(n7, n10, n4);
            }
            if (!bl) continue;
            n7 = n8 * n5 + n9;
            if (!this.isClipped3(n9, n8, n10) && n10 < nArray2[n7]) {
                pixelator.addPixel(n7, n10, n4);
            }
            n7 = ++n8 * n5 + n9;
            if (!this.isClipped3(n9, n8, n10) && n10 < nArray2[n7]) {
                pixelator.addPixel(n7, n10, n4);
            }
            n7 = n8 * n5 + --n9;
            if (this.isClipped3(n9, n8, n10) || n10 >= nArray2[n7]) continue;
            pixelator.addPixel(n7, n10, n4);
        }
    }

    void setColorNoisy(int n) {
        this.currentShadeIndex = n;
        this.argbCurrent = this.shadesCurrent[n];
        this.argbNoisyUp = this.shadesCurrent[n < 63 ? n + 1 : 63];
        this.argbNoisyDn = this.shadesCurrent[n > 0 ? n - 1 : 0];
    }

    private int getShadeIndexP3(P3 p3, P3 p32, P3 p33) {
        this.vectorAB.sub2(p32, p3);
        this.vectorAC.sub2(p33, p3);
        V3 v3 = this.vectorNormal;
        v3.cross(this.vectorAB, this.vectorAC);
        int n = v3.z >= 0.0f ? this.shader.getShadeIndex(-v3.x, -v3.y, v3.z) : this.shader.getShadeIndex(v3.x, v3.y, -v3.z);
        return n;
    }

    @Override
    public void renderBackground(JmolRendererInterface jmolRendererInterface) {
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, jmolRendererInterface, (short)0, 0, 0);
        }
    }

    @Override
    public void drawAtom(Atom atom) {
        this.fillSphereXYZ(atom.sD, atom.sX, atom.sY, atom.sZ);
    }

    @Override
    public int getExportType() {
        return 0;
    }

    @Override
    public String getExportName() {
        return null;
    }

    public boolean canDoTriangles() {
        return true;
    }

    public boolean isCartesianExport() {
        return false;
    }

    @Override
    public JmolRendererInterface initializeExporter(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        return null;
    }

    @Override
    public String finalizeOutput() {
        return null;
    }

    @Override
    public void drawBond(P3 p3, P3 p32, short s, short s2, byte by, short s3, int n) {
    }

    @Override
    public boolean drawEllipse(P3 p3, P3 p32, P3 p33, boolean bl, boolean bl2) {
        return false;
    }

    public double getPrivateKey() {
        return 0.0;
    }

    @Override
    public void clearFontCache() {
        TextRenderer.clearFontCache();
    }

    public void setRotationMatrix(M3 m3) {
        V3[] v3Array = Normix.getVertexVectors();
        int n = normixCount;
        while (--n >= 0) {
            V3 v3 = this.transformedVectors[n];
            m3.rotate2(v3Array[n], v3);
            this.shadeIndexes[n] = this.shader.getShadeB(v3.x, -v3.y, v3.z);
            this.shadeIndexes2Sided[n] = v3.z >= 0.0f ? this.shadeIndexes[n] : this.shader.getShadeB(-v3.x, v3.y, -v3.z);
        }
    }

    @Override
    public void renderCrossHairs(int[] nArray, int n, int n2, P3 p3, float f) {
        boolean bl = this.isAntialiased();
        this.setC((short)(f < 0.0f ? 10 : (f > 100.0f ? 11 : 23)));
        int n3 = Math.max(Math.min(this.width, Math.round(p3.x)), 0);
        int n4 = Math.max(Math.min(this.height, Math.round(p3.y)), 0);
        int n5 = Math.round(p3.z) + 1;
        int n6 = bl ? 8 : 4;
        int n7 = bl ? 20 : 10;
        int n8 = bl ? 2 : 1;
        this.drawRect(n3 - n6, n4, n5, 0, n7, n8);
        this.drawRect(n3, n4 - n6, n5, 0, n8, n7);
        this.drawRect(n3 - n6, n4 - n6, n5, 0, n7, n7);
        n6 = n7;
        this.setC((float)nArray[1] < p3.x ? (short)21 : 11);
        this.drawRect(n3 - n6, n4, n5, 0, n7 >>= 1, n8);
        this.setC((float)nArray[0] > p3.x ? (short)21 : 11);
        this.drawRect(n3 + n7, n4, n5, 0, n7, n8);
        this.setC((float)nArray[3] < p3.y ? (short)21 : 11);
        this.drawRect(n3, n4 - n6, n5, 0, n8, n7);
        this.setC((float)nArray[2] > p3.y ? (short)21 : 11);
        this.drawRect(n3, n4 + n7, n5, 0, n8, n7);
    }

    @Override
    public boolean initializeOutput(Viewer viewer, double d, Map<String, Object> map) {
        return false;
    }

    static {
        nullShadeIndex = (byte)50;
    }
}

