/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Category;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.patterns.FalseFriendPatternRule;
import org.languagetool.rules.patterns.XMLRuleHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class FalseFriendRuleHandler
extends XMLRuleHandler {
    private static final String TRANSLATION = "translation";
    private final ResourceBundle messages;
    private final MessageFormat formatter;
    private final Language textLanguage;
    private final Language motherTongue;
    private final Map<String, List<String>> suggestionMap = new HashMap<String, List<String>>();
    private final List<String> suggestions = new ArrayList<String>();
    private final List<StringBuilder> translations = new ArrayList<StringBuilder>();
    private boolean defaultOff;
    private Language language;
    private Language translationLanguage;
    private Language currentTranslationLanguage;
    private StringBuilder translation = new StringBuilder();
    private boolean inTranslation;

    FalseFriendRuleHandler(Language textLanguage, Language motherTongue) {
        this.messages = ResourceBundle.getBundle("org.languagetool.MessagesBundle", motherTongue.getLocale());
        this.formatter = new MessageFormat("");
        this.formatter.setLocale(motherTongue.getLocale());
        this.textLanguage = textLanguage;
        this.motherTongue = motherTongue;
    }

    public Map<String, List<String>> getSuggestionMap() {
        return this.suggestionMap;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("rule")) {
            this.translations.clear();
            this.id = attrs.getValue("id");
            if (!this.inRuleGroup || !this.defaultOff) {
                this.defaultOff = "off".equals(attrs.getValue("default"));
            }
            if (this.inRuleGroup && this.id == null) {
                this.id = this.ruleGroupId;
            }
            this.correctExamples = new ArrayList();
            this.incorrectExamples = new ArrayList();
        } else if (qName.equals("pattern")) {
            this.inPattern = true;
            String languageStr = attrs.getValue("lang");
            if (Languages.isLanguageSupported(languageStr)) {
                this.language = Languages.getLanguageForShortName(languageStr);
            }
        } else if (qName.equals("token")) {
            this.setToken(attrs);
        } else if (qName.equals(TRANSLATION)) {
            this.inTranslation = true;
            String languageStr = attrs.getValue("lang");
            if (Languages.isLanguageSupported(languageStr)) {
                Language tmpLang;
                this.currentTranslationLanguage = tmpLang = Languages.getLanguageForShortName(languageStr);
                if (tmpLang.equalsConsiderVariantsIfSpecified(this.motherTongue)) {
                    this.translationLanguage = tmpLang;
                }
            }
        } else if (qName.equals("example") && attrs.getValue("type").equals("correct")) {
            this.inCorrectExample = true;
            this.correctExample = new StringBuilder();
        } else if (qName.equals("example") && attrs.getValue("type").equals("incorrect")) {
            this.inIncorrectExample = true;
            this.incorrectExample = new StringBuilder();
        } else if (qName.equals("message")) {
            this.inMessage = true;
            this.message = new StringBuilder();
        } else if (qName.equals("rulegroup")) {
            this.ruleGroupId = attrs.getValue("id");
            this.inRuleGroup = true;
            this.defaultOff = "off".equals(attrs.getValue("default"));
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        switch (qName) {
            case "rule": {
                if (this.language.equalsConsiderVariantsIfSpecified(this.textLanguage) && this.translationLanguage != null && this.translationLanguage.equalsConsiderVariantsIfSpecified(this.motherTongue) && this.language != this.motherTongue && !this.translations.isEmpty()) {
                    this.formatter.applyPattern(this.messages.getString("false_friend_hint"));
                    String tokensAsString = StringUtils.join((Collection)this.patternTokens, (String)" ").replace('|', '/');
                    Object[] messageArguments = new Object[]{tokensAsString, this.messages.getString(this.textLanguage.getShortName()), this.formatTranslations(this.translations), this.messages.getString(this.motherTongue.getShortName())};
                    String description = this.formatter.format(messageArguments);
                    FalseFriendPatternRule rule = new FalseFriendPatternRule(this.id, this.language, this.patternTokens, this.messages.getString("false_friend_desc") + " " + tokensAsString, description, this.messages.getString("false_friend"));
                    rule.setCorrectExamples(this.correctExamples);
                    rule.setIncorrectExamples(this.incorrectExamples);
                    rule.setCategory(new Category(this.messages.getString("category_false_friend")));
                    if (this.defaultOff) {
                        rule.setDefaultOff();
                    }
                    this.rules.add(rule);
                }
                if (this.patternTokens == null) break;
                this.patternTokens.clear();
                break;
            }
            case "token": {
                this.finalizeTokens();
                break;
            }
            case "pattern": {
                this.inPattern = false;
                break;
            }
            case "translation": {
                if (this.currentTranslationLanguage != null && this.currentTranslationLanguage.equalsConsiderVariantsIfSpecified(this.motherTongue)) {
                    this.translations.add(this.translation);
                }
                if (this.currentTranslationLanguage != null && this.currentTranslationLanguage.equalsConsiderVariantsIfSpecified(this.textLanguage) && this.language.equalsConsiderVariantsIfSpecified(this.motherTongue)) {
                    this.suggestions.add(this.translation.toString());
                }
                this.translation = new StringBuilder();
                this.inTranslation = false;
                this.currentTranslationLanguage = null;
                break;
            }
            case "example": {
                if (this.inCorrectExample) {
                    this.correctExamples.add(this.correctExample.toString());
                } else if (this.inIncorrectExample) {
                    this.incorrectExamples.add(new IncorrectExample(this.incorrectExample.toString()));
                }
                this.inCorrectExample = false;
                this.inIncorrectExample = false;
                this.correctExample = new StringBuilder();
                this.incorrectExample = new StringBuilder();
                break;
            }
            case "message": {
                this.inMessage = false;
                break;
            }
            case "rulegroup": {
                if (!this.suggestions.isEmpty()) {
                    ArrayList<String> l = new ArrayList<String>(this.suggestions);
                    this.suggestionMap.put(this.id, l);
                    this.suggestions.clear();
                }
                this.inRuleGroup = false;
            }
        }
    }

    private String formatTranslations(List<StringBuilder> translations) {
        return translations.stream().map(o -> "\"" + o + "\"").collect(Collectors.joining(", "));
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.inToken && this.inPattern) {
            this.elements.append(s);
        } else if (this.inCorrectExample) {
            this.correctExample.append(s);
        } else if (this.inIncorrectExample) {
            this.incorrectExample.append(s);
        } else if (this.inTranslation) {
            this.translation.append(s);
        }
    }
}

