/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.alternatemix;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.alternatemix.AlternateMixParametersBuilder;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.support.validation.Validators;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;

class AlternateMixOptionsPane
extends VBox
implements TaskParametersBuildStep<AlternateMixParametersBuilder>,
RestorableView {
    private CheckBox reverseFirst = new CheckBox(DefaultI18nContext.getInstance().i18n("Reverse the first document"));
    private CheckBox reverseSecond = new CheckBox(DefaultI18nContext.getInstance().i18n("Reverse the second document"));
    private ValidableTextField firstStep = AlternateMixOptionsPane.createValidableField();
    private ValidableTextField secondStep = AlternateMixOptionsPane.createValidableField();

    AlternateMixOptionsPane() {
        super(5.0);
        this.reverseFirst.setId("reverseFirst");
        this.reverseSecond.setId("reverseSecond");
        this.reverseSecond.setSelected(true);
        this.firstStep.setId("alternateMixFirstStep");
        this.secondStep.setId("alternateMixSecondStep");
        this.initialState();
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        HBox firstStepContainer = new HBox(new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Switch from the first document to the second one after the following pages")), this.firstStep});
        firstStepContainer.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        HBox secondStepContainer = new HBox(new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Switch from the second document to the first one after the following pages")), this.secondStep});
        secondStepContainer.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{this.reverseFirst, this.reverseSecond, firstStepContainer, secondStepContainer});
    }

    void setFirstDocumentMaxPages(Integer value) {
        this.firstStep.setValidator(Validators.positiveIntRange(1, value));
    }

    void setSecondDocumentMaxPages(Integer value) {
        this.secondStep.setValidator(Validators.positiveIntRange(1, value));
    }

    @Override
    public void apply(AlternateMixParametersBuilder builder, Consumer<String> onError) {
        builder.reverseFirst(this.reverseFirst.isSelected());
        builder.reverseSecond(this.reverseSecond.isSelected());
        this.firstStep.validate();
        this.secondStep.validate();
        if (this.firstStep.getValidationState() == FXValidationSupport.ValidationState.VALID && this.secondStep.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.stepFirst(Integer.parseInt(this.firstStep.getText()));
            builder.stepSecond(Integer.parseInt(this.secondStep.getText()));
        } else {
            onError.accept(DefaultI18nContext.getInstance().i18n("Invalid parameter 'first and second step' must be numbers"));
        }
    }

    private static ValidableTextField createValidableField() {
        ValidableTextField field = new ValidableTextField();
        field.setEnableInvalidStyle(true);
        field.setErrorMessage(DefaultI18nContext.getInstance().i18n("Select a valid number of pages"));
        field.setValidator(Validators.positiveInteger());
        field.setOnEnterValidation(true);
        field.setPrefWidth(50.0);
        return field;
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put("reverseFirst", Boolean.toString(this.reverseFirst.isSelected()));
        data.put("reverseSecond", Boolean.toString(this.reverseSecond.isSelected()));
        data.put("firstStep", StringUtils.defaultString(this.firstStep.getText()));
        data.put("secondStep", StringUtils.defaultString(this.secondStep.getText()));
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        this.reverseFirst.setSelected(Boolean.valueOf(data.get("reverseFirst")).booleanValue());
        this.reverseSecond.setSelected(Boolean.valueOf(data.get("reverseSecond")).booleanValue());
        this.firstStep.setText(Optional.ofNullable(data.get("firstStep")).orElse(""));
        this.secondStep.setText(Optional.ofNullable(data.get("secondStep")).orElse(""));
    }

    private void initialState() {
        this.reverseFirst.setSelected(false);
        this.reverseSecond.setSelected(true);
        this.firstStep.setText("1");
        this.secondStep.setText("1");
    }
}

