/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui;

import javafx.animation.FadeTransition;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.news.HideNewsPanelRequest;
import org.pdfsam.news.ShowNewsPanelRequest;
import org.pdfsam.ui.dashboard.Dashboard;
import org.pdfsam.ui.event.SetActiveDashboardItemRequest;
import org.pdfsam.ui.event.SetActiveModuleRequest;
import org.pdfsam.ui.news.NewsPanel;
import org.pdfsam.ui.workarea.WorkArea;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

@Named
public class ContentPane
extends HBox {
    private WorkArea modules;
    private Dashboard dashboard;
    private VBox newsContainer;
    private FadeTransition fadeIn;
    private FadeTransition fadeOut;

    @Inject
    public ContentPane(WorkArea modules, Dashboard dashboard, NewsPanel news, @Named(value="defaultDashboardItemId") String defaultDasboardItem) {
        this.modules = modules;
        this.dashboard = dashboard;
        this.newsContainer = new VBox(new Node[]{news});
        this.newsContainer.getStyleClass().add((Object)"news-container");
        StackPane stack = new StackPane(new Node[]{modules, dashboard});
        ContentPane.setHgrow((Node)stack, (Priority)Priority.ALWAYS);
        this.newsContainer.managedProperty().bind((ObservableValue)this.newsContainer.visibleProperty());
        this.newsContainer.setVisible(false);
        this.fadeIn = new FadeTransition(new Duration(300.0), (Node)this.newsContainer);
        this.fadeIn.setFromValue(0.0);
        this.fadeIn.setToValue(1.0);
        this.fadeOut = new FadeTransition(new Duration(300.0), (Node)this.newsContainer);
        this.fadeOut.setFromValue(1.0);
        this.fadeOut.setToValue(0.0);
        this.fadeOut.setOnFinished(e -> this.newsContainer.setVisible(false));
        this.getChildren().addAll((Object[])new Node[]{stack, this.newsContainer});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        StaticStudio.eventStudio().broadcast(new SetActiveDashboardItemRequest(defaultDasboardItem));
    }

    @EventListener(priority=-2147483648)
    public void onSetActiveModule(SetActiveModuleRequest request) {
        this.dashboard.setVisible(false);
        this.modules.setVisible(true);
    }

    @EventListener(priority=-2147483648)
    public void onSetActiveDashboardItem(SetActiveDashboardItemRequest request) {
        this.dashboard.setVisible(true);
        this.modules.setVisible(false);
    }

    @EventListener(priority=-2147483648)
    public void onShowNewsPanel(ShowNewsPanelRequest request) {
        if (!this.newsContainer.isVisible()) {
            this.newsContainer.setVisible(true);
            this.fadeIn.play();
        }
    }

    @EventListener(priority=-2147483648)
    public void onHideNewsPanel(HideNewsPanelRequest request) {
        if (this.newsContainer.isVisible()) {
            this.fadeOut.play();
        }
    }
}

