/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import java.util.HashMap;
import java.util.List;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.ui.event.SetActiveModuleRequest;
import org.sejda.eventstudio.StaticStudio;

@Named
class ModulesMenu
extends Menu {
    @Inject
    private List<Module> modules;

    ModulesMenu() {
        super(DefaultI18nContext.getInstance().i18n("_Modules"));
    }

    @PostConstruct
    void initModulesMenu() {
        this.setId("modulesMenu");
        HashMap<ModuleCategory, Menu> moduleSubmenus = new HashMap<ModuleCategory, Menu>();
        for (Module currentModule : this.modules) {
            ModuleCategory category = currentModule.descriptor().getCategory();
            Menu currentMenu = (Menu)moduleSubmenus.get((Object)category);
            if (currentMenu == null) {
                currentMenu = new Menu(category.getDescription());
                moduleSubmenus.put(category, currentMenu);
            }
            MenuItem moduleMenu = new MenuItem(currentModule.descriptor().getName());
            moduleMenu.setOnAction(e -> StaticStudio.eventStudio().broadcast(SetActiveModuleRequest.activeteModule(currentModule.id())));
            currentMenu.getItems().add((Object)moduleMenu);
        }
        this.getItems().addAll(moduleSubmenus.values());
    }
}

