/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.function.Function;
import org.bouncycastle.util.Arrays;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.encryption.ARC4Engine;
import org.sejda.sambox.encryption.ConcatenatingAESEngine;
import org.sejda.sambox.encryption.EncryptionAlgorithmEngine;
import org.sejda.sambox.encryption.EncryptionException;
import org.sejda.sambox.encryption.GeneralEncryptionAlgorithm;
import org.sejda.sambox.encryption.MessageDigests;
import org.sejda.util.RequireUtils;

class Algorithm1
implements GeneralEncryptionAlgorithm {
    private static final byte[] AES_SALT = new byte[]{115, 65, 108, 84};
    private EncryptionAlgorithmEngine engine;
    private MessageDigest digest = MessageDigests.md5();
    private Function<COSObjectKey, byte[]> keyCalculator;
    private Function<byte[], byte[]> md5Initializer;
    private Function<byte[], byte[]> md5ToKey;
    private COSObjectKey currentCOSObjectKey;

    private Algorithm1(EncryptionAlgorithmEngine engine, byte[] key) {
        RequireUtils.requireNotNullArg(engine, "Encryption engine cannot be null");
        RequireUtils.requireArg(key != null && key.length > 0, "Encryption key cannot be blank");
        this.engine = engine;
        this.keyCalculator = cosKey -> {
            RequireUtils.requireNotNullArg(cosKey, "Cannot encrypt a reference with a null key");
            byte[] append = new byte[]{(byte)(cosKey.objectNumber() & 0xFFL), (byte)(cosKey.objectNumber() >> 8 & 0xFFL), (byte)(cosKey.objectNumber() >> 16 & 0xFFL), (byte)(cosKey.generation() & 0xFF), (byte)(cosKey.generation() >> 8 & 0xFF)};
            return Arrays.concatenate(key, append);
        };
        this.md5Initializer = newKey -> {
            this.digest.reset();
            this.digest.update((byte[])newKey);
            return newKey;
        };
        this.md5ToKey = newKey -> java.util.Arrays.copyOf(this.digest.digest(), Math.min(((byte[])newKey).length, 16));
    }

    @Override
    public void setCurrentCOSObjectKey(COSObjectKey currentCOSObjectKey) {
        this.currentCOSObjectKey = currentCOSObjectKey;
    }

    @Override
    public void visit(COSString value) {
        if (value.encryptable()) {
            this.requireObjectKey();
            value.setValue(this.engine.encryptBytes(value.getBytes(), this.keyCalculator.andThen(this.md5Initializer).andThen(this.md5ToKey).apply(this.currentCOSObjectKey)));
        }
    }

    @Override
    public void visit(COSStream value) {
        if (value.encryptable()) {
            this.requireObjectKey();
            value.setEncryptor(i -> this.engine.encryptStream((InputStream)i, this.keyCalculator.andThen(this.md5Initializer).andThen(this.md5ToKey).apply(this.currentCOSObjectKey)));
        }
    }

    private void requireObjectKey() {
        if (Objects.isNull(this.currentCOSObjectKey)) {
            throw new EncryptionException("General encryption algorithm 1 requires object number and generation number");
        }
    }

    static Algorithm1 withAESEngine(byte[] key) {
        Algorithm1 algorithm = new Algorithm1(new ConcatenatingAESEngine(), key);
        algorithm.md5Initializer = algorithm.md5Initializer.andThen(k -> {
            algorithm.digest.update(AES_SALT);
            return k;
        });
        return algorithm;
    }

    static Algorithm1 withARC4Engine(byte[] key) {
        return new Algorithm1(new ARC4Engine(), key);
    }
}

