/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class DCTFilter
extends Filter {
    private static final Logger LOG = LoggerFactory.getLogger(DCTFilter.class);

    DCTFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        ImageReader reader = DCTFilter.findImageReader("JPEG", "a suitable JAI I/O image filter is not installed");
        ImageInputStream iis = null;
        try {
            Raster raster;
            iis = ImageIO.createImageInputStream(encoded);
            if (iis.read() != 10) {
                iis.seek(0L);
            }
            reader.setInput(iis);
            String numChannels = this.getNumChannels(reader);
            ImageIO.setUseCache(false);
            if ("3".equals(numChannels) || numChannels.isEmpty()) {
                try {
                    BufferedImage image = reader.read(0);
                    raster = image.getRaster();
                }
                catch (IIOException e) {
                    raster = reader.readRaster(0, null);
                }
            } else {
                raster = reader.readRaster(0, null);
            }
            if (raster.getNumBands() == 4) {
                Integer transform;
                try {
                    transform = this.getAdobeTransform(reader.getImageMetadata(0));
                }
                catch (IIOException e) {
                    try {
                        Field field = reader.getClass().getDeclaredField("colorSpaceCode");
                        field.setAccessible(true);
                        int colorSpaceCode = field.getInt(reader);
                        if (colorSpaceCode == 7 || colorSpaceCode == 8 || colorSpaceCode == 9 || colorSpaceCode == 11) {
                            transform = 2;
                        }
                        if (colorSpaceCode == 4) {
                            transform = 0;
                        }
                        throw new IOException("Unexpected color space: " + colorSpaceCode);
                    }
                    catch (NoSuchFieldException e1) {
                        throw e;
                    }
                    catch (IllegalAccessException e1) {
                        throw e;
                    }
                }
                int colorTransform = transform != null ? transform : 0;
                switch (colorTransform) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        LOG.warn("YCbCr JPEGs not implemented");
                        break;
                    }
                    case 2: {
                        raster = this.fromYCCKtoCMYK(raster);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown colorTransform");
                    }
                }
            } else if (raster.getNumBands() == 3) {
                raster = this.fromBGRtoRGB(raster);
            }
            DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
            decoded.write(dataBuffer.getData());
        }
        finally {
            if (iis != null) {
                iis.close();
            }
            reader.dispose();
        }
        return new DecodeResult(parameters);
    }

    private Integer getAdobeTransform(IIOMetadata metadata) {
        Element tree = (Element)metadata.getAsTree("javax_imageio_jpeg_image_1.0");
        Element markerSequence = (Element)tree.getElementsByTagName("markerSequence").item(0);
        NodeList app14AdobeNodeList = markerSequence.getElementsByTagName("app14Adobe");
        if (app14AdobeNodeList != null && app14AdobeNodeList.getLength() > 0) {
            Element adobe = (Element)app14AdobeNodeList.item(0);
            return Integer.parseInt(adobe.getAttribute("transform"));
        }
        return 0;
    }

    private WritableRaster fromYCCKtoCMYK(Raster raster) {
        WritableRaster writableRaster = raster.createCompatibleWritableRaster();
        int[] value = new int[4];
        int height = raster.getHeight();
        for (int y = 0; y < height; ++y) {
            int width = raster.getWidth();
            for (int x = 0; x < width; ++x) {
                raster.getPixel(x, y, value);
                float Y = value[0];
                float Cb = value[1];
                float Cr = value[2];
                float K = value[3];
                int r = this.clamp(Y + 1.402f * Cr - 179.456f);
                int g = this.clamp(Y - 0.34414f * Cb - 0.71414f * Cr + 135.45984f);
                int b = this.clamp(Y + 1.772f * Cb - 226.816f);
                int cyan = 255 - r;
                int magenta = 255 - g;
                int yellow = 255 - b;
                value[0] = cyan;
                value[1] = magenta;
                value[2] = yellow;
                value[3] = (int)K;
                writableRaster.setPixel(x, y, value);
            }
        }
        return writableRaster;
    }

    private WritableRaster fromBGRtoRGB(Raster raster) {
        WritableRaster writableRaster = raster.createCompatibleWritableRaster();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int w3 = width * 3;
        int[] tab = new int[w3];
        for (int y = 0; y < height; ++y) {
            raster.getPixels(0, y, width, 1, tab);
            for (int off = 0; off < w3; off += 3) {
                int tmp = tab[off];
                tab[off] = tab[off + 2];
                tab[off + 2] = tmp;
            }
            writableRaster.setPixels(0, y, width, 1, tab);
        }
        return writableRaster;
    }

    private String getNumChannels(ImageReader reader) {
        try {
            IIOMetadata imageMetadata = reader.getImageMetadata(0);
            if (imageMetadata == null) {
                return "";
            }
            IIOMetadataNode metaTree = (IIOMetadataNode)imageMetadata.getAsTree("javax_imageio_1.0");
            Element numChannelsItem = (Element)metaTree.getElementsByTagName("NumChannels").item(0);
            if (numChannelsItem == null) {
                return "";
            }
            return numChannelsItem.getAttribute("value");
        }
        catch (IOException e) {
            return "";
        }
    }

    private int clamp(float value) {
        return (int)(value < 0.0f ? 0.0f : (value > 255.0f ? 255.0f : value));
    }

    @Override
    public void encode(InputStream input, OutputStream encoded, COSDictionary parameters) {
        throw new UnsupportedOperationException("DCTFilter encoding not implemented, use the JPEGFactory methods instead");
    }
}

