/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.util;

import java.io.IOException;
import java.util.regex.Pattern;
import org.sejda.util.RequireUtils;

public class SpecVersionUtils {
    public static final int EXPECTED_HEADER_LENGTH = 8;
    public static final String PDF_HEADER = "%PDF-";
    public static final String V1_0 = "1.0";
    public static final String V1_1 = "1.1";
    public static final String V1_2 = "1.2";
    public static final String V1_3 = "1.3";
    public static final String V1_4 = "1.4";
    public static final String V1_5 = "1.5";
    public static final String V1_6 = "1.6";
    public static final String V1_7 = "1.7";
    public static final String V2_0 = "2.0";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)$");

    private SpecVersionUtils() {
    }

    public static String parseHeaderString(String header) throws IOException {
        String version = header.substring(5, 8);
        if (!VERSION_PATTERN.matcher(version).matches()) {
            throw new IOException("Unable to get header version from " + header);
        }
        return version;
    }

    public static boolean isAtLeast(String version, String atLeast) {
        RequireUtils.requireNotNullArg(version, "Cannot compare a null version");
        RequireUtils.requireNotNullArg(atLeast, "Cannot compare a null version");
        return version.compareTo(atLeast) >= 0;
    }
}

