/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.xref;

import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.xref.CompressedXrefEntry;
import org.sejda.sambox.xref.XrefType;
import org.sejda.util.RequireUtils;

public class XrefEntry {
    private static final String XREFTABLE_ENTRY_FORMAT = "%010d %05d %c\r\n";
    public static final XrefEntry DEFAULT_FREE_ENTRY = XrefEntry.freeEntry(0L, 65535);
    public static final long UNKNOWN_OFFSET = -1L;
    private XrefType type;
    private COSObjectKey key;
    private long byteOffset;

    XrefEntry(XrefType type, long objectNumber, long byteOffset, int generationNumber) {
        RequireUtils.requireArg(objectNumber >= 0L && generationNumber >= 0, "Object number and generation number cannot be negative");
        this.type = type;
        this.key = new COSObjectKey(objectNumber, generationNumber);
        this.byteOffset = byteOffset;
    }

    public XrefType getType() {
        return this.type;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(long byteOffset) {
        this.byteOffset = byteOffset;
    }

    public long getObjectNumber() {
        return this.key.objectNumber();
    }

    public int getGenerationNumber() {
        return this.key.generation();
    }

    public boolean isUnknownOffset() {
        return this.byteOffset <= -1L;
    }

    public COSObjectKey key() {
        return this.key;
    }

    public boolean owns(XrefEntry entry) {
        return entry != null && entry.getType() == XrefType.COMPRESSED && this.key.objectNumber() == ((CompressedXrefEntry)entry).getObjectStreamNumber();
    }

    public String toString() {
        return String.format("%s offset=%d, %s", this.type.toString(), this.byteOffset, this.key.toString());
    }

    public String toXrefTableEntry() {
        switch (this.type) {
            case IN_USE: {
                return String.format(XREFTABLE_ENTRY_FORMAT, this.getByteOffset(), this.getGenerationNumber(), Character.valueOf('n'));
            }
            case FREE: {
                return String.format(XREFTABLE_ENTRY_FORMAT, this.getObjectNumber(), this.getGenerationNumber(), Character.valueOf('f'));
            }
        }
        throw new IllegalArgumentException("Only in_use and free entries can be written to an xref table");
    }

    public byte[] toXrefStreamEntry(int secondFieldLength, int thirdFieldLength) {
        byte[] retVal = new byte[1 + secondFieldLength + thirdFieldLength];
        if (this.type == XrefType.FREE) {
            retVal[0] = 0;
            this.copyBytesTo(this.key.objectNumber(), secondFieldLength, retVal, 1);
            this.copyBytesTo(this.key.generation(), thirdFieldLength, retVal, 1 + secondFieldLength);
            return retVal;
        }
        retVal[0] = 1;
        this.copyBytesTo(this.byteOffset, secondFieldLength, retVal, 1);
        this.copyBytesTo(this.key.generation(), thirdFieldLength, retVal, 1 + secondFieldLength);
        return retVal;
    }

    protected void copyBytesTo(long data, int length, byte[] destination, int destinationIndex) {
        for (int i = 0; i < length; ++i) {
            destination[length + destinationIndex - i - 1] = (byte)(data & 0xFFL);
            data >>= 8;
        }
    }

    public static XrefEntry inUseEntry(long objectNumber, long byteOffset, int generationNumber) {
        return new XrefEntry(XrefType.IN_USE, objectNumber, byteOffset, generationNumber);
    }

    public static XrefEntry unknownOffsetEntry(long objectNumber, int generationNumber) {
        return new XrefEntry(XrefType.IN_USE, objectNumber, -1L, generationNumber);
    }

    public static XrefEntry freeEntry(long objectNumber, int generationNumber) {
        return new XrefEntry(XrefType.FREE, objectNumber, -1L, generationNumber);
    }
}

