/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.AspectJPrecedenceInformation;
import org.springframework.aop.aspectj.InstantiationModelAwarePointcutAdvisor;
import org.springframework.aop.aspectj.annotation.AbstractAspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.LazySingletonAspectInstanceFactoryDecorator;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.aop.support.DynamicMethodMatcherPointcut;
import org.springframework.aop.support.Pointcuts;

class InstantiationModelAwarePointcutAdvisorImpl
implements InstantiationModelAwarePointcutAdvisor,
AspectJPrecedenceInformation {
    private final AspectJExpressionPointcut declaredPointcut;
    private Pointcut pointcut;
    private final MetadataAwareAspectInstanceFactory aspectInstanceFactory;
    private final Method method;
    private final boolean lazy;
    private final AspectJAdvisorFactory atAspectJAdvisorFactory;
    private Advice instantiatedAdvice;
    private int declarationOrder;
    private String aspectName;
    private Boolean isBeforeAdvice;
    private Boolean isAfterAdvice;

    public InstantiationModelAwarePointcutAdvisorImpl(AspectJAdvisorFactory af, AspectJExpressionPointcut ajexp, MetadataAwareAspectInstanceFactory aif, Method method, int declarationOrderInAspect, String aspectName) {
        this.declaredPointcut = ajexp;
        this.method = method;
        this.atAspectJAdvisorFactory = af;
        this.aspectInstanceFactory = aif;
        this.declarationOrder = declarationOrderInAspect;
        this.aspectName = aspectName;
        if (aif.getAspectMetadata().isLazilyInstantiated()) {
            Pointcut preInstantiationPointcut = Pointcuts.union(aif.getAspectMetadata().getPerClausePointcut(), this.declaredPointcut);
            this.pointcut = new PerTargetInstantiationModelPointcut(this.declaredPointcut, preInstantiationPointcut, aif);
            this.lazy = true;
        } else {
            this.instantiatedAdvice = this.instantiateAdvice(this.declaredPointcut);
            this.pointcut = this.declaredPointcut;
            this.lazy = false;
        }
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    @Override
    public boolean isPerInstance() {
        return this.getAspectMetadata().getAjType().getPerClause().getKind() != PerClauseKind.SINGLETON;
    }

    public AspectMetadata getAspectMetadata() {
        return this.aspectInstanceFactory.getAspectMetadata();
    }

    @Override
    public synchronized Advice getAdvice() {
        if (this.instantiatedAdvice == null) {
            this.instantiatedAdvice = this.instantiateAdvice(this.declaredPointcut);
        }
        return this.instantiatedAdvice;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public synchronized boolean isAdviceInstantiated() {
        return this.instantiatedAdvice != null;
    }

    private Advice instantiateAdvice(AspectJExpressionPointcut pcut) {
        return this.atAspectJAdvisorFactory.getAdvice(this.method, pcut, this.aspectInstanceFactory, this.declarationOrder, this.aspectName);
    }

    public MetadataAwareAspectInstanceFactory getAspectInstanceFactory() {
        return this.aspectInstanceFactory;
    }

    public AspectJExpressionPointcut getDeclaredPointcut() {
        return this.declaredPointcut;
    }

    @Override
    public int getOrder() {
        return this.aspectInstanceFactory.getOrder();
    }

    @Override
    public String getAspectName() {
        return this.aspectName;
    }

    @Override
    public int getDeclarationOrder() {
        return this.declarationOrder;
    }

    @Override
    public boolean isBeforeAdvice() {
        if (this.isBeforeAdvice == null) {
            this.determineAdviceType();
        }
        return this.isBeforeAdvice;
    }

    @Override
    public boolean isAfterAdvice() {
        if (this.isAfterAdvice == null) {
            this.determineAdviceType();
        }
        return this.isAfterAdvice;
    }

    private void determineAdviceType() {
        AbstractAspectJAdvisorFactory.AspectJAnnotation<?> aspectJAnnotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(this.method);
        if (aspectJAnnotation == null) {
            this.isBeforeAdvice = false;
            this.isAfterAdvice = false;
        } else {
            switch (aspectJAnnotation.getAnnotationType()) {
                case AtAfter: 
                case AtAfterReturning: 
                case AtAfterThrowing: {
                    this.isAfterAdvice = true;
                    this.isBeforeAdvice = false;
                    break;
                }
                case AtAround: 
                case AtPointcut: {
                    this.isAfterAdvice = false;
                    this.isBeforeAdvice = false;
                    break;
                }
                case AtBefore: {
                    this.isAfterAdvice = false;
                    this.isBeforeAdvice = true;
                }
            }
        }
    }

    public String toString() {
        return "InstantiationModelAwarePointcutAdvisor: expression [" + this.getDeclaredPointcut().getExpression() + "]; advice method [" + this.method + "]; perClauseKind=" + this.aspectInstanceFactory.getAspectMetadata().getAjType().getPerClause().getKind();
    }

    private class PerTargetInstantiationModelPointcut
    extends DynamicMethodMatcherPointcut {
        private final AspectJExpressionPointcut declaredPointcut;
        private final Pointcut preInstantiationPointcut;
        private LazySingletonAspectInstanceFactoryDecorator aspectInstanceFactory;

        private PerTargetInstantiationModelPointcut(AspectJExpressionPointcut declaredPointcut, Pointcut preInstantiationPointcut, MetadataAwareAspectInstanceFactory aspectInstanceFactory) {
            this.declaredPointcut = declaredPointcut;
            this.preInstantiationPointcut = preInstantiationPointcut;
            if (aspectInstanceFactory instanceof LazySingletonAspectInstanceFactoryDecorator) {
                this.aspectInstanceFactory = (LazySingletonAspectInstanceFactoryDecorator)aspectInstanceFactory;
            }
        }

        @Override
        public boolean matches(Method method, Class<?> targetClass) {
            return this.isAspectMaterialized() && this.declaredPointcut.matches(method, targetClass) || this.preInstantiationPointcut.getMethodMatcher().matches(method, targetClass);
        }

        @Override
        public boolean matches(Method method, Class<?> targetClass, Object[] args) {
            return this.isAspectMaterialized() && this.declaredPointcut.matches(method, targetClass);
        }

        private boolean isAspectMaterialized() {
            return this.aspectInstanceFactory == null || this.aspectInstanceFactory.isMaterialized();
        }
    }
}

