/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.facet;

import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Priority;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.FirstRunFacet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.relation.facet.LineDescriptionPositionFacet;
import com.baselet.element.relation.facet.LineDescriptionUtils;
import com.baselet.element.relation.facet.SettingsRelation;
import com.baselet.element.relation.helper.LineDescriptionEnum;
import com.baselet.element.relation.helper.RelationPointHandler;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LineDescriptionFacet
extends FirstRunFacet {
    static final int X_DIST_TO_LINE = 4;
    static final int LOWER_Y_DIST_TO_LINE = 1;
    static final int UPPER_Y_DIST_TO_LINE = 5;
    static final int MIDDLE_DISTANCE_TO_LINE = 4;
    public static final LineDescriptionFacet INSTANCE = new LineDescriptionFacet();

    private LineDescriptionFacet() {
    }

    @Override
    public boolean checkStart(String line, PropertiesParserState state) {
        return !line.startsWith("lt=");
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Arrays.asList(new AutocompletionText(LineDescriptionEnum.MESSAGE_START.getKey() + "=", "message at start"), new AutocompletionText(LineDescriptionEnum.MESSAGE_END.getKey() + "=", "message at end"), new AutocompletionText(LineDescriptionEnum.ROLE_START.getKey() + "=", "role at start"), new AutocompletionText(LineDescriptionEnum.ROLE_END.getKey() + "=", "role at end"));
    }

    @Override
    public void handleLine(String line, PropertiesParserState state) {
    }

    private RelationPointHandler getRelationPoints(PropertiesParserState state) {
        return ((SettingsRelation)state.getSettings()).getRelationPoints();
    }

    private void printAndUpdateIndex(DrawHandler drawer, RelationPointHandler relationPoints, PointDouble pointText, int index, String text, Point displacement, Set<Integer> usedIndexes) {
        if (displacement != null) {
            pointText = new PointDouble(pointText.getX() + (double)displacement.getX(), pointText.getY() + (double)displacement.getY());
        }
        this.printAndUpdateIndex(drawer, relationPoints, pointText, index, text, usedIndexes);
    }

    private void printAndUpdateIndex(DrawHandler drawer, RelationPointHandler relationPoints, PointDouble pointText, int index, String text, Set<Integer> usedIndexes) {
        drawer.print(text, pointText, AlignHorizontal.LEFT);
        relationPoints.setTextBox(index, new Rectangle(pointText.getX(), pointText.getY() - drawer.textHeightMax(), drawer.textWidth(text), drawer.textHeightMax()));
        usedIndexes.add(index);
    }

    @Override
    public void parsingFinished(PropertiesParserState state, List<String> handledLines) {
        Map displacements = state.getOrInitFacetResponse(LineDescriptionPositionFacet.class, new HashMap());
        RelationPointHandler relationPoints = this.getRelationPoints(state);
        DrawHandler drawer = state.getDrawer();
        HashSet<Integer> usedIndexes = new HashSet<Integer>();
        ArrayList<String> middleLines = new ArrayList<String>();
        ArrayList<String> otherLines = new ArrayList<String>();
        for (String line : handledLines) {
            if (LineDescriptionEnum.forString(line) == LineDescriptionEnum.MESSAGE_MIDDLE) {
                middleLines.add(line);
                continue;
            }
            otherLines.add(line);
        }
        double halfMiddleBlockHeight = (double)middleLines.size() * drawer.textHeightMaxWithSpace() / 2.0;
        for (int i = 0; i < middleLines.size(); ++i) {
            String line = LineDescriptionUtils.replaceArrowsWithUtf8Characters((String)middleLines.get(i));
            PointDouble pointText = LineDescriptionUtils.calcPosOfMiddleText(drawer, line, relationPoints.getMiddleLine(), i, halfMiddleBlockHeight);
            int index = LineDescriptionEnum.MESSAGE_MIDDLE.getIndex() + i;
            this.printAndUpdateIndex(drawer, relationPoints, pointText, index, line, usedIndexes);
        }
        for (String line : otherLines) {
            LineDescriptionEnum enumVal = LineDescriptionEnum.forString(line);
            String[] split = line.split("=", -1);
            String text = split[1];
            if (text.isEmpty()) continue;
            PointDouble pointText = LineDescriptionUtils.calcPosOfEndText(drawer, text, relationPoints, enumVal);
            this.printAndUpdateIndex(drawer, relationPoints, pointText, enumVal.getIndex(), text, (Point)displacements.get(enumVal.getKey()), usedIndexes);
        }
        relationPoints.resetTextBoxIndexesExcept(usedIndexes);
        relationPoints.resizeRectAndReposPoints();
    }

    @Override
    public Priority getPriority() {
        return Priority.LOWEST;
    }
}

