/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;

public class TabbedPanel
extends JTabbedPane {
    private static final long serialVersionUID = 8927990541854169615L;
    private Container originalParent = null;
    private Container alternativeParent = null;
    private Component backupChild = null;
    private Logger log = Logger.getLogger(this.getClass());
    private boolean isAlternative = true;

    public TabbedPanel() {
        this.initialize();
    }

    private void initialize() {
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(225, 145);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    TabbedPanel.this.alternateParent();
                }
            }
        });
    }

    public void setAlternativeParent(Container container) {
        this.alternativeParent = container;
    }

    public boolean isInAlternativeParent() {
        return !this.isAlternative;
    }

    public void alternateParent() {
        if (this.alternativeParent == null) {
            return;
        }
        if (Model.getSingleton().getOptionsParam().getViewParam().getWarnOnTabDoubleClick()) {
            if (View.getSingleton().showConfirmDialog(Constant.messages.getString("tab.doubleClick.warning")) != 0) {
                return;
            }
            Model.getSingleton().getOptionsParam().getViewParam().setWarnOnTabDoubleClick(false);
            try {
                Model.getSingleton().getOptionsParam().getViewParam().getConfig().save();
            }
            catch (ConfigurationException configurationException) {
                this.log.error((Object)configurationException.getMessage(), (Throwable)configurationException);
            }
        }
        if (this.isAlternative) {
            this.originalParent = this.getParent();
            this.originalParent.remove(this);
            this.backupChild = this.alternativeParent.getComponent(0);
            this.alternativeParent.remove(this.backupChild);
            this.alternativeParent.add(this);
        } else {
            this.alternativeParent.remove(this);
            this.alternativeParent.add(this.backupChild);
            this.originalParent.add(this);
        }
        this.originalParent.validate();
        this.alternativeParent.validate();
        this.validate();
        this.isAlternative = !this.isAlternative;
    }
}

