/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.split.response;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseHeaderPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    public HttpResponseHeaderPanelSyntaxHighlightTextView(ResponseHeaderStringHttpPanelViewModel responseHeaderStringHttpPanelViewModel) {
        super(responseHeaderStringHttpPanelViewModel);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpResponseHeaderPanelSyntaxHighlightTextArea();
    }

    private static class HttpResponseHeaderPanelSyntaxHighlightTextArea
    extends HttpPanelSyntaxHighlightTextArea {
        private static final long serialVersionUID = 6197189781594557597L;
        private static final Logger log = Logger.getLogger(HttpResponseHeaderPanelSyntaxHighlightTextArea.class);
        private static ResponseHeaderTokenMakerFactory tokenMakerFactory = null;

        @Override
        public void search(Pattern pattern, List<SearchMatch> list) {
            Matcher matcher = pattern.matcher(this.getText());
            while (matcher.find()) {
                int n = matcher.start();
                try {
                    n += this.getLineOfOffset(n);
                }
                catch (BadLocationException badLocationException) {
                    log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                    return;
                }
                int n2 = matcher.end();
                try {
                    n2 += this.getLineOfOffset(n2);
                }
                catch (BadLocationException badLocationException) {
                    log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                    return;
                }
                list.add(new SearchMatch(SearchMatch.Location.REQUEST_HEAD, n, n2));
            }
        }

        @Override
        public void highlight(SearchMatch searchMatch) {
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)searchMatch.getLocation())) {
                return;
            }
            int n = 0;
            String string = searchMatch.getMessage().getResponseHeader().toString();
            int n2 = 0;
            while ((n2 = string.indexOf("\r\n", n2)) != -1 && n2 < searchMatch.getStart()) {
                n2 += 2;
                ++n;
            }
            int n3 = this.getText().length();
            if (searchMatch.getStart() - n > n3 || searchMatch.getEnd() - n > n3) {
                return;
            }
            this.highlight(searchMatch.getStart() - n, searchMatch.getEnd() - n);
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseHeaderTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseHeaderTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
        }
    }
}

