/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class UnmappedSampler
extends InternalSampler {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("sampler", "umsampler");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public UnmappedSampler readResult(StreamInput in) throws IOException {
            UnmappedSampler sampler = new UnmappedSampler();
            sampler.readFrom(in);
            return sampler;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    UnmappedSampler() {
    }

    public UnmappedSampler(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, 0L, InternalAggregations.EMPTY, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        for (InternalAggregation agg : aggregations) {
            if (agg instanceof UnmappedSampler) continue;
            return agg.reduce(aggregations, reduceContext);
        }
        return this;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(InternalAggregation.CommonFields.DOC_COUNT, 0);
        return builder;
    }
}

