/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.springframework.util.StringUtils;

public class ApplicationHome {
    private final File source;
    private final File dir;

    public ApplicationHome() {
        this(null);
    }

    public ApplicationHome(Class<?> sourceClass) {
        this.source = this.findSource(sourceClass == null ? this.getClass() : sourceClass);
        this.dir = this.findHomeDir(this.source);
    }

    private File findSource(Class<?> sourceClass) {
        try {
            File source;
            ProtectionDomain protectionDomain = sourceClass.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL location = codeSource == null ? null : codeSource.getLocation();
            File file = source = location == null ? null : this.findSource(location);
            if (source != null && source.exists()) {
                return source.getAbsoluteFile();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private File findSource(URL location) throws IOException {
        URLConnection connection = location.openConnection();
        if (connection instanceof JarURLConnection) {
            return new File(((JarURLConnection)connection).getJarFile().getName());
        }
        return new File(location.getPath());
    }

    private File findHomeDir(File source) {
        File homeDir = source;
        File file = homeDir = homeDir == null ? this.findDefaultHomeDir() : homeDir;
        if (homeDir.isFile()) {
            homeDir = homeDir.getParentFile();
        }
        homeDir = homeDir.exists() ? homeDir : new File(".");
        return homeDir.getAbsoluteFile();
    }

    private File findDefaultHomeDir() {
        String userDir = System.getProperty("user.dir");
        return new File(StringUtils.hasLength((String)userDir) ? userDir : ".");
    }

    public File getSource() {
        return this.source;
    }

    public File getDir() {
        return this.dir;
    }

    public String toString() {
        return this.getDir().toString();
    }
}

