/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.pages;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObject;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriService;
import org.grails.buffer.FastStringWriter;
import org.grails.web.servlet.mvc.GrailsWebRequest;

public class GroovyPagesUriSupport
implements grails.web.pages.GroovyPagesUriService,
GroovyPagesUriService {
    public static final String PATH_TO_VIEWS = "/WEB-INF/grails-app/views";
    private static final char SLASH = '/';
    private static final String SLASH_STR = "/";
    private static final String SLASH_UNDR = "/_";
    private static final String BLANK = "";
    private static final String UNDERSCORE = "_";
    protected static final String EXTENSION = ".gsp";
    protected static final String SUFFIX = ".gsp";

    @Override
    public String getTemplateURI(GroovyObject controller, String templateName) {
        return this.getTemplateURI(this.getLogicalControllerName(controller), templateName);
    }

    @Override
    public String getTemplateURI(GroovyObject controller, String templateName, boolean includeExtension) {
        return this.getTemplateURI(this.getLogicalControllerName(controller), templateName, includeExtension);
    }

    @Override
    public void clear() {
    }

    public String getViewURI(GroovyObject controller, String viewName) {
        return this.getViewURI(this.getLogicalControllerName(controller), viewName);
    }

    @Override
    public String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        return this.getNoSuffixViewURI(this.getLogicalControllerName(controller), viewName);
    }

    public String getLogicalControllerName(GroovyObject controller) {
        if (controller == null) {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup();
            return webRequest != null ? webRequest.getControllerName() : null;
        }
        String simpleName = controller.getClass().getSimpleName();
        if (!simpleName.endsWith("Controller")) {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup();
            return webRequest != null ? webRequest.getControllerName() : null;
        }
        return GrailsNameUtils.getLogicalPropertyName((String)simpleName, (String)"Controller");
    }

    @Override
    public String getTemplateURI(String controllerName, String templateName) {
        return this.getTemplateURI(controllerName, templateName, true);
    }

    @Override
    public String getTemplateURI(String controllerName, String templateName, boolean includeExtension) {
        if (templateName.startsWith(SLASH_STR)) {
            return this.getAbsoluteTemplateURI(templateName);
        }
        FastStringWriter buf = new FastStringWriter();
        String pathToTemplate = BLANK;
        int lastSlash = templateName.lastIndexOf(47);
        if (lastSlash > -1) {
            pathToTemplate = templateName.substring(0, lastSlash + 1);
            templateName = templateName.substring(lastSlash + 1);
        }
        if (controllerName != null) {
            buf.append('/').append((CharSequence)controllerName);
        }
        buf.append('/').append((CharSequence)pathToTemplate).append((CharSequence)UNDERSCORE).append((CharSequence)templateName);
        if (includeExtension) {
            return buf.append((CharSequence)".gsp").toString();
        }
        return buf.toString();
    }

    @Override
    public String getAbsoluteTemplateURI(String templateName) {
        FastStringWriter buf = new FastStringWriter();
        String tmp = templateName.substring(1, templateName.length());
        if (tmp.indexOf(47) > -1) {
            buf.append('/');
            int i = tmp.lastIndexOf(47);
            buf.append((CharSequence)tmp.substring(0, i));
            buf.append((CharSequence)SLASH_UNDR);
            buf.append((CharSequence)tmp.substring(i + 1, tmp.length()));
        } else {
            buf.append((CharSequence)SLASH_UNDR);
            buf.append((CharSequence)templateName.substring(1, templateName.length()));
        }
        String uri = buf.append((CharSequence)".gsp").toString();
        buf.close();
        return uri;
    }

    @Override
    public String getViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return this.getViewURIInternal(controllerName, viewName, buf, true);
    }

    @Override
    public String getAbsoluteViewURI(String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return this.getAbsoluteViewURIInternal(viewName, buf, true);
    }

    @Override
    public String getNoSuffixViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return this.getViewURIInternal(controllerName, viewName, buf, false);
    }

    @Override
    public String getDeployedViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter((Object)PATH_TO_VIEWS);
        return this.getViewURIInternal(controllerName, viewName, buf, true);
    }

    @Override
    public String getDeployedAbsoluteViewURI(String viewName) {
        FastStringWriter buf = new FastStringWriter((Object)PATH_TO_VIEWS);
        return this.getAbsoluteViewURIInternal(viewName, buf, true);
    }

    private String getViewURIInternal(String viewPathPrefix, String viewName, FastStringWriter buf, boolean includeSuffix) {
        if (viewName != null && viewName.startsWith(SLASH_STR)) {
            return this.getAbsoluteViewURIInternal(viewName, buf, includeSuffix);
        }
        if (viewPathPrefix != null) {
            buf.append('/').append((CharSequence)viewPathPrefix);
        }
        if (viewName != null) {
            buf.append('/').append((CharSequence)viewName);
        }
        return includeSuffix ? buf.append((CharSequence)".gsp").toString() : buf.toString();
    }

    private String getAbsoluteViewURIInternal(String viewName, FastStringWriter buf, boolean includeSuffix) {
        String tmp = viewName.substring(1, viewName.length());
        if (tmp.indexOf(47) > -1) {
            buf.append('/');
            buf.append((CharSequence)tmp.substring(0, tmp.lastIndexOf(47)));
            buf.append('/');
            buf.append((CharSequence)tmp.substring(tmp.lastIndexOf(47) + 1, tmp.length()));
        } else {
            buf.append('/');
            buf.append((CharSequence)viewName.substring(1, viewName.length()));
        }
        if (includeSuffix) {
            buf.append((CharSequence)".gsp").toString();
        }
        return buf.toString();
    }
}

