/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.Truffle;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Callable;

public final class CompilerDirectives {
    public static final double LIKELY_PROBABILITY = 0.75;
    public static final double UNLIKELY_PROBABILITY = 0.25;
    public static final double SLOWPATH_PROBABILITY = 1.0E-4;
    public static final double FASTPATH_PROBABILITY = 0.9999;

    public static void transferToInterpreter() {
        if (CompilerDirectives.inInterpreter()) {
            Truffle.getRuntime().notifyTransferToInterpreter();
        }
    }

    public static void transferToInterpreterAndInvalidate() {
        if (CompilerDirectives.inInterpreter()) {
            Truffle.getRuntime().notifyTransferToInterpreter();
        }
    }

    public static boolean inInterpreter() {
        return true;
    }

    public static boolean inCompiledCode() {
        return false;
    }

    public static boolean isCompilationConstant(Object value) {
        return CompilerDirectives.inInterpreter();
    }

    public static boolean isPartialEvaluationConstant(Object value) {
        return CompilerDirectives.inInterpreter();
    }

    public static void interpreterOnly(Runnable runnable) {
        runnable.run();
    }

    public static <T> T interpreterOnly(Callable<T> callable) throws Exception {
        return callable.call();
    }

    public static boolean injectBranchProbability(double probability, boolean condition) {
        assert (probability >= 0.0 && probability <= 1.0);
        return condition;
    }

    public static void bailout(String reason) {
    }

    public static void materialize(Object obj) {
    }

    public static void ensureVirtualized(Object object) {
    }

    public static void ensureVirtualizedHere(Object object) {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ValueType {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
    public static @interface TruffleBoundary {
        public boolean throwsControlFlowException() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface CompilationFinal {
    }
}

