/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.array;

import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.DoubleArrayMirror;
import org.jruby.truffle.runtime.array.EmptyArrayMirror;
import org.jruby.truffle.runtime.array.IntegerArrayMirror;
import org.jruby.truffle.runtime.array.LongArrayMirror;
import org.jruby.truffle.runtime.array.ObjectArrayMirror;

public abstract class ArrayReflector {
    public static IntegerArrayMirror reflect(int[] array) {
        return new IntegerArrayMirror(array);
    }

    public static LongArrayMirror reflect(long[] array) {
        return new LongArrayMirror(array);
    }

    public static DoubleArrayMirror reflect(double[] array) {
        return new DoubleArrayMirror(array);
    }

    public static ObjectArrayMirror reflect(Object[] array) {
        return new ObjectArrayMirror(array);
    }

    public static ArrayMirror reflect(Object array) {
        if (array == null) {
            return new EmptyArrayMirror();
        }
        if (array instanceof int[]) {
            return ArrayReflector.reflect((int[])array);
        }
        if (array instanceof long[]) {
            return ArrayReflector.reflect((long[])array);
        }
        if (array instanceof double[]) {
            return ArrayReflector.reflect((double[])array);
        }
        if (array.getClass() == Object[].class) {
            return ArrayReflector.reflect((Object[])array);
        }
        throw new UnsupportedOperationException();
    }
}

