/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.beans;

public class CallWatchThread
extends Thread {
    private static boolean DEBUG = false;
    private Thread aWatchedThread = Thread.currentThread();
    private String aTag;
    private boolean bAlive;
    private long nTimeout;

    public CallWatchThread(long nTimeout) {
        this(nTimeout, "CallWatchThread");
    }

    public CallWatchThread(long nTimeout, String aTag) {
        super(aTag);
        this.nTimeout = nTimeout;
        this.aTag = aTag;
        this.setDaemon(true);
        this.dbgPrint("CallWatchThread(" + this + ").start(" + aTag + ")");
        this.start();
    }

    public void cancel() throws InterruptedException {
        this.dbgPrint("CallWatchThread(" + this + ".cancel(" + this.aTag + ")");
        if (this.aWatchedThread != null && this.aWatchedThread != Thread.currentThread()) {
            throw new RuntimeException("wrong thread");
        }
        this.aWatchedThread = null;
        if (CallWatchThread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public synchronized void restart() throws InterruptedException {
        this.dbgPrint("CallWatchThread(" + this + ".restart(" + this.aTag + ")");
        if (this.aWatchedThread != null && this.aWatchedThread != Thread.currentThread()) {
            throw new RuntimeException("wrong thread");
        }
        this.bAlive = true;
        if (CallWatchThread.interrupted()) {
            throw new InterruptedException();
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.dbgPrint("CallWatchThread(" + this + ".run(" + this.aTag + ") ***** STARTED *****");
        long n = 0L;
        while (this.aWatchedThread != null) {
            this.dbgPrint("CallWatchThread(" + this + ").run(" + this.aTag + ") running #" + ++n);
            CallWatchThread callWatchThread = this;
            synchronized (callWatchThread) {
                this.bAlive = false;
                try {
                    this.wait(this.nTimeout);
                }
                catch (InterruptedException aExc) {
                    this.bAlive = false;
                }
                if (!this.bAlive && this.aWatchedThread != null) {
                    this.dbgPrint("CallWatchThread(" + this + ").run(" + this.aTag + ") interrupting");
                    this.aWatchedThread.interrupt();
                    this.aWatchedThread = null;
                }
            }
        }
        this.dbgPrint("CallWatchThread(" + this + ").run(" + this.aTag + ") terminated");
    }

    private void dbgPrint(String aMessage) {
        if (DEBUG) {
            System.err.println("OOoBean: " + aMessage);
        }
    }
}

