/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.BreakID;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.BreakException;

public class CatchBreakNode
extends RubyNode {
    @Node.Child
    private RubyNode body;
    private final BreakID breakID;
    private final BranchProfile breakProfile = BranchProfile.create();
    private final ConditionProfile matchingBreakProfile = ConditionProfile.createCountingProfile();

    public CatchBreakNode(RubyContext context, SourceSection sourceSection, RubyNode body, BreakID breakID) {
        super(context, sourceSection);
        this.body = body;
        this.breakID = breakID;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (BreakException e) {
            this.breakProfile.enter();
            if (this.matchingBreakProfile.profile(e.getBreakID() == this.breakID)) {
                return e.getResult();
            }
            throw e;
        }
    }
}

