/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RefHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final MyMap myMap;
    private final ReferenceQueue<K> myReferenceQueue;
    private final HardKey myHardKeyInstance;
    @NotNull
    private final TObjectHashingStrategy<K> myStrategy;
    private Set<Map.Entry<K, V>> entrySet;
    private boolean processingQueue;

    RefHashMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/RefHashMap", "<init>"));
        }
        this.myReferenceQueue = new ReferenceQueue();
        this.myHardKeyInstance = new HardKey();
        this.myStrategy = strategy;
        this.myMap = new MyMap(initialCapacity, loadFactor);
    }

    RefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, ContainerUtil.canonicalStrategy());
    }

    RefHashMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    RefHashMap() {
        this(4);
    }

    RefHashMap(@NotNull Map<K, V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/RefHashMap", "<init>"));
        }
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    RefHashMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/RefHashMap", "<init>"));
        }
        this(4, 0.8f, hashingStrategy);
    }

    static <K> boolean keyEqual(K k1, K k2, TObjectHashingStrategy<K> strategy) {
        return k1 == k2 || strategy.equals(k1, k2);
    }

    @NotNull
    protected abstract <T> Key<T> createKey(@NotNull T var1, @NotNull TObjectHashingStrategy<T> var2, @NotNull ReferenceQueue<? super T> var3);

    boolean processQueue() {
        boolean processed = false;
        try {
            Key wk;
            this.processingQueue = true;
            while ((wk = (Key)((Object)this.myReferenceQueue.poll())) != null) {
                this.removeKey(wk);
                processed = true;
            }
        }
        finally {
            this.processingQueue = false;
        }
        this.myMap.compactIfNecessary();
        return processed;
    }

    V removeKey(@NotNull Key<K> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap", "removeKey"));
        }
        return (V)this.myMap.remove(key);
    }

    @NotNull
    Key<K> createKey(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap", "createKey"));
        }
        Key<K> key2 = this.createKey(key, this.myStrategy, this.myReferenceQueue);
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RefHashMap", "createKey"));
        }
        return key2;
    }

    V putKey(@NotNull Key<K> weakKey, V value) {
        if (weakKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "weakKey", "com/intellij/util/containers/RefHashMap", "putKey"));
        }
        return (V)this.myMap.put(weakKey, value);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        this.myHardKeyInstance.set(key);
        boolean result = this.myMap.containsKey(this.myHardKeyInstance);
        this.myHardKeyInstance.clear();
        return result;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        this.myHardKeyInstance.set(key);
        Object result = this.myMap.get(this.myHardKeyInstance);
        this.myHardKeyInstance.clear();
        return (V)result;
    }

    @Override
    public V put(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap", "put"));
        }
        this.processQueue();
        return this.putKey(this.createKey(key), value);
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap", "remove"));
        }
        this.processQueue();
        this.myHardKeyInstance.set(key);
        Object result = this.myMap.remove(this.myHardKeyInstance);
        this.myHardKeyInstance.clear();
        return (V)result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RefHashMap", "entrySet"));
        }
        return set;
    }

    int underlyingMapSize() {
        return this.myMap.size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<Key<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = RefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator iterator = new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<Key<K>, V>> hashIterator;
                private MyEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        Key wk = ent.getKey();
                        Object k = wk.get();
                        if (k == null) continue;
                        this.next = new MyEntry(ent, k, wk.hashCode(), RefHashMap.this.myStrategy);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    MyEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RefHashMap$EntrySet", "iterator"));
            }
            return iterator;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            RefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            RefHashMap.this.myHardKeyInstance.set(e.getKey());
            HardKey key = RefHashMap.this.myHardKeyInstance;
            Object hv = RefHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && RefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                RefHashMap.this.myMap.remove(key);
            }
            RefHashMap.this.myHardKeyInstance.clear();
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Key wk = entry.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = entry.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;
        private final int myKeyHashCode;
        @NotNull
        private final TObjectHashingStrategy<K> myStrategy;

        private MyEntry(@NotNull Map.Entry<?, V> ent, @NotNull K key, int keyHashCode, @NotNull TObjectHashingStrategy<K> strategy) {
            if (ent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ent", "com/intellij/util/containers/RefHashMap$MyEntry", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/RefHashMap$MyEntry", "<init>"));
            }
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/RefHashMap$MyEntry", "<init>"));
            }
            this.ent = ent;
            this.key = key;
            this.myKeyHashCode = keyHashCode;
            this.myStrategy = strategy;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private static boolean valEqual(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RefHashMap.keyEqual(this.key, e.getKey(), this.myStrategy) && MyEntry.valEqual(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return this.myKeyHashCode ^ (v == null ? 0 : v.hashCode());
        }
    }

    private class HardKey
    implements Key<K> {
        private K myObject;
        private int myHash;

        private HardKey() {
        }

        @Override
        public K get() {
            return this.myObject;
        }

        private void set(@NotNull K object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/containers/RefHashMap$HardKey", "set"));
            }
            this.myObject = object;
            this.myHash = RefHashMap.this.myStrategy.computeHashCode(object);
        }

        private void clear() {
            this.myObject = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.myObject;
            Object u = ((Key)o).get();
            return RefHashMap.keyEqual(t, u, RefHashMap.this.myStrategy);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    static interface Key<T> {
        public T get();
    }

    private class MyMap
    extends THashMap<Key<K>, V> {
        private MyMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, new TObjectHashingStrategy<Key<K>>(){

                public int computeHashCode(Key<K> key) {
                    return key.hashCode();
                }

                public boolean equals(Key<K> o1, Key<K> o2) {
                    return o1 == o2 || RefHashMap.keyEqual(o1.get(), o2.get(), RefHashMap.this.myStrategy);
                }
            });
        }

        public void compact() {
            if (!RefHashMap.this.processingQueue) {
                super.compact();
            }
        }

        private void compactIfNecessary() {
            if (this._deadkeys > this._size && this.capacity() > 42) {
                this.compact();
            }
        }

        protected void rehash(int newCapacity) {
            int oldCapacity = this._set.length;
            Object[] oldKeys = this._set;
            Object[] oldVals = this._values;
            this._set = new Object[newCapacity];
            this._values = new Object[newCapacity];
            int i = oldCapacity;
            while (i-- > 0) {
                Key k;
                Object key;
                Object o = oldKeys[i];
                if (o == null || o == REMOVED || (key = (k = (Key)o).get()) == null) continue;
                int index = this.insertionIndex(k);
                if (index < 0) {
                    this.throwObjectContractViolation(this._set[-index - 1], o);
                    if (key == this._set) {
                        throw new AssertionError();
                    }
                }
                this._set[index] = o;
                this._values[index] = oldVals[i];
            }
        }
    }
}

