/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsEdit;

import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.command.reservedcheckout.EditCommand;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;

public class EditOperation
extends CvsOperationOnFiles {
    private final boolean myIsReservedEdit;
    private final List<EditedFileInfo> myEditFileInfos = new ArrayList<EditedFileInfo>();
    @NonNls
    public static final String FILES_BEING_EDITED_EXCEPTION = "cvs [edit aborted]: files being edited";

    public EditOperation(boolean isReservedEdit) {
        this.myIsReservedEdit = isReservedEdit;
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        EditCommand result = new EditCommand();
        result.setTemporaryWatch(Watch.TALL);
        result.setCheckThatUnedited(this.myIsReservedEdit);
        result.setForceEvenIfEdited(false);
        this.addFilesToCommand(root, (AbstractCommand)result);
        return result;
    }

    @Override
    protected void execute(CvsRootProvider root, CvsExecutionEnvironment executionEnvironment, ReadWriteStatistics statistics, IProgressViewer progressViewer) throws CommandException, CommandAbortedException, VcsException {
        super.execute(root, executionEnvironment, statistics, progressViewer);
        CvsException vcsException = new CvsException(FILES_BEING_EDITED_EXCEPTION, root.getCvsRootAsString());
        for (EditedFileInfo info : this.myEditFileInfos) {
            if (info.isSuitableFor(root)) {
                return;
            }
            File file = info.getFile(root);
            VirtualFile virtualFile = CvsVfsUtil.findFileByIoFile(file);
            if (virtualFile == null) continue;
            vcsException.setVirtualFile(virtualFile);
        }
        if (!this.myEditFileInfos.isEmpty()) {
            throw vcsException;
        }
    }

    @Override
    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        super.messageSent(message, byteMessage, error, tagged);
        EditedFileInfo editedFileInfo = EditedFileInfo.createOn(message);
        if (editedFileInfo != null) {
            this.myEditFileInfos.add(editedFileInfo);
        }
    }

    @Override
    protected String getOperationName() {
        return "edit";
    }

    private static final class EditedFileInfo {
        private final String myFileName;
        private final String myUser;
        private final String myHost;
        private final File myEditLocation;

        public EditedFileInfo(String fileName, String user, String host, String editLocation) {
            this.myFileName = fileName;
            this.myUser = user;
            this.myHost = host;
            this.myEditLocation = new File(editLocation);
        }

        public static EditedFileInfo createOn(String editInfoString) {
            StringTokenizer tokens = new StringTokenizer(editInfoString, "\t");
            if (!tokens.hasMoreTokens()) {
                return null;
            }
            String fileName = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                return null;
            }
            String user = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                return null;
            }
            tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                return null;
            }
            String host = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                return null;
            }
            String editLocation = tokens.nextToken();
            return new EditedFileInfo(fileName, user, host, editLocation);
        }

        public File getFile(CvsRootProvider root) {
            return new File(root.getLocalRoot(), this.myFileName);
        }

        public boolean isSuitableFor(CvsRootProvider root) {
            try {
                String hostName = InetAddress.getLocalHost().getHostName();
                return this.myUser.equals(root.getCvsRoot().getUser()) && this.myEditLocation.equals(this.getFile(root).getParentFile()) && this.myHost.equals(hostName);
            }
            catch (UnknownHostException e) {
                LOG.error((Throwable)e);
                return false;
            }
        }
    }
}

