/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import com.intellij.rt.execution.testFrameworks.ForkedByModuleSplitter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ForkedSplitter
extends ForkedByModuleSplitter {
    private Object myRootDescription;

    public ForkedSplitter(String workingDirsPath, String forkMode, PrintStream out, PrintStream err, List newArgs) {
        super(workingDirsPath, forkMode, out, err, newArgs);
    }

    protected int startSplitting(String[] args, String configName) throws Exception {
        this.myRootDescription = this.createRootDescription(args, configName);
        if (this.myRootDescription == null) {
            return -1;
        }
        this.sendTree(this.myRootDescription);
        if (this.myWorkingDirsPath == null || new File(this.myWorkingDirsPath).length() == 0L) {
            List children = this.getChildren(this.myRootDescription);
            boolean forkTillMethod = this.myForkMode.equalsIgnoreCase("method");
            return this.splitChildren(children, 0, forkTillMethod, null, System.getProperty("java.class.path"));
        }
        return this.splitPerModule();
    }

    protected int startPerModuleFork(String moduleName, List classNames, String packageName, String workingDir, String classpath, int result) throws Exception {
        if (this.myForkMode.equals("none")) {
            List childArgs = this.createPerModuleArgs(packageName, workingDir, classNames, this.myRootDescription);
            return this.startChildFork(childArgs, new File(workingDir), classpath);
        }
        ArrayList children = new ArrayList(this.getChildren(this.myRootDescription));
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            if (classNames.contains(this.getTestClassName(iterator.next()))) continue;
            iterator.remove();
        }
        boolean forkTillMethod = this.myForkMode.equalsIgnoreCase("method");
        return this.splitChildren(children, result, forkTillMethod, new File(workingDir), classpath);
    }

    protected int splitChildren(List children, int result, boolean forkTillMethod, File workingDir, String classpath) throws IOException, InterruptedException {
        int argsLength = children.size();
        for (int i = 0; i < argsLength; ++i) {
            Object child = children.get(i);
            List childTests = this.getChildren(child);
            int childResult = childTests.isEmpty() || !forkTillMethod ? this.startChildFork(this.createChildArgs(child), workingDir, classpath) : this.splitChildren(childTests, result, forkTillMethod, workingDir, classpath);
            result = Math.min(childResult, result);
        }
        return result;
    }

    protected abstract List createPerModuleArgs(String var1, String var2, List var3, Object var4) throws IOException;

    protected abstract Object createRootDescription(String[] var1, String var2) throws Exception;

    protected abstract String getTestClassName(Object var1);

    protected abstract List createChildArgs(Object var1);

    protected abstract List getChildren(Object var1);
}

