/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class SelectInMavenNavigatorTarget
implements SelectInTarget {
    public boolean canSelect(SelectInContext context) {
        return SelectInMavenNavigatorTarget.getMavenProject(context) != null;
    }

    public void selectIn(final SelectInContext context, boolean requestFocus) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MavenProjectsNavigator.getInstance(context.getProject()).selectInTree(SelectInMavenNavigatorTarget.getMavenProject(context));
            }
        };
        if (requestFocus) {
            ToolWindowManager.getInstance((Project)context.getProject()).getToolWindow(this.getToolWindowId()).activate(r);
        } else {
            r.run();
        }
    }

    private static MavenProject getMavenProject(SelectInContext context) {
        VirtualFile file = context.getVirtualFile();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(context.getProject());
        Module module = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex().getModuleForFile(file);
        return module == null ? null : manager.findProject(module);
    }

    public String getToolWindowId() {
        return "Maven Projects";
    }

    public String toString() {
        return "Maven Projects";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 20.0f;
    }
}

