/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.xml.util.IncludedXmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public class PluginDescriptorChooser {
    private static final ImmutableMap<String, String> INTELLIJ_MODULES = ImmutableMap.builder().put((Object)"platform-api", (Object)"PlatformExtensions.xml").put((Object)"platform-impl", (Object)"PlatformExtensions.xml").put((Object)"lang-api", (Object)"LangExtensions.xml").put((Object)"lang-impl", (Object)"LangExtensions.xml").put((Object)"vcs-api", (Object)"VcsExtensions.xml").put((Object)"vcs-impl", (Object)"VcsExtensions.xml").put((Object)"openapi", (Object)"IdeaPlugin.xml").put((Object)"java-impl", (Object)"IdeaPlugin.xml").build();

    public static void show(final Project project, Editor editor, PsiFile file, final Consumer<DomFileElement<IdeaPlugin>> consumer) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        List<DomFileElement<IdeaPlugin>> elements = DomService.getInstance().getFileElements(IdeaPlugin.class, project, module.getModuleWithDependenciesScope());
        elements = ContainerUtil.filter((Collection)elements, (Condition)new Condition<DomFileElement<IdeaPlugin>>(){

            public boolean value(DomFileElement<IdeaPlugin> element) {
                VirtualFile virtualFile = element.getFile().getVirtualFile();
                return virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile);
            }
        });
        elements = PluginDescriptorChooser.findAppropriateIntelliJModule(module.getName(), elements);
        if (elements.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find plugin descriptor");
            return;
        }
        if (elements.size() == 1) {
            consumer.consume(elements.get(0));
            return;
        }
        BaseListPopupStep<PluginDescriptorCandidate> popupStep = new BaseListPopupStep<PluginDescriptorCandidate>("Choose Plugin Descriptor", PluginDescriptorChooser.createCandidates(module, elements)){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public Icon getIconFor(PluginDescriptorCandidate candidate) {
                return candidate.getIcon();
            }

            @NotNull
            public String getTextFor(PluginDescriptorCandidate candidate) {
                String string = candidate.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/PluginDescriptorChooser$2", "getTextFor"));
                }
                return string;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(PluginDescriptorCandidate candidate) {
                String separatorText = candidate.getSeparatorText();
                if (separatorText != null) {
                    return new ListSeparator(separatorText);
                }
                return null;
            }

            public PopupStep onChosen(PluginDescriptorCandidate selectedValue, boolean finalChoice) {
                consumer.consume((Object)selectedValue.myDomFileElement);
                return FINAL_CHOICE;
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep).showInBestPositionFor(editor);
    }

    @NotNull
    public static Extensions findOrCreateExtensionsForEP(DomFileElement<IdeaPlugin> domFileElement, String epName) {
        IdeaPlugin ideaPlugin = (IdeaPlugin)domFileElement.getRootElement();
        List<Extensions> extensionsList = ideaPlugin.getExtensions();
        for (Extensions extensions : extensionsList) {
            String s;
            if (extensions.getXmlTag() instanceof IncludedXmlTag || (s = extensions.getDefaultExtensionNs().getStringValue()) == null || !epName.startsWith(s)) continue;
            Extensions extensions2 = extensions;
            if (extensions2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/PluginDescriptorChooser", "findOrCreateExtensionsForEP"));
            }
            return extensions2;
        }
        Extensions extensions = ideaPlugin.addExtensions();
        String epPrefix = StringUtil.getPackageName((String)epName);
        extensions.getDefaultExtensionNs().setStringValue(epPrefix);
        Extensions extensions3 = extensions;
        if (extensions3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/PluginDescriptorChooser", "findOrCreateExtensionsForEP"));
        }
        return extensions3;
    }

    private static List<PluginDescriptorCandidate> createCandidates(final Module currentModule, List<DomFileElement<IdeaPlugin>> elements) {
        Collections.sort(elements, new Comparator<DomFileElement<IdeaPlugin>>(){

            @Override
            public int compare(DomFileElement<IdeaPlugin> o1, DomFileElement<IdeaPlugin> o2) {
                Module module2;
                Module module1 = o1.getModule();
                int byAlpha = ModulesAlphaComparator.INSTANCE.compare(module1, module2 = o2.getModule());
                if (byAlpha == 0) {
                    return 0;
                }
                if (currentModule.equals(module1)) {
                    return -1;
                }
                if (currentModule.equals(module2)) {
                    return 1;
                }
                return byAlpha;
            }
        });
        Collections.sort(elements, new Comparator<DomFileElement<IdeaPlugin>>(){

            @Override
            public int compare(DomFileElement<IdeaPlugin> o1, DomFileElement<IdeaPlugin> o2) {
                if (!Comparing.equal((Object)o1.getModule(), (Object)o2.getModule())) {
                    return 0;
                }
                return o1.getFile().getName().compareTo(o2.getFile().getName());
            }
        });
        return ContainerUtil.map(elements, (Function)new Function<DomFileElement<IdeaPlugin>, PluginDescriptorCandidate>(){
            private Module myLastModule;
            {
                this.myLastModule = currentModule;
            }

            public PluginDescriptorCandidate fun(DomFileElement<IdeaPlugin> element) {
                Module module = element.getModule();
                boolean startsNewGroup = !this.myLastModule.equals(module);
                this.myLastModule = module;
                return new PluginDescriptorCandidate(element, startsNewGroup);
            }
        });
    }

    private static List<DomFileElement<IdeaPlugin>> findAppropriateIntelliJModule(String moduleName, List<DomFileElement<IdeaPlugin>> elements) {
        String extensionsFile = (String)INTELLIJ_MODULES.get((Object)moduleName);
        if (extensionsFile != null) {
            for (DomFileElement<IdeaPlugin> element : elements) {
                if (!element.getFile().getName().equals(extensionsFile)) continue;
                return Collections.singletonList(element);
            }
        }
        return elements;
    }

    private static class PluginDescriptorCandidate {
        private final DomFileElement<IdeaPlugin> myDomFileElement;
        private final boolean myStartsNewGroup;

        private PluginDescriptorCandidate(DomFileElement<IdeaPlugin> domFileElement, boolean startsNewGroup) {
            this.myDomFileElement = domFileElement;
            this.myStartsNewGroup = startsNewGroup;
        }

        public String getText() {
            String name = this.myDomFileElement.getFile().getName();
            String pluginId = this.getPluginId();
            return pluginId != null ? name + " [" + pluginId + "]" : name;
        }

        public Icon getIcon() {
            return this.getPluginId() != null ? AllIcons.Nodes.Plugin : EmptyIcon.create((Icon)AllIcons.Nodes.Plugin);
        }

        public String getSeparatorText() {
            if (!this.myStartsNewGroup) {
                return null;
            }
            Module module = this.myDomFileElement.getModule();
            return module == null ? null : module.getName();
        }

        private String getPluginId() {
            return ((IdeaPlugin)this.myDomFileElement.getRootElement()).getPluginId();
        }
    }
}

