/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;

public class IdeaJdkConfigurable
implements AdditionalDataConfigurable {
    private final JLabel mySandboxHomeLabel = new JLabel(DevKitBundle.message("sandbox.home.label", new Object[0]));
    private final TextFieldWithStoredHistory mySandboxHome = new TextFieldWithStoredHistory("DEVKIT_SANDBOX_HISTORY");
    private final JLabel myInternalJreLabel = new JLabel("Internal Java Platform:");
    private final DefaultComboBoxModel myJdksModel = new DefaultComboBoxModel();
    private final JComboBox myInternalJres = new JComboBox(this.myJdksModel);
    private Sdk myIdeaJdk;
    private boolean myModified;
    @NonNls
    private static final String SANDBOX_HISTORY = "DEVKIT_SANDBOX_HISTORY";
    private final SdkModel mySdkModel;
    private final SdkModificator mySdkModificator;
    private boolean myFreeze = false;
    private final SdkModel.Listener myListener;

    public IdeaJdkConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        this.mySdkModel = sdkModel;
        this.mySdkModificator = sdkModificator;
        this.myListener = new SdkModel.Listener(){

            public void sdkAdded(Sdk sdk) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    IdeaJdkConfigurable.this.addJavaSdk(sdk);
                }
            }

            public void beforeSdkRemove(Sdk sdk) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    IdeaJdkConfigurable.this.removeJavaSdk(sdk);
                }
            }

            public void sdkChanged(Sdk sdk, String previousName) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    IdeaJdkConfigurable.this.updateJavaSdkList(sdk, previousName);
                }
            }

            public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
                if (sdk.getSdkType() instanceof IdeaJdk) {
                    IdeaJdkConfigurable.this.internalJdkUpdate(sdk);
                }
            }
        };
        this.mySdkModel.addListener(this.myListener);
    }

    private void updateJdkList() {
        this.myJdksModel.removeAllElements();
        for (Sdk sdk : this.mySdkModel.getSdks()) {
            if (!IdeaJdk.isValidInternalJdk(this.myIdeaJdk, sdk)) continue;
            this.myJdksModel.addElement(sdk);
        }
    }

    public void setSdk(Sdk sdk) {
        this.myIdeaJdk = sdk;
    }

    public JComponent createComponent() {
        this.mySandboxHome.setHistorySize(5);
        JPanel wholePanel = new JPanel(new GridBagLayout());
        wholePanel.add((Component)this.mySandboxHomeLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        wholePanel.add((Component)GuiUtils.constructFieldWithBrowseButton((TextFieldWithHistory)this.mySandboxHome, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setTitle(DevKitBundle.message("sandbox.home", new Object[0]));
                descriptor.setDescription(DevKitBundle.message("sandbox.purpose", new Object[0]));
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)IdeaJdkConfigurable.this.mySandboxHome, null, null);
                if (file != null) {
                    IdeaJdkConfigurable.this.mySandboxHome.setText(FileUtil.toSystemDependentName((String)file.getPath()));
                }
                IdeaJdkConfigurable.this.myModified = true;
            }
        }), new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 13, 2, (Insets)JBUI.insets((int)0, (int)30, (int)0, (int)0), 0, 0));
        wholePanel.add((Component)this.myInternalJreLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        wholePanel.add((Component)this.myInternalJres, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 13, 2, (Insets)JBUI.insets((int)0, (int)30, (int)0, (int)0), 0, 0));
        this.myInternalJres.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Sdk) {
                    this.setText(((Sdk)value).getName());
                }
            }
        });
        this.myInternalJres.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (IdeaJdkConfigurable.this.myFreeze) {
                    return;
                }
                Sdk javaJdk = (Sdk)e.getItem();
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    if (!((SdkType)javaJdk.getSdkType()).isRootTypeApplicable(type)) continue;
                    VirtualFile[] internalRoots = javaJdk.getSdkModificator().getRoots(type);
                    Object[] configuredRoots = IdeaJdkConfigurable.this.mySdkModificator.getRoots(type);
                    for (VirtualFile file : internalRoots) {
                        if (e.getStateChange() == 2) {
                            IdeaJdkConfigurable.this.mySdkModificator.removeRoot(file, type);
                            continue;
                        }
                        if (ArrayUtil.find((Object[])configuredRoots, (Object)file) != -1) continue;
                        IdeaJdkConfigurable.this.mySdkModificator.addRoot(file, type);
                    }
                }
            }
        });
        this.mySandboxHome.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                IdeaJdkConfigurable.this.myModified = true;
            }
        });
        this.mySandboxHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeaJdkConfigurable.this.myModified = true;
            }
        });
        this.mySandboxHome.setText("");
        this.myModified = true;
        return wholePanel;
    }

    private void internalJdkUpdate(Sdk sdk) {
        Sdk javaSdk = ((Sandbox)sdk.getSdkAdditionalData()).getJavaSdk();
        if (this.myJdksModel.getIndexOf(javaSdk) == -1) {
            this.myJdksModel.addElement(javaSdk);
        } else {
            this.myJdksModel.setSelectedItem(javaSdk);
        }
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() throws ConfigurationException {
        this.mySandboxHome.addCurrentTextToHistory();
        Sandbox additionalData = (Sandbox)this.myIdeaJdk.getSdkAdditionalData();
        if (additionalData != null) {
            additionalData.cleanupWatchedRoots();
        }
        Sandbox sandbox = new Sandbox(this.mySandboxHome.getText(), (Sdk)this.myInternalJres.getSelectedItem(), this.myIdeaJdk);
        final SdkModificator modificator = this.myIdeaJdk.getSdkModificator();
        modificator.setSdkAdditionalData((SdkAdditionalData)sandbox);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                modificator.commitChanges();
            }
        });
        ((ProjectJdkImpl)this.myIdeaJdk).resetVersionString();
        this.myModified = false;
    }

    public void reset() {
        this.myFreeze = true;
        this.updateJdkList();
        this.myFreeze = false;
        this.mySandboxHome.reset();
        if (this.myIdeaJdk != null && this.myIdeaJdk.getSdkAdditionalData() instanceof Sandbox) {
            Sandbox sandbox = (Sandbox)this.myIdeaJdk.getSdkAdditionalData();
            String sandboxHome = sandbox.getSandboxHome();
            this.mySandboxHome.setText(sandboxHome);
            this.mySandboxHome.setSelectedItem((Object)sandboxHome);
            Sdk internalJava = sandbox.getJavaSdk();
            if (internalJava != null) {
                for (int i = 0; i < this.myJdksModel.getSize(); ++i) {
                    if (!Comparing.strEqual((String)((Sdk)this.myJdksModel.getElementAt(i)).getName(), (String)internalJava.getName())) continue;
                    this.myInternalJres.setSelectedIndex(i);
                    break;
                }
            }
            this.myModified = false;
        } else {
            this.mySandboxHome.setText(IdeaJdk.getDefaultSandbox());
        }
    }

    public void disposeUIResources() {
        this.mySdkModel.removeListener(this.myListener);
    }

    private void addJavaSdk(Sdk sdk) {
        this.myJdksModel.addElement(sdk);
    }

    private void removeJavaSdk(Sdk sdk) {
        this.myJdksModel.removeElement(sdk);
    }

    private void updateJavaSdkList(Sdk sdk, String previousName) {
        Sdk[] sdks;
        for (Sdk currentSdk : sdks = this.mySdkModel.getSdks()) {
            Sandbox sandbox;
            Sdk internalJava;
            if (!(currentSdk.getSdkType() instanceof IdeaJdk) || (internalJava = (sandbox = (Sandbox)currentSdk.getSdkAdditionalData()).getJavaSdk()) == null || !Comparing.equal((String)internalJava.getName(), (String)previousName)) continue;
            sandbox.setJavaSdk(sdk);
        }
        this.updateJdkList();
    }
}

