/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.LinesUtil;
import com.intellij.rt.coverage.util.StringsPool;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class ProjectDataLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectData load(File sessionDataFile) {
        ProjectData projectInfo = new ProjectData();
        FilterInputStream in = null;
        try {
            ClassData classInfo;
            int c;
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(sessionDataFile)));
            TIntObjectHashMap dict = new TIntObjectHashMap(1000, 0.99f);
            int classCount = CoverageIOUtil.readINT((DataInput)((Object)in));
            for (c = 0; c < classCount; ++c) {
                classInfo = projectInfo.getOrCreateClassData(StringsPool.getFromPool(CoverageIOUtil.readUTFFast((DataInput)((Object)in))));
                dict.put(c, (Object)classInfo);
            }
            for (c = 0; c < classCount; ++c) {
                classInfo = (ClassData)dict.get(CoverageIOUtil.readINT((DataInput)((Object)in)));
                int methCount = CoverageIOUtil.readINT((DataInput)((Object)in));
                TIntObjectHashMap lines = new TIntObjectHashMap(4, 0.99f);
                int maxLine = 1;
                for (int m = 0; m < methCount; ++m) {
                    String methodSig = ProjectDataLoader.expand((DataInputStream)in, dict);
                    int lineCount = CoverageIOUtil.readINT((DataInput)((Object)in));
                    for (int l = 0; l < lineCount; ++l) {
                        int line = CoverageIOUtil.readINT((DataInput)((Object)in));
                        LineData lineInfo = (LineData)lines.get(line);
                        if (lineInfo == null) {
                            lineInfo = new LineData(line, StringsPool.getFromPool(methodSig));
                            lines.put(line, (Object)lineInfo);
                            if (line > maxLine) {
                                maxLine = line;
                            }
                        }
                        classInfo.registerMethodSignature(lineInfo);
                        String testName = CoverageIOUtil.readUTFFast((DataInput)((Object)in));
                        if (testName != null && testName.length() > 0) {
                            lineInfo.setTestName(testName);
                        }
                        int hits = CoverageIOUtil.readINT((DataInput)((Object)in));
                        lineInfo.setHits(hits);
                        if (hits > 0) {
                            int jumpsNumber = CoverageIOUtil.readINT((DataInput)((Object)in));
                            for (int j = 0; j < jumpsNumber; ++j) {
                                lineInfo.setTrueHits(j, CoverageIOUtil.readINT((DataInput)((Object)in)));
                                lineInfo.setFalseHits(j, CoverageIOUtil.readINT((DataInput)((Object)in)));
                            }
                            int switchesNumber = CoverageIOUtil.readINT((DataInput)((Object)in));
                            for (int s = 0; s < switchesNumber; ++s) {
                                int defaultHit = CoverageIOUtil.readINT((DataInput)((Object)in));
                                int keysLength = CoverageIOUtil.readINT((DataInput)((Object)in));
                                int[] keys = new int[keysLength];
                                int[] keysHits = new int[keysLength];
                                for (int k = 0; k < keysLength; ++k) {
                                    keys[k] = CoverageIOUtil.readINT((DataInput)((Object)in));
                                    keysHits[k] = CoverageIOUtil.readINT((DataInput)((Object)in));
                                }
                                lineInfo.setDefaultHits(s, keys, defaultHit);
                                lineInfo.setSwitchHits(s, keys, keysHits);
                            }
                        }
                        lineInfo.fillArrays();
                    }
                }
                classInfo.setLines(LinesUtil.calcLineArray(maxLine, lines));
            }
        }
        catch (Exception e) {
            ErrorReporter.reportError((String)("Failed to load coverage data from file: " + sessionDataFile.getAbsolutePath()), (Throwable)e);
            ProjectData projectData = projectInfo;
            return projectData;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                ErrorReporter.reportError((String)("Failed to close file: " + sessionDataFile.getAbsolutePath()), (Throwable)e);
            }
        }
        return projectInfo;
    }

    private static String expand(DataInputStream in, final TIntObjectHashMap dict) throws IOException {
        return CoverageIOUtil.processWithDictionary((String)CoverageIOUtil.readUTFFast((DataInput)in), (CoverageIOUtil.Consumer)new CoverageIOUtil.Consumer(){

            protected String consume(String type) {
                int typeIdx;
                try {
                    typeIdx = Integer.parseInt(type);
                }
                catch (NumberFormatException e) {
                    return type;
                }
                return ((ClassData)dict.get(typeIdx)).getName();
            }
        });
    }
}

