/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.ide.commander.AbstractListBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class CoverageViewBuilder
extends AbstractListBuilder {
    private final JBTable myTable;
    private final FileStatusListener myFileStatusListener;
    private CoverageViewExtension myCoverageViewExtension;

    CoverageViewBuilder(Project project, JList list, AbstractListBuilder.Model model, AbstractTreeStructure treeStructure, final JBTable table) {
        super(project, list, model, treeStructure, (Comparator)AlphaComparator.INSTANCE, false);
        this.myTable = table;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Building coverage report..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/view/CoverageViewBuilder$1", "run"));
                }
                CoverageViewBuilder.this.buildRoot();
            }

            public void onSuccess() {
                CoverageViewBuilder.this.ensureSelectionExist();
                CoverageViewBuilder.this.updateParentTitle();
            }
        });
        this.myFileStatusListener = new FileStatusListener(){

            public void fileStatusesChanged() {
                table.repaint();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/coverage/view/CoverageViewBuilder$2", "fileStatusChanged"));
                }
                table.repaint();
            }
        };
        this.myCoverageViewExtension = ((CoverageViewTreeStructure)this.myTreeStructure).myData.getCoverageEngine().createCoverageViewExtension(this.myProject, ((CoverageViewTreeStructure)this.myTreeStructure).myData, ((CoverageViewTreeStructure)this.myTreeStructure).myStateBean);
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener(this.myFileStatusListener);
    }

    public void dispose() {
        FileStatusManager.getInstance((Project)this.myProject).removeFileStatusListener(this.myFileStatusListener);
        super.dispose();
    }

    protected boolean shouldEnterSingleTopLevelElement(Object rootChild) {
        return false;
    }

    protected boolean shouldAddTopElement() {
        return false;
    }

    protected boolean nodeIsAcceptableForElement(AbstractTreeNode node, Object element) {
        return Comparing.equal((Object)node.getValue(), (Object)element);
    }

    protected List<AbstractTreeNode> getAllAcceptableNodes(Object[] childElements, VirtualFile file) {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (Object childElement1 : childElements) {
            CoverageListNode childElement = (CoverageListNode)((Object)childElement1);
            if (!childElement.contains(file)) continue;
            result.add(childElement);
        }
        return result;
    }

    protected void updateParentTitle() {
        if (this.myParentTitle == null) {
            return;
        }
        Object rootElement = this.myTreeStructure.getRootElement();
        AbstractTreeNode node = this.getParentNode();
        if (node == null) {
            node = (AbstractTreeNode)rootElement;
        }
        if (node instanceof CoverageListRootNode) {
            this.myParentTitle.setText(this.myCoverageViewExtension.getSummaryForRootNode(node));
        } else {
            this.myParentTitle.setText(this.myCoverageViewExtension.getSummaryForNode(node));
        }
    }

    public Object getSelectedValue() {
        int row = this.myTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.myModel.getElementAt(this.myTable.convertRowIndexToModel(row));
    }

    protected void ensureSelectionExist() {
        TableUtil.ensureSelectionExists((JTable)this.myTable);
    }

    protected void selectItem(int i) {
        TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{this.myTable.convertRowIndexToView(i)});
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
    }

    public boolean canSelect(VirtualFile file) {
        return this.myCoverageViewExtension.canSelectInCoverageView(file);
    }

    public void select(Object object) {
        this.selectElement(this.myCoverageViewExtension.getElementToSelect(object), this.myCoverageViewExtension.getVirtualFile(object));
    }
}

