/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.GenericTask;
import com.intellij.tasks.generic.ResponseHandler;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xml.util.XmlUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="RegExResponseHandler")
public final class RegExResponseHandler
extends ResponseHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.generic.RegExResponseHandler");
    private static final String ID_PLACEHOLDER = "{id}";
    private static final String SUMMARY_PLACEHOLDER = "{summary}";
    private String myTaskRegex = "";

    public RegExResponseHandler() {
    }

    public RegExResponseHandler(GenericRepository repository) {
        super(repository);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegExResponseHandler handler = (RegExResponseHandler)o;
        return this.myTaskRegex.equals(handler.myTaskRegex);
    }

    public int hashCode() {
        return this.myTaskRegex.hashCode();
    }

    @Override
    @NotNull
    public JComponent getConfigurationComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/generic/RegExResponseHandler", "getConfigurationComponent"));
        }
        FormBuilder builder = FormBuilder.createFormBuilder();
        LanguageTextField taskPatternText = new LanguageTextField((Language)RegExpLanguage.INSTANCE, project, this.myTaskRegex, false);
        taskPatternText.addDocumentListener((DocumentListener)new DocumentAdapter((EditorTextField)taskPatternText){
            final /* synthetic */ EditorTextField val$taskPatternText;
            {
                this.val$taskPatternText = editorTextField;
            }

            public void documentChanged(DocumentEvent e) {
                RegExResponseHandler.this.myTaskRegex = this.val$taskPatternText.getText();
            }
        });
        String tooltip = "<html>Task pattern should be a regexp with two matching groups: ({id}.+?) and ({summary}.+?)";
        builder.addLabeledComponent("Task Pattern:", (JComponent)new JBScrollPane((Component)taskPatternText)).addTooltip(tooltip);
        JPanel jPanel = builder.getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/RegExResponseHandler", "getConfigurationComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public Task[] parseIssues(@NotNull String response, int max) throws Exception {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/intellij/tasks/generic/RegExResponseHandler", "parseIssues"));
        }
        List<String> placeholders = RegExResponseHandler.getPlaceholders(this.myTaskRegex);
        if (!placeholders.contains(ID_PLACEHOLDER) || !placeholders.contains(SUMMARY_PLACEHOLDER)) {
            throw new Exception("Incorrect Task Pattern");
        }
        String taskPatternWithoutPlaceholders = this.myTaskRegex.replaceAll("\\{.+?\\}", "");
        Matcher matcher = Pattern.compile(taskPatternWithoutPlaceholders, 234).matcher(response);
        ArrayList<GenericTask> tasks = new ArrayList<GenericTask>();
        for (int i = 0; i < max && matcher.find(); ++i) {
            String summary;
            String id = matcher.group(placeholders.indexOf(ID_PLACEHOLDER) + 1);
            final String finalSummary = summary = matcher.group(placeholders.indexOf(SUMMARY_PLACEHOLDER) + 1);
            summary = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    XmlElementFactory factory = XmlElementFactory.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
                    XmlTag text = factory.createTagFromText((CharSequence)("<a>" + finalSummary + "</a>"));
                    String trimmedText = text.getValue().getTrimmedText();
                    return XmlUtil.decode((String)trimmedText);
                }
            });
            tasks.add(new GenericTask(id, summary, (TaskRepository)this.myRepository));
        }
        Task[] taskArray = tasks.toArray(new Task[tasks.size()]);
        if (taskArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/RegExResponseHandler", "parseIssues"));
        }
        return taskArray;
    }

    @Override
    @Nullable
    public Task parseIssue(@NotNull String response) throws Exception {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/intellij/tasks/generic/RegExResponseHandler", "parseIssue"));
        }
        return null;
    }

    private static List<String> getPlaceholders(String value) {
        if (value == null) {
            return ContainerUtil.emptyList();
        }
        ArrayList<String> vars = new ArrayList<String>();
        Matcher m = Pattern.compile("\\{(.+?)\\}").matcher(value);
        while (m.find()) {
            vars.add(m.group(0));
        }
        return vars;
    }

    public String getTaskRegex() {
        return this.myTaskRegex;
    }

    public void setTaskRegex(String taskRegex) {
        this.myTaskRegex = taskRegex;
    }

    @Override
    public boolean isConfigured() {
        return !StringUtil.isEmpty((String)this.myTaskRegex);
    }

    @Override
    @NotNull
    public ResponseType getResponseType() {
        ResponseType responseType = ResponseType.TEXT;
        if (responseType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/RegExResponseHandler", "getResponseType"));
        }
        return responseType;
    }

    @Override
    public RegExResponseHandler clone() {
        RegExResponseHandler clone = (RegExResponseHandler)super.clone();
        clone.myTaskRegex = this.myTaskRegex;
        return clone;
    }
}

