/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.bugs.RecursionUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyInfiniteRecursionInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInfiniteRecursionInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Infinite recursion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInfiniteRecursionInspection", "getDisplayName"));
        }
        return "Infinite recursion";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "<code>#ref</code> recurses infinitely, and can only complete by throwing an exception #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInfiniteRecursionInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInfiniteRecursionInspection$Visitor", "visitMethod"));
            }
            super.visitMethod(method);
            if (method.hasModifierProperty("abstract")) {
                return;
            }
            if (!RecursionUtils.methodMayRecurse(method)) {
                return;
            }
            if (!RecursionUtils.methodDefinitelyRecurses(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

