/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.StatementCountVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyLongMethodInspectionBase
extends GroovyMethodMetricInspection {
    @NotNull
    public String getDisplayName() {
        if ("Overly long method" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyLongMethodInspectionBase", "getDisplayName"));
        }
        return "Overly long method";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Method Metrics" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyLongMethodInspectionBase", "getGroupDisplayName"));
        }
        return "Method Metrics";
    }

    @Override
    protected int getDefaultLimit() {
        return 30;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Maximum statements per method:";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' is too long ( statement count =" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyLongMethodInspectionBase", "buildVisitor"));
        }
        return visitor;
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod method) {
            super.visitMethod(method);
            int limit = GroovyOverlyLongMethodInspectionBase.this.getLimit();
            StatementCountVisitor visitor = new StatementCountVisitor();
            GrOpenBlock block = method.getBlock();
            if (block == null) {
                return;
            }
            block.accept(visitor);
            int statementCount = visitor.getStatementCount();
            if (statementCount <= limit) {
                return;
            }
            this.registerMethodError(method, statementCount, limit);
        }
    }
}

