/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class SplitIfIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement andElement, Project project, Editor editor) throws IncorrectOperationException {
        if (andElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "andElement", "org/jetbrains/plugins/groovy/intentions/control/SplitIfIntention", "processIntention"));
        }
        GrBinaryExpression binaryExpression = (GrBinaryExpression)andElement.getParent();
        GrIfStatement ifStatement = (GrIfStatement)binaryExpression.getParent();
        GrExpression leftOperand = binaryExpression.getLeftOperand();
        GrExpression rightOperand = binaryExpression.getRightOperand();
        GrStatement thenBranch = ifStatement.getThenBranch();
        assert (thenBranch != null);
        assert (rightOperand != null);
        GrStatement newSplittedIfs = GroovyPsiElementFactory.getInstance(project).createStatementFromText("if(" + leftOperand.getText() + ") { \n" + "  if(" + rightOperand.getText() + ")" + thenBranch.getText() + "\n" + "}");
        ifStatement.replaceWithStatement(newSplittedIfs);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return element.getParent() instanceof GrBinaryExpression && ((GrBinaryExpression)element.getParent()).getRightOperand() != null && element.getParent().getParent() instanceof GrIfStatement && ((GrIfStatement)element.getParent().getParent()).getElseBranch() == null && "&&".equals(element.getText());
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/SplitIfIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

