/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.jetbrains.annotations.NotNull;

public interface XPathQuickFixFactory {
    public Fix<XPathExpression>[] createImplicitTypeConversionFixes(XPathExpression var1, XPathType var2, boolean var3);

    public Fix<XPathExpression>[] createRedundantTypeConversionFixes(XPathExpression var1);

    public Fix<XPathNodeTest>[] createUnknownNodeTestFixes(XPathNodeTest var1);

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(XPathInspection var1);

    public boolean isSuppressedFor(PsiElement var1, XPathInspection var2);

    public static abstract class Fix<E extends PsiElement>
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected Fix(E element) {
            super(element);
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix", "isAvailable"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix", "isAvailable"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix", "isAvailable"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix", "isAvailable"));
            }
            return startElement.isValid() && startElement.getParent().isValid();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix", "invoke"));
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            try {
                this.invokeImpl(project, file);
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance((String)((Object)((Object)this)).getClass().getName()).error((Throwable)e);
            }
        }

        protected abstract void invokeImpl(Project var1, PsiFile var2) throws IncorrectOperationException;
    }
}

