/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.validation.XsltValidator;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnusedElementInspection
extends XsltInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unused Variable/Parameter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection", "getDisplayName"));
        }
        return "Unused Variable/Parameter";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("XsltUnusedDeclaration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection", "getShortName"));
        }
        return "XsltUnusedDeclaration";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection", "buildVisitor"));
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    private static class MyVisitor
    extends XmlElementVisitor {
        private final ProblemsHolder myHolder;

        public MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            if (!XsltSupport.isVariableOrParamName(attribute)) {
                return;
            }
            XmlTag tag = attribute.getParent();
            if (XsltSupport.isTopLevelElement(tag)) {
                return;
            }
            XsltVariable variable = XsltElementFactory.getInstance().wrapElement(tag, XsltVariable.class);
            String name = variable.getName();
            if (name == null || name.length() == 0) {
                return;
            }
            XsltValidator.checkUnusedVariable(variable, this.myHolder);
        }
    }
}

